// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_get_delegated_access_token_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_delegated_access_token::GetDelegatedAccessTokenOutput,
    crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError,
> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::unhandled)?;
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExpiredTradeInTokenException" => crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::ExpiredTradeInTokenException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::ExpiredTradeInTokenExceptionBuilder::default();
                output = crate::protocol_serde::shape_expired_trade_in_token_exception::de_expired_trade_in_token_exception_xml_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "PackedPolicyTooLarge" => crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::PackedPolicyTooLargeException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::PackedPolicyTooLargeExceptionBuilder::default();
                output = crate::protocol_serde::shape_packed_policy_too_large_exception::de_packed_policy_too_large_exception_xml_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "RegionDisabledException" => crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::RegionDisabledException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::RegionDisabledExceptionBuilder::default();
                output = crate::protocol_serde::shape_region_disabled_exception::de_region_disabled_exception_xml_err(_response_body, output)
                    .map_err(crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_get_delegated_access_token_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_delegated_access_token::GetDelegatedAccessTokenOutput,
    crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::get_delegated_access_token::builders::GetDelegatedAccessTokenOutputBuilder::default();
        output = crate::protocol_serde::shape_get_delegated_access_token::de_get_delegated_access_token(_response_body, output)
            .map_err(crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError::unhandled)?;
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

#[allow(unused_mut)]
pub fn de_get_delegated_access_token(
    inp: &[u8],
    mut builder: crate::operation::get_delegated_access_token::builders::GetDelegatedAccessTokenOutputBuilder,
) -> std::result::Result<
    crate::operation::get_delegated_access_token::builders::GetDelegatedAccessTokenOutputBuilder,
    ::aws_smithy_xml::decode::XmlDecodeError,
> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !(start_el.matches("GetDelegatedAccessTokenResponse")) {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "invalid root, expected GetDelegatedAccessTokenResponse got {start_el:?}"
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetDelegatedAccessTokenResult")) {
            return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
                "invalid result, expected GetDelegatedAccessTokenResult got {start_el:?}"
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Credentials") /* Credentials com.amazonaws.sts.synthetic#GetDelegatedAccessTokenOutput$Credentials */ =>  {
                let var_1 =
                    Some(
                        crate::protocol_serde::shape_credentials::de_credentials(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_credentials(var_1);
            }
            ,
            s if s.matches("PackedPolicySize") /* PackedPolicySize com.amazonaws.sts.synthetic#GetDelegatedAccessTokenOutput$PackedPolicySize */ =>  {
                let var_2 =
                    Some(
                         {
                            <i32 as ::aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|::aws_smithy_xml::decode::XmlDecodeError::custom("expected (integer: `com.amazonaws.sts#nonNegativeIntegerType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_packed_policy_size(var_2);
            }
            ,
            s if s.matches("AssumedPrincipal") /* AssumedPrincipal com.amazonaws.sts.synthetic#GetDelegatedAccessTokenOutput$AssumedPrincipal */ =>  {
                let var_3 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_assumed_principal(var_3);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(
            "expected GetDelegatedAccessTokenResult tag",
        ));
    };
    Ok(builder)
}
