import { $n as e, Cn as t, Ct as n, Fn as r, Nn as i, Ot as a, Rn as o, Rt as s, St as c, Tt as l, Wt as u, Zn as d, Zt as f, _t as p, cn as m, dn as h, er as g, fn as _, ft as v, gn as y, gt as b, j as x, jn as S, kn as C, kt as w, or as T, pn as E, wn as D, wt as O, xt as k, __tla as __tla_0 } from "./index-BKkrdbNu.js";
import { t as A } from "./leaflet-src-DdXMy_8W.js";
import { a as j, c as M, i as N, l as P, n as F, o as I, s as R, __tla as __tla_1 } from "./leaflet-BitxWQD-.js";
let J, Q, Z, ne;
let __tla = Promise.all([
  (() => {
    try {
      return __tla_0;
    } catch {
    }
  })(),
  (() => {
    try {
      return __tla_1;
    } catch {
    }
  })()
]).then(async () => {
  var z = () => a("label", "Label", "The label on the marker"), B = () => l("item", "Item", "The Location item this marker will be centered on"), V = () => a("location", "Fixed location", "The fixed position of the marker if no item is configured or its coordinates are invalid").c("location");
  const H = () => new k("oh-map-page", "Map page", "Displays markers on a map").params([
    a("initialCenter", "Initial Center", "The center to use when no markers are present or have valid positions").c("location"),
    a("initialZoom", "Initial Zoom Level", "The zoom level to use when no markers are present or have valid positions"),
    c("noZoomOrDrag", "Disable Zooming & Dragging", "Disable the ability to zoom and drag"),
    c("noZoomAnimation", "No Zoom Animation", "Change zoom levels without animation, can also avoid graphic glitches with persistent tooltips"),
    c("noMarkerZoomAnimation", "Hide Markers during Zoom Animation").a(),
    a("tileLayerProvider", "Provider for the background tiles", 'The provider of tiles to use for the background of the map. Use one from <a class="external text-color-blue" target="_blank" href="https://leaflet-extras.github.io/leaflet-providers/preview/">Leaflet Providers</a>, Some providers will not work until you set options, like access tokens, in the <code>tileLayerProviderOptions</code> parameter (in Code view). See <a class="external text-color-blue" target="_blank" href="https://github.com/leaflet-extras/leaflet-providers#providers-requiring-registration">here</a> for more info. The default is CartoDB, the variant depending on the dark mode setting.'),
    a("overlayTileLayerProvider", "Provider for the overlay tiles", 'The provider of tiles to use for the overlay layer above the background of the map. Use one from <a class="external text-color-blue" target="_blank" href="https://leaflet-extras.github.io/leaflet-providers/preview/">Leaflet Providers</a>, Some providers will not work until you set options, like access tokens, in the <code>overlayTileLayerProviderOptions</code> parameter (in Code view). See <a class="external text-color-blue" target="_blank" href="https://github.com/leaflet-extras/leaflet-providers#providers-requiring-registration">here</a> for more info. ')
  ]), U = () => new k("oh-map-marker", "Map Marker", "An icon on a map", "map_pin").paramGroup(O("marker", "Marker", "General marker settings"), [
    z(),
    a("icon", "Icon", 'Use <code>oh:iconName</code> (<a class="external text-color-blue" target="_blank" href="https://www.openhab.org/link/icons">openHAB icon</a>)')
  ]).paramGroup(O("position", "Position", "Position"), [
    B(),
    V()
  ]).paramGroup(b(null, "Action to perform when the marker is clicked"), p()), W = () => new k("oh-map-circle-marker", "Circle Marker", "A circle on a map, to represent a radius", "map_pin_ellipse").paramGroup(O("marker", "Marker", "General marker settings"), [
    z(),
    a("color", "Circle color", 'The color of the circle (e.g. "blue", "red", "yellow"...)')
  ]).paramGroup(O("position", "Center Position"), [
    B(),
    V()
  ]).paramGroup(O("radius", "Radius", "Radius of the circle"), [
    l("radiusItem", "Radius Item", "The item whose state holds the radius of the circle, in meters"),
    n("radius", "Fixed radius", "The fixed radius of the circle in meters if no item is configured or its state is invalid")
  ]).paramGroup(b(null, "Action to perform when the circle is clicked"), p());
  var G = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAABSCAMAAAAhFXfZAAAC91BMVEVMaXEzeak2f7I4g7g3g7cua5gzeKg8hJo3grY4g7c3grU0gLI2frE0daAubJc2gbQwd6QzeKk2gLMtd5sxdKIua5g1frA2f7IydaM0e6w2fq41fK01eqo3grgubJgta5cxdKI1f7AydaQydaMxc6EubJgvbJkwcZ4ubZkwcJwubZgubJcydqUydKIxapgubJctbJcubZcubJcvbJYubJcvbZkubJctbJctbZcubJg2f7AubJcrbZcubJcubJcua5g3grY0fq8ubJcubJdEkdEwhsw6i88vhswuhcsuhMtBjMgthMsrg8srgss6is8qgcs8i9A9iMYtg8spgcoogMo7hcMngMonf8olfso4gr8kfck5iM8jfMk4iM8he8k1fro7itAgesk2hs8eecgzfLcofssdeMg0hc4cd8g2hcsxeLQbdsgZdcgxeLImfcszhM0vda4xgckzhM4xg84wf8Yxgs4udKsvfcQucqhUndROmdM1fK0wcZ8vb5w0eqpQm9MzeKhXoNVcpdYydKNWn9VZotVKltJFjsIwcJ1Rms9OlslLmtH///8+kc9epdYzd6dbo9VHkMM2f7FHmNBClM8ydqVcpNY9hro3gLM9hLczealQmcw3fa46f7A8gLMxc6I3eagyc6FIldJMl9JSnNRSntNNl9JPnNJFi75UnM9ZodVKksg8kM45jc09e6ZHltFBk883gbRBh7pDk9EwcaBzn784g7dKkcY2i81Om9M7j85Llc81is09g7Q4grY/j9A0eqxKmdFFltBEjcXf6fFImdBCiLxJl9FGlNFBi78yiMxVndEvbpo6js74+vx+psPP3+o/ks5HkcpGmNCjwdZCkNDM3ehYoNJEls+lxNkxh8xHks0+jdC1zd5Lg6r+/v/H2ufz9/o3jM3t8/edvdM/k89Th61OiLBSjbZklbaTt9BfptdjmL1AicBHj8hGk9FAgK1dkLNTjLRekrdClc/k7fM0icy0y9tgp9c4jc2NtM9Dlc8zicxeXZn3AAAAQ3RSTlMAHDdTb4yPA+LtnEQmC4L2EmHqB7XA0d0sr478x4/Yd5i1zOfyPkf1sLVq4Nh3FvjxopQ2/STNuFzUwFIwxKaejILpIBEV9wAABhVJREFUeF6s1NdyFEcYBeBeoQIhRAkLlRDGrhIgY3BJL8CVeKzuyXFzzjkn5ZxzzuScg3PO8cKzu70JkO0LfxdTU//pM9vTu7Xgf6KqOVTb9X7toRrVEfBf1HTVjZccrT/2by1VV928Yty9ZbVuucdz90frG8DBjl9pVApbOstvmMuvVgaNXSfAAd6pGxpy6yxf5ph43pS/4f3uoaGm2rdu72S9xzOvMymkZFq/ptDrk90mhW7e4zl7HLzhxGWPR20xmSxJ/VqldG5m9XhaVOA1DadsNh3Pu5L2N6QtPO/32JpqQBVVk20oy/Pi2s23WEvyfHbe1thadVQttvm7Llf65gGmXK67XtupyoM7HQhmXdLS8oGWJNeOJ3C5fG5XCEJnkez3/oFdsvgJ4l2ANZwhrJKk/7OSXa+3Vw2WJMlKnGkobouYk6T0TyX30klOUnTD9HJ5qpckL3EW/w4XF3Xd0FGywXUrstrclVsqz5Pd/sXFYyDnPdrLcQODmGOK47IZb4CmibmMn+MYRzFZ5jg33ZL/EJrWcszHmANy3ARBK/IXtciJy8VsitPSdE3uuHxzougojcUdr8/32atnz/ev3f/K5wtpxUTpcaI45zusVDpYtZi+jg0oU9b3x74h7+n9ABvYEZeKaVq0sh0AtLKsFtqNBdeT0MrSzwwlq9+x6xAO4tgOtSzbCjrNQQiNvQUbUEubvzBUeGw26yDCsRHCoLkTHDa7IdOLIThs/gHvChszh2CimE8peRs47cxANI0lYNB5y1DljpOF0IhzBDPOZnDOqYYbeGKECbPzWnXludPphw5c2YBq5zlwXphIbO4VDCZ0gnPfUO1TwZoYwAs2ExPCedAu9DAjfQUjzITQb3jNj0KG2Sgt6BHaQUdYzWz+XmBktOHwanXjaSTcwwziBcuMOtwBmqPrTOxFQR/DRKKPqyur0aiW6cULYsx6tBm0jXpR/AUWR6HRq9WVW6MRhIq5jLyjbaCTDCijyYJNpCajdyobP/eTw0iexBAKkJ3gA5KcQb2zBXsIBckn+xVv8jkZSaEFHE+jFEleAEfayRU0MouNoBmB/L50Ai/HSLIHxcrpCvnhSQAuakKp2C/YbCylJjXRVy/z3+Kv/RrNcCo+WUzlVEhzKffnTQnxeN9fWF88fiNCUdSTsaufaChKWInHeysygfpIqagoakW+vV20J8uyl6TyNKEZWV4oRSPyCkWpgOLSbkCObT8o2r6tlG58HQquf6O0v50tB7JM7F4EORd2dx/K0w/KHsVkLPaoYrwgP/y7krr3SSMA4zj+OBgmjYkxcdIJQyQRKgg2viX9Hddi9UBb29LrKR7CVVEEEXWojUkXNyfTNDE14W9gbHJNuhjDettN3ZvbOvdOqCD3Jp/9l+/wJE+9PkYGjx/fqkys3S2rMozM/o2106rfMUINo6hVqz+eu/hd1c4xTg0TAfy5kV+4UG6+IthHTU9woWmxuKNbTfuCSfovBCxq7EtHqvYL4Sm6F8GVxsSXHMQ07TOi1DKtZxjWaaIyi4CXWjxPccUw8WVbMYY5wxC1mzEyXMJWkllpRloi+Kkoq69sxBTlElF6aAxYUbjXNlhlDZilDnM4U5SlN5biRsRHnbx3mbeWjEh4mEyiuJDl5XcWVmX5GvNkFgLWZM5qwsop4/AWfLhU1cR7k1VVvcYCWRkOI6Xy5gmnphCYIkvzuNYzHzosq2oNk2RtSs8khfUOfHIDgR6ysYBaMpl4uEgk2U/oJTs9AaTSwma7dT69geAE2ZpEjUsn2ieJNHeKfrI3EcAGJ2ZaNgVuC8EBctCLc57P5u5led6IOBkIYkuQMrmmjChs4VkfOerHqSBkPzZlhe06RslZ3zMjk2sscqKwY0RcjKK+LWbzd7KiHhkncs/siFJ+V5eXxD34B8nVuJEpGJNmxN2gH3vSvp7J70tF+D1Ej8qUJD1TkErAND2GZwTFg/LubvmgiBG3SOvdlsqFQrkEzJCL1rstlnVFROixZoDDSuXQFHESwVGlcuQcMb/b42NgjLowh5MTDFE3vNB5qStRIErdCQEh6pLPR92anSUb/wAIhldAaDMpGgAAAABJRU5ErkJggg==", K = {
    mixins: [
      w,
      x
    ],
    components: {
      LMarker: M,
      LTooltip: N,
      LIcon: R
    },
    widget: U,
    emits: [
      "update"
    ],
    data() {
      return {
        markerKey: f.utils.id()
      };
    },
    created() {
      this.DefaultIcon = G;
    },
    computed: {
      coords() {
        if (this.config.item) {
          let e2 = this.context.store[this.config.item];
          if (e2 && e2.state.indexOf(",") > 0) return e2.state.split(",");
        }
        return this.config.location ? this.config.location.split(",") : null;
      },
      hasIcon() {
        return this.config.icon;
      }
    },
    asyncComputed: {
      icon() {
        return this.config.icon && this.config.icon.indexOf("oh:") === 0 ? this.$oh.media.getIcon(this.config.icon.substring(3)).then((e2) => (this.markerKey = f.utils.id(), this.$emit("update"), e2)) : null;
      }
    },
    watch: {
      coords(e2) {
        e2 && this.$emit("update", e2);
      }
    }
  };
  function q(t2, n2, r2, a2, s2, c2) {
    let l2 = i("l-tooltip"), u2 = i("l-icon"), d2 = i("l-marker");
    return c2.coords ? (C(), h(d2, {
      ref: "marker",
      key: s2.markerKey,
      "lat-lng": c2.coords,
      onClick: t2.performAction
    }, {
      default: o(() => [
        t2.config.label ? (C(), h(l2, {
          key: 0
        }, {
          default: o(() => [
            y(e(t2.config.label), 1)
          ]),
          _: 1
        })) : _("", true),
        t2.icon ? (C(), h(u2, {
          key: 1,
          "icon-size": [
            40,
            40
          ],
          "icon-url": t2.icon
        }, null, 8, [
          "icon-url"
        ])) : (C(), h(u2, {
          key: 2,
          "icon-size": [
            25,
            41
          ],
          "icon-url": t2.DefaultIcon
        }, null, 8, [
          "icon-url"
        ]))
      ]),
      _: 1
    }, 8, [
      "lat-lng",
      "onClick"
    ])) : _("", true);
  }
  let Y;
  J = v(K, [
    [
      "render",
      q
    ]
  ]);
  Y = {
    mixins: [
      w,
      x
    ],
    components: {
      LCircle: F,
      LTooltip: N
    },
    widget: W,
    emits: [
      "update"
    ],
    data() {
      return {
        markerKey: f.utils.id()
      };
    },
    computed: {
      center() {
        if (this.config.item) {
          let e2 = this.context.store[this.config.item];
          if (e2 && e2.state.indexOf(",") > 0) return e2.state.split(",");
        }
        return this.config.location ? this.config.location.split(",") : null;
      },
      radius() {
        if (this.config.radiusItem) {
          let e2 = this.context.store[this.config.radiusItem];
          if (e2 && !isNaN(parseFloat(e2.state))) return parseFloat(e2.state);
        }
        return this.config.radius ? parseFloat(this.config.radius) : null;
      },
      markerConfig() {
        if (!this.config) return {};
        let e2 = {};
        return Object.assign(e2, this.config), delete e2.latLng, delete e2.radius, e2;
      }
    },
    mounted() {
      this.$emit("update", this.center, this.radius);
    }
  };
  function X(n2, r2, a2, s2, c2, l2) {
    let u2 = i("l-tooltip"), d2 = i("l-circle");
    return l2.center && l2.radius ? (C(), h(d2, t({
      ref: "marker",
      key: c2.markerKey,
      "lat-lng": l2.center,
      radius: l2.radius
    }, l2.markerConfig, {
      "onUpdate:latLng": r2[0] || (r2[0] = (e2) => n2.$emit("update", e2)),
      onClick: n2.performAction
    }), {
      default: o(() => [
        n2.config.label ? (C(), h(u2, {
          key: 0
        }, {
          default: o(() => [
            y(e(n2.config.label), 1)
          ]),
          _: 1
        })) : _("", true)
      ]),
      _: 1
    }, 16, [
      "lat-lng",
      "radius",
      "onClick"
    ])) : _("", true);
  }
  let $;
  Z = v(Y, [
    [
      "render",
      X
    ]
  ]);
  Q = g(((e2, t2) => {
    (function(e3, n2) {
      typeof define == "function" && define.amd ? define([
        "leaflet"
      ], n2) : typeof modules == "object" && t2.exports ? t2.exports = n2(A()) : n2(L);
    })(e2, function(e3) {
      return e3.TileLayer.Provider = e3.TileLayer.extend({
        initialize: function(t3, n2) {
          var r2 = e3.TileLayer.Provider.providers, i2 = t3.split("."), a2 = i2[0], o2 = i2[1];
          if (!r2[a2]) throw "No such provider (" + a2 + ")";
          var s2 = {
            url: r2[a2].url,
            options: r2[a2].options
          };
          if (o2 && "variants" in r2[a2]) {
            if (!(o2 in r2[a2].variants)) throw "No such variant of " + a2 + " (" + o2 + ")";
            var c2 = r2[a2].variants[o2], l2 = typeof c2 == "string" ? {
              variant: c2
            } : c2.options;
            s2 = {
              url: c2.url || s2.url,
              options: e3.Util.extend({}, s2.options, l2)
            };
          }
          var u2 = function(e4) {
            return e4.indexOf("{attribution.") === -1 ? e4 : e4.replace(/\{attribution.(\w*)\}/g, function(e5, t4) {
              return u2(r2[t4].options.attribution);
            });
          };
          s2.options.attribution = u2(s2.options.attribution);
          var d2 = e3.Util.extend({}, s2.options, n2);
          e3.TileLayer.prototype.initialize.call(this, s2.url, d2);
        }
      }), e3.TileLayer.Provider.providers = {
        OpenStreetMap: {
          url: "https://tile.openstreetmap.org/{z}/{x}/{y}.png",
          options: {
            maxZoom: 19,
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
          },
          variants: {
            Mapnik: {},
            DE: {
              url: "https://tile.openstreetmap.de/{z}/{x}/{y}.png",
              options: {
                maxZoom: 18
              }
            },
            CH: {
              url: "https://tile.osm.ch/switzerland/{z}/{x}/{y}.png",
              options: {
                maxZoom: 18,
                bounds: [
                  [
                    45,
                    5
                  ],
                  [
                    48,
                    11
                  ]
                ]
              }
            },
            France: {
              url: "https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png",
              options: {
                maxZoom: 20,
                attribution: "&copy; OpenStreetMap France | {attribution.OpenStreetMap}"
              }
            },
            HOT: {
              url: "https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png",
              options: {
                attribution: '{attribution.OpenStreetMap}, Tiles style by <a href="https://www.hotosm.org/" target="_blank">Humanitarian OpenStreetMap Team</a> hosted by <a href="https://openstreetmap.fr/" target="_blank">OpenStreetMap France</a>'
              }
            },
            BZH: {
              url: "https://tile.openstreetmap.bzh/br/{z}/{x}/{y}.png",
              options: {
                attribution: '{attribution.OpenStreetMap}, Tiles courtesy of <a href="http://www.openstreetmap.bzh/" target="_blank">Breton OpenStreetMap Team</a>',
                bounds: [
                  [
                    46.2,
                    -5.5
                  ],
                  [
                    50,
                    0.7
                  ]
                ]
              }
            }
          }
        },
        MapTilesAPI: {
          url: "https://maptiles.p.rapidapi.com/{variant}/{z}/{x}/{y}.png?rapidapi-key={apikey}",
          options: {
            attribution: '&copy; <a href="http://www.maptilesapi.com/">MapTiles API</a>, {attribution.OpenStreetMap}',
            variant: "en/map/v1",
            apikey: "<insert your api key here>",
            maxZoom: 19
          },
          variants: {
            OSMEnglish: {
              options: {
                variant: "en/map/v1"
              }
            },
            OSMFrancais: {
              options: {
                variant: "fr/map/v1"
              }
            },
            OSMEspagnol: {
              options: {
                variant: "es/map/v1"
              }
            }
          }
        },
        OpenSeaMap: {
          url: "https://tiles.openseamap.org/seamark/{z}/{x}/{y}.png",
          options: {
            attribution: 'Map data: &copy; <a href="http://www.openseamap.org">OpenSeaMap</a> contributors'
          }
        },
        OPNVKarte: {
          url: "https://tileserver.memomaps.de/tilegen/{z}/{x}/{y}.png",
          options: {
            maxZoom: 18,
            attribution: 'Map <a href="https://memomaps.de/">memomaps.de</a> <a href="http://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>, map data {attribution.OpenStreetMap}'
          }
        },
        OpenTopoMap: {
          url: "https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png",
          options: {
            maxZoom: 17,
            attribution: 'Map data: {attribution.OpenStreetMap}, <a href="http://viewfinderpanoramas.org">SRTM</a> | Map style: &copy; <a href="https://opentopomap.org">OpenTopoMap</a> (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)'
          }
        },
        OpenRailwayMap: {
          url: "https://{s}.tiles.openrailwaymap.org/standard/{z}/{x}/{y}.png",
          options: {
            maxZoom: 19,
            attribution: 'Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href="https://www.OpenRailwayMap.org">OpenRailwayMap</a> (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)'
          }
        },
        OpenFireMap: {
          url: "http://openfiremap.org/hytiles/{z}/{x}/{y}.png",
          options: {
            maxZoom: 19,
            attribution: 'Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href="http://www.openfiremap.org">OpenFireMap</a> (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)'
          }
        },
        SafeCast: {
          url: "https://s3.amazonaws.com/te512.safecast.org/{z}/{x}/{y}.png",
          options: {
            maxZoom: 16,
            attribution: 'Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href="https://blog.safecast.org/about/">SafeCast</a> (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)'
          }
        },
        Stadia: {
          url: "https://tiles.stadiamaps.com/tiles/{variant}/{z}/{x}/{y}{r}.{ext}",
          options: {
            minZoom: 0,
            maxZoom: 20,
            attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
            variant: "alidade_smooth",
            ext: "png"
          },
          variants: {
            AlidadeSmooth: "alidade_smooth",
            AlidadeSmoothDark: "alidade_smooth_dark",
            OSMBright: "osm_bright",
            Outdoors: "outdoors",
            StamenToner: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_toner"
              }
            },
            StamenTonerBackground: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_toner_background"
              }
            },
            StamenTonerLines: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_toner_lines"
              }
            },
            StamenTonerLabels: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_toner_labels"
              }
            },
            StamenTonerLite: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_toner_lite"
              }
            },
            StamenWatercolor: {
              url: "https://tiles.stadiamaps.com/tiles/{variant}/{z}/{x}/{y}.{ext}",
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_watercolor",
                ext: "jpg",
                minZoom: 1,
                maxZoom: 16
              }
            },
            StamenTerrain: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_terrain",
                minZoom: 0,
                maxZoom: 18
              }
            },
            StamenTerrainBackground: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_terrain_background",
                minZoom: 0,
                maxZoom: 18
              }
            },
            StamenTerrainLabels: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_terrain_labels",
                minZoom: 0,
                maxZoom: 18
              }
            },
            StamenTerrainLines: {
              options: {
                attribution: '&copy; <a href="https://www.stadiamaps.com/" target="_blank">Stadia Maps</a> &copy; <a href="https://www.stamen.com/" target="_blank">Stamen Design</a> &copy; <a href="https://openmaptiles.org/" target="_blank">OpenMapTiles</a> {attribution.OpenStreetMap}',
                variant: "stamen_terrain_lines",
                minZoom: 0,
                maxZoom: 18
              }
            }
          }
        },
        Thunderforest: {
          url: "https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}",
          options: {
            attribution: '&copy; <a href="http://www.thunderforest.com/">Thunderforest</a>, {attribution.OpenStreetMap}',
            variant: "cycle",
            apikey: "<insert your api key here>",
            maxZoom: 22
          },
          variants: {
            OpenCycleMap: "cycle",
            Transport: {
              options: {
                variant: "transport"
              }
            },
            TransportDark: {
              options: {
                variant: "transport-dark"
              }
            },
            SpinalMap: {
              options: {
                variant: "spinal-map"
              }
            },
            Landscape: "landscape",
            Outdoors: "outdoors",
            Pioneer: "pioneer",
            MobileAtlas: "mobile-atlas",
            Neighbourhood: "neighbourhood"
          }
        },
        CyclOSM: {
          url: "https://{s}.tile-cyclosm.openstreetmap.fr/cyclosm/{z}/{x}/{y}.png",
          options: {
            maxZoom: 20,
            attribution: '<a href="https://github.com/cyclosm/cyclosm-cartocss-style/releases" title="CyclOSM - Open Bicycle render">CyclOSM</a> | Map data: {attribution.OpenStreetMap}'
          }
        },
        Jawg: {
          url: "https://{s}.tile.jawg.io/{variant}/{z}/{x}/{y}{r}.png?access-token={accessToken}",
          options: {
            attribution: '<a href="http://jawg.io" title="Tiles Courtesy of Jawg Maps" target="_blank">&copy; <b>Jawg</b>Maps</a> {attribution.OpenStreetMap}',
            minZoom: 0,
            maxZoom: 22,
            subdomains: "abcd",
            variant: "jawg-terrain",
            accessToken: "<insert your access token here>"
          },
          variants: {
            Streets: "jawg-streets",
            Terrain: "jawg-terrain",
            Sunny: "jawg-sunny",
            Dark: "jawg-dark",
            Light: "jawg-light",
            Matrix: "jawg-matrix"
          }
        },
        MapBox: {
          url: "https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}{r}?access_token={accessToken}",
          options: {
            attribution: '&copy; <a href="https://www.mapbox.com/about/maps/" target="_blank">Mapbox</a> {attribution.OpenStreetMap} <a href="https://www.mapbox.com/map-feedback/" target="_blank">Improve this map</a>',
            tileSize: 512,
            maxZoom: 18,
            zoomOffset: -1,
            id: "mapbox/streets-v11",
            accessToken: "<insert your access token here>"
          }
        },
        MapTiler: {
          url: "https://api.maptiler.com/maps/{variant}/{z}/{x}/{y}{r}.{ext}?key={key}",
          options: {
            attribution: '<a href="https://www.maptiler.com/copyright/" target="_blank">&copy; MapTiler</a> <a href="https://www.openstreetmap.org/copyright" target="_blank">&copy; OpenStreetMap contributors</a>',
            variant: "streets",
            ext: "png",
            key: "<insert your MapTiler Cloud API key here>",
            tileSize: 512,
            zoomOffset: -1,
            minZoom: 0,
            maxZoom: 21
          },
          variants: {
            Streets: "streets",
            Basic: "basic",
            Bright: "bright",
            Pastel: "pastel",
            Positron: "positron",
            Hybrid: {
              options: {
                variant: "hybrid",
                ext: "jpg"
              }
            },
            Toner: "toner",
            Topo: "topo",
            Voyager: "voyager"
          }
        },
        TomTom: {
          url: "https://{s}.api.tomtom.com/map/1/tile/{variant}/{style}/{z}/{x}/{y}.{ext}?key={apikey}",
          options: {
            variant: "basic",
            maxZoom: 22,
            attribution: '<a href="https://tomtom.com" target="_blank">&copy;  1992 - ' + (/* @__PURE__ */ new Date()).getFullYear() + " TomTom.</a> ",
            subdomains: "abcd",
            style: "main",
            ext: "png",
            apikey: "<insert your API key here>"
          },
          variants: {
            Basic: "basic",
            Hybrid: "hybrid",
            Labels: "labels"
          }
        },
        Esri: {
          url: "https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}",
          options: {
            variant: "World_Street_Map",
            attribution: "Tiles &copy; Esri"
          },
          variants: {
            WorldStreetMap: {
              options: {
                attribution: "{attribution.Esri} &mdash; Source: Esri, DeLorme, NAVTEQ, USGS, Intermap, iPC, NRCAN, Esri Japan, METI, Esri China (Hong Kong), Esri (Thailand), TomTom, 2012"
              }
            },
            DeLorme: {
              options: {
                variant: "Specialty/DeLorme_World_Base_Map",
                minZoom: 1,
                maxZoom: 11,
                attribution: "{attribution.Esri} &mdash; Copyright: &copy;2012 DeLorme"
              }
            },
            WorldTopoMap: {
              options: {
                variant: "World_Topo_Map",
                attribution: "{attribution.Esri} &mdash; Esri, DeLorme, NAVTEQ, TomTom, Intermap, iPC, USGS, FAO, NPS, NRCAN, GeoBase, Kadaster NL, Ordnance Survey, Esri Japan, METI, Esri China (Hong Kong), and the GIS User Community"
              }
            },
            WorldImagery: {
              options: {
                variant: "World_Imagery",
                attribution: "{attribution.Esri} &mdash; Source: Esri, i-cubed, USDA, USGS, AEX, GeoEye, Getmapping, Aerogrid, IGN, IGP, UPR-EGP, and the GIS User Community"
              }
            },
            WorldTerrain: {
              options: {
                variant: "World_Terrain_Base",
                maxZoom: 13,
                attribution: "{attribution.Esri} &mdash; Source: USGS, Esri, TANA, DeLorme, and NPS"
              }
            },
            WorldShadedRelief: {
              options: {
                variant: "World_Shaded_Relief",
                maxZoom: 13,
                attribution: "{attribution.Esri} &mdash; Source: Esri"
              }
            },
            WorldPhysical: {
              options: {
                variant: "World_Physical_Map",
                maxZoom: 8,
                attribution: "{attribution.Esri} &mdash; Source: US National Park Service"
              }
            },
            OceanBasemap: {
              options: {
                variant: "Ocean/World_Ocean_Base",
                maxZoom: 13,
                attribution: "{attribution.Esri} &mdash; Sources: GEBCO, NOAA, CHS, OSU, UNH, CSUMB, National Geographic, DeLorme, NAVTEQ, and Esri"
              }
            },
            NatGeoWorldMap: {
              options: {
                variant: "NatGeo_World_Map",
                maxZoom: 16,
                attribution: "{attribution.Esri} &mdash; National Geographic, Esri, DeLorme, NAVTEQ, UNEP-WCMC, USGS, NASA, ESA, METI, NRCAN, GEBCO, NOAA, iPC"
              }
            },
            WorldGrayCanvas: {
              options: {
                variant: "Canvas/World_Light_Gray_Base",
                maxZoom: 16,
                attribution: "{attribution.Esri} &mdash; Esri, DeLorme, NAVTEQ"
              }
            }
          }
        },
        OpenWeatherMap: {
          url: "http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}",
          options: {
            maxZoom: 19,
            attribution: 'Map data &copy; <a href="http://openweathermap.org">OpenWeatherMap</a>',
            apiKey: "<insert your api key here>",
            opacity: 0.5
          },
          variants: {
            Clouds: "clouds",
            CloudsClassic: "clouds_cls",
            Precipitation: "precipitation",
            PrecipitationClassic: "precipitation_cls",
            Rain: "rain",
            RainClassic: "rain_cls",
            Pressure: "pressure",
            PressureContour: "pressure_cntr",
            Wind: "wind",
            Temperature: "temp",
            Snow: "snow"
          }
        },
        HERE: {
          url: "https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}",
          options: {
            attribution: "Map &copy; 1987-" + (/* @__PURE__ */ new Date()).getFullYear() + ' <a href="http://developer.here.com">HERE</a>',
            subdomains: "1234",
            mapID: "newest",
            app_id: "<insert your app_id here>",
            app_code: "<insert your app_code here>",
            base: "base",
            variant: "normal.day",
            maxZoom: 20,
            type: "maptile",
            language: "eng",
            format: "png8",
            size: "256"
          },
          variants: {
            normalDay: "normal.day",
            normalDayCustom: "normal.day.custom",
            normalDayGrey: "normal.day.grey",
            normalDayMobile: "normal.day.mobile",
            normalDayGreyMobile: "normal.day.grey.mobile",
            normalDayTransit: "normal.day.transit",
            normalDayTransitMobile: "normal.day.transit.mobile",
            normalDayTraffic: {
              options: {
                variant: "normal.traffic.day",
                base: "traffic",
                type: "traffictile"
              }
            },
            normalNight: "normal.night",
            normalNightMobile: "normal.night.mobile",
            normalNightGrey: "normal.night.grey",
            normalNightGreyMobile: "normal.night.grey.mobile",
            normalNightTransit: "normal.night.transit",
            normalNightTransitMobile: "normal.night.transit.mobile",
            reducedDay: "reduced.day",
            reducedNight: "reduced.night",
            basicMap: {
              options: {
                type: "basetile"
              }
            },
            mapLabels: {
              options: {
                type: "labeltile",
                format: "png"
              }
            },
            trafficFlow: {
              options: {
                base: "traffic",
                type: "flowtile"
              }
            },
            carnavDayGrey: "carnav.day.grey",
            hybridDay: {
              options: {
                base: "aerial",
                variant: "hybrid.day"
              }
            },
            hybridDayMobile: {
              options: {
                base: "aerial",
                variant: "hybrid.day.mobile"
              }
            },
            hybridDayTransit: {
              options: {
                base: "aerial",
                variant: "hybrid.day.transit"
              }
            },
            hybridDayGrey: {
              options: {
                base: "aerial",
                variant: "hybrid.grey.day"
              }
            },
            hybridDayTraffic: {
              options: {
                variant: "hybrid.traffic.day",
                base: "traffic",
                type: "traffictile"
              }
            },
            pedestrianDay: "pedestrian.day",
            pedestrianNight: "pedestrian.night",
            satelliteDay: {
              options: {
                base: "aerial",
                variant: "satellite.day"
              }
            },
            terrainDay: {
              options: {
                base: "aerial",
                variant: "terrain.day"
              }
            },
            terrainDayMobile: {
              options: {
                base: "aerial",
                variant: "terrain.day.mobile"
              }
            }
          }
        },
        HEREv3: {
          url: "https://{s}.{base}.maps.ls.hereapi.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?apiKey={apiKey}&lg={language}",
          options: {
            attribution: "Map &copy; 1987-" + (/* @__PURE__ */ new Date()).getFullYear() + ' <a href="http://developer.here.com">HERE</a>',
            subdomains: "1234",
            mapID: "newest",
            apiKey: "<insert your apiKey here>",
            base: "base",
            variant: "normal.day",
            maxZoom: 20,
            type: "maptile",
            language: "eng",
            format: "png8",
            size: "256"
          },
          variants: {
            normalDay: "normal.day",
            normalDayCustom: "normal.day.custom",
            normalDayGrey: "normal.day.grey",
            normalDayMobile: "normal.day.mobile",
            normalDayGreyMobile: "normal.day.grey.mobile",
            normalDayTransit: "normal.day.transit",
            normalDayTransitMobile: "normal.day.transit.mobile",
            normalNight: "normal.night",
            normalNightMobile: "normal.night.mobile",
            normalNightGrey: "normal.night.grey",
            normalNightGreyMobile: "normal.night.grey.mobile",
            normalNightTransit: "normal.night.transit",
            normalNightTransitMobile: "normal.night.transit.mobile",
            reducedDay: "reduced.day",
            reducedNight: "reduced.night",
            basicMap: {
              options: {
                type: "basetile"
              }
            },
            mapLabels: {
              options: {
                type: "labeltile",
                format: "png"
              }
            },
            trafficFlow: {
              options: {
                base: "traffic",
                type: "flowtile"
              }
            },
            carnavDayGrey: "carnav.day.grey",
            hybridDay: {
              options: {
                base: "aerial",
                variant: "hybrid.day"
              }
            },
            hybridDayMobile: {
              options: {
                base: "aerial",
                variant: "hybrid.day.mobile"
              }
            },
            hybridDayTransit: {
              options: {
                base: "aerial",
                variant: "hybrid.day.transit"
              }
            },
            hybridDayGrey: {
              options: {
                base: "aerial",
                variant: "hybrid.grey.day"
              }
            },
            pedestrianDay: "pedestrian.day",
            pedestrianNight: "pedestrian.night",
            satelliteDay: {
              options: {
                base: "aerial",
                variant: "satellite.day"
              }
            },
            terrainDay: {
              options: {
                base: "aerial",
                variant: "terrain.day"
              }
            },
            terrainDayMobile: {
              options: {
                base: "aerial",
                variant: "terrain.day.mobile"
              }
            }
          }
        },
        FreeMapSK: {
          url: "https://{s}.freemap.sk/T/{z}/{x}/{y}.jpeg",
          options: {
            minZoom: 8,
            maxZoom: 16,
            subdomains: "abcd",
            bounds: [
              [
                47.204642,
                15.996093
              ],
              [
                49.830896,
                22.576904
              ]
            ],
            attribution: '{attribution.OpenStreetMap}, visualization CC-By-SA 2.0 <a href="http://freemap.sk">Freemap.sk</a>'
          }
        },
        MtbMap: {
          url: "http://tile.mtbmap.cz/mtbmap_tiles/{z}/{x}/{y}.png",
          options: {
            attribution: "{attribution.OpenStreetMap} &amp; USGS"
          }
        },
        CartoDB: {
          url: "https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png",
          options: {
            attribution: '{attribution.OpenStreetMap} &copy; <a href="https://carto.com/attributions">CARTO</a>',
            subdomains: "abcd",
            maxZoom: 20,
            variant: "light_all"
          },
          variants: {
            Positron: "light_all",
            PositronNoLabels: "light_nolabels",
            PositronOnlyLabels: "light_only_labels",
            DarkMatter: "dark_all",
            DarkMatterNoLabels: "dark_nolabels",
            DarkMatterOnlyLabels: "dark_only_labels",
            Voyager: "rastertiles/voyager",
            VoyagerNoLabels: "rastertiles/voyager_nolabels",
            VoyagerOnlyLabels: "rastertiles/voyager_only_labels",
            VoyagerLabelsUnder: "rastertiles/voyager_labels_under"
          }
        },
        HikeBike: {
          url: "https://tiles.wmflabs.org/{variant}/{z}/{x}/{y}.png",
          options: {
            maxZoom: 19,
            attribution: "{attribution.OpenStreetMap}",
            variant: "hikebike"
          },
          variants: {
            HikeBike: {},
            HillShading: {
              options: {
                maxZoom: 15,
                variant: "hillshading"
              }
            }
          }
        },
        BasemapAT: {
          url: "https://mapsneu.wien.gv.at/basemap/{variant}/{type}/google3857/{z}/{y}/{x}.{format}",
          options: {
            maxZoom: 19,
            attribution: 'Datenquelle: <a href="https://www.basemap.at">basemap.at</a>',
            type: "normal",
            format: "png",
            bounds: [
              [
                46.35877,
                8.782379
              ],
              [
                49.037872,
                17.189532
              ]
            ],
            variant: "geolandbasemap"
          },
          variants: {
            basemap: {
              options: {
                maxZoom: 20,
                variant: "geolandbasemap"
              }
            },
            grau: "bmapgrau",
            overlay: "bmapoverlay",
            terrain: {
              options: {
                variant: "bmapgelaende",
                type: "grau",
                format: "jpeg"
              }
            },
            surface: {
              options: {
                variant: "bmapoberflaeche",
                type: "grau",
                format: "jpeg"
              }
            },
            highdpi: {
              options: {
                variant: "bmaphidpi",
                format: "jpeg"
              }
            },
            orthofoto: {
              options: {
                maxZoom: 20,
                variant: "bmaporthofoto30cm",
                format: "jpeg"
              }
            }
          }
        },
        nlmaps: {
          url: "https://service.pdok.nl/brt/achtergrondkaart/wmts/v2_0/{variant}/EPSG:3857/{z}/{x}/{y}.png",
          options: {
            minZoom: 6,
            maxZoom: 19,
            bounds: [
              [
                50.5,
                3.25
              ],
              [
                54,
                7.6
              ]
            ],
            attribution: 'Kaartgegevens &copy; <a href="https://www.kadaster.nl">Kadaster</a>'
          },
          variants: {
            standaard: "standaard",
            pastel: "pastel",
            grijs: "grijs",
            water: "water",
            luchtfoto: {
              url: "https://service.pdok.nl/hwh/luchtfotorgb/wmts/v1_0/Actueel_ortho25/EPSG:3857/{z}/{x}/{y}.jpeg"
            }
          }
        },
        NASAGIBS: {
          url: "https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{maxZoom}/{z}/{y}/{x}.{format}",
          options: {
            attribution: 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (<a href="https://earthdata.nasa.gov">ESDIS</a>) with funding provided by NASA/HQ.',
            bounds: [
              [
                -85.0511287776,
                -179.999999975
              ],
              [
                85.0511287776,
                179.999999975
              ]
            ],
            minZoom: 1,
            maxZoom: 9,
            format: "jpg",
            time: "",
            tilematrixset: "GoogleMapsCompatible_Level"
          },
          variants: {
            ModisTerraTrueColorCR: "MODIS_Terra_CorrectedReflectance_TrueColor",
            ModisTerraBands367CR: "MODIS_Terra_CorrectedReflectance_Bands367",
            ViirsEarthAtNight2012: {
              options: {
                variant: "VIIRS_CityLights_2012",
                maxZoom: 8
              }
            },
            ModisTerraLSTDay: {
              options: {
                variant: "MODIS_Terra_Land_Surface_Temp_Day",
                format: "png",
                maxZoom: 7,
                opacity: 0.75
              }
            },
            ModisTerraSnowCover: {
              options: {
                variant: "MODIS_Terra_NDSI_Snow_Cover",
                format: "png",
                maxZoom: 8,
                opacity: 0.75
              }
            },
            ModisTerraAOD: {
              options: {
                variant: "MODIS_Terra_Aerosol",
                format: "png",
                maxZoom: 6,
                opacity: 0.75
              }
            },
            ModisTerraChlorophyll: {
              options: {
                variant: "MODIS_Terra_Chlorophyll_A",
                format: "png",
                maxZoom: 7,
                opacity: 0.75
              }
            }
          }
        },
        NLS: {
          url: "https://nls-{s}.tileserver.com/nls/{z}/{x}/{y}.jpg",
          options: {
            attribution: '<a href="http://geo.nls.uk/maps/">National Library of Scotland Historic Maps</a>',
            bounds: [
              [
                49.6,
                -12
              ],
              [
                61.7,
                3
              ]
            ],
            minZoom: 1,
            maxZoom: 18,
            subdomains: "0123"
          }
        },
        JusticeMap: {
          url: "https://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png",
          options: {
            attribution: '<a href="http://www.justicemap.org/terms.php">Justice Map</a>',
            size: "county",
            bounds: [
              [
                14,
                -180
              ],
              [
                72,
                -56
              ]
            ]
          },
          variants: {
            income: "income",
            americanIndian: "indian",
            asian: "asian",
            black: "black",
            hispanic: "hispanic",
            multi: "multi",
            nonWhite: "nonwhite",
            white: "white",
            plurality: "plural"
          }
        },
        GeoportailFrance: {
          url: "https://wxs.ign.fr/{apikey}/geoportail/wmts?REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0&STYLE={style}&TILEMATRIXSET=PM&FORMAT={format}&LAYER={variant}&TILEMATRIX={z}&TILEROW={y}&TILECOL={x}",
          options: {
            attribution: '<a target="_blank" href="https://www.geoportail.gouv.fr/">Geoportail France</a>',
            bounds: [
              [
                -75,
                -180
              ],
              [
                81,
                180
              ]
            ],
            minZoom: 2,
            maxZoom: 18,
            apikey: "choisirgeoportail",
            format: "image/png",
            style: "normal",
            variant: "GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2"
          },
          variants: {
            plan: "GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2",
            parcels: {
              options: {
                variant: "CADASTRALPARCELS.PARCELLAIRE_EXPRESS",
                style: "PCI vecteur",
                maxZoom: 20
              }
            },
            orthos: {
              options: {
                maxZoom: 19,
                format: "image/jpeg",
                variant: "ORTHOIMAGERY.ORTHOPHOTOS"
              }
            }
          }
        },
        OneMapSG: {
          url: "https://maps-{s}.onemap.sg/v3/{variant}/{z}/{x}/{y}.png",
          options: {
            variant: "Default",
            minZoom: 11,
            maxZoom: 18,
            bounds: [
              [
                1.56073,
                104.11475
              ],
              [
                1.16,
                103.502
              ]
            ],
            attribution: '<img src="https://docs.onemap.sg/maps/images/oneMap64-01.png" style="height:20px;width:20px;"/> New OneMap | Map data &copy; contributors, <a href="http://SLA.gov.sg">Singapore Land Authority</a>'
          },
          variants: {
            Default: "Default",
            Night: "Night",
            Original: "Original",
            Grey: "Grey",
            LandLot: "LandLot"
          }
        },
        USGS: {
          url: "https://basemap.nationalmap.gov/arcgis/rest/services/USGSTopo/MapServer/tile/{z}/{y}/{x}",
          options: {
            maxZoom: 20,
            attribution: 'Tiles courtesy of the <a href="https://usgs.gov/">U.S. Geological Survey</a>'
          },
          variants: {
            USTopo: {},
            USImagery: {
              url: "https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer/tile/{z}/{y}/{x}"
            },
            USImageryTopo: {
              url: "https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryTopo/MapServer/tile/{z}/{y}/{x}"
            }
          }
        },
        WaymarkedTrails: {
          url: "https://tile.waymarkedtrails.org/{variant}/{z}/{x}/{y}.png",
          options: {
            maxZoom: 18,
            attribution: 'Map data: {attribution.OpenStreetMap} | Map style: &copy; <a href="https://waymarkedtrails.org">waymarkedtrails.org</a> (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-SA</a>)'
          },
          variants: {
            hiking: "hiking",
            cycling: "cycling",
            mtb: "mtb",
            slopes: "slopes",
            riding: "riding",
            skating: "skating"
          }
        },
        OpenAIP: {
          url: "https://{s}.tile.maps.openaip.net/geowebcache/service/tms/1.0.0/openaip_basemap@EPSG%3A900913@png/{z}/{x}/{y}.{ext}",
          options: {
            attribution: '<a href="https://www.openaip.net/">openAIP Data</a> (<a href="https://creativecommons.org/licenses/by-sa/3.0/">CC-BY-NC-SA</a>)',
            ext: "png",
            minZoom: 4,
            maxZoom: 14,
            tms: true,
            detectRetina: true,
            subdomains: "12"
          }
        },
        OpenSnowMap: {
          url: "https://tiles.opensnowmap.org/{variant}/{z}/{x}/{y}.png",
          options: {
            minZoom: 9,
            maxZoom: 18,
            attribution: 'Map data: {attribution.OpenStreetMap} & ODbL, &copy; <a href="https://www.opensnowmap.org/iframes/data.html">www.opensnowmap.org</a> <a href="https://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>'
          },
          variants: {
            pistes: "pistes"
          }
        },
        AzureMaps: {
          url: "https://atlas.microsoft.com/map/tile?api-version={apiVersion}&tilesetId={variant}&x={x}&y={y}&zoom={z}&language={language}&subscription-key={subscriptionKey}",
          options: {
            attribution: "See https://docs.microsoft.com/en-us/rest/api/maps/render-v2/get-map-tile for details.",
            apiVersion: "2.0",
            variant: "microsoft.imagery",
            subscriptionKey: "<insert your subscription key here>",
            language: "en-US"
          },
          variants: {
            MicrosoftImagery: "microsoft.imagery",
            MicrosoftBaseDarkGrey: "microsoft.base.darkgrey",
            MicrosoftBaseRoad: "microsoft.base.road",
            MicrosoftBaseHybridRoad: "microsoft.base.hybrid.road",
            MicrosoftTerraMain: "microsoft.terra.main",
            MicrosoftWeatherInfraredMain: {
              url: "https://atlas.microsoft.com/map/tile?api-version={apiVersion}&tilesetId={variant}&x={x}&y={y}&zoom={z}&timeStamp={timeStamp}&language={language}&subscription-key={subscriptionKey}",
              options: {
                timeStamp: "2021-05-08T09:03:00Z",
                attribution: "See https://docs.microsoft.com/en-us/rest/api/maps/render-v2/get-map-tile#uri-parameters for details.",
                variant: "microsoft.weather.infrared.main"
              }
            },
            MicrosoftWeatherRadarMain: {
              url: "https://atlas.microsoft.com/map/tile?api-version={apiVersion}&tilesetId={variant}&x={x}&y={y}&zoom={z}&timeStamp={timeStamp}&language={language}&subscription-key={subscriptionKey}",
              options: {
                timeStamp: "2021-05-08T09:03:00Z",
                attribution: "See https://docs.microsoft.com/en-us/rest/api/maps/render-v2/get-map-tile#uri-parameters for details.",
                variant: "microsoft.weather.radar.main"
              }
            }
          }
        },
        SwissFederalGeoportal: {
          url: "https://wmts.geo.admin.ch/1.0.0/{variant}/default/current/3857/{z}/{x}/{y}.jpeg",
          options: {
            attribution: '&copy; <a href="https://www.swisstopo.admin.ch/">swisstopo</a>',
            minZoom: 2,
            maxZoom: 18,
            bounds: [
              [
                45.398181,
                5.140242
              ],
              [
                48.230651,
                11.47757
              ]
            ]
          },
          variants: {
            NationalMapColor: "ch.swisstopo.pixelkarte-farbe",
            NationalMapGrey: "ch.swisstopo.pixelkarte-grau",
            SWISSIMAGE: {
              options: {
                variant: "ch.swisstopo.swissimage",
                maxZoom: 19
              }
            }
          }
        }
      }, e3.tileLayer.provider = function(t3, n2) {
        return new e3.TileLayer.Provider(t3, n2);
      }, e3;
    });
  }));
  $ = T(A());
  Q(), delete $.Icon.Default.prototype._getIconUrl, $.Icon.Default.mergeOptions({
    iconRetinaUrl: u(() => import("./marker-icon-2x-Iy0OynPB.js").then(async (m2) => {
      await m2.__tla;
      return m2;
    }), []),
    iconUrl: u(() => import("./marker-icon-DizE4ZB9.js").then(async (m2) => {
      await m2.__tla;
      return m2;
    }), []),
    shadowUrl: u(() => import("./marker-shadow-Sn32H3fm.js").then(async (m2) => {
      await m2.__tla;
      return m2;
    }), [])
  });
  var ee = {
    mixins: [
      w
    ],
    components: {
      LMap: j,
      LTileLayer: P,
      LFeatureGroup: I,
      OhMapMarker: J,
      OhMapCircleMarker: Z
    },
    widget: H,
    data() {
      return {
        zoom: this.context.component.config.initialZoom || 4,
        currentZoom: 13,
        currentCenter: null,
        center: this.context.component.config.initialCenter ? (0, $.latLng)(this.context.component.config.initialCenter.split(",")) : (0, $.latLng)(48, 6),
        url: "https://a.basemaps.cartocdn.com/".concat(s().getDarkMode(), "_all/{z}/{x}/{y}.png"),
        attribution: '&copy; <a class="external" target="_blank" href="http://osm.org/copyright">OpenStreetMap</a>, &copy; <a class="external" target="_blank" href="https://carto.com/attribution/">CARTO</a>',
        showMarkers: false
      };
    },
    computed: {
      mapOptions() {
        return Object.assign({
          zoomSnap: 0.1
        }, this.config.noZoomOrDrag ? {
          dragging: false,
          touchZoom: false,
          doubleClickZoom: false,
          scrollWheelZoom: false,
          zoomControl: false
        } : {});
      }
    },
    mounted() {
      let e2 = () => {
        var _a;
        ((_a = this.$refs.map) == null ? void 0 : _a.ready) ? (console.debug("Map is now ready, initializing ..."), this.initialize()) : setTimeout(e2, 10);
      };
      D(() => {
        e2();
      });
    },
    methods: {
      initialize() {
        this.setBackgroundLayer(), this.context.component.slots && D(() => {
          this.showMarkers = true, this.onMarkerUpdate();
        });
      },
      setBackgroundLayer() {
        let e2 = s().getDarkMode() === "dark" ? "CartoDB.DarkMatter" : "CartoDB.Positron", t2 = this.config.tileLayerProvider || e2, n2, r2;
        try {
          n2 = $.tileLayer.provider(t2, this.config.tileLayerProviderOptions);
        } catch {
          n2 = $.tileLayer.provider(e2);
        }
        if (n2.addTo(this.$refs.map.leafletObject), this.config.overlayTileLayerProvider) {
          try {
            r2 = $.tileLayer.provider(this.config.overlayTileLayerProvider, this.config.overlayTileLayerProviderOptions);
          } catch {
          }
          r2._url.indexOf("openweather") > 0 && (r2._url = r2._url.replace("{variant}", "{variant}_new")), r2.addTo(this.$refs.map.leafletObject);
        }
        this.$refs.map.leafletObject.invalidateSize();
      },
      zoomUpdate(e2) {
        this.currentZoom = e2;
      },
      centerUpdate(e2) {
        this.currentCenter = e2;
      },
      markerComponent(e2) {
        switch (e2.component) {
          case "oh-map-marker":
            return J;
          case "oh-map-circle-marker":
            return Z;
          default:
            return null;
        }
      },
      onMarkerUpdate() {
        D(() => {
          let e2 = this.$refs.featureGroup.leafletObject.getBounds();
          e2.isValid() && (this.$refs.map.leafletObject.fitBounds(e2.pad(0.5)), this.$refs.map.leafletObject.invalidateSize());
        });
      }
    }
  };
  function te(e2, t2, n2, a2, s2, c2) {
    let l2 = i("l-feature-group"), u2 = i("l-map");
    return C(), h(u2, {
      ref: "map",
      zoom: s2.zoom,
      center: s2.center,
      options: c2.mapOptions,
      "zoom-animation": !e2.config.noZoomAnimation,
      "marker-zoom-animation": !e2.config.noMarkerZoomAnimation,
      class: d([
        "oh-map-page-lmap",
        {
          "with-tabbar": e2.context.tab
        }
      ]),
      "onUpdate:center": c2.centerUpdate,
      "onUpdate:zoom": c2.zoomUpdate
    }, {
      default: o(() => [
        s2.showMarkers ? (C(), h(l2, {
          key: 0,
          ref: "featureGroup"
        }, {
          default: o(() => [
            (C(true), E(m, null, S(e2.context.component.slots.default, (t3, n3) => (C(), h(r(c2.markerComponent(t3)), {
              key: n3,
              context: e2.childContext(t3),
              onUpdate: c2.onMarkerUpdate
            }, null, 40, [
              "context",
              "onUpdate"
            ]))), 128))
          ]),
          _: 1
        }, 512)) : _("", true)
      ]),
      _: 1
    }, 8, [
      "zoom",
      "center",
      "options",
      "zoom-animation",
      "marker-zoom-animation",
      "class",
      "onUpdate:center",
      "onUpdate:zoom"
    ]);
  }
  ne = v(ee, [
    [
      "render",
      te
    ]
  ]);
});
export {
  __tla,
  J as i,
  Q as n,
  Z as r,
  ne as t
};
