/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.upnp.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.jupnp.UpnpService;
import org.jupnp.model.message.header.RootDeviceHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryListener;
import org.jupnp.transport.RouterException;
import org.openhab.core.config.discovery.AbstractDiscoveryService;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.upnp.UpnpDiscoveryParticipant;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.net.CidrAddress;
import org.openhab.core.net.NetworkAddressChangeListener;
import org.openhab.core.net.NetworkAddressService;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid={"discovery.upnp"})
public class UpnpDiscoveryService
extends AbstractDiscoveryService
implements RegistryListener,
NetworkAddressChangeListener {
    private final Logger logger = LoggerFactory.getLogger(UpnpDiscoveryService.class);
    private final Map<UDN, Future<?>> deviceRemovalTasks = new ConcurrentHashMap();
    private final Set<UpnpDiscoveryParticipant> participants = new CopyOnWriteArraySet<UpnpDiscoveryParticipant>();
    private final UpnpService upnpService;

    @Activate
    public UpnpDiscoveryService(@Nullable Map<String, Object> configProperties, @Reference UpnpService upnpService, @Reference TranslationProvider i18nProvider, @Reference LocaleProvider localeProvider) {
        super(5);
        this.upnpService = upnpService;
        this.i18nProvider = i18nProvider;
        this.localeProvider = localeProvider;
        super.activate(configProperties);
        this.startScan();
    }

    @Modified
    protected void modified(Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    @Reference
    protected void setNetworkAddressService(NetworkAddressService networkAddressService) {
        networkAddressService.addNetworkAddressChangeListener((NetworkAddressChangeListener)this);
    }

    protected void unsetNetworkAddressService(NetworkAddressService networkAddressService) {
        networkAddressService.removeNetworkAddressChangeListener((NetworkAddressChangeListener)this);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUpnpDiscoveryParticipant(UpnpDiscoveryParticipant participant) {
        this.participants.add(participant);
        Collection devices = this.upnpService.getRegistry().getRemoteDevices();
        for (RemoteDevice device : devices) {
            DiscoveryResult result;
            if (!device.isRoot() && !participant.notifyChildDevices() || (result = participant.createResult(device)) == null) continue;
            this.thingDiscovered(result, FrameworkUtil.getBundle(participant.getClass()));
        }
    }

    protected void removeUpnpDiscoveryParticipant(UpnpDiscoveryParticipant participant) {
        this.participants.remove(participant);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        HashSet<ThingTypeUID> supportedThingTypes = new HashSet<ThingTypeUID>();
        for (UpnpDiscoveryParticipant participant : this.participants) {
            supportedThingTypes.addAll(participant.getSupportedThingTypeUIDs());
        }
        return supportedThingTypes;
    }

    protected void startBackgroundDiscovery() {
        this.upnpService.getRegistry().addListener((RegistryListener)this);
    }

    protected void stopBackgroundDiscovery() {
        this.upnpService.getRegistry().removeListener((RegistryListener)this);
    }

    protected void startScan() {
        for (RemoteDevice device : this.upnpService.getRegistry().getRemoteDevices()) {
            this.remoteDeviceAdded(this.upnpService.getRegistry(), device);
            RemoteDevice[] remoteDeviceArray = device.getEmbeddedDevices();
            int n = remoteDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteDevice childDevice = remoteDeviceArray[n2];
                this.remoteDeviceAdded(this.upnpService.getRegistry(), childDevice);
                ++n2;
            }
        }
        this.upnpService.getRegistry().addListener((RegistryListener)this);
        this.upnpService.getControlPoint().search();
        this.upnpService.getControlPoint().search((UpnpHeader)new RootDeviceHeader());
    }

    protected synchronized void stopScan() {
        this.removeOlderResults(this.getTimestampOfLastScan());
        super.stopScan();
        if (!this.isBackgroundDiscoveryEnabled()) {
            this.upnpService.getRegistry().removeListener((RegistryListener)this);
        }
    }

    public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
        for (UpnpDiscoveryParticipant participant : this.participants) {
            if (!device.isRoot() && !participant.notifyChildDevices()) continue;
            try {
                DiscoveryResult result = participant.createResult(device);
                if (result == null) continue;
                if (participant.getRemovalGracePeriodSeconds(device) > 0L) {
                    this.cancelRemovalTask(((RemoteDeviceIdentity)device.getIdentity()).getUdn());
                }
                this.thingDiscovered(result, FrameworkUtil.getBundle(participant.getClass()));
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
            }
        }
    }

    private void cancelRemovalTask(UDN udn) {
        Future<?> deviceRemovalTask = this.deviceRemovalTasks.remove(udn);
        if (deviceRemovalTask != null) {
            deviceRemovalTask.cancel(false);
        }
    }

    public void remoteDeviceRemoved(Registry registry, RemoteDevice device) {
        for (UpnpDiscoveryParticipant participant : this.participants) {
            if (!device.isRoot() && !participant.notifyChildDevices()) continue;
            try {
                ThingUID thingUID = participant.getThingUID(device);
                if (thingUID == null) continue;
                long gracePeriod = participant.getRemovalGracePeriodSeconds(device);
                if (gracePeriod <= 0L) {
                    this.thingRemoved(thingUID);
                    continue;
                }
                UDN udn = ((RemoteDeviceIdentity)device.getIdentity()).getUdn();
                this.cancelRemovalTask(udn);
                this.deviceRemovalTasks.put(udn, this.scheduler.schedule(() -> {
                    this.thingRemoved(thingUID);
                    this.cancelRemovalTask(udn);
                }, gracePeriod, TimeUnit.SECONDS));
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
            }
        }
    }

    public void onChanged(List<CidrAddress> added, List<CidrAddress> removed) {
        this.scheduler.execute(() -> {
            if (!removed.isEmpty()) {
                this.upnpService.getRegistry().removeAllRemoteDevices();
            }
            try {
                this.upnpService.getRouter().disable();
                this.upnpService.getRouter().enable();
                this.startScan();
            }
            catch (RouterException e) {
                this.logger.error("Could not restart UPnP network components.", (Throwable)e);
            }
        });
    }

    public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
    }

    public void localDeviceAdded(Registry registry, LocalDevice device) {
    }

    public void localDeviceRemoved(Registry registry, LocalDevice device) {
    }

    public void beforeShutdown(Registry registry) {
    }

    public void afterShutdown() {
    }

    public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
    }

    public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
    }
}

