/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.usbserial.windowsregistry.internal;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadFactoryBuilder;
import org.openhab.core.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscovery;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.openhab.core.config.discovery.usbserial.windowsregistry.internal.WindowMessageHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={UsbSerialDiscovery.class}, name="usb-serial-discovery-windows", configurationPid={"discovery.usbserial.windows"})
public class WindowsUsbSerialDiscovery
implements UsbSerialDiscovery,
WindowMessageHandler.WindowMessageListener {
    protected static final String SERVICE_NAME = "usb-serial-discovery-windows";
    public static final String SCAN_INTERVAL_PROPERTY = "scanInterval";
    public static final int DEFAULT_SCAN_INTERVAL_SECONDS = 15;
    private static final String DEVICE_PATH_PATTERN = "^\\\\\\\\\\?\\\\usb#vid_(?<vid>[0-9a-f]{4})&pid_(?<pid>[0-9a-f]{4})(?:&mi_(?<mi>[0-9a-f]{2}))?#(?<id>.*?)(?:#(?<guid>\\{[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}\\}))$";
    private final Pattern devicePathPattern = Pattern.compile("^\\\\\\\\\\?\\\\usb#vid_(?<vid>[0-9a-f]{4})&pid_(?<pid>[0-9a-f]{4})(?:&mi_(?<mi>[0-9a-f]{2}))?#(?<id>.*?)(?:#(?<guid>\\{[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}\\}))$");
    private static final boolean IS_64_BIT = Platform.is64Bit();
    private static final int ERROR_NO_SUCH_DEVINST = -536870389;
    private static final String KEY_SERIAL_PORT = "PortName";
    private final Logger logger = LoggerFactory.getLogger(WindowsUsbSerialDiscovery.class);
    private final Set<UsbSerialDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<UsbSerialDiscoveryListener>();
    private volatile Duration scanInterval = Duration.ofSeconds(15L);
    private final ScheduledExecutorService scheduler;
    private Set<UsbSerialDeviceInformation> lastScanResult = new HashSet<UsbSerialDeviceInformation>();
    private @Nullable ScheduledFuture<?> scanTask;
    private @Nullable WindowMessageHandler windowMessageHandler;
    private volatile boolean windowMessageFailed;

    @Activate
    public WindowsUsbSerialDiscovery(Map<String, Object> config) {
        Object value = config.get(SCAN_INTERVAL_PROPERTY);
        if (value instanceof String) {
            String s = (String)value;
            try {
                this.scanInterval = Duration.ofSeconds(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                this.logger.warn("Invalid configuration value for '{}': {}", (Object)SCAN_INTERVAL_PROPERTY, (Object)s);
            }
        } else if (value instanceof Number) {
            Number n = (Number)value;
            this.scanInterval = Duration.ofSeconds(n.longValue());
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor(ThreadFactoryBuilder.create().withName(SERVICE_NAME).withDaemonThreads(true).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(Map<String, Object> config) {
        Object value = config.get(SCAN_INTERVAL_PROPERTY);
        Duration newScanInterval = null;
        if (value instanceof String) {
            String s = (String)value;
            try {
                newScanInterval = Duration.ofSeconds(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                this.logger.warn("Invalid configuration value for '{}': {}", (Object)SCAN_INTERVAL_PROPERTY, (Object)s);
            }
        } else if (value instanceof Number) {
            Number n = (Number)value;
            newScanInterval = Duration.ofSeconds(n.longValue());
        }
        WindowsUsbSerialDiscovery windowsUsbSerialDiscovery = this;
        synchronized (windowsUsbSerialDiscovery) {
            if (!Objects.equals(newScanInterval, this.scanInterval)) {
                this.scanInterval = newScanInterval == null ? Duration.ofSeconds(15L) : newScanInterval;
                if (this.scanTask != null) {
                    this.stopBackgroundScanning();
                    this.startBackgroundScanning();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        WindowsUsbSerialDiscovery windowsUsbSerialDiscovery = this;
        synchronized (windowsUsbSerialDiscovery) {
            this.stopBackgroundScanning();
            this.lastScanResult.clear();
        }
    }

    private void announceAddedDevice(UsbSerialDeviceInformation deviceInfo) {
        for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
            listener.usbSerialDeviceDiscovered(deviceInfo);
        }
    }

    private void announceRemovedDevice(UsbSerialDeviceInformation deviceInfo) {
        for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
            listener.usbSerialDeviceRemoved(deviceInfo);
        }
    }

    public void doSingleScan() {
        this.doSingleScanInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSingleScanInternal(boolean includeExisting) {
        Set unchanged;
        Set<UsbSerialDeviceInformation> removed;
        Set<UsbSerialDeviceInformation> added;
        WindowsUsbSerialDiscovery windowsUsbSerialDiscovery = this;
        synchronized (windowsUsbSerialDiscovery) {
            Set<UsbSerialDeviceInformation> scanResult = this.gatherUsbDevicesInformation();
            added = this.setDifference(scanResult, this.lastScanResult);
            removed = this.setDifference(this.lastScanResult, scanResult);
            unchanged = includeExisting ? this.setDifference(scanResult, added) : Set.of();
            this.lastScanResult = scanResult;
        }
        removed.forEach(this::announceRemovedDevice);
        added.forEach(this::announceAddedDevice);
        unchanged.forEach(this::announceAddedDevice);
    }

    private <T> Set<T> setDifference(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.removeAll(set2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDiscoveryListener(UsbSerialDiscoveryListener listener) {
        Set<UsbSerialDeviceInformation> lastScanResult;
        this.discoveryListeners.add(listener);
        WindowsUsbSerialDiscovery windowsUsbSerialDiscovery = this;
        synchronized (windowsUsbSerialDiscovery) {
            lastScanResult = Set.copyOf(this.lastScanResult);
        }
        for (UsbSerialDeviceInformation deviceInfo : lastScanResult) {
            listener.usbSerialDeviceDiscovered(deviceInfo);
        }
    }

    public void unregisterDiscoveryListener(UsbSerialDiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<UsbSerialDeviceInformation> gatherUsbDevicesInformation() {
        if (!Platform.isWindows()) {
            return Set.of();
        }
        Guid.GUID GUID_DEVINTERFACE_USB_DEVICE = new Guid.GUID("A5DCBF10-6530-11D2-901F-00C04FB951ED");
        int SPDRP_FRIENDLYNAME = 12;
        int SPDRP_MFG = 11;
        SetupApi apiInst = SetupApi.INSTANCE;
        HashSet<UsbSerialDeviceInformation> result = new HashSet<UsbSerialDeviceInformation>();
        WinNT.HANDLE deviceInfoSet = apiInst.SetupDiGetClassDevs(GUID_DEVINTERFACE_USB_DEVICE, null, null, 18);
        if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)deviceInfoSet)) {
            try {
                int lastError;
                SetupApi.SP_DEVINFO_DATA deviceInfoData = new SetupApi.SP_DEVINFO_DATA();
                SetupApi.SP_DEVICE_INTERFACE_DATA deviceInterfaceData = new SetupApi.SP_DEVICE_INTERFACE_DATA();
                int devIdx = 0;
                while (apiInst.SetupDiEnumDeviceInfo(deviceInfoSet, devIdx, deviceInfoData)) {
                    String mfg;
                    String friendlyName;
                    String name;
                    try {
                        name = this.getDeviceRegistryPropertyString(deviceInfoSet, 0, deviceInfoData);
                        friendlyName = this.getDeviceRegistryPropertyString(deviceInfoSet, SPDRP_FRIENDLYNAME, deviceInfoData);
                        mfg = this.getDeviceRegistryPropertyString(deviceInfoSet, SPDRP_MFG, deviceInfoData);
                    }
                    catch (Win32Exception e) {
                        this.logger.warn("Failed to get USB device property: {}", (Object)e.getMessage());
                        continue;
                    }
                    int intIdx = 0;
                    while (apiInst.SetupDiEnumDeviceInterfaces(deviceInfoSet, deviceInfoData.getPointer(), GUID_DEVINTERFACE_USB_DEVICE, intIdx, deviceInterfaceData)) {
                        List<String> devicePaths;
                        try {
                            devicePaths = this.getDeviceInterfaceDetails(deviceInfoSet, deviceInterfaceData, null);
                        }
                        catch (Win32Exception e) {
                            this.logger.warn("Failed to get USB device interface details for \"{}\": {}", (Object)name, (Object)e.getMessage());
                            continue;
                        }
                        for (String devicePath : devicePaths) {
                            String serialPort;
                            DevicePathData data;
                            block23: {
                                data = this.parseDevicePath(devicePath);
                                if (data == null) continue;
                                WinReg.HKEY hKey = apiInst.SetupDiOpenDevRegKey(deviceInfoSet, deviceInfoData, 1, 0, 1, 131097);
                                if (hKey != WinBase.INVALID_HANDLE_VALUE) {
                                    try {
                                        serialPort = Advapi32Util.registryGetStringValue((WinReg.HKEY)hKey, (String)KEY_SERIAL_PORT);
                                    }
                                    catch (Win32Exception e) {
                                        if (e.getErrorCode() != 2) {
                                            this.logger.debug("Failed to read serial port for USB device \"{}\": {} {}", new Object[]{name, ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
                                        }
                                        serialPort = "";
                                        Advapi32.INSTANCE.RegCloseKey(hKey);
                                        break block23;
                                    }
                                    catch (RuntimeException e) {
                                        try {
                                            this.logger.debug("Failed to read serial port for USB device \"{}\": {} {}", new Object[]{name, e.getClass().getSimpleName(), e.getMessage()});
                                            serialPort = "";
                                            break block23;
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            Advapi32.INSTANCE.RegCloseKey(hKey);
                                        }
                                    }
                                    Advapi32.INSTANCE.RegCloseKey(hKey);
                                } else {
                                    serialPort = "";
                                }
                            }
                            UsbSerialDeviceInformation usbSerialDeviceInformation = new UsbSerialDeviceInformation(data.vendorId, data.productId, data.id, mfg, friendlyName == null || friendlyName.isBlank() ? name : friendlyName, data.interfaceNumber, data.id, serialPort);
                            this.logger.debug("Parsed {}", (Object)usbSerialDeviceInformation);
                            result.add(usbSerialDeviceInformation);
                        }
                        ++intIdx;
                    }
                    lastError = Native.getLastError();
                    if (lastError != 259) {
                        this.logger.warn("Unexpected error while iterating USB device interfaces: {}", (Object)Kernel32Util.formatMessage((int)lastError));
                    }
                    ++devIdx;
                }
                lastError = Native.getLastError();
                if (lastError == 259) return result;
                this.logger.warn("Unexpected error while iterating USB devices: {}", (Object)Kernel32Util.formatMessage((int)lastError));
                return result;
            }
            finally {
                apiInst.SetupDiDestroyDeviceInfoList(deviceInfoSet);
            }
        }
        int lastError = Native.getLastError();
        this.logger.warn("Unable to enumerate USB devices: {}", (Object)Kernel32Util.formatMessage((int)lastError));
        return result;
    }

    protected @Nullable String getDeviceRegistryPropertyString(WinNT.HANDLE deviceInfoSet, int property, SetupApi.SP_DEVINFO_DATA deviceInfoData) {
        Memory buffer = this.getDeviceRegistryProperty(deviceInfoSet, property, deviceInfoData);
        return buffer == null ? null : buffer.getWideString(0L);
    }

    protected @Nullable Memory getDeviceRegistryProperty(WinNT.HANDLE deviceInfoSet, int property, SetupApi.SP_DEVINFO_DATA deviceInfoData) {
        int lastError;
        SetupApi apiInst = SetupApi.INSTANCE;
        IntByReference size = new IntByReference();
        if (!apiInst.SetupDiGetDeviceRegistryProperty(deviceInfoSet, deviceInfoData, property, null, null, 0, size) && (lastError = Native.getLastError()) != 122) {
            if (lastError == 13 || lastError == -536870389) {
                return null;
            }
            throw new Win32Exception(lastError);
        }
        int sizeValue = size.getValue();
        if (sizeValue == 0) {
            return null;
        }
        Memory buffer = new Memory((long)sizeValue);
        if (!apiInst.SetupDiGetDeviceRegistryProperty(deviceInfoSet, deviceInfoData, property, null, (Pointer)buffer, sizeValue, null)) {
            lastError = Native.getLastError();
            if (lastError == 13) {
                return null;
            }
            throw new Win32Exception(lastError);
        }
        return buffer;
    }

    protected List<String> getDeviceInterfaceDetails(WinNT.HANDLE deviceInfoSet, SetupApi.SP_DEVICE_INTERFACE_DATA deviceInterfaceData, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SetupApi.SP_DEVINFO_DATA deviceInfoData) {
        int lastError;
        SetupApi apiInst = SetupApi.INSTANCE;
        IntByReference size = new IntByReference();
        if (!apiInst.SetupDiGetDeviceInterfaceDetail(deviceInfoSet, deviceInterfaceData, null, 0, size, deviceInfoData) && (lastError = Native.getLastError()) != 122) {
            if (lastError == 13) {
                return List.of();
            }
            throw new Win32Exception(lastError);
        }
        int sizeValue = size.getValue();
        if (sizeValue == 0) {
            return List.of();
        }
        Memory result = new Memory((long)sizeValue);
        result.setInt(0L, IS_64_BIT ? 8 : 6);
        if (!apiInst.SetupDiGetDeviceInterfaceDetail(deviceInfoSet, deviceInterfaceData, (Pointer)result, sizeValue, null, deviceInfoData)) {
            lastError = Native.getLastError();
            if (lastError == 13) {
                return List.of();
            }
            throw new Win32Exception(lastError);
        }
        return WindowsUsbSerialDiscovery.readRegMultiSz(result, 4L);
    }

    protected @Nullable DevicePathData parseDevicePath(String devicePath) {
        Matcher m = this.devicePathPattern.matcher(devicePath.toLowerCase(Locale.ROOT));
        if (m.find()) {
            try {
                int vendorId = Integer.valueOf(m.group("vid"), 16);
                int productId = Integer.valueOf(m.group("pid"), 16);
                String s = m.group("mi");
                int interfaceNumber = s == null || s.isBlank() ? 0 : Integer.valueOf(s, 16);
                s = m.group("id");
                return new DevicePathData(vendorId, productId, s, interfaceNumber);
            }
            catch (NumberFormatException e) {
                this.logger.warn("Unable to parse USB device data idVendor: {}, idProduct {} or interface number {}: {}", new Object[]{m.group("vid"), m.group("pid"), m.group("mi"), e.getMessage()});
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackgroundScanning() {
        if (Platform.isWindows()) {
            boolean initScan = false;
            WindowsUsbSerialDiscovery windowsUsbSerialDiscovery = this;
            synchronized (windowsUsbSerialDiscovery) {
                ScheduledFuture<?> scanTask = this.scanTask;
                WindowMessageHandler messageHandler = this.windowMessageHandler;
                if (this.windowMessageFailed) {
                    if (messageHandler != null) {
                        messageHandler.removeListener(this);
                        messageHandler.terminate();
                        this.windowMessageHandler = null;
                    }
                    if (scanTask == null || scanTask.isDone()) {
                        this.scanTask = this.scheduler.scheduleWithFixedDelay(() -> this.doSingleScanInternal(false), 0L, this.scanInterval.toSeconds(), TimeUnit.SECONDS);
                    }
                } else {
                    if (scanTask != null) {
                        scanTask.cancel(true);
                        this.scanTask = null;
                    }
                    if (messageHandler == null) {
                        messageHandler = new WindowMessageHandler();
                        messageHandler.addListener(this);
                        this.windowMessageHandler = messageHandler;
                        this.scheduler.submit(messageHandler);
                        initScan = true;
                    }
                }
            }
            if (initScan) {
                this.doSingleScanInternal(false);
            }
        }
    }

    public synchronized void stopBackgroundScanning() {
        ScheduledFuture<?> scanTask;
        WindowMessageHandler messageHandler = this.windowMessageHandler;
        if (messageHandler != null) {
            messageHandler.removeListener(this);
            messageHandler.terminate();
            this.windowMessageHandler = null;
        }
        if ((scanTask = this.scanTask) != null) {
            scanTask.cancel(true);
            this.scanTask = null;
        }
    }

    @Override
    public void deviceAdded(String devicePath) {
        this.logger.debug("New USB device discovered: {}", (Object)devicePath);
        this.doSingleScan();
    }

    @Override
    public void deviceRemoved(String devicePath) {
        this.logger.debug("USB device removed: {}", (Object)devicePath);
        this.doSingleScan();
    }

    @Override
    public void portAdded(String portName) {
        this.logger.debug("New serial port discovered: {}", (Object)portName);
    }

    @Override
    public void portRemoved(String portName) {
        this.logger.debug("Serial port removed: {}", (Object)portName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceTerminated() {
        this.logger.debug("Listening for window messages failed, falling back to interval scanning");
        this.windowMessageFailed = true;
        WindowsUsbSerialDiscovery windowsUsbSerialDiscovery = this;
        synchronized (windowsUsbSerialDiscovery) {
            if (this.windowMessageHandler != null) {
                this.startBackgroundScanning();
            }
        }
    }

    public static List<String> readRegMultiSz(Memory buffer, long offset) {
        long bufferSize = buffer.size();
        if (offset < 0L || offset >= bufferSize) {
            throw new IllegalArgumentException("Invalid offset " + offset + " for buffer of size " + bufferSize);
        }
        int size = (int)(bufferSize - offset) / 2;
        if (size == 0) {
            return List.of();
        }
        return WindowsUsbSerialDiscovery.readRegMultiSz(buffer.getCharArray(offset, size));
    }

    public static List<String> readRegMultiSz(char[] chars) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\u0000') {
                if (start < i) {
                    result.add(String.valueOf(chars, start, i - start));
                }
                start = i + 1;
            }
            ++i;
        }
        return result;
    }

    private record DevicePathData(int vendorId, int productId, String id, int interfaceNumber) {
    }
}

