/*
Copyright 2019 Exoscale™

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"log"

	"github.com/exoscale/cli/cmd"
	_ "github.com/exoscale/cli/cmd/subcommands"
	"github.com/exoscale/cli/pkg/globalstate"
)

var (
	// version comes from the tag (during the build)
	version = "dev"
	// commit represents the HEAD commit (during the build)
	commit = "n/a"
)

func main() {
	log.SetFlags(0)
	globalstate.GitCommit = commit
	globalstate.GitVersion = version
	cmd.Execute(version, commit)
}
