// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::update_max_record_size::_update_max_record_size_output::UpdateMaxRecordSizeOutputBuilder;

pub use crate::operation::update_max_record_size::_update_max_record_size_input::UpdateMaxRecordSizeInputBuilder;

impl crate::operation::update_max_record_size::builders::UpdateMaxRecordSizeInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::update_max_record_size::UpdateMaxRecordSizeOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.update_max_record_size();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `UpdateMaxRecordSize`.
///
/// <p>This allows you to update the <code>MaxRecordSize</code> of a single record that you can write to, and read from a stream. You can ingest and digest single records up to 10240 KiB.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct UpdateMaxRecordSizeFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::update_max_record_size::builders::UpdateMaxRecordSizeInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::update_max_record_size::UpdateMaxRecordSizeOutput,
        crate::operation::update_max_record_size::UpdateMaxRecordSizeError,
    > for UpdateMaxRecordSizeFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::update_max_record_size::UpdateMaxRecordSizeOutput,
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl UpdateMaxRecordSizeFluentBuilder {
    /// Creates a new `UpdateMaxRecordSizeFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the UpdateMaxRecordSize as a reference.
    pub fn as_input(&self) -> &crate::operation::update_max_record_size::builders::UpdateMaxRecordSizeInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::update_max_record_size::UpdateMaxRecordSizeOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_max_record_size::UpdateMaxRecordSizeError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::update_max_record_size::UpdateMaxRecordSize::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::update_max_record_size::UpdateMaxRecordSize::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::update_max_record_size::UpdateMaxRecordSizeOutput,
        crate::operation::update_max_record_size::UpdateMaxRecordSizeError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.stream_arn(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_stream_arn(input);
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream for the <code>MaxRecordSize</code> update.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_stream_arn()
    }
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    pub fn max_record_size_in_kib(mut self, input: i32) -> Self {
        self.inner = self.inner.max_record_size_in_kib(input);
        self
    }
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    pub fn set_max_record_size_in_kib(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_max_record_size_in_kib(input);
        self
    }
    /// <p>The maximum record size of a single record in KiB that you can write to, and read from a stream. Specify a value between 1024 and 10240 KiB (1 to 10 MiB). If you specify a value that is out of this range, <code>UpdateMaxRecordSize</code> sends back an <code>ValidationException</code> message.</p>
    pub fn get_max_record_size_in_kib(&self) -> &::std::option::Option<i32> {
        self.inner.get_max_record_size_in_kib()
    }
}
