//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscolorwellstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSColorWellStyle(pub NSInteger);
impl NSColorWellStyle {
    #[doc(alias = "NSColorWellStyleDefault")]
    pub const Default: Self = Self(0);
    /// The default `colorWellStyle`. A well that accepts drag/drop of colors as well as reveals the color panel when clicked.
    #[doc(alias = "NSColorWellStyleMinimal")]
    pub const Minimal: Self = Self(1);
    /// A minimally adorned well. By default shows a popover color picker when clicked; this interaction behavior can be customized.
    #[doc(alias = "NSColorWellStyleExpanded")]
    pub const Expanded: Self = Self(2);
}

unsafe impl Encode for NSColorWellStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSColorWellStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscolorwell?language=objc)
    #[unsafe(super(NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    pub struct NSColorWell;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSColorWell {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSColorWell {}
);

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSColorWell {}
);

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSColorWell {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSColorWell {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSColorWell {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSColorWell {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSColorWell {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSColorWell {
    extern_methods!(
        #[unsafe(method(colorWellWithStyle:))]
        #[unsafe(method_family = none)]
        pub fn colorWellWithStyle(style: NSColorWellStyle, mtm: MainThreadMarker)
            -> Retained<Self>;

        /// Instantiates a well in the given style with a default configuration.
        #[unsafe(method(deactivate))]
        #[unsafe(method_family = none)]
        pub fn deactivate(&self);

        #[unsafe(method(activate:))]
        #[unsafe(method_family = none)]
        pub fn activate(&self, exclusive: bool);

        #[unsafe(method(isActive))]
        #[unsafe(method_family = none)]
        pub fn isActive(&self) -> bool;

        #[unsafe(method(drawWellInside:))]
        #[unsafe(method_family = none)]
        pub fn drawWellInside(&self, inside_rect: NSRect);

        #[deprecated = "This property will be deprecated in a future release."]
        #[unsafe(method(isBordered))]
        #[unsafe(method_family = none)]
        pub fn isBordered(&self) -> bool;

        /// Setter for [`isBordered`][Self::isBordered].
        #[deprecated = "This property will be deprecated in a future release."]
        #[unsafe(method(setBordered:))]
        #[unsafe(method_family = none)]
        pub fn setBordered(&self, bordered: bool);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeColorFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeColorFrom(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSColor")]
        #[unsafe(method(color))]
        #[unsafe(method_family = none)]
        pub fn color(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`color`][Self::color].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setColor:))]
        #[unsafe(method_family = none)]
        pub fn setColor(&self, color: &NSColor);

        #[unsafe(method(colorWellStyle))]
        #[unsafe(method_family = none)]
        pub fn colorWellStyle(&self) -> NSColorWellStyle;

        /// Setter for [`colorWellStyle`][Self::colorWellStyle].
        #[unsafe(method(setColorWellStyle:))]
        #[unsafe(method_family = none)]
        pub fn setColorWellStyle(&self, color_well_style: NSColorWellStyle);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub fn image(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub fn setImage(&self, image: Option<&NSImage>);

        /// The image that appears on the button portion of the expanded control. This property only applicable when `colorWellStyle` is `NSColorWellStyleExpanded`.
        #[unsafe(method(pulldownTarget))]
        #[unsafe(method_family = none)]
        pub fn pulldownTarget(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`pulldownTarget`][Self::pulldownTarget].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `pulldown_target` should be of the correct type.
        #[unsafe(method(setPulldownTarget:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPulldownTarget(&self, pulldown_target: Option<&AnyObject>);

        /// The target which `pulldownAction` is sent to. This property only applicable when `colorWellStyle` is `NSColorWellStyleExpanded` or `NSColorWellStyleMinimal`.
        #[unsafe(method(pulldownAction))]
        #[unsafe(method_family = none)]
        pub fn pulldownAction(&self) -> Option<Sel>;

        /// Setter for [`pulldownAction`][Self::pulldownAction].
        ///
        /// # Safety
        ///
        /// `pulldown_action` must be a valid selector.
        #[unsafe(method(setPulldownAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPulldownAction(&self, pulldown_action: Option<Sel>);

        /// Controls alpha support for the current color well, and the visibility of alpha slider in the color panel.
        /// When `NSColor.ignoresAlpha` (deprecated) is set to `YES`, this property will always return `NO` and alpha is not supported globally.
        #[unsafe(method(supportsAlpha))]
        #[unsafe(method_family = none)]
        pub fn supportsAlpha(&self) -> bool;

        /// Setter for [`supportsAlpha`][Self::supportsAlpha].
        #[unsafe(method(setSupportsAlpha:))]
        #[unsafe(method_family = none)]
        pub fn setSupportsAlpha(&self, supports_alpha: bool);

        #[cfg(feature = "objc2-core-foundation")]
        /// The maximum linear exposure a color in this color well can be set to. Defaults to 1 and ignores any value less than 1. If set to a value >= 2, the color picked for this well may have a linear exposure applied to it.
        #[unsafe(method(maximumLinearExposure))]
        #[unsafe(method_family = none)]
        pub fn maximumLinearExposure(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`maximumLinearExposure`][Self::maximumLinearExposure].
        #[unsafe(method(setMaximumLinearExposure:))]
        #[unsafe(method_family = none)]
        pub fn setMaximumLinearExposure(&self, maximum_linear_exposure: CGFloat);
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSColorWell {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSColorWell {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSColorWell {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
