/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.PrintWriter;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralVectorNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.Token;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypeIdentifierNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UntypedVariableBindingNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.UseNumericNode;
import macromedia.asc.parser.UsePrecisionNode;
import macromedia.asc.parser.UseRoundingNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.NumberUsage;

public class NodePrinter
implements Evaluator {
    private PrintWriter out;
    private int level;
    private int mode;
    public static final int man_mode = 0;
    public static final int machine_mode = 1;
    private static String[] usageName = new String[]{"Number", "decimal", "double", "int", "uint"};

    private void separate() {
        if (this.mode == 1) {
            this.out.print("|");
        }
    }

    private void push_in() {
        ++this.level;
        if (this.mode == 1) {
            this.out.print("[");
        } else {
            this.out.print(" ");
        }
    }

    private void pop_out() {
        if (this.mode == 1) {
            this.out.print("]");
        }
        --this.level;
    }

    private void indent() {
        if (this.mode == 0) {
            this.out.println();
            for (int i = this.level; i != 0; --i) {
                this.out.print("  ");
            }
        }
    }

    @Override
    public boolean checkFeature(Context cx, Node node) {
        return true;
    }

    public NodePrinter() {
        this(0, new PrintWriter(System.out, true));
    }

    public NodePrinter(PrintWriter out) {
        this(0, out);
    }

    public NodePrinter(int mode, PrintWriter out) {
        this.out = out;
        this.level = 0;
        this.mode = mode;
    }

    @Override
    public Value evaluate(Context cx, Node node) {
        this.indent();
        this.out.print("error:undefined printer method");
        return null;
    }

    @Override
    public Value evaluate(Context cx, IdentifierNode node) {
        this.indent();
        if (node instanceof TypeIdentifierNode) {
            this.out.print("typeidentifier ");
        } else if (node.isAttr()) {
            this.out.print("attributeidentifier ");
        } else {
            this.out.print("identifier ");
        }
        this.out.print(node.name);
        if (node instanceof TypeIdentifierNode) {
            this.out.print("types ");
            this.push_in();
            ((TypeIdentifierNode)node).typeArgs.evaluate(cx, this);
            this.pop_out();
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, IncrementNode node) {
        this.indent();
        this.out.print("increment");
        this.out.print(node.getMode() == -29 ? " bracket" : (node.getMode() == -13 ? " filter" : (node.getMode() == -19 ? " descend" : (node.getMode() == -18 ? " dot" : (node.getMode() == -133 ? " lexical" : " error")))));
        this.out.print((node.isPostfix ? " postfix " : " prefix ") + Token.getTokenClassName(node.op));
        this.push_in();
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ThisExpressionNode node) {
        this.indent();
        this.out.print("this");
        return null;
    }

    @Override
    public Value evaluate(Context cx, QualifiedIdentifierNode node) {
        this.indent();
        if (node.isAttr()) {
            this.out.print("qualifiedattributeidentifier ");
        } else {
            this.out.print("qualifiedidentifier ");
        }
        this.out.print(node.name);
        if (node.qualifier != null) {
            this.push_in();
            this.indent();
            this.out.print("qualifier");
            this.push_in();
            node.qualifier.evaluate(cx, this);
            this.pop_out();
            this.pop_out();
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, QualifiedExpressionNode node) {
        this.indent();
        if (node.isAttr()) {
            this.out.print("qualifiedattributeexpression ");
        } else {
            this.out.print("qualifiedexpression ");
        }
        this.out.print(node.name);
        if (node.qualifier != null) {
            this.push_in();
            this.indent();
            this.out.print("qualifier");
            this.push_in();
            node.qualifier.evaluate(cx, this);
            this.pop_out();
            this.pop_out();
        }
        if (node.expr != null) {
            this.push_in();
            this.indent();
            this.out.print("expr");
            this.push_in();
            node.expr.evaluate(cx, this);
            this.pop_out();
            this.pop_out();
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralBooleanNode node) {
        this.indent();
        this.out.print("literalboolean ");
        this.out.print(node.value ? 1 : 0);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralNumberNode node) {
        this.indent();
        this.out.print("literalnumber:");
        this.out.print(node.value);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralStringNode node) {
        this.indent();
        this.out.print("literalstring:");
        this.out.print(node.value);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralNullNode node) {
        this.indent();
        this.out.print("literalnull");
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralRegExpNode node) {
        this.indent();
        this.out.print("literalregexp:");
        this.out.print(node.value);
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralXMLNode node) {
        this.indent();
        this.out.print("literalxml");
        this.push_in();
        if (node.list != null) {
            node.list.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, FunctionCommonNode node) {
        this.indent();
        this.out.print("functioncommon");
        this.push_in();
        if (node.signature != null) {
            node.signature.evaluate(cx, this);
        }
        this.separate();
        if (node.body != null) {
            node.body.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParenExpressionNode node) {
        this.indent();
        this.out.print("paren");
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParenListExpressionNode node) {
        this.indent();
        this.out.print("parenlist");
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralObjectNode node) {
        this.indent();
        this.out.print("literalobject");
        this.push_in();
        if (node.fieldlist != null) {
            node.fieldlist.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralFieldNode node) {
        this.indent();
        this.out.print("literalfield");
        this.push_in();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.separate();
        if (node.value != null) {
            node.value.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralArrayNode node) {
        this.indent();
        this.out.print("literalarray");
        this.push_in();
        if (node.elementlist != null) {
            node.elementlist.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, LiteralVectorNode node) {
        this.indent();
        this.out.print("new<");
        node.type.evaluate(cx, this);
        this.out.print(">");
        this.push_in();
        if (node.elementlist != null) {
            node.elementlist.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, SuperExpressionNode node) {
        this.indent();
        this.out.print("superexpression");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, MemberExpressionNode node) {
        this.indent();
        this.out.print("member");
        this.push_in();
        if (node.base != null) {
            node.base.evaluate(cx, this);
        }
        this.separate();
        if (node.selector != null) {
            node.selector.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, InvokeNode node) {
        this.indent();
        this.out.print("invoke");
        this.out.print(node.getMode() == -29 ? " bracket" : (node.getMode() == -13 ? " filter" : (node.getMode() == -19 ? " descend" : (node.getMode() == -133 ? " lexical" : " dot"))));
        this.push_in();
        this.out.print(node.name);
        this.separate();
        if (node.args != null) {
            node.args.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, CallExpressionNode node) {
        this.indent();
        this.out.print(node.is_new ? "construct" : "call");
        this.out.print(node.getMode() == -29 ? " bracket" : (node.getMode() == -13 ? " filter" : (node.getMode() == -19 ? " descend" : (node.getMode() == -133 ? " lexical" : " dot"))));
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.separate();
        if (node.args != null) {
            node.args.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, DeleteExpressionNode node) {
        this.indent();
        this.out.print("delete");
        this.out.print(node.getMode() == -29 ? " bracket" : (node.getMode() == -13 ? " filter" : (node.getMode() == -19 ? " descend" : (node.getMode() == -133 ? " lexical" : " dot"))));
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ApplyTypeExprNode node) {
        this.indent();
        this.out.print("applytype");
        this.push_in();
        node.typeArgs.evaluate(cx, this);
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, GetExpressionNode node) {
        this.indent();
        this.out.print("get");
        this.out.print(node.getMode() == -29 ? " bracket" : (node.getMode() == -13 ? " filter" : (node.getMode() == -19 ? " descend" : (node.getMode() == -133 ? " lexical" : " dot"))));
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, SetExpressionNode node) {
        this.indent();
        this.out.print("set");
        this.out.print(node.getMode() == -29 ? " bracket" : (node.getMode() == -13 ? " filter" : (node.getMode() == -19 ? " descend" : (node.getMode() == -133 ? " lexical" : " dot"))));
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.separate();
        if (node.args != null) {
            node.args.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, UnaryExpressionNode node) {
        this.indent();
        this.out.print("unary");
        this.push_in();
        this.out.print(Token.getTokenClassName(node.op));
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryExpressionNode node) {
        this.indent();
        this.out.print("binary");
        this.push_in();
        this.out.print(Token.getTokenClassName(node.op));
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.lhs != null) {
            node.lhs.evaluate(cx, this);
        }
        this.separate();
        if (node.rhs != null) {
            node.rhs.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ConditionalExpressionNode node) {
        this.indent();
        this.out.print("cond");
        this.push_in();
        if (node.condition != null) {
            node.condition.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.thenexpr != null) {
            node.thenexpr.evaluate(cx, this);
        }
        this.separate();
        if (node.elseexpr != null) {
            node.elseexpr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ArgumentListNode node) {
        this.indent();
        this.out.print("argumentlist");
        this.push_in();
        for (Node n : node.items) {
            n.evaluate(cx, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ListNode node) {
        this.indent();
        this.out.print("list");
        this.push_in();
        for (Node n : node.items) {
            n.evaluate(cx, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, StatementListNode node) {
        this.indent();
        this.out.print("statementlist");
        this.push_in();
        for (Node n : node.items) {
            if (n == null) continue;
            n.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, EmptyElementNode node) {
        this.indent();
        this.out.print("empty");
        return null;
    }

    @Override
    public Value evaluate(Context cx, EmptyStatementNode node) {
        this.indent();
        this.out.print("empty");
        return null;
    }

    @Override
    public Value evaluate(Context cx, ExpressionStatementNode node) {
        this.indent();
        this.out.print("expression");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, SuperStatementNode node) {
        this.indent();
        this.out.print("super");
        this.push_in();
        if (node.call.args != null) {
            node.call.args.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, LabeledStatementNode node) {
        this.indent();
        this.out.print("labeled");
        this.push_in();
        if (node.label != null) {
            node.label.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.statement != null) {
            node.statement.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, IfStatementNode node) {
        this.indent();
        this.out.print("if");
        this.push_in();
        if (node.condition != null) {
            node.condition.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.thenactions != null) {
            node.thenactions.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.elseactions != null) {
            node.elseactions.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, SwitchStatementNode node) {
        this.indent();
        this.out.print("switch");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, CaseLabelNode node) {
        this.indent();
        this.out.print("case");
        this.push_in();
        if (node.label != null) {
            node.label.evaluate(cx, this);
        } else {
            this.out.print("default");
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, DoStatementNode node) {
        this.indent();
        this.out.print("do");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, WhileStatementNode node) {
        this.indent();
        this.out.print("while");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.statement != null) {
            node.statement.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ForStatementNode node) {
        this.indent();
        this.out.print("for");
        this.push_in();
        if (node.initialize != null) {
            node.initialize.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.test != null) {
            node.test.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.increment != null) {
            node.increment.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.statement != null) {
            node.statement.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, WithStatementNode node) {
        this.indent();
        this.out.print("with");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.statement != null) {
            node.statement.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ContinueStatementNode node) {
        this.indent();
        this.out.print("continue");
        this.push_in();
        if (node.id != null) {
            node.id.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, BreakStatementNode node) {
        this.indent();
        this.out.print("break");
        this.push_in();
        if (node.id != null) {
            node.id.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ReturnStatementNode node) {
        this.indent();
        this.out.print("return");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ThrowStatementNode node) {
        this.indent();
        this.out.print("throw");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, TryStatementNode node) {
        this.indent();
        this.out.print("try");
        this.push_in();
        if (node.tryblock != null) {
            node.tryblock.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.catchlist != null) {
            node.catchlist.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.finallyblock != null) {
            node.finallyblock.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, CatchClauseNode node) {
        this.indent();
        this.out.print("catch");
        this.push_in();
        if (node.parameter != null) {
            node.parameter.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, FinallyClauseNode node) {
        this.indent();
        this.out.print("finally");
        this.push_in();
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, UseDirectiveNode node) {
        this.indent();
        this.out.print("use");
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, IncludeDirectiveNode node) {
        this.indent();
        this.out.print("include");
        this.push_in();
        if (node.filespec != null) {
            node.filespec.evaluate(cx, this);
        }
        this.separate();
        if (node.program != null) {
            // empty if block
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ImportDirectiveNode node) {
        this.indent();
        this.out.print("import");
        this.push_in();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, AttributeListNode node) {
        this.indent();
        this.out.print("attributelist");
        this.push_in();
        for (Node n : node.items) {
            n.evaluate(cx, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, VariableDefinitionNode node) {
        this.indent();
        if (node.kind == -65) {
            this.out.print("const");
        } else {
            this.out.print("var");
        }
        this.push_in();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.list != null) {
            node.list.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, VariableBindingNode node) {
        this.indent();
        this.out.print("variablebinding");
        this.push_in();
        if (node.variable != null) {
            node.variable.evaluate(cx, this);
        }
        this.separate();
        if (node.initializer != null) {
            node.initializer.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, UntypedVariableBindingNode node) {
        this.indent();
        this.out.print("untypedvariablebinding");
        this.push_in();
        if (node.identifier != null) {
            node.identifier.evaluate(cx, this);
        }
        this.separate();
        if (node.initializer != null) {
            node.initializer.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, TypedIdentifierNode node) {
        this.indent();
        this.out.print("typedidentifier");
        this.push_in();
        if (node.identifier != null) {
            node.identifier.evaluate(cx, this);
        }
        this.separate();
        if (node.type != null) {
            node.type.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryFunctionDefinitionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, FunctionDefinitionNode node) {
        this.indent();
        this.out.print("function");
        this.push_in();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.separate();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.separate();
        if (node.fexpr != null) {
            node.fexpr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, FunctionNameNode node) {
        this.indent();
        this.out.print("functionname");
        this.out.print(node.kind == -79 ? " get" : (node.kind == -99 ? " set" : ""));
        this.push_in();
        if (node.identifier != null) {
            node.identifier.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, FunctionSignatureNode node) {
        this.indent();
        this.out.print(node.inits != null ? "constructorsignature" : "functionsignature");
        this.push_in();
        if (node.parameter != null) {
            node.parameter.evaluate(cx, this);
        }
        this.separate();
        if (node.result != null) {
            node.result.evaluate(cx, this);
        }
        if (node.inits != null) {
            node.inits.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParameterNode node) {
        this.indent();
        this.out.print("parameter");
        if (node.kind == -65) {
            this.out.print(" const");
        }
        this.push_in();
        if (node.identifier != null) {
            node.identifier.evaluate(cx, this);
        }
        this.separate();
        if (node.init != null) {
            node.init.evaluate(cx, this);
        }
        this.separate();
        if (node.type != null) {
            node.type.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, RestExpressionNode node) {
        this.indent();
        this.out.print("restexpression");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, RestParameterNode node) {
        this.indent();
        this.out.print("restparameter");
        this.push_in();
        if (node.parameter != null) {
            node.parameter.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ClassDefinitionNode node) {
        this.indent();
        this.out.print("class");
        this.push_in();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.separate();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.separate();
        if (node.baseclass != null) {
            node.baseclass.evaluate(cx, this);
        }
        this.separate();
        if (node.interfaces != null) {
            node.interfaces.evaluate(cx, this);
        }
        this.separate();
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, InterfaceDefinitionNode node) {
        this.indent();
        this.out.print("interface");
        this.push_in();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.separate();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.separate();
        if (node.interfaces != null) {
            node.interfaces.evaluate(cx, this);
        }
        this.separate();
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ClassNameNode node) {
        this.indent();
        this.out.print("classname");
        this.push_in();
        if (node.pkgname != null) {
            node.pkgname.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.ident != null) {
            node.ident.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, InheritanceNode node) {
        if (node.baseclass != null) {
            this.indent();
            this.out.print("extends");
            this.push_in();
            node.baseclass.evaluate(cx, this);
            this.pop_out();
        }
        this.separate();
        if (node.interfaces != null) {
            this.indent();
            this.out.print("implements");
            this.push_in();
            node.interfaces.evaluate(cx, this);
            this.pop_out();
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, NamespaceDefinitionNode node) {
        this.indent();
        this.out.print("namespace");
        this.push_in();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.value != null) {
            node.value.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ConfigNamespaceDefinitionNode node) {
        this.indent();
        this.out.print("config namespace");
        this.push_in();
        if (node.attrs != null) {
            node.attrs.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (node.value != null) {
            node.value.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, PackageDefinitionNode node) {
        this.indent();
        this.out.print("package");
        this.push_in();
        if (node.name != null) {
            node.name.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, PackageIdentifiersNode node) {
        this.indent();
        this.out.print("packageidentifiers");
        this.push_in();
        for (IdentifierNode n : node.list) {
            n.evaluate(cx, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, PackageNameNode node) {
        this.indent();
        this.out.print("packagename");
        this.push_in();
        if (node.id != null) {
            node.id.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ProgramNode node) {
        this.indent();
        this.out.print("program");
        this.push_in();
        if (node.statements != null) {
            node.statements.evaluate(cx, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ErrorNode node) {
        this.indent();
        this.out.print("error");
        this.out.print(node.errorCode);
        return null;
    }

    @Override
    public Value evaluate(Context cx, ToObjectNode node) {
        this.indent();
        this.out.print("toobject");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    @Override
    public Value evaluate(Context cx, LoadRegisterNode node) {
        this.indent();
        this.out.print("loadregister");
        this.push_in();
        if (node.reg != null) {
            node.reg.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, StoreRegisterNode node) {
        this.indent();
        this.out.print("storeregister");
        this.push_in();
        if (node.reg != null) {
            node.reg.evaluate(cx, this);
        }
        this.pop_out();
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    @Override
    public Value evaluate(Context cx, RegisterNode node) {
        this.indent();
        this.out.print("register");
        this.push_in();
        this.out.print(node.index);
        return null;
    }

    @Override
    public Value evaluate(Context cx, HasNextNode node) {
        this.indent();
        this.out.print("hasNext");
        this.push_in();
        if (node.objectRegister != null) {
            node.objectRegister.evaluate(cx, this);
        }
        this.pop_out();
        this.push_in();
        if (node.indexRegister != null) {
            node.indexRegister.evaluate(cx, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    @Override
    public Value evaluate(Context cx, BoxNode node) {
        this.indent();
        this.out.print("box");
        this.out.print(node.actual);
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, CoerceNode node) {
        this.indent();
        this.out.print("coerce");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, PragmaNode node) {
        this.indent();
        this.out.print("pragma");
        this.push_in();
        if (node.list != null) {
            node.list.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, UsePrecisionNode node) {
        this.indent();
        this.out.print("usePrecision(" + node.precision + ")");
        return null;
    }

    @Override
    public Value evaluate(Context cx, UseNumericNode node) {
        this.indent();
        this.out.print("useNumeric(" + usageName[node.numeric_mode] + ")");
        return null;
    }

    @Override
    public Value evaluate(Context cx, UseRoundingNode node) {
        this.indent();
        this.out.print("useRounding(" + NumberUsage.roundingModeName[node.mode] + ")");
        return null;
    }

    @Override
    public Value evaluate(Context cx, PragmaExpressionNode node) {
        this.indent();
        this.out.print("pragmaitem");
        this.push_in();
        if (node.identifier != null) {
            node.identifier.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, ParameterListNode node) {
        this.indent();
        this.out.print("parameterlist");
        this.push_in();
        int size = node.items.size();
        for (int i = 0; i < size; ++i) {
            ParameterNode param = (ParameterNode)node.items.get(i);
            if (param != null) {
                param.evaluate(cx, this);
            }
            if (i >= size - 1) continue;
            this.separate();
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, MetaDataNode node) {
        int length;
        if (node.data != null) {
            MetaDataEvaluator mde = new MetaDataEvaluator();
            mde.evaluate(cx, node);
        }
        this.indent();
        this.out.print("metadata:");
        this.out.print(node.getId() != null ? node.getId() : "");
        this.out.print(" ");
        int n = length = node.getValues() == null ? 0 : node.getValues().length;
        for (int i = 0; i < length; ++i) {
            Value v = node.getValues()[i];
            if (v instanceof MetaDataEvaluator.KeyValuePair) {
                MetaDataEvaluator.KeyValuePair pair = (MetaDataEvaluator.KeyValuePair)v;
                this.out.print("[" + pair.key + "," + pair.obj + "]");
            }
            if (!(v instanceof MetaDataEvaluator.KeylessValue)) continue;
            MetaDataEvaluator.KeylessValue val = (MetaDataEvaluator.KeylessValue)v;
            this.out.print("[" + val.obj + "]");
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, DefaultXMLNamespaceNode node) {
        this.indent();
        this.out.print("dxns");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }

    @Override
    public Value evaluate(Context cx, DocCommentNode node) {
        this.evaluate(cx, (MetaDataNode)node);
        return null;
    }

    @Override
    public Value evaluate(Context cx, ImportNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryProgramNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryClassDefNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, BinaryInterfaceDefinitionNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context cx, TypeExpressionNode node) {
        this.indent();
        this.out.print("typeexpr");
        this.push_in();
        if (node.expr != null) {
            node.expr.evaluate(cx, this);
        }
        this.pop_out();
        return null;
    }
}

