/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.RescueBodyNode;

public class RescueNode
extends Node {
    private Node bodyNode;
    private RescueBodyNode rescueNode;
    private Node elseNode;

    public RescueNode(SourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position);
        this.bodyNode = this.adopt(bodyNode);
        this.rescueNode = (RescueBodyNode)this.adopt(rescueNode);
        this.elseNode = this.adopt(elseNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        RescueNode other = (RescueNode)node;
        if (this.getBody() == null && other.getBody() == null) {
            if (this.getRescue() == null && other.getRescue() == null) {
                if (this.getElse() == null && other.getElse() == null) {
                    return true;
                }
                if (this.getElse() == null || other.getElse() == null) {
                    return false;
                }
                return this.getElse().isSame(other.getElse());
            }
            if (this.getRescue() == null || other.getRescue() == null) {
                return false;
            }
            if (this.getElse() == null && other.getElse() == null) {
                return this.getRescue().isSame(other.getRescue());
            }
            if (this.getElse() == null || other.getElse() == null) {
                return false;
            }
            return this.getElse().isSame(other.getElse()) && this.getRescue().isSame(other.getRescue());
        }
        if (this.getBody() == null || other.getBody() == null) {
            return false;
        }
        if (this.getRescue() == null && other.getRescue() == null) {
            if (this.getElse() == null && other.getElse() == null) {
                return this.getRescue().isSame(other.getRescue());
            }
            if (this.getElse() == null || other.getElse() == null) {
                return false;
            }
            return this.getElse().isSame(other.getElse()) && this.getBody().isSame(other.getBody());
        }
        if (this.getRescue() == null || other.getRescue() == null) {
            return false;
        }
        if (this.getElse() == null && other.getElse() == null) {
            return this.getRescue().isSame(other.getRescue()) && this.getBody().isSame(other.getBody());
        }
        if (this.getElse() == null || other.getElse() == null) {
            return false;
        }
        return this.getElse().isSame(other.getElse()) && this.getRescue().isSame(other.getRescue()) && this.getBody().isSame(other.getBody());
    }

    public NodeType getNodeType() {
        return NodeType.RESCUENODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyException() {
        return this.getBody();
    }

    public void setBody(Node body) {
        this.bodyNode = this.adopt(body);
    }

    public Node getElse() {
        return this.elseNode;
    }

    @Deprecated
    public Node getElseNode() {
        return this.getElse();
    }

    public void setElse(Node elseNode) {
        this.elseNode = this.adopt(elseNode);
    }

    public RescueBodyNode getRescue() {
        return this.rescueNode;
    }

    @Deprecated
    public RescueBodyNode getRescueNode() {
        return this.getRescue();
    }

    public void setRescue(RescueBodyNode rescue) {
        this.rescueNode = (RescueBodyNode)this.adopt(rescue);
    }
}

