/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceImportExport;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordElementType;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.HighlightReporterKt;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.ecma6.ES6DecoratorDeclaration;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSWithClause;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSKeywordHighlighterVisitor
extends JSElementVisitor {
    protected static final TokenSet TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.DOLLAR, JSTokenTypes.RBRACE});
    @NotNull
    protected final HighlightInfoHolder myHolder;
    @NotNull
    protected final JSHighlighter myHighlighter;
    @NotNull
    private final Set<String> myKeywords;

    public JSKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder, @NotNull DialectOptionHolder dialectOptionHolder) {
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        if (dialectOptionHolder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        this(holder, new JSHighlighter(dialectOptionHolder));
    }

    protected JSKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder, @NotNull JSHighlighter highlighter) {
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        if (highlighter == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(3);
        }
        this.myKeywords = new HashSet<String>();
        this.myHolder = holder;
        this.myHighlighter = highlighter;
        TokenSet keywords = highlighter.getKeywords();
        for (IElementType keyword : keywords.getTypes()) {
            if (!(keyword instanceof JSKeywordElementType)) continue;
            this.myKeywords.add(((JSKeywordElementType)keyword).getKeyword());
        }
    }

    public void visitJSForInStatement(@NotNull JSForInStatement element2) {
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(4);
        }
        this.highlightChildKeywordOfType((PsiElement)element2, JSTokenTypes.EACH_KEYWORD);
        super.visitJSForInStatement(element2);
    }

    public void visitES6DecoratorDeclaration(@NotNull ES6DecoratorDeclaration node) {
        if (node == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(5);
        }
        this.highlightChildKeywordOfType((PsiElement)node, JSTokenTypes.DECORATOR_KEYWORD);
        super.visitES6DecoratorDeclaration(node);
    }

    public void visitES6FromClause(@NotNull ES6FromClause element2) {
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(6);
        }
        this.highlightChildKeywordOfType((PsiElement)element2, JSTokenTypes.FROM_KEYWORD);
        super.visitES6FromClause(element2);
    }

    public void visitES6NamespaceImportExport(@NotNull ES6NamespaceImportExport element2) {
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(7);
        }
        this.highlightChildKeywordOfType((PsiElement)element2, JSTokenTypes.AS_KEYWORD);
        super.visitES6NamespaceImportExport(element2);
    }

    public void visitES6ImportExportSpecifierAlias(@NotNull ES6ImportExportSpecifierAlias alias) {
        if (alias == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(8);
        }
        this.highlightChildKeywordOfType((PsiElement)alias, JSTokenTypes.AS_KEYWORD);
        super.visitES6ImportExportSpecifierAlias(alias);
    }

    public void visitJSAttributeList(@NotNull JSAttributeList attributeList) {
        if (attributeList == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(9);
        }
        super.visitJSAttributeList(attributeList);
        this.highlightChildKeywordOfType((PsiElement)attributeList, JSTokenTypes.GET_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)attributeList, JSTokenTypes.SET_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)attributeList, JSTokenTypes.ACCESSOR_KEYWORD);
    }

    public void visitJSDocTagNamepath(@NotNull JSDocTagNamepath element2) {
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(10);
        }
        this.highlightExcludingLeadingAsterisks((PsiElement)element2, DialectDetector.isTypeScript((PsiElement)element2) ? TypeScriptHighlighter.TS_DOC_TAG_NAMEPATH : JSHighlighter.JS_DOC_TAG_NAMEPATH);
        super.visitJSDocTagNamepath(element2);
    }

    public void visitJSDocTagType(@NotNull JSDocTagType element2) {
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(11);
        }
        this.highlightExcludingLeadingAsterisks((PsiElement)element2, DialectDetector.isTypeScript((PsiElement)element2) ? TypeScriptHighlighter.TS_DOC_TYPE : JSHighlighter.JS_DOC_TYPE);
        super.visitJSDocTagType(element2);
    }

    public void visitElement(@NotNull PsiElement element2) {
        String elementText;
        IElementType elementType;
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(12);
        }
        if (element2 instanceof LeafPsiElement && ((elementType = ((LeafPsiElement)element2).getElementType()) == JSTokenTypes.IDENTIFIER || elementType == JSTokenTypes.PRIVATE_IDENTIFIER) && this.myKeywords.contains(elementText = element2.getText())) {
            Lexer lexer = this.myHighlighter.getHighlightingLexer();
            lexer.start((CharSequence)elementText);
            if (this.myHighlighter.getKeywords().contains(lexer.getTokenType())) {
                this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(element2.getNode()).textAttributes(TextAttributes.ERASE_MARKER).create());
            }
        }
        super.visitElement(element2);
    }

    public void visitJSLabeledStatement(JSLabeledStatement labeledStatement) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            this.lineMarker(labelIdentifier, this.myHighlighter.getMappedKey(JSHighlighter.JS_LABEL), "label");
        }
    }

    public void visitJSStatementWithLabelReference(JSStatementWithLabelReference labeledStatement) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            this.lineMarker(labelIdentifier, this.myHighlighter.getMappedKey(JSHighlighter.JS_LABEL), "label");
        }
    }

    public void visitWithClause(@NotNull JSWithClause assertClause) {
        if (assertClause == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(13);
        }
        this.highlightChildKeywordOfType((PsiElement)assertClause, JSTokenTypes.WITH_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)assertClause, JSTokenTypes.ASSERT_KEYWORD);
    }

    public void visitJSFile(@NotNull JSFile file) {
        if (file == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(14);
        }
        super.visitJSFile(file);
        this.highlightTopLevelDirective((PsiElement)file);
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        if (node == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(15);
        }
        super.visitJSFunctionDeclaration(node);
        this.highlightTopLevelDirective((PsiElement)node.getBlock());
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(16);
        }
        super.visitJSFunctionExpression(node);
        this.highlightTopLevelDirective((PsiElement)node.getBlock());
    }

    public void visitJSStringTemplateExpression(@NotNull JSStringTemplateExpression stringTemplateExpression) {
        if (stringTemplateExpression == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(17);
        }
        for (ASTNode child : stringTemplateExpression.getNode().getChildren(TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS)) {
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(child, this.myHighlighter.getMappedKey(JSHighlighter.JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS)));
        }
        super.visitJSStringTemplateExpression(stringTemplateExpression);
    }

    private void highlightTopLevelDirective(PsiElement element2) {
        JSStatement statement = JSPsiImplUtils.findFirstStatementOrDirective((PsiElement)element2);
        if (!JSPsiImplUtils.isCompilerDirectiveStatement((PsiElement)statement, (String[])new String[]{"use asm", "use babel", "use client", "use server", "use strict", "use cache"})) {
            return;
        }
        this.highlightChildKeywordOfType((PsiElement)statement, JSElementTypes.LITERAL_EXPRESSION);
    }

    private void highlightExcludingLeadingAsterisks(@NotNull PsiElement element2, @NotNull TextAttributesKey attributesKey) {
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(18);
        }
        if (attributesKey == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(19);
        }
        int startOffset = 0;
        for (ASTNode cur = element2.getNode().getFirstChildNode(); cur != null; cur = cur.getTreeNext()) {
            int eol;
            if (cur.getElementType() != JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK || startOffset == cur.getStartOffsetInParent()) continue;
            int endOffset = cur.getStartOffsetInParent();
            ASTNode prevNode = cur.getTreePrev();
            if (prevNode.getElementType() == JSDocTokenTypes.DOC_WHITESPACE && (eol = prevNode.getText().lastIndexOf(10)) >= 0) {
                endOffset = prevNode.getStartOffsetInParent() + eol;
            }
            this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(element2, TextRange.create((int)startOffset, (int)endOffset)).textAttributes(attributesKey).create());
            startOffset = cur.getStartOffsetInParent() + cur.getTextLength();
        }
        this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(element2, TextRange.create((int)startOffset, (int)element2.getNode().getTextLength())).textAttributes(attributesKey).create());
    }

    protected static HighlightInfo highlightKeyword(@NotNull ASTNode keyword, @NotNull TextAttributesKey key) {
        if (keyword == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(20);
        }
        if (key == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(21);
        }
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(keyword).textAttributes(key).create();
    }

    protected void highlightChildKeywordOfTypes(@NotNull PsiElement parent, @NotNull TokenSet types2) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(22);
        }
        if (types2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(23);
        }
        if ((keyword = parent.getNode().findChildByType(types2)) != null) {
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHighlighter.getMappedKey(JSHighlighter.JS_KEYWORD)));
        }
    }

    protected void highlightChildKeywordOfType(@NotNull PsiElement parent, @NotNull IElementType type2) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(24);
        }
        if (type2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(25);
        }
        if ((keyword = parent.getNode().findChildByType(type2)) != null) {
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHighlighter.getMappedKey(JSHighlighter.JS_KEYWORD)));
        }
    }

    protected void lineMarker(@NotNull PsiElement element2, @NotNull TextAttributesKey attrKey, @NotNull String debugName) {
        if (element2 == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(26);
        }
        if (attrKey == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(27);
        }
        if (debugName == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(28);
        }
        HighlightReporterKt.addHighlight(this.myHolder, element2, attrKey, debugName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertClause";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringTemplateExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrKey";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForInStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitES6DecoratorDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitES6FromClause";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitES6NamespaceImportExport";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitES6ImportExportSpecifierAlias";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSAttributeList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDocTagNamepath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDocTagType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWithClause";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSStringTemplateExpression";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightExcludingLeadingAsterisks";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeyword";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfTypes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "lineMarker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

