/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterView;
import com.intellij.lang.javascript.linter.NewLinterView;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterConfigurable<T extends JSLinterState>
extends UntypedJSLinterConfigurable {
    private final Class<? extends JSLinterConfiguration<T>> myConfigurationClass;

    public JSLinterConfigurable(@NotNull Project project, Class<? extends JSLinterConfiguration<T>> configurationClass, boolean fullModeDialog) {
        if (project == null) {
            JSLinterConfigurable.$$$reportNull$$$0(0);
        }
        super(project, fullModeDialog);
        this.myConfigurationClass = configurationClass;
    }

    @Override
    @NotNull
    protected abstract JSLinterView<T> createView();

    @Override
    public boolean isModified() {
        ExtendedLinterState<T> newState;
        JSLinterView<T> view = this.getView();
        if (view == null) {
            return false;
        }
        ExtendedLinterState oldState = this.getExtendedState(this.myConfigurationClass);
        return !oldState.equals(newState = view.getExtendedState()) || view instanceof NewLinterView && ((NewLinterView)view).isModified();
    }

    public void apply() throws ConfigurationException {
        JSLinterView<T> view = this.getView();
        if (view != null) {
            this.setExtendedState(view.getExtendedState(), this.myConfigurationClass);
            if (view instanceof NewLinterView) {
                ((NewLinterView)view).apply();
            }
        }
    }

    public void reset() {
        JSLinterView view = this.getView();
        if (view != null) {
            view.setExtendedState(this.getExtendedState(this.myConfigurationClass));
            this.resizeDialogToFitPreferredSize(view);
            if (view instanceof NewLinterView) {
                ((NewLinterView)view).reset();
            }
        }
    }

    @Nullable
    protected JSLinterView<T> getView() {
        return this.myView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfigurable", "<init>"));
    }
}

