/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.ext.awt.image.rendered;

import java.awt.image.Raster;
import org.jetbrains.relocated.apache.batik.ext.awt.image.rendered.LRUCache;
import org.jetbrains.relocated.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.jetbrains.relocated.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.jetbrains.relocated.apache.batik.ext.awt.image.rendered.TileStore;
import org.jetbrains.relocated.apache.batik.util.HaltingThread;

public class TileGrid
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private int xSz;
    private int ySz;
    private int minTileX;
    private int minTileY;
    private TileLRUMember[][] rasters = null;
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;

    public TileGrid(int minTileX, int minTileY, int xSz, int ySz, TileGenerator source, LRUCache cache) {
        this.cache = cache;
        this.source = source;
        this.minTileX = minTileX;
        this.minTileY = minTileY;
        this.xSz = xSz;
        this.ySz = ySz;
        this.rasters = new TileLRUMember[ySz][];
    }

    @Override
    public void setTile(int x2, int y2, Raster ras) {
        TileLRUMember item;
        y2 -= this.minTileY;
        if ((x2 -= this.minTileX) < 0 || x2 >= this.xSz) {
            return;
        }
        if (y2 < 0 || y2 >= this.ySz) {
            return;
        }
        TileLRUMember[] row = this.rasters[y2];
        if (ras == null) {
            if (row == null) {
                return;
            }
            TileLRUMember item2 = row[x2];
            if (item2 == null) {
                return;
            }
            row[x2] = null;
            this.cache.remove(item2);
            return;
        }
        if (row != null) {
            item = row[x2];
            if (item == null) {
                row[x2] = item = new TileLRUMember();
            }
        } else {
            row = new TileLRUMember[this.xSz];
            row[x2] = item = new TileLRUMember();
            this.rasters[y2] = row;
        }
        item.setRaster(ras);
        this.cache.add(item);
    }

    @Override
    public Raster getTileNoCompute(int x2, int y2) {
        y2 -= this.minTileY;
        if ((x2 -= this.minTileX) < 0 || x2 >= this.xSz) {
            return null;
        }
        if (y2 < 0 || y2 >= this.ySz) {
            return null;
        }
        TileLRUMember[] row = this.rasters[y2];
        if (row == null) {
            return null;
        }
        TileLRUMember item = row[x2];
        if (item == null) {
            return null;
        }
        Raster ret = item.retrieveRaster();
        if (ret != null) {
            this.cache.add(item);
        }
        return ret;
    }

    @Override
    public Raster getTile(int x2, int y2) {
        y2 -= this.minTileY;
        if ((x2 -= this.minTileX) < 0 || x2 >= this.xSz) {
            return null;
        }
        if (y2 < 0 || y2 >= this.ySz) {
            return null;
        }
        Raster ras = null;
        TileLRUMember[] row = this.rasters[y2];
        TileLRUMember item = null;
        if (row != null) {
            item = row[x2];
            if (item != null) {
                ras = item.retrieveRaster();
            } else {
                row[x2] = item = new TileLRUMember();
            }
        } else {
            row = new TileLRUMember[this.xSz];
            this.rasters[y2] = row;
            row[x2] = item = new TileLRUMember();
        }
        if (ras == null) {
            ras = this.source.genTile(x2 + this.minTileX, y2 + this.minTileY);
            if (HaltingThread.hasBeenHalted()) {
                return ras;
            }
            item.setRaster(ras);
        }
        this.cache.add(item);
        return ras;
    }
}

