/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.encoding;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"deflate", "", "input", "inflate", "expectedSize", "", "commons"})
public final class Zip_jvmKt {
    @NotNull
    public static final byte[] deflate(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        deflater.setInput(input);
        deflater.finish();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count2 = deflater.deflate(buffer);
            output.write(buffer, 0, count2);
        }
        deflater.end();
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] inflate(@NotNull byte[] input, int expectedSize) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Inflater inflater = new Inflater();
        inflater.setInput(input);
        byte[] output = new byte[expectedSize];
        int count2 = inflater.inflate(output);
        inflater.end();
        byte[] byArray = Arrays.copyOf(output, count2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }
}

