/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.listener;

import dev.langchain4j.Experimental;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.request.ChatRequest;
import java.util.Map;

@Experimental
public class ChatModelErrorContext {
    private final Throwable error;
    private final ChatRequest chatRequest;
    @Deprecated(forRemoval=true)
    private final ChatModelRequest request;
    @Deprecated(forRemoval=true)
    private final ChatModelResponse partialResponse;
    private final Map<Object, Object> attributes;

    public ChatModelErrorContext(Throwable error, ChatRequest chatRequest, Map<Object, Object> attributes) {
        this.error = ValidationUtils.ensureNotNull(error, "error");
        this.chatRequest = ValidationUtils.ensureNotNull(chatRequest, "chatRequest");
        this.request = ChatModelRequest.fromChatRequest(chatRequest);
        this.partialResponse = null;
        this.attributes = ValidationUtils.ensureNotNull(attributes, "attributes");
    }

    @Deprecated(forRemoval=true)
    public ChatModelErrorContext(Throwable error, ChatModelRequest request, ChatModelResponse partialResponse, Map<Object, Object> attributes) {
        this.error = ValidationUtils.ensureNotNull(error, "error");
        this.chatRequest = ChatModelRequest.toChatRequest(request);
        this.request = ValidationUtils.ensureNotNull(request, "request");
        this.partialResponse = partialResponse;
        this.attributes = ValidationUtils.ensureNotNull(attributes, "attributes");
    }

    public Throwable error() {
        return this.error;
    }

    public ChatRequest chatRequest() {
        return this.chatRequest;
    }

    @Deprecated(forRemoval=true)
    public ChatModelRequest request() {
        return this.request;
    }

    @Deprecated(forRemoval=true)
    public ChatModelResponse partialResponse() {
        return this.partialResponse;
    }

    public Map<Object, Object> attributes() {
        return this.attributes;
    }
}

