/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariablesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB'\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/debugger/VariablesGroup;", "Lcom/intellij/xdebugger/frame/XValueGroup;", "start", "", "end", "variables", "", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "name", "", "<init>", "(IILjava/util/List;Lorg/jetbrains/debugger/VariableContext;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/util/List;Lorg/jetbrains/debugger/VariableContext;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.javascript.debugger.ui"})
public final class VariablesGroup
extends XValueGroup {
    private final int start;
    private final int end;
    @NotNull
    private final List<Variable> variables;
    @NotNull
    private final VariableContext context;

    public VariablesGroup(int start, int end, @NotNull List<? extends Variable> variables, @NotNull VariableContext context, @NotNull String name) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.start = start;
        this.end = end;
        this.variables = variables;
        this.context = context;
    }

    public VariablesGroup(@NotNull String name, @NotNull List<? extends Variable> variables, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(0, variables.size(), variables, context, name);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.setAlreadySorted(true);
        node.addChildren(VariablesKt.createVariablesList(this.variables, this.start, this.end, this.context, null), true);
    }
}

