/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells;

import com.intellij.dataspell.jupyter.customCells.JupyterCustomCellTypes;
import com.intellij.dataspell.jupyter.customCells.JupyterCustomCellsCollector;
import com.intellij.jupyter.core.jupyter.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0017\u0010\b\u001a\u000b\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/JupyterDsEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "collectNoteInfo", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/annotations/NotNull;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "intellij.dataspell.jupyter.customCells"})
@SourceDebugExtension(value={"SMAP\nJupyterDsEditorFactoryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDsEditorFactoryListener.kt\ncom/intellij/dataspell/jupyter/customCells/JupyterDsEditorFactoryListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1550#2:47\n1788#2,4:48\n*S KotlinDebug\n*F\n+ 1 JupyterDsEditorFactoryListener.kt\ncom/intellij/dataspell/jupyter/customCells/JupyterDsEditorFactoryListener\n*L\n31#1:47\n32#1:48,4\n*E\n"})
final class JupyterDsEditorFactoryListener
implements EditorFactoryListener {
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            if (!(editor2 instanceof EditorImpl) || ((EditorImpl)editor2).getProject() == null || !JupyterEditorExtensionsKt.isJupyter((Editor)editor2) || JupyterConsoleUtil.INSTANCE.isJupyterConsoleView(editor2)) {
                return;
            }
            JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor2);
            if (jupyterNotebook == null) break block1;
            JupyterNotebook it = jupyterNotebook;
            boolean bl = false;
            this.collectNoteInfo(it);
        }
    }

    @NotNull
    public final Future<?> collectNoteInfo(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> JupyterDsEditorFactoryListener.collectNoteInfo$lambda$0(notebook));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        return future;
    }

    private static final void collectNoteInfo$lambda$0(JupyterNotebook $notebook) {
        int n;
        JupyterNotebookSchemaVersion version = $notebook.getVersion();
        int size = $notebook.getJson().toString().length() / 1024;
        int cellCount = $notebook.cellsCount();
        List cells = $notebook.computeCells();
        Iterable $this$groupingBy$iv = cells;
        boolean $i$f$groupingBy = false;
        Map cellTypeCount = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<JupyterCell, JupyterCellType>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<JupyterCell> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object keyOf(Object element) {
                JupyterCell it = (JupyterCell)element;
                boolean bl = false;
                return it.getCellTypeProvider().getJupyterCellType();
            }
        }));
        Iterable $this$count$iv = cells;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                JupyterCell it = (JupyterCell)element$iv;
                boolean bl = false;
                if (!(it.getMetadata().getJsonNode("tags") != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int cellWithTags = n;
        Integer n2 = (Integer)cellTypeCount.get(JupyterCellType.Companion.getCODE());
        Integer n3 = (Integer)cellTypeCount.get(JupyterCellType.Companion.getMARKDOWN());
        Integer n4 = (Integer)cellTypeCount.get(JupyterCellType.Companion.getSQL());
        Integer n5 = (Integer)cellTypeCount.get(JupyterCustomCellTypes.INSTANCE.getDATA_WRANGLER());
        Integer n6 = (Integer)cellTypeCount.get(JupyterCustomCellTypes.INSTANCE.getVISUALIZATION());
        Integer n7 = (Integer)cellTypeCount.get(JupyterCellType.Companion.getDATA_INPUT());
        JupyterCustomCellsCollector.Companion.notebookOpened(version.toString(), size, cellCount, n2 != null ? n2 : 0, n3 != null ? n3 : 0, n4 != null ? n4 : 0, n5 != null ? n5 : 0, n6 != null ? n6 : 0, n7 != null ? n7 : 0, cellWithTags);
    }
}

