/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.filters.Filter;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookFileRenameListener;
import com.intellij.jupyter.core.editor.NotebookFileRenamedEvent;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterRestartKernelListener;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerToolWindowKt;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleHistoryEditorProvider;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.run.PythonTracebackFilter;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 92\u00020\u0001:\u000289B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u000e\u0010\u0018\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006J\u0016\u0010\u0019\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\u0006\u0010\u001a\u001a\u00020\u0014J\u001e\u0010\u001b\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\u000e\u0010\u001c\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\rJ\u001c\u0010\u001d\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\n\u0010\u0018\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\n\u0010\u0018\u001a\u00060\u0005j\u0002`\u0006J\u0016\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0012J\u000e\u0010(\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\"\u0010*\u001a\u00020+2\u0006\u0010\"\u001a\u00020#2\n\u0010\u0018\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010,\u001a\u00020\u0001J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010-\u001a\u00020!H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0012H\u0002J$\u00103\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u00104\u001a\u0002052\n\u0010\u0018\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0012\u00106\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u00107\u001a\u00020!H\u0016R\"\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0016\u0012\b\u0012\u00060\u0005j\u0002`\r\u0012\b\u0012\u00060\u0005j\u0002`\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\b\u0012\u00060\u0005j\u0002`\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00120\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u0005j\u0002`\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "activeNotebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Lcom/intellij/jupyter/py/jupyterConsole/OriginalNotebookFile;", "getActiveNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "setActiveNotebookFile", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "consoleFileToOriginalFileMap", "", "Lcom/intellij/jupyter/py/jupyterConsole/ConsoleNotebookFile;", "originalFileToConsoleFileMap", "consoleFileToConsoleEditorMap", "Lcom/intellij/openapi/editor/Editor;", "originalFileToConsoleViewMap", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "consoleExecutionVirtualFileToOriginalFileMap", "Lcom/intellij/openapi/vfs/VirtualFile;", "isToolWindowListenersInit", "", "getConsoleViewForNotebook", "originalNotebookFile", "getOriginalNotebookFileByConsoleVirtualFile", "virtualFile", "getOriginalNotebookFileByConsoleNotebookFile", "consoleNotebookFile", "getConsoleNotebookFileByOriginalNotebookFile", "isOriginalNotebookFile", "notebookFile", "showConsoleViewContent", "", "project", "Lcom/intellij/openapi/project/Project;", "showAndFocusConsoleView", "consoleView", "removeConsoleViewContent", "jupyterConsoleView", "requestFocus", "showToolwindowIfInactive", "createConsoleHistoryEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "disposable", "listenForFileRenameChanges", "handleConsoleRename", "event", "Lcom/intellij/jupyter/core/editor/NotebookFileRenamedEvent;", "addToolWindowListeners", "createContent", "createConsoleView", "title", "", "removeConsoleView", "dispose", "JupyterConsoleContentManagerListener", "Companion", "intellij.jupyter.py"})
public final class JupyterConsoleService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BackedNotebookVirtualFile activeNotebookFile;
    @NotNull
    private final Map<BackedNotebookVirtualFile, BackedNotebookVirtualFile> consoleFileToOriginalFileMap = new HashMap();
    @NotNull
    private final Map<BackedNotebookVirtualFile, BackedNotebookVirtualFile> originalFileToConsoleFileMap = new HashMap();
    @NotNull
    private final Map<BackedNotebookVirtualFile, Editor> consoleFileToConsoleEditorMap = new HashMap();
    @NotNull
    private final Map<BackedNotebookVirtualFile, JupyterConsoleView> originalFileToConsoleViewMap = new HashMap();
    @NotNull
    private final Map<VirtualFile, BackedNotebookVirtualFile> consoleExecutionVirtualFileToOriginalFileMap = new HashMap();
    private boolean isToolWindowListenersInit;

    public JupyterConsoleService() {
        this.listenForFileRenameChanges();
    }

    @Nullable
    public final BackedNotebookVirtualFile getActiveNotebookFile() {
        return this.activeNotebookFile;
    }

    public final void setActiveNotebookFile(@Nullable BackedNotebookVirtualFile backedNotebookVirtualFile) {
        this.activeNotebookFile = backedNotebookVirtualFile;
    }

    @Nullable
    public final JupyterConsoleView getConsoleViewForNotebook(@Nullable BackedNotebookVirtualFile originalNotebookFile) {
        return this.originalFileToConsoleViewMap.get(originalNotebookFile);
    }

    @Nullable
    public final BackedNotebookVirtualFile getOriginalNotebookFileByConsoleVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.consoleExecutionVirtualFileToOriginalFileMap.get(virtualFile);
    }

    @Nullable
    public final BackedNotebookVirtualFile getOriginalNotebookFileByConsoleNotebookFile(@Nullable BackedNotebookVirtualFile consoleNotebookFile) {
        return this.consoleFileToOriginalFileMap.get(consoleNotebookFile);
    }

    private final BackedNotebookVirtualFile getConsoleNotebookFileByOriginalNotebookFile(BackedNotebookVirtualFile originalNotebookFile) {
        return this.originalFileToConsoleFileMap.get(originalNotebookFile);
    }

    private final boolean isOriginalNotebookFile(BackedNotebookVirtualFile notebookFile) {
        return !this.consoleFileToOriginalFileMap.containsKey(notebookFile);
    }

    public final void showConsoleViewContent(@NotNull Project project, @NotNull BackedNotebookVirtualFile originalNotebookFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalNotebookFile, (String)"originalNotebookFile");
        Object object = JupyterFileExtensionsKt.getRelativePathFromProjectRoot((VirtualFile)originalNotebookFile.getFile(), (Project)project);
        if (object == null || (object = object.toString()) == null) {
            String string = originalNotebookFile.getFile().getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        Object relativePath = object;
        JupyterConsoleView jupyterConsoleView = this.originalFileToConsoleViewMap.get(originalNotebookFile);
        if (jupyterConsoleView == null) {
            jupyterConsoleView = this.createConsoleView(project, (String)relativePath, originalNotebookFile);
        }
        JupyterConsoleView consoleView = jupyterConsoleView;
        this.consoleExecutionVirtualFileToOriginalFileMap.put(consoleView.getVirtualFile(), originalNotebookFile);
        this.createContent(project, consoleView);
        this.requestFocus(consoleView);
    }

    public final void showAndFocusConsoleView(@NotNull Project project, @NotNull JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        ToolWindow jupyterToolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        jupyterToolWindow.show(() -> JupyterConsoleService.showAndFocusConsoleView$lambda$0(jupyterToolWindow, consoleView, this));
    }

    public final void removeConsoleViewContent(@NotNull JupyterConsoleView jupyterConsoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterConsoleView), (String)"jupyterConsoleView");
        this.removeConsoleView(jupyterConsoleView);
        ToolWindow jupyterToolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)jupyterConsoleView.getProject());
        jupyterToolWindow.getContentManager().removeContent(jupyterConsoleView.getContent(), true);
    }

    public final void requestFocus(@NotNull JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        IdeFocusManager.getGlobalInstance().requestFocus((Component)consoleView.getConsoleEditor().getContentComponent(), true);
    }

    public final void showToolwindowIfInactive(@NotNull Project project) {
        ToolWindow toolWindow;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow it = toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        boolean bl = false;
        if (!it.isActive()) {
            it.show();
        }
    }

    @NotNull
    public final TextEditor createConsoleHistoryEditor(@NotNull Project project, @NotNull BackedNotebookVirtualFile originalNotebookFile, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalNotebookFile, (String)"originalNotebookFile");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempFile("PycharmJupyterConsole", "." + JupyterFileType.INSTANCE.getDefaultExtension(), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        Path tempFile = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(tempFile);
        if (virtualFile == null) {
            throw new IllegalStateException(("Can't find temp file " + tempFile).toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        JupyterNotebookBase emptyNotebook = JupyterFileUtils.createEmptyNotebook$default((JupyterFileUtils)JupyterFileUtils.INSTANCE, null, (int)1, null);
        BackedNotebookVirtualFile consoleNotebookFile = BackedNotebookVirtualFile.Companion.createWithNotebook(virtualFile2, (JupyterNotebook)emptyNotebook, disposable);
        NonProjectFileWritingAccessProvider.allowWriting((Iterable)CollectionsKt.listOf((Object)consoleNotebookFile.getOriginFile()));
        TextEditor editor = (TextEditor)new JupyterConsoleHistoryEditorProvider().createJupyterFileEditor(project, consoleNotebookFile);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)editor));
        consoleNotebookFile.getFile().putUserData(JupyterCellLinesExtensionsKt.getJUPYTER_EDITOR_KEY(), new WeakReference<Editor>(editor.getEditor()));
        this.consoleFileToConsoleEditorMap.put(consoleNotebookFile, editor.getEditor());
        this.consoleFileToOriginalFileMap.put(consoleNotebookFile, originalNotebookFile);
        this.originalFileToConsoleFileMap.put(originalNotebookFile, consoleNotebookFile);
        return editor;
    }

    private final void removeConsoleViewContent(BackedNotebookVirtualFile notebookFile) {
        JupyterConsoleView consoleView = this.originalFileToConsoleViewMap.get(notebookFile);
        if (consoleView != null) {
            this.removeConsoleViewContent(consoleView);
        }
    }

    private final void listenForFileRenameChanges() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(NotebookFileRenameListener.Companion.getNOTEBOOK_FILE_RENAMED_TOPIC(), arg_0 -> JupyterConsoleService.listenForFileRenameChanges$lambda$0(this, arg_0));
    }

    private final void handleConsoleRename(NotebookFileRenamedEvent event) {
        block1: {
            String string = event.getNewRelativePath();
            if (string == null) {
                string = event.getNewName();
            }
            String displayPath = string;
            JupyterConsoleView jupyterConsoleView = this.getConsoleViewForNotebook(event.getNotebookVirtualFile());
            if (jupyterConsoleView == null) break block1;
            jupyterConsoleView.renameConsoleTab(displayPath);
        }
    }

    private final void addToolWindowListeners(Project project) {
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        busConnection.subscribe(topic, (Object)new FileEditorManagerListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterConsoleService this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void selectionChanged(FileEditorManagerEvent e) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FileEditor fileEditor = e.getNewEditor();
                    JupyterFileEditor jupyterFileEditor = fileEditor instanceof JupyterFileEditor ? (JupyterFileEditor)fileEditor : null;
                    if (jupyterFileEditor == null) {
                        return;
                    }
                    JupyterFileEditor editor = jupyterFileEditor;
                    BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(editor.getFile());
                    if (backedNotebookVirtualFile == null) {
                        return;
                    }
                    BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
                    ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)this.$project);
                    if (!JupyterConsoleService.access$getOriginalFileToConsoleViewMap$p(this.this$0).containsKey(backedNotebookVirtualFile2)) break block3;
                    JupyterConsoleView view = (JupyterConsoleView)((Object)JupyterConsoleService.access$getOriginalFileToConsoleViewMap$p(this.this$0).get(backedNotebookVirtualFile2));
                    JupyterConsoleView jupyterConsoleView = view;
                    if (jupyterConsoleView != null && (jupyterConsoleView = jupyterConsoleView.getContent()) != null) {
                        JupyterConsoleView it = jupyterConsoleView;
                        boolean bl = false;
                        toolWindow.getContentManager().setSelectedContent((Content)it);
                    }
                }
            }
        });
        this.isToolWindowListenersInit = true;
        JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project).getContentManager().addContentManagerListener(new ContentManagerListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterConsoleService this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)this.$project);
                if (toolWindow.getContentManager().getContentCount() == 0) {
                    toolWindow.remove();
                    JupyterConsoleService.access$setToolWindowListenersInit$p(this.this$0, false);
                }
            }
        });
    }

    private final void createContent(Project project, JupyterConsoleView consoleView) {
        if (!this.isToolWindowListenersInit) {
            this.addToolWindowListeners(project);
        }
        Content content = consoleView.showPanel();
        ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        toolWindow.getContentManager().addContent(content);
        toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new JupyterConsoleContentManagerListener(consoleView));
        if (!toolWindow.isActive()) {
            toolWindow.show();
        }
        toolWindow.getContentManager().setSelectedContent(content);
    }

    private final JupyterConsoleView createConsoleView(Project project, String title, BackedNotebookVirtualFile originalNotebookFile) {
        this.activeNotebookFile = originalNotebookFile;
        JupyterConsoleView jupyterConsoleView = new JupyterConsoleView(project, title, originalNotebookFile);
        jupyterConsoleView.setBorder((Border)new SideBorder(JBColor.border(), 1));
        jupyterConsoleView.addMessageFilter((Filter)new PythonTracebackFilter(project));
        this.originalFileToConsoleViewMap.put(originalNotebookFile, jupyterConsoleView);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(JupyterRestartKernelListener.Companion.getTOPIC(), arg_0 -> JupyterConsoleService.createConsoleView$lambda$0(this, arg_0));
        return jupyterConsoleView;
    }

    private final void removeConsoleView(JupyterConsoleView jupyterConsoleView) {
        if (jupyterConsoleView == null) {
            return;
        }
        this.consoleExecutionVirtualFileToOriginalFileMap.remove(jupyterConsoleView.getVirtualFile());
        this.originalFileToConsoleViewMap.remove(jupyterConsoleView.getOriginalNotebookFile());
        BackedNotebookVirtualFile consoleNotebookFile = jupyterConsoleView.getConsoleNotebookFile();
        TypeIntrinsics.asMutableMap(this.consoleFileToConsoleEditorMap).remove(consoleNotebookFile);
        TypeIntrinsics.asMutableMap(this.consoleFileToOriginalFileMap).remove(consoleNotebookFile);
        this.originalFileToConsoleFileMap.remove(jupyterConsoleView.getOriginalNotebookFile());
        Disposer.dispose((Disposable)((Disposable)jupyterConsoleView));
    }

    public void dispose() {
        this.originalFileToConsoleViewMap.clear();
        this.consoleFileToConsoleEditorMap.clear();
        this.consoleExecutionVirtualFileToOriginalFileMap.clear();
        this.consoleFileToOriginalFileMap.clear();
        this.originalFileToConsoleFileMap.clear();
    }

    private static final void showAndFocusConsoleView$lambda$0(ToolWindow $jupyterToolWindow, JupyterConsoleView $consoleView, JupyterConsoleService this$0) {
        $jupyterToolWindow.getContentManager().setSelectedContent($consoleView.getContent());
        this$0.requestFocus($consoleView);
    }

    private static final void listenForFileRenameChanges$lambda$0(JupyterConsoleService this$0, NotebookFileRenamedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleConsoleRename(it);
    }

    private static final void createConsoleView$lambda$0(JupyterConsoleService this$0, BackedNotebookVirtualFile nf) {
        Intrinsics.checkNotNullParameter((Object)nf, (String)"nf");
        this$0.removeConsoleViewContent(nf);
    }

    public static final /* synthetic */ Map access$getOriginalFileToConsoleViewMap$p(JupyterConsoleService $this) {
        return $this.originalFileToConsoleViewMap;
    }

    public static final /* synthetic */ void access$setToolWindowListenersInit$p(JupyterConsoleService $this, boolean bl) {
        $this.isToolWindowListenersInit = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService$Companion;", "", "<init>", "()V", "findLinkedNotebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "notebookFile", "resolveRealNotebook", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterConsoleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConsoleService.kt\ncom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,265:1\n42#2,3:266\n42#2,3:269\n*S KotlinDebug\n*F\n+ 1 JupyterConsoleService.kt\ncom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService$Companion\n*L\n243#1:266,3\n257#1:269,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BackedNotebookVirtualFile findLinkedNotebook(@NotNull BackedNotebookVirtualFile notebookFile) {
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            boolean $i$f$service = false;
            Class<JupyterConsoleService> serviceClass$iv = JupyterConsoleService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            JupyterConsoleService service = (JupyterConsoleService)object;
            return service.isOriginalNotebookFile(notebookFile) ? service.getConsoleNotebookFileByOriginalNotebookFile(notebookFile) : service.getOriginalNotebookFileByConsoleNotebookFile(notebookFile);
        }

        @NotNull
        public final BackedNotebookVirtualFile resolveRealNotebook(@NotNull BackedNotebookVirtualFile notebookFile) {
            BackedNotebookVirtualFile backedNotebookVirtualFile;
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            boolean $i$f$service = false;
            Class<JupyterConsoleService> serviceClass$iv = JupyterConsoleService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            JupyterConsoleService service = (JupyterConsoleService)object;
            if (service.isOriginalNotebookFile(notebookFile)) {
                backedNotebookVirtualFile = notebookFile;
            } else {
                backedNotebookVirtualFile = service.getOriginalNotebookFileByConsoleNotebookFile(notebookFile);
                if (backedNotebookVirtualFile == null) {
                    backedNotebookVirtualFile = notebookFile;
                }
            }
            return backedNotebookVirtualFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService$JupyterConsoleContentManagerListener;", "Lcom/intellij/ui/content/ContentManagerListener;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "contentRemoved", "", "event", "Lcom/intellij/ui/content/ContentManagerEvent;", "intellij.jupyter.py"})
    private final class JupyterConsoleContentManagerListener
    implements ContentManagerListener {
        @NotNull
        private final JupyterConsoleView consoleView;

        public JupyterConsoleContentManagerListener(JupyterConsoleView consoleView) {
            Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
            this.consoleView = consoleView;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getContent().getDisplayName().equals(this.consoleView.getTitle())) {
                JupyterConsoleService.this.removeConsoleView(this.consoleView);
            }
        }
    }
}

