/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.target;

import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.target.RunConfigurationTargetEnvironmentAdjuster;
import com.intellij.execution.target.TargetBasedSdks;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdks;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshRemoteEnvironmentRequest;
import com.jetbrains.plugins.remotesdk.target.vagrant.VagrantEnvironmentRequest;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/python/remoteInterpreter/target/RunConfigurationSshEnvironmentAdjuster;", "Lcom/intellij/execution/target/RunConfigurationTargetEnvironmentAdjuster;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "adjust", "", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "providesAdditionalRunConfigurationUI", "", "createAdditionalRunConfigurationUI", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configuration/AbstractRunConfiguration;", "sdkGetter", "Lkotlin/Function0;", "Factory", "Companion", "intellij.python.remoteInterpreter"})
public final class RunConfigurationSshEnvironmentAdjuster
implements RunConfigurationTargetEnvironmentAdjuster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sdk sdk;

    public RunConfigurationSshEnvironmentAdjuster(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        this.sdk = sdk;
    }

    public void adjust(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull RunConfigurationBase<?> runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        TargetEnvironmentRequest targetEnvironmentRequest2 = targetEnvironmentRequest;
        if (targetEnvironmentRequest2 instanceof SshRemoteEnvironmentRequest) {
            ((SshRemoteEnvironmentRequest)targetEnvironmentRequest).setForcedPtyAllocation(RunConfigurationSshEnvironmentAdjuster.Companion.isForcedPtyAllocationEnabledInRegistry());
            ((SshRemoteEnvironmentRequest)targetEnvironmentRequest).setRunAsSudoViaRoot(PythonSdkType.isRunAsRootViaSudo((Sdk)this.sdk));
        } else if (targetEnvironmentRequest2 instanceof VagrantEnvironmentRequest) {
            ((VagrantEnvironmentRequest)targetEnvironmentRequest).setForcedPtyAllocation(RunConfigurationSshEnvironmentAdjuster.Companion.isForcedPtyAllocationEnabledInRegistry());
        }
    }

    public boolean providesAdditionalRunConfigurationUI() {
        return false;
    }

    @Nullable
    public SettingsEditor<AbstractRunConfiguration> createAdditionalRunConfigurationUI(@NotNull AbstractRunConfiguration runConfiguration, @NotNull Function0<? extends Sdk> sdkGetter) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(sdkGetter, (String)"sdkGetter");
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/python/remoteInterpreter/target/RunConfigurationSshEnvironmentAdjuster$Companion;", "", "<init>", "()V", "isForcedPtyAllocationEnabledInRegistry", "", "()Z", "intellij.python.remoteInterpreter"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isForcedPtyAllocationEnabledInRegistry() {
            return Registry.Companion.is("python.run.configurations.allocate.pty.for.ssh.processes");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/remoteInterpreter/target/RunConfigurationSshEnvironmentAdjuster$Factory;", "Lcom/intellij/execution/target/RunConfigurationTargetEnvironmentAdjuster$Factory;", "<init>", "()V", "isEnabledFor", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createAdjuster", "Lcom/intellij/execution/target/RunConfigurationTargetEnvironmentAdjuster;", "intellij.python.remoteInterpreter"})
    public static final class Factory
    implements RunConfigurationTargetEnvironmentAdjuster.Factory {
        public boolean isEnabledFor(@NotNull Sdk sdk) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            return PythonSdkUtil.isPythonSdk((Sdk)sdk) && (TargetBasedSdks.isBasedOnTargetType((Sdk)sdk, (String)"ssh/sftp") || TargetBasedSdks.isBasedOnTargetType((Sdk)sdk, (String)"ssh/web-deployment") || TargetBasedSdks.isBasedOnTargetType((Sdk)sdk, (String)"vagrant") || RemoteSdks.isBasedOnCredentialsType((Sdk)sdk, (CredentialsType)((CredentialsType)SshCredentialsType.Companion.getInstance())) || RemoteSdks.isBasedOnCredentialsType((Sdk)sdk, (CredentialsType)((CredentialsType)WebDeploymentCredentialsType.Companion.getInstance())) || RemoteSdks.isBasedOnCredentialsType((Sdk)sdk, (CredentialsType)((CredentialsType)VagrantCredentialsType.Companion.getInstance())));
        }

        @NotNull
        public RunConfigurationTargetEnvironmentAdjuster createAdjuster(@NotNull Sdk sdk) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            return new RunConfigurationSshEnvironmentAdjuster(sdk);
        }
    }
}

