/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pro.flask.FlaskFQNamesProvider;
import com.intellij.python.pro.flask.stubs.FlaskGAttributesIndex;
import com.intellij.python.pro.icons.PythonUltimateIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/python/pro/flask/completion/FlaskGAttributesCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "intellij.python"})
public final class FlaskGAttributesCompletionContributor
extends CompletionContributor
implements DumbAware {
    public FlaskGAttributesCompletionContributor() {
        PatternCondition<PsiElement> isFlaskGContextAccess2 = new PatternCondition<PsiElement>(){

            public boolean accepts(PsiElement element, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyReferenceExpression.class);
                if (pyReferenceExpression == null) {
                    return false;
                }
                PyReferenceExpression referenceExpression = pyReferenceExpression;
                PyExpression pyExpression = referenceExpression.getQualifier();
                PyReferenceExpression pyReferenceExpression2 = pyExpression instanceof PyReferenceExpression ? (PyReferenceExpression)pyExpression : null;
                if (pyReferenceExpression2 == null) {
                    return false;
                }
                PyReferenceExpression qualifierExpr = pyReferenceExpression2;
                TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)element.getProject(), (PsiFile)element.getContainingFile());
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(...)");
                TypeEvalContext tec = typeEvalContext;
                PyType qType = tec.getType((PyTypedElement)qualifierExpr);
                Object object = qType instanceof PyClassType ? (PyClassType)qType : null;
                if (object == null || (object = object.getPyClass()) == null || (object = object.getQualifiedName()) == null) {
                    return false;
                }
                Object qTypeQName = object;
                return Intrinsics.areEqual((Object)qualifierExpr.getText(), (Object)"g") && ArraysKt.contains((Object[])FlaskFQNamesProvider.FLASK_APP_CONTEXT_GLOBALS.getNames(), (Object)qTypeQName);
            }
        };
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PyReferenceExpression.class)).with((PatternCondition)isFlaskGContextAccess2), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Project project = parameters.getEditor().getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                PsiElement psiElement = parameters.getPosition().getParent();
                PyReferenceExpression pyReferenceExpression = psiElement instanceof PyReferenceExpression ? (PyReferenceExpression)psiElement : null;
                if (pyReferenceExpression == null) {
                    return;
                }
                PyReferenceExpression ref = pyReferenceExpression;
                List<Pair<String, String>> entries = FlaskGAttributesIndex.Companion.getEntries(project2);
                if (entries.isEmpty()) {
                    return;
                }
                PyPsiFacade facade = PyPsiFacade.getInstance((Project)project2);
                for (Pair<String, String> pair : entries) {
                    LookupElementBuilder builder;
                    PyClass cls;
                    String name = (String)pair.component1();
                    String qName = (String)pair.component2();
                    if (facade.createClassByQName(qName, (PsiElement)ref) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)name).withTypeText(cls.getName(), true).withIcon(PythonUltimateIcons.Flask.FlaskLogo), (String)"withIcon(...)");
                    result.addElement((LookupElement)builder);
                }
            }
        });
    }
}

