/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ColumnMappingStrategy {
    SIMPLE{

        @Override
        @NotNull
        Condition<AutoValueDescriptor> condition(@NotNull State state) {
            if (state == null) {
                1.$$$reportNull$$$0(0);
            }
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                1.$$$reportNull$$$0(1);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ColumnMappingStrategy$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ColumnMappingStrategy$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "condition";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
    ,
    SKIP_COMPUTED{

        @Override
        @NotNull
        Condition<AutoValueDescriptor> condition(@NotNull State state) {
            if (state == null) {
                2.$$$reportNull$$$0(0);
            }
            Condition condition = column -> !column.isComputed() || state.additionalColumns-- > 0;
            if (condition == null) {
                2.$$$reportNull$$$0(1);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ColumnMappingStrategy$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ColumnMappingStrategy$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "condition";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
    ,
    SKIP_AUTO{

        @Override
        @NotNull
        Condition<AutoValueDescriptor> condition(@NotNull State state) {
            if (state == null) {
                3.$$$reportNull$$$0(0);
            }
            Condition condition = column -> !column.isAutogenerated() || state.additionalColumns-- > 0;
            if (condition == null) {
                3.$$$reportNull$$$0(1);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ColumnMappingStrategy$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ColumnMappingStrategy$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "condition";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
    ,
    SKIP_AUTO_AND_DEFAULT{

        @Override
        @NotNull
        Condition<AutoValueDescriptor> condition(@NotNull State state) {
            if (state == null) {
                4.$$$reportNull$$$0(0);
            }
            Condition condition = column -> 4.shouldNotSkip(column) || (column.isAutogenerated() || this.acceptDefault(state, (AutoValueDescriptor)column)) && state.additionalColumns-- > 0;
            if (condition == null) {
                4.$$$reportNull$$$0(1);
            }
            return condition;
        }

        private static boolean shouldNotSkip(@NotNull AutoValueDescriptor column) {
            if (column == null) {
                4.$$$reportNull$$$0(2);
            }
            return !column.isAutogenerated() && !column.hasDefault();
        }

        private boolean acceptDefault(@NotNull State state, @NotNull AutoValueDescriptor column) {
            if (state == null) {
                4.$$$reportNull$$$0(3);
            }
            if (column == null) {
                4.$$$reportNull$$$0(4);
            }
            return column.hasDefault() && 4.autoColumnsCount(state.columns) < state.additionalColumns;
        }

        @Override
        <T extends ColumnDescriptor> boolean isSuitable(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
            if (columns == null) {
                4.$$$reportNull$$$0(5);
            }
            if (descriptors == null) {
                4.$$$reportNull$$$0(6);
            }
            return true;
        }

        private static int autoColumnsCount(@NotNull Collection<AutoValueDescriptor> columns) {
            if (columns == null) {
                4.$$$reportNull$$$0(7);
            }
            return ContainerUtil.filter(columns, AutoValueDescriptor::isAutogenerated).size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ColumnMappingStrategy$4";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ColumnMappingStrategy$4";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "condition";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldNotSkip";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptDefault";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitable";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "autoColumnsCount";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
    ,
    BY_NAME{

        @Override
        @NotNull
        Condition<AutoValueDescriptor> condition(@NotNull State state) {
            if (state == null) {
                5.$$$reportNull$$$0(0);
            }
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                5.$$$reportNull$$$0(1);
            }
            return condition;
        }

        @Override
        <T extends ColumnDescriptor> boolean isSuitable(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
            if (columns == null) {
                5.$$$reportNull$$$0(2);
            }
            if (descriptors == null) {
                5.$$$reportNull$$$0(3);
            }
            return false;
        }

        @Override
        @NotNull
        <T extends ColumnDescriptor> Map<AutoValueDescriptor, T> createMapping(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
            if (columns == null) {
                5.$$$reportNull$$$0(4);
            }
            if (descriptors == null) {
                5.$$$reportNull$$$0(5);
            }
            HashMap<AutoValueDescriptor, T> result = new HashMap<AutoValueDescriptor, T>();
            for (AutoValueDescriptor column : columns) {
                T descriptor = 5.getSameNameDescriptor(column, descriptors);
                if (descriptor == null || result.containsValue(descriptor)) continue;
                result.put(column, descriptor);
            }
            HashMap<AutoValueDescriptor, T> hashMap = result;
            if (hashMap == null) {
                5.$$$reportNull$$$0(6);
            }
            return hashMap;
        }

        @Nullable
        private static <T extends ColumnDescriptor> T getSameNameDescriptor(@NotNull AutoValueDescriptor column, @NotNull List<T> descriptors) {
            if (column == null) {
                5.$$$reportNull$$$0(7);
            }
            if (descriptors == null) {
                5.$$$reportNull$$$0(8);
            }
            return (T)((ColumnDescriptor)ContainerUtil.find(descriptors, descriptor -> StringUtil.equalsIgnoreCase((CharSequence)descriptor.getName(), (CharSequence)column.getName())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ColumnMappingStrategy$5";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ColumnMappingStrategy$5";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "condition";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "condition";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createMapping";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getSameNameDescriptor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6 -> new IllegalStateException(string);
            };
        }
    };


    @NotNull
    public static <T extends ColumnDescriptor> Map<AutoValueDescriptor, T> map(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(0);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(1);
        }
        Map mapping = ColumnMappingStrategy.mapByName(columns, descriptors);
        List unmappedColumns = ContainerUtil.filter(columns, column -> !mapping.containsKey(column));
        List unmappedDescriptors = ContainerUtil.filter(descriptors, descriptor -> !mapping.containsValue(descriptor));
        mapping.putAll(ColumnMappingStrategy.strategyOf(unmappedColumns, unmappedDescriptors).createMapping(unmappedColumns, unmappedDescriptors));
        Map map = mapping;
        if (map == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(2);
        }
        return map;
    }

    @ApiStatus.Internal
    @NotNull
    public static <T extends ColumnDescriptor> Map<AutoValueDescriptor, T> mapByName(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(4);
        }
        Map<AutoValueDescriptor, T> map = BY_NAME.createMapping(columns, descriptors);
        if (map == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Nullable
    public static <T extends ColumnDescriptor> T map(@NotNull AutoValueDescriptor column, @NotNull List<T> descriptors) {
        if (column == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(7);
        }
        return (T)((ColumnDescriptor)ColumnMappingStrategy.map(Collections.singletonList(column), descriptors).get(column));
    }

    @NotNull
    <T extends ColumnDescriptor> Map<AutoValueDescriptor, T> createMapping(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(9);
        }
        return ColumnMappingStrategy.createMap(this.filter(columns, descriptors), descriptors);
    }

    <T extends ColumnDescriptor> boolean isSuitable(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(10);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(11);
        }
        return ContainerUtil.filter(columns, this.condition(State.pure(columns))).size() <= descriptors.size();
    }

    @NotNull
    private <T extends ColumnDescriptor> List<AutoValueDescriptor> filter(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(12);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(13);
        }
        List filter = ContainerUtil.filter(columns, this.condition(State.pure(columns)));
        int additionalColumns = descriptors.size() - filter.size();
        ArrayList<AutoValueDescriptor> result = new ArrayList<AutoValueDescriptor>();
        for (AutoValueDescriptor column : columns) {
            State state = new State(ContainerUtil.subtract(columns, result), additionalColumns);
            if (this.condition(state).value((Object)column)) {
                result.add(column);
            }
            additionalColumns = state.additionalColumns;
        }
        ArrayList<AutoValueDescriptor> arrayList = result;
        if (arrayList == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    abstract Condition<AutoValueDescriptor> condition(@NotNull State var1);

    @NotNull
    private static <T extends ColumnDescriptor> Map<AutoValueDescriptor, T> createMap(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(16);
        }
        HashMap<AutoValueDescriptor, ColumnDescriptor> result = new HashMap<AutoValueDescriptor, ColumnDescriptor>();
        for (int i2 = 0; i2 < Math.min(columns.size(), descriptors.size()); ++i2) {
            result.put(columns.get(i2), (ColumnDescriptor)descriptors.get(i2));
        }
        HashMap<AutoValueDescriptor, ColumnDescriptor> hashMap = result;
        if (hashMap == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @NotNull
    private static <T extends ColumnDescriptor> ColumnMappingStrategy strategyOf(@NotNull List<AutoValueDescriptor> columns, @NotNull List<T> descriptors) {
        if (columns == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(18);
        }
        if (descriptors == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(19);
        }
        for (ColumnMappingStrategy strategy : ColumnMappingStrategy.values()) {
            if (!strategy.isSuitable(columns, descriptors)) continue;
            ColumnMappingStrategy columnMappingStrategy = strategy;
            if (columnMappingStrategy == null) {
                ColumnMappingStrategy.$$$reportNull$$$0(20);
            }
            return columnMappingStrategy;
        }
        ColumnMappingStrategy columnMappingStrategy = SIMPLE;
        if (columnMappingStrategy == null) {
            ColumnMappingStrategy.$$$reportNull$$$0(21);
        }
        return columnMappingStrategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 14, 17, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ColumnMappingStrategy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ColumnMappingStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mapByName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "strategyOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mapByName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "strategyOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 14, 17, 20, 21 -> new IllegalStateException(string);
        };
    }

    private static class State {
        final Collection<AutoValueDescriptor> columns;
        int additionalColumns;

        State(@NotNull Collection<AutoValueDescriptor> columns, int additionalColumns) {
            if (columns == null) {
                State.$$$reportNull$$$0(0);
            }
            this.additionalColumns = additionalColumns;
            this.columns = columns;
        }

        @NotNull
        private static State pure(@NotNull List<AutoValueDescriptor> columns) {
            if (columns == null) {
                State.$$$reportNull$$$0(1);
            }
            return new State(columns, -1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "columns";
            objectArray2[1] = "com/intellij/database/dbimport/ColumnMappingStrategy$State";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

