/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXFont;

public class TeXEnvironment {
    private Color background = null;
    private Color color = null;
    private int style = 0;
    private TeXFont tf;
    private int lastFontId = -1;
    private float textwidth = Float.POSITIVE_INFINITY;
    private String textStyle;
    private boolean smallCap;
    private float scaleFactor = 1.0f;
    private int interlineUnit;
    private float interline;
    public boolean isColored = false;

    public TeXEnvironment(int style, TeXFont tf) {
        this(style, tf, null, null);
    }

    public TeXEnvironment(int style, TeXFont tf, int widthUnit, float textwidth) {
        this(style, tf, null, null);
        this.textwidth = textwidth * SpaceAtom.getFactor(widthUnit, this);
    }

    private TeXEnvironment(int style, TeXFont tf, Color bg, Color c) {
        this.style = style;
        this.tf = tf;
        this.background = bg;
        this.color = c;
        this.setInterline(1, 1.0f);
    }

    private TeXEnvironment(int style, float scaleFactor, TeXFont tf, Color bg, Color c, String textStyle, boolean smallCap) {
        this.style = style;
        this.scaleFactor = scaleFactor;
        this.tf = tf;
        this.textStyle = textStyle;
        this.smallCap = smallCap;
        this.background = bg;
        this.color = c;
        this.setInterline(1, 1.0f);
    }

    public void setInterline(int unit, float len) {
        this.interline = len;
        this.interlineUnit = unit;
    }

    public float getInterline() {
        return this.interline * SpaceAtom.getFactor(this.interlineUnit, this);
    }

    public void setTextwidth(int widthUnit, float textwidth) {
        this.textwidth = textwidth * SpaceAtom.getFactor(widthUnit, this);
    }

    public float getTextwidth() {
        return this.textwidth;
    }

    public void setScaleFactor(float f) {
        this.scaleFactor = f;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    protected TeXEnvironment copy() {
        return new TeXEnvironment(this.style, this.scaleFactor, this.tf, this.background, this.color, this.textStyle, this.smallCap);
    }

    protected TeXEnvironment copy(TeXFont tf) {
        TeXEnvironment te = new TeXEnvironment(this.style, this.scaleFactor, tf, this.background, this.color, this.textStyle, this.smallCap);
        te.textwidth = this.textwidth;
        te.interline = this.interline;
        te.interlineUnit = this.interlineUnit;
        return te;
    }

    public TeXEnvironment crampStyle() {
        TeXEnvironment s = this.copy();
        s.style = this.style % 2 == 1 ? this.style : this.style + 1;
        return s;
    }

    public TeXEnvironment denomStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 2) + 1 + 2 - 2 * (this.style / 6);
        return s;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getColor() {
        return this.color;
    }

    public float getSize() {
        return this.tf.getSize();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public String getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(String textStyle) {
        this.textStyle = textStyle;
    }

    public boolean getSmallCap() {
        return this.smallCap;
    }

    public void setSmallCap(boolean smallCap) {
        this.smallCap = smallCap;
    }

    public TeXFont getTeXFont() {
        return this.tf;
    }

    public TeXEnvironment numStyle() {
        TeXEnvironment s = this.copy();
        s.style = this.style + 2 - 2 * (this.style / 6);
        return s;
    }

    public void reset() {
        this.color = null;
        this.background = null;
    }

    public TeXEnvironment rootStyle() {
        TeXEnvironment s = this.copy();
        s.style = 6;
        return s;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public TeXEnvironment subStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 4) + 4 + 1;
        return s;
    }

    public TeXEnvironment supStyle() {
        TeXEnvironment s = this.copy();
        s.style = 2 * (this.style / 4) + 4 + this.style % 2;
        return s;
    }

    public float getSpace() {
        return this.tf.getSpace(this.style) * this.tf.getScaleFactor();
    }

    public void setLastFontId(int id) {
        this.lastFontId = id;
    }

    public int getLastFontId() {
        return this.lastFontId == -1 ? this.tf.getMuFontId() : this.lastFontId;
    }
}

