/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.syntaxSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/syntaxSelection/JavaScriptCommentSelectioner;", "Lcom/intellij/codeInsight/editorActions/wordSelection/AbstractWordSelectioner;", "<init>", "()V", "canSelect", "", "e", "Lcom/intellij/psi/PsiElement;", "select", "", "Lcom/intellij/openapi/util/TextRange;", "editorText", "", "cursorOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.javascript.common"})
public final class JavaScriptCommentSelectioner
extends AbstractWordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e instanceof PsiComment && e.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || e instanceof JSNamedElement || e instanceof JSVarStatement;
    }

    @NotNull
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (e instanceof JSNamedElement || e instanceof JSVarStatement) {
            PsiComment comment = JSDocumentationUtils.findDocComment(e);
            if (comment == null || e != JSDocumentationUtils.findAssociatedElement(comment)) {
                return CollectionsKt.emptyList();
            }
            ASTNode child = comment.getNextSibling().getNode();
            if (child.getElementType() == JSTokenTypes.WHITE_SPACE) {
                child = child.getTreeNext();
            }
            List list = AbstractWordSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(child.getTextRange().getStartOffset(), ((JSElement)e).getTextRange().getEndOffset()));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandToWholeLine(...)");
            return list;
        }
        List list = super.select(e, editorText, cursorOffset, editor);
        Intrinsics.checkNotNull((Object)list);
        List ranges = list;
        if (e instanceof PsiComment) {
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)e);
            if (next instanceof PsiWhiteSpace) {
                next = ((PsiWhiteSpace)next).getNextSibling();
            }
            if ((next instanceof JSNamedElement || next instanceof JSVarStatement) && !ranges.isEmpty()) {
                List list2 = AbstractWordSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(((TextRange)ranges.get(0)).getStartOffset(), ((JSElement)next).getTextRange().getEndOffset()));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expandToWholeLine(...)");
                ranges.addAll(list2);
            }
        }
        return ranges;
    }
}

