/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptObjectJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeBySwitchOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.psi.PsiElement;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNarrowTypeBySwitchDiscriminantOperation
extends JSNarrowTypeBySwitchOperationBase {
    public JSNarrowTypeBySwitchDiscriminantOperation(@NotNull JSTypeOperation prev, @NotNull JSSwitchStatement statement, int clauseStart, int clauseEnd) {
        if (prev == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(1);
        }
        super(prev, statement, JSNarrowTypeBySwitchDiscriminantOperation.getClauseTypes(statement), clauseStart, clauseEnd);
    }

    @NotNull
    private static List<JSType> getClauseTypes(@NotNull JSSwitchStatement statement) {
        if (statement == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(2);
        }
        Object[] clauses = statement.getCaseClauses();
        List list = ContainerUtil.map((Object[])clauses, el -> {
            if (el.isDefault()) {
                return JSNamedTypeFactory.createNeverType(JSTypeSourceFactory.createTypeSource((PsiElement)statement, true));
            }
            JSExpression expression = el.getCaseExpression();
            return expression == null ? JSAnyType.get((PsiElement)statement) : JSTypeGuardUtil.getOperationType(expression);
        });
        if (list == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        if (context == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(4);
        }
        if (type == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(5);
        }
        if (this.myAllClauseTypes.isEmpty()) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        List expandedAllSwitchTypes = ContainerUtil.mapNotNull((Collection)this.myAllClauseTypes, el -> context.expandOperationType((JSType)el));
        if (expandedAllSwitchTypes.size() != this.myAllClauseTypes.size()) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        List clauseTypes = this.myIsSyntheticDefault ? Collections.emptyList() : expandedAllSwitchTypes.subList(this.myClauseStart, this.myClauseEnd + 1);
        JSType discriminantType = JSTypeGuardUtil.getUnionType(clauseTypes, context.getDefaultTypeSource());
        if (type instanceof JSUnknownType && !this.myHasDefaultClause) {
            return JSNarrowTypeBySwitchDiscriminantOperation.narrowUnknownType(discriminantType);
        }
        JSType caseType = JSNarrowTypeBySwitchDiscriminantOperation.getEffectiveCaseType(context, type, discriminantType);
        if (!this.myHasDefaultClause) {
            JSType jSType = caseType;
            if (jSType == null) {
                JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSType defaultType = TypeScriptTypeRelations.filterType(type, t -> !JSTypeGuardUtil.isUnitType(t) || !JSNarrowTypeBySwitchDiscriminantOperation.containsType(context, expandedAllSwitchTypes, t), context.getContextElement());
        JSType jSType = caseType instanceof TypeScriptNeverType ? defaultType : JSTypeGuardUtil.getUnionType(List.of(caseType, defaultType), context.getDefaultTypeSource());
        if (jSType == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @NotNull
    private static JSType narrowUnknownType(@NotNull JSType discriminantType) {
        if (discriminantType == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(10);
        }
        if (discriminantType instanceof JSPrimitiveType) {
            JSType jSType = discriminantType;
            if (jSType == null) {
                JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        return new TypeScriptObjectJSTypeImpl(discriminantType.getSource(), JSTypeContext.STATIC);
    }

    private static boolean containsType(@NotNull JSApplyTypeOperationContext context, @NotNull List<JSType> types, @Nullable JSType type) {
        if (context == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(12);
        }
        if (types == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(13);
        }
        JSType canonicalType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(type);
        return types.stream().anyMatch(clauseType -> TypeScriptTypeRelations.getRegularTypeOfLiteralType(clauseType).isEquivalentTo(canonicalType, context.getProcessingContext()));
    }

    @NotNull
    private static JSType getEffectiveCaseType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type, @NotNull JSType discriminantType) {
        JSType typeToProcess;
        if (context == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(14);
        }
        if (type == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(15);
        }
        if (discriminantType == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(16);
        }
        if (discriminantType instanceof TypeScriptNeverType) {
            JSType jSType = discriminantType;
            if (jSType == null) {
                JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        if (discriminantType instanceof JSUnionType) {
            JSUnionType unionType = (JSUnionType)discriminantType;
            typeToProcess = unionType.transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)TypeScriptTypeRelations::getRegularTypeOfLiteralType));
        } else {
            typeToProcess = discriminantType;
        }
        PsiElement contextElement = context.getContextElement();
        JSType rawType = TypeScriptTypeRelations.filterType(type, t -> TypeScriptTypeRelations.areTypesComparable(typeToProcess, t, context.getProcessingContext()), contextElement);
        JSType jSType = JSTypeGuardUtil.replacePrimitivesWithLiterals(rawType, discriminantType, contextElement);
        if (jSType == null) {
            JSNarrowTypeBySwitchDiscriminantOperation.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 8, 9, 11, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeBySwitchDiscriminantOperation";
                break;
            }
            case 4: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "discriminantType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeBySwitchDiscriminantOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClauseTypes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowUnknownType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveCaseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClauseTypes";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "narrowUnknownType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveCaseType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7, 8, 9, 11, 17, 18 -> new IllegalStateException(string);
        };
    }
}

