/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_az extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ərəb";
        final String metaValue_hy = "erməni";
        final String metaValue_ae = "avestan";
        final String metaValue_ban = "bali";
        final String metaValue_bn = "benqal";
        final String metaValue_ka = "gürcü";
        final String metaValue_el = "yunan";
        final String metaValue_gu = "qucarat";
        final String metaValue_ja = "yapon";
        final String metaValue_km = "kxmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreya";
        final String metaValue_la = "latın";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "monqol";
        final String metaValue_nqo = "nko";
        final String metaValue_sam = "samaritan";
        final String metaValue_su = "sundan";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "teluqu";
        final String metaValue_tl = "taqaloq";
        final String metaValue_th = "tay";
        final String metaValue_bo = "tibet";
        final String metaValue_uga = "uqarit";
        final String metaValue_type_hc_h23 = "24 Saatlıq Sistem (0–23)";
        final Object[][] data = new Object[][] {
            { "001", "Dünya" },
            { "002", "Afrika" },
            { "003", "Şimali Amerika" },
            { "005", "Cənubi Amerika" },
            { "009", "Okeaniya" },
            { "011", "Qərbi Afrika" },
            { "013", "Mərkəzi Amerika" },
            { "014", "Şərqi Afrika" },
            { "015", "Şimali Afrika" },
            { "017", "Mərkəzi Afrika" },
            { "018", "Cənubi Afrika" },
            { "019", "Amerika" },
            { "021", "Şimal Amerikası" },
            { "029", "Karib" },
            { "030", "Şərqi Asiya" },
            { "034", "Cənubi Asiya" },
            { "035", "Cənub-Şərqi Asiya" },
            { "039", "Cənubi Avropa" },
            { "053", "Avstralaziya" },
            { "054", "Melaneziya" },
            { "057", "Mikroneziya Regionu" },
            { "061", "Polineziya" },
            { "142", "Asiya" },
            { "143", "Mərkəzi Asiya" },
            { "145", "Qərbi Asiya" },
            { "150", "Avropa" },
            { "151", "Şərqi Avropa" },
            { "154", "Şimali Avropa" },
            { "155", "Qərbi Avropa" },
            { "202", "Saharadan cənub" },
            { "419", "Latın Amerikası" },
            { "AC", "Askenson adası" },
            { "AD", "Andorra" },
            { "AE", "Birləşmiş Ərəb Əmirlikləri" },
            { "AF", "Əfqanıstan" },
            { "AG", "Antiqua və Barbuda" },
            { "AI", "Angilya" },
            { "AL", "Albaniya" },
            { "AM", "Ermənistan" },
            { "AO", "Anqola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Amerika Samoası" },
            { "AT", "Avstriya" },
            { "AU", "Avstraliya" },
            { "AW", "Aruba" },
            { "AX", "Aland adaları" },
            { "AZ", "Azərbaycan" },
            { "BA", "Bosniya və Herseqovina" },
            { "BB", "Barbados" },
            { "BD", "Banqladeş" },
            { "BE", "Belçika" },
            { "BF", "Burkina Faso" },
            { "BG", "Bolqarıstan" },
            { "BH", "Bəhreyn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sent-Bartelemi" },
            { "BM", "Bermud adaları" },
            { "BN", "Bruney" },
            { "BO", "Boliviya" },
            { "BQ", "Karib Niderlandı" },
            { "BR", "Braziliya" },
            { "BS", "Baham adaları" },
            { "BT", "Butan" },
            { "BV", "Buve adası" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "CA", "Kanada" },
            { "CC", "Kokos (Kilinq) adaları" },
            { "CD", "Konqo - Kinşasa" },
            { "CF", "Mərkəzi Afrika Respublikası" },
            { "CG", "Konqo - Brazzavil" },
            { "CH", "İsveçrə" },
            { "CI", "Kotd’ivuar" },
            { "CK", "Kuk adaları" },
            { "CL", "Çili" },
            { "CM", "Kamerun" },
            { "CN", "Çin" },
            { "CO", "Kolumbiya" },
            { "CP", "Klipperton adası" },
            { "CQ", "sark (ingilis dili) dialekti" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo-Verde" },
            { "CW", "Kurasao" },
            { "CX", "Milad adası" },
            { "CY", "Kipr" },
            { "CZ", "Çexiya" },
            { "DE", "Almaniya" },
            { "DG", "Dieqo Qarsiya" },
            { "DJ", "Cibuti" },
            { "DK", "Danimarka" },
            { "DM", "Dominika" },
            { "DO", "Dominikan Respublikası" },
            { "DZ", "Əlcəzair" },
            { "EA", "Seuta və Melilya" },
            { "EC", "Ekvador" },
            { "EE", "Estoniya" },
            { "EG", "Misir" },
            { "EH", "Qərbi Saxara" },
            { "ER", "Eritreya" },
            { "ES", "İspaniya" },
            { "ET", "Efiopiya" },
            { "EU", "Avropa Birliyi" },
            { "EZ", "Avrozona" },
            { "FI", "Finlandiya" },
            { "FJ", "Fici" },
            { "FK", "Folklend adaları" },
            { "FM", "Mikroneziya" },
            { "FO", "Farer adaları" },
            { "FR", "Fransa" },
            { "GA", "Qabon" },
            { "GB", "Birləşmiş Krallıq" },
            { "GD", "Qrenada" },
            { "GE", "Gürcüstan" },
            { "GF", "Fransa Qvianası" },
            { "GG", "Gernsi" },
            { "GH", "Qana" },
            { "GI", "Cəbəllütariq" },
            { "GL", "Qrenlandiya" },
            { "GM", "Qambiya" },
            { "GN", "Qvineya" },
            { "GP", "Qvadelupa" },
            { "GQ", "Ekvatorial Qvineya" },
            { "GR", "Yunanıstan" },
            { "GS", "Cənubi Corciya və Cənubi Sendviç adaları" },
            { "GT", "Qvatemala" },
            { "GU", "Quam" },
            { "GW", "Qvineya-Bisau" },
            { "GY", "Qayana" },
            { "HK", "Honq Konq Xüsusi İnzibati Rayonu Çin" },
            { "HM", "Herd və Makdonald adaları" },
            { "HN", "Honduras" },
            { "HR", "Xorvatiya" },
            { "HT", "Haiti" },
            { "HU", "Macarıstan" },
            { "IC", "Kanar adaları" },
            { "ID", "İndoneziya" },
            { "IE", "İrlandiya" },
            { "IL", "İsrail" },
            { "IM", "Men adası" },
            { "IN", "Hindistan" },
            { "IO", "Britaniyanın Hind Okeanı Ərazisi" },
            { "IQ", "İraq" },
            { "IR", "İran" },
            { "IS", "İslandiya" },
            { "IT", "İtaliya" },
            { "JE", "Cersi" },
            { "JM", "Yamayka" },
            { "JO", "İordaniya" },
            { "JP", "Yaponiya" },
            { "KE", "Keniya" },
            { "KG", "Qırğızıstan" },
            { "KH", "Kamboca" },
            { "KI", "Kiribati" },
            { "KM", "Komor adaları" },
            { "KN", "Sent-Kits və Nevis" },
            { "KP", "Şimali Koreya" },
            { "KR", "Cənubi Koreya" },
            { "KW", "Küveyt" },
            { "KY", "Kayman adaları" },
            { "KZ", "Qazaxıstan" },
            { "LA", "Laos" },
            { "LB", "Livan" },
            { "LC", "Sent-Lusiya" },
            { "LI", "Lixtenşteyn" },
            { "LK", "Şri-Lanka" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litva" },
            { "LU", "Lüksemburq" },
            { "LV", "Latviya" },
            { "LY", "Liviya" },
            { "MA", "Mərakeş" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Monteneqro" },
            { "MF", "Sent Martin" },
            { "MG", "Madaqaskar" },
            { "MH", "Marşal adaları" },
            { "MK", "Şimali Makedoniya" },
            { "ML", "Mali" },
            { "MM", "Myanma" },
            { "MN", "Monqolustan" },
            { "MO", "Makao XİR Çin" },
            { "MP", "Şimali Marian adaları" },
            { "MQ", "Martinik" },
            { "MR", "Mavritaniya" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "MU", "Mavriki" },
            { "MV", "Maldiv adaları" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "MY", "Malayziya" },
            { "MZ", "Mozambik" },
            { "NA", "Namibiya" },
            { "NC", "Yeni Kaledoniya" },
            { "NE", "Niger" },
            { "NF", "Norfolk adası" },
            { "NG", "Nigeriya" },
            { "NI", "Nikaraqua" },
            { "NL", "Niderland" },
            { "NO", "Norveç" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Yeni Zelandiya" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fransa Polineziyası" },
            { "PG", "Papua-Yeni Qvineya" },
            { "PH", "Filippin" },
            { "PK", "Pakistan" },
            { "PL", "Polşa" },
            { "PM", "Müqəddəs Pyer və Mikelon" },
            { "PN", "Pitkern adaları" },
            { "PR", "Puerto Riko" },
            { "PS", "Fələstin Əraziləri" },
            { "PT", "Portuqaliya" },
            { "PW", "Palau" },
            { "PY", "Paraqvay" },
            { "QA", "Qətər" },
            { "QO", "Uzaq Okeaniya" },
            { "RE", "Reyunyon" },
            { "RO", "Rumıniya" },
            { "RS", "Serbiya" },
            { "RU", "Rusiya" },
            { "RW", "Ruanda" },
            { "SA", "Səudiyyə Ərəbistanı" },
            { "SB", "Solomon adaları" },
            { "SC", "Seyşel adaları" },
            { "SD", "Sudan" },
            { "SE", "İsveç" },
            { "SG", "Sinqapur" },
            { "SH", "Müqəddəs Yelena" },
            { "SI", "Sloveniya" },
            { "SJ", "Svalbard və Yan-Mayen" },
            { "SK", "Slovakiya" },
            { "SL", "Syerra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Seneqal" },
            { "SO", "Somali" },
            { "SR", "Surinam" },
            { "SS", "Cənubi Sudan" },
            { "ST", "San-Tome və Prinsipi" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Suriya" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Kunya" },
            { "TC", "Törks və Kaykos adaları" },
            { "TD", "Çad" },
            { "TF", "Fransanın Cənub Əraziləri" },
            { "TG", "Toqo" },
            { "TH", "Tailand" },
            { "TJ", "Tacikistan" },
            { "TK", "Tokelau" },
            { "TL", "Şərqi Timor" },
            { "TM", "Türkmənistan" },
            { "TN", "Tunis" },
            { "TO", "Tonqa" },
            { "TR", "Türkiyə" },
            { "TT", "Trinidad və Tobaqo" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "TZ", "Tanzaniya" },
            { "UA", "Ukrayna" },
            { "UG", "Uqanda" },
            { "UM", "ABŞ-a bağlı kiçik adacıqlar" },
            { "UN", "Birləşmiş Millətlər Təşkilatı" },
            { "US", "Amerika Birləşmiş Ştatları" },
            { "UY", "Uruqvay" },
            { "UZ", "Özbəkistan" },
            { "VA", "Vatikan" },
            { "VC", "Sent-Vinsent və Qrenadinlər" },
            { "VE", "Venesuela" },
            { "VG", "Britaniyanın Virgin adaları" },
            { "VI", "ABŞ Virgin adaları" },
            { "VN", "Vyetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Uollis və Futuna" },
            { "WS", "Samoa" },
            { "XA", "Psevdo-Aksent" },
            { "XB", "Psevdo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yəmən" },
            { "YT", "Mayot" },
            { "ZA", "Cənub Afrika" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Naməlum Region" },
            { "aa", "afar" },
            { "ab", "abxaz" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhar" },
            { "an", "araqon" },
            { "ar", metaValue_ar },
            { "as", "assam" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "azərbaycan" },
            { "ba", "başqırd" },
            { "be", "belarus" },
            { "bg", "bolqar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniya" },
            { "ca", "katalan" },
            { "ce", "çeçen" },
            { "ch", "çamoro" },
            { "co", "korsika" },
            { "cr", "kri" },
            { "cs", "çex" },
            { "cu", "slavyan" },
            { "cv", "çuvaş" },
            { "cy", "uels" },
            { "da", "danimarka" },
            { "de", "alman" },
            { "dv", "maldiv" },
            { "dz", "dzonqxa" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "ingilis" },
            { "eo", "esperanto" },
            { "es", "ispan" },
            { "et", "eston" },
            { "eu", "bask" },
            { "fa", "fars" },
            { "ff", "fula" },
            { "fi", "fin" },
            { "fj", "fici" },
            { "fo", "farer" },
            { "fr", "fransız" },
            { "fy", "qərbi friz" },
            { "ga", "irland" },
            { "gd", "Şotlandiya keltcəsi" },
            { "gl", "qalisiya" },
            { "gn", "quarani" },
            { "gu", metaValue_gu },
            { "gv", "manks" },
            { "ha", "hausa" },
            { "he", "ivrit" },
            { "hi", "hind" },
            { "ho", "hiri motu" },
            { "hr", "xorvat" },
            { "ht", "haiti kreol" },
            { "hu", "macar" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlinqua" },
            { "id", "indoneziya" },
            { "ie", "interlinqve" },
            { "ig", "iqbo" },
            { "ii", "siçuan yi" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "island" },
            { "it", "italyan" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "yava" },
            { "ka", metaValue_ka },
            { "kg", "konqo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "qazax" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kəşmir" },
            { "ku", "kurmanci (kürd dili) dialekti" },
            { "kv", "komi" },
            { "kw", "korn" },
            { "ky", "qırğız" },
            { "la", metaValue_la },
            { "lb", "lüksemburq" },
            { "lg", "qanda" },
            { "li", "limburq" },
            { "ln", "linqala" },
            { "lo", "laos" },
            { "lt", "litva" },
            { "lu", "luba-katanqa" },
            { "lv", "latış" },
            { "mg", "malaqas" },
            { "mh", "marşal" },
            { "mi", "māori" },
            { "mk", "makedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malay" },
            { "mt", "malta" },
            { "my", "birman" },
            { "na", "nauru" },
            { "nb", "bokmal norveç" },
            { "nd", "şimali ndebele" },
            { "ne", "nepal" },
            { "ng", "ndonqa" },
            { "nl", "holland" },
            { "nn", "nünorsk norveç" },
            { "no", "norveç" },
            { "nr", "cənubi ndebele" },
            { "nv", "navayo" },
            { "ny", "nyanca" },
            { "oc", "oksitan" },
            { "oj", "ocibva" },
            { "om", "oromo" },
            { "or", "odiya" },
            { "os", "osetin" },
            { "pa", "pəncab" },
            { "pi", "pali" },
            { "pl", "polyak" },
            { "ps", "puştu" },
            { "pt", "portuqal" },
            { "qu", "keçua" },
            { "rm", "romanş" },
            { "rn", "rundi" },
            { "ro", "rumın" },
            { "ru", "rus" },
            { "rw", "kinyarvanda" },
            { "sa", "sanskrit" },
            { "sc", "sardin" },
            { "sd", "sindhi" },
            { "se", "şimali sami" },
            { "sg", "sanqo" },
            { "sh", "serb-xorvat" },
            { "si", "sinhala" },
            { "sk", "slovak" },
            { "sl", "sloven" },
            { "sm", "samoa" },
            { "sn", "şona" },
            { "so", "somali" },
            { "sq", "alban" },
            { "sr", "serb" },
            { "ss", "svati" },
            { "st", "sesoto" },
            { "su", metaValue_su },
            { "sv", "isveç" },
            { "sw", "suahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tacik" },
            { "th", metaValue_th },
            { "ti", "tiqrin" },
            { "tk", "türkmən" },
            { "tl", metaValue_tl },
            { "tn", "svana" },
            { "to", "tonqa" },
            { "tr", "türk" },
            { "ts", "sonqa" },
            { "tt", "tatar" },
            { "tw", "tvi" },
            { "ty", "taxiti" },
            { "ug", "uyğur" },
            { "uk", "ukrayna" },
            { "ur", "urdu" },
            { "uz", "özbək" },
            { "ve", "venda" },
            { "vi", "vyetnam" },
            { "vo", "volapük" },
            { "wa", "valun" },
            { "wo", "volof" },
            { "xh", "xosa" },
            { "yi", "idiş" },
            { "yo", "yoruba" },
            { "za", "çjuan" },
            { "zh", "çin" },
            { "zu", "zulu" },
            { "ace", "akin" },
            { "ach", "akoli" },
            { "ada", "adanqme" },
            { "ady", "adıgey" },
            { "afh", "afrihili" },
            { "agq", "aqhem" },
            { "ain", "aynu" },
            { "akk", "akkad" },
            { "ale", "aleut" },
            { "alt", "cənubi altay" },
            { "ang", "qədim ingilis" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramik" },
            { "arn", "mapuçe" },
            { "arp", "arapaho" },
            { "ars", "Nəcd ərəbcəsi" },
            { "arw", "aravak" },
            { "asa", "asu" },
            { "ast", "asturiya" },
            { "atj", "Atikamek" },
            { "awa", "avadhi" },
            { "bal", "baluc" },
            { "ban", metaValue_ban },
            { "bas", "basa" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "Haryanvi" },
            { "bgn", "qərbi bəluc" },
            { "bho", "bxoçpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksikə" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bua", "buryat" },
            { "bug", "bugin" },
            { "byn", "blin" },
            { "cad", "keddo" },
            { "car", "karib" },
            { "cay", "Kayuqa" },
            { "cch", "atsam" },
            { "ccp", "Çakma" },
            { "ceb", "sebuan" },
            { "cgg", "çiqa" },
            { "chb", "çibça" },
            { "chg", "çağatay" },
            { "chk", "çukiz" },
            { "chm", "mari" },
            { "chn", "çinuk ləhçəsi" },
            { "cho", "çoktau" },
            { "chp", "çipevyan" },
            { "chr", "çeroki" },
            { "chy", "çeyen" },
            { "ckb", "Mərkəzi kürdcə" },
            { "clc", "Çilotin" },
            { "cop", "kopt" },
            { "crg", "miçif" },
            { "crh", "krım türkcəsi" },
            { "crj", "cənub-şərqi kri" },
            { "crk", "ova kricəsi" },
            { "crl", "şimal-şəqri kri" },
            { "crm", "muz kri" },
            { "crr", "Karolina alonkincəsi" },
            { "crs", "Seyşel kreol fransızcası" },
            { "csb", "kaşubyan" },
            { "csw", "bataqlıq kricəsi" },
            { "dak", "dakota" },
            { "dar", "darqva" },
            { "dav", "taita" },
            { "del", "delaver" },
            { "den", "slavey" },
            { "dgr", "doqrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "doqri" },
            { "dsb", "aşağı sorb" },
            { "dua", "duala" },
            { "dum", "orta holland" },
            { "dyo", "diola" },
            { "dyu", "dyula" },
            { "dzg", "dazaqa" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "qədim misir" },
            { "eka", "ekacuk" },
            { "elx", "elamit" },
            { "enm", "orta ingilis" },
            { "ewo", "evondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippin" },
            { "fon", "fon" },
            { "frc", "Kacun fransızcası" },
            { "frm", "orta fransız" },
            { "fro", "qədim fransız" },
            { "frr", "şimali fris" },
            { "fur", "friul" },
            { "gaa", "qa" },
            { "gag", "qaqauz" },
            { "gan", "qan" },
            { "gay", "qayo" },
            { "gba", "qabaya" },
            { "gez", "qez" },
            { "gil", "qilbert" },
            { "gmh", "orta yüksək alman" },
            { "goh", "qədim alman" },
            { "gon", "qondi" },
            { "gor", "qorontalo" },
            { "got", "qotika" },
            { "grb", "qrebo" },
            { "grc", "qədim yunan" },
            { "gsw", "İsveçrə almancası" },
            { "guz", "qusi" },
            { "gwi", "qviçin" },
            { "hai", "hayda" },
            { "hak", "hakka" },
            { "haw", "havay" },
            { "hax", "cənubi haida" },
            { "hil", "hiliqaynon" },
            { "hit", "hittit" },
            { "hmn", "monq" },
            { "hsb", "yuxarı sorb" },
            { "hsn", "syan" },
            { "hup", "hupa" },
            { "hur", "Halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "qərbi Kanada inuktitutu" },
            { "ilo", "iloko" },
            { "inh", "inquş" },
            { "jbo", "loğban" },
            { "jgo", "nqomba" },
            { "jmc", "maçam" },
            { "jpr", "ivrit-fars" },
            { "jrb", "ivrit-ərəb" },
            { "kaa", "qaraqalpaq" },
            { "kab", "kabile" },
            { "kac", "kaçin" },
            { "kaj", "ju" },
            { "kam", "kamba" },
            { "kaw", "kavi" },
            { "kbd", "kabarda-çərkəz" },
            { "kcg", "tiyap" },
            { "kde", "makond" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaynqanq" },
            { "kha", "xazi" },
            { "kho", "xotan" },
            { "khq", "koyra çiini" },
            { "kkj", "kako" },
            { "kln", "kalencin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "kos", "kosreyan" },
            { "kpe", "kpelle" },
            { "krc", "qaraçay-balkar" },
            { "krl", "karel" },
            { "kru", "kurux" },
            { "ksb", "şambala" },
            { "ksf", "bafia" },
            { "ksh", "köln" },
            { "kum", "kumık" },
            { "kut", "kutenay" },
            { "kwk", "Kvakvala" },
            { "kxv", "kuvi" },
            { "lad", "sefard" },
            { "lag", "langi" },
            { "lah", "qərbi pəncab" },
            { "lam", "lamba" },
            { "lez", "ləzgi" },
            { "lij", "liquriya dili" },
            { "lil", "Liluet" },
            { "lkt", "lakota" },
            { "lmo", "lombard dili" },
            { "lol", "monqo" },
            { "lou", "Luiziana kreolu" },
            { "loz", "lozi" },
            { "lrc", "şimali luri" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luyseno" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "maduriz" },
            { "mag", "maqahi" },
            { "mai", "maitili" },
            { "mak", "makasar" },
            { "man", "məndinqo" },
            { "mas", "masay" },
            { "mdf", "mokşa" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisien" },
            { "mga", "orta irland" },
            { "mgh", "maxuva-meetto" },
            { "mgo", "meta’" },
            { "mic", "mikmak" },
            { "min", "minanqkaban" },
            { "mnc", "mançu" },
            { "mni", "manipüri" },
            { "moe", "İnnu-aimun" },
            { "moh", "mohavk" },
            { "mos", "mosi" },
            { "mua", "mundanq" },
            { "mul", "çoxsaylı dillər" },
            { "mus", "krik" },
            { "mwl", "mirand" },
            { "mwr", "maruari" },
            { "myv", "erzya" },
            { "mzn", "mazandaran" },
            { "nan", "Min Nan" },
            { "nap", "neapolitan" },
            { "naq", "nama" },
            { "nds", "aşağı alman" },
            { "new", "nevari" },
            { "nia", "nias" },
            { "niu", "niyuan" },
            { "nmg", "kvasio" },
            { "nnh", "ngiemboon" },
            { "nog", "noqay" },
            { "non", "qədim nors" },
            { "nqo", metaValue_nqo },
            { "nso", "şimal soto" },
            { "nus", "nuer" },
            { "nym", "nyamvezi" },
            { "nyn", "nyankol" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "şimal-qərbi ocibva" },
            { "ojc", "Mərkəzi ocibva" },
            { "ojs", "ocikri" },
            { "ojw", "qərbi ocibva" },
            { "oka", "okanaqan" },
            { "osa", "osage" },
            { "ota", "osman" },
            { "pag", "panqasinan" },
            { "pal", "pəhləvi" },
            { "pam", "pampanqa" },
            { "pap", "papyamento" },
            { "pau", "palayan" },
            { "pcm", "niger kreol" },
            { "peo", "qədim fars" },
            { "phn", "foyenik" },
            { "pis", "picin" },
            { "pon", "ponpey" },
            { "pqm", "malesit-passamakvodi" },
            { "prg", "pruss" },
            { "pro", "qədim provansal" },
            { "quc", "kiçe" },
            { "raj", "racastani" },
            { "rap", "rapanui" },
            { "rar", "rarotonqan" },
            { "rhg", "Rohinca" },
            { "rof", "rombo" },
            { "rom", "roman" },
            { "rup", "aroman" },
            { "rwk", "rua" },
            { "sad", "sandave" },
            { "sah", "saxa" },
            { "sam", metaValue_sam },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santal" },
            { "sba", "nqambay" },
            { "sbp", "sanqu" },
            { "scn", "siciliya" },
            { "sco", "skots" },
            { "sdh", "cənubi kürd" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "qədim irland" },
            { "shi", "taçelit" },
            { "shn", "şan" },
            { "sid", "sidamo" },
            { "slh", "cənubi luşusid" },
            { "sma", "cənubi sami" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninke" },
            { "sog", "soqdiyen" },
            { "srn", "sranan tonqo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "streyts saliş" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeryan" },
            { "swb", "komor" },
            { "syr", "suriya" },
            { "szl", "silez dili" },
            { "tce", "cənubi tuçon" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "taq" },
            { "tht", "taltan" },
            { "tig", "tiqre" },
            { "tiv", "tiv" },
            { "tkl", "tokelay" },
            { "tlh", "klinqon" },
            { "tli", "tlinqit" },
            { "tmh", "tamaşek" },
            { "tog", "nyasa tonqa" },
            { "tok", "tokipona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "simşyan" },
            { "ttm", "şimali tuçon" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasavaq" },
            { "tyv", "tuvinyan" },
            { "tzm", "Mərkəzi Atlas tamazicəsi" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "naməlum dil" },
            { "vec", "venet dili" },
            { "vmw", "makua dili" },
            { "vot", "votik" },
            { "vun", "vunyo" },
            { "wae", "valles" },
            { "wal", "valamo" },
            { "war", "varay" },
            { "was", "vaşo" },
            { "wbp", "valpiri" },
            { "wuu", "vu" },
            { "xal", "kalmık" },
            { "xnr", "kanqri" },
            { "xog", "soqa" },
            { "yao", "yao" },
            { "yap", "yapiz" },
            { "yav", "yanqben" },
            { "ybb", "yemba" },
            { "yrl", "nyenqatu" },
            { "yue", "kanton" },
            { "zap", "zapotek" },
            { "zbl", "blisimbols" },
            { "zen", "zenaqa" },
            { "zgh", "tamazi" },
            { "zun", "zuni" },
            { "zxx", "dil məzmunu yoxdur" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "aran" },
            { "Armi", "armi" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", "blissymbols" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "brayl" },
            { "Bugi", "buqin" },
            { "Buhd", "buhid" },
            { "Cakm", "çakma" },
            { "Cans", "birləşmiş kanada yerli yazısı" },
            { "Cari", "kariyan" },
            { "Cham", "çam" },
            { "Cher", "çiroki" },
            { "Cirt", "sirt" },
            { "Copt", "koptik" },
            { "Cprt", "kipr" },
            { "Cyrl", "kiril" },
            { "Cyrs", "qədimi kilsa kirili" },
            { "Deva", "devanaqari" },
            { "Dsrt", "deseret" },
            { "Egyd", "misir demotik" },
            { "Egyh", "misir hiyeratik" },
            { "Egyp", "misir hiyeroqlif" },
            { "Ethi", "efiop" },
            { "Geok", "gürcü xutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "qlaqolitik" },
            { "Goth", "qotik" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "qurmuxi" },
            { "Hanb", "hanb" },
            { "Hang", "hanqıl" },
            { "Hani", "han" },
            { "Hano", "hanunu" },
            { "Hans", "sadələşmiş" },
            { "Hant", "ənənəvi" },
            { "Hebr", "ibrani" },
            { "Hira", "iraqana" },
            { "Hmng", "pahav monq" },
            { "Hrkt", "hecalı yapon əlifbası" },
            { "Hung", "qədimi macar" },
            { "Inds", "hindistan" },
            { "Ital", "qədimi italyalı" },
            { "Jamo", "jamo" },
            { "Java", "cava" },
            { "Jpan", metaValue_ja },
            { "Kali", "kayax li" },
            { "Kana", "katakana" },
            { "Khar", "xaroşti" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "kti" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "fraktur latını" },
            { "Latg", "gael latını" },
            { "Latn", metaValue_la },
            { "Lepc", "lepçə" },
            { "Limb", "limbu" },
            { "Lyci", "lusian" },
            { "Lydi", "ludian" },
            { "Mand", "mandayen" },
            { "Mani", "maniçayen" },
            { "Maya", "maya hiyeroqlifi" },
            { "Mero", "meroytik" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "mun" },
            { "Mtei", "meytey mayek" },
            { "Mymr", "myanmar" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "oğam" },
            { "Olck", "ol çiki" },
            { "Orkh", "orxon" },
            { "Orya", "oriya" },
            { "Osma", "osmanya" },
            { "Perm", "qədimi permik" },
            { "Phag", "faqs-pa" },
            { "Phli", "fli" },
            { "Phlp", "flp" },
            { "Phlv", "kitab paxlavi" },
            { "Phnx", "foenik" },
            { "Plrd", "polard fonetik" },
            { "Prti", "prti" },
            { "Rjng", "recəng" },
            { "Rohg", "hanifi" },
            { "Roro", "ronqoronqo" },
            { "Runr", "runik" },
            { "Samr", metaValue_sam },
            { "Sara", "sarati" },
            { "Saur", "saurastra" },
            { "Sgnw", "işarət yazısı" },
            { "Shaw", "şavyan" },
            { "Sinh", "sinhal" },
            { "Sund", metaValue_su },
            { "Sylo", "siloti nəqri" },
            { "Syrc", "siryak" },
            { "Syre", "estrangela süryanice" },
            { "Tagb", "taqbanva" },
            { "Tale", "tay le" },
            { "Talu", "təzə tay lu" },
            { "Taml", metaValue_ta },
            { "Tavt", "tavt" },
            { "Telu", metaValue_te },
            { "Teng", "tengvar" },
            { "Tfng", "tifinaq" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", "vay" },
            { "Visp", "danışma səsləri" },
            { "Xpeo", "qədimi fars" },
            { "Xsux", "sumer-akadyan kuneyform" },
            { "Yiii", "yi" },
            { "Zmth", "riyazi notasiya" },
            { "Zsye", "emoji" },
            { "Zsym", "simvollar" },
            { "Zxxx", "yazısız" },
            { "Zyyy", "ümumi yazı" },
            { "Zzzz", "tanınmayan yazı" },
            { "de_AT", "Avstriya almancası" },
            { "en_AU", "Avstraliya ingiliscəsi" },
            { "en_CA", "Kanada ingiliscəsi" },
            { "en_GB", "Britaniya ingiliscəsi" },
            { "en_US", "Amerika ingiliscəsi" },
            { "es_ES", "Kastiliya ispancası" },
            { "es_MX", "Meksika ispancası" },
            { "fa_AF", "dari" },
            { "fr_CA", "Kanada fransızcası" },
            { "fr_CH", "İsveçrə fransızcası" },
            { "nl_BE", "flamand" },
            { "pt_BR", "Braziliya portuqalcası" },
            { "pt_PT", "Portuqaliya portuqalcası" },
            { "ro_MD", "moldav" },
            { "sw_CD", "Konqo suahilicəsi" },
            { "ar_001", "müasir standart ərəb" },
            { "es_419", "Latın Amerikası ispancası" },
            { "key.ca", "Təqvim" },
            { "key.cf", "Valyuta Formatı" },
            { "key.co", "Sıralama" },
            { "key.cu", "Valyuta" },
            { "key.em", "Emojilərin təqdim edilməsi" },
            { "key.hc", "Saat Sikli (12 / 24)" },
            { "key.lb", "Sətirdən sətrə keçirmə üslubu" },
            { "key.lw", "Sözlərin bölünərək sətirdən-sətrə keçirilməsi" },
            { "key.ms", "Ölçü Sistemi" },
            { "key.nu", "Rəqəmlər" },
            { "key.ss", "Abreviaturadan sonra cümlə kəsintisi" },
            { "nds_NL", "aşağı sakson" },
            { "az_Arab", "cənubi azərbaycan" },
            { "hi_Latn", "Hindi (latın)" },
            { "zh_Hans", "sadələşmiş çin" },
            { "zh_Hant", "ənənəvi çin" },
            { "type.ca.roc", "Minquo Təqvimi" },
            { "type.hc.h11", "12 Saatlıq Sistem (0–11)" },
            { "type.hc.h12", "12 Saatlıq Sistem (0–12)" },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "type.nu.arab", "Ərəb-Hind Rəqəmləri" },
            { "type.nu.armn", "Erməni Rəqəmləri" },
            { "type.nu.beng", "Benqal Rəqəmləri" },
            { "type.nu.cakm", "Çakma rəqəmləri" },
            { "type.nu.deva", "Devanaqari Rəqəmləri" },
            { "type.nu.ethi", "Efiop Rəqəmləri" },
            { "type.nu.geor", "Gürcü Rəqəmləri" },
            { "type.nu.grek", "Yunan Rəqəmləri" },
            { "type.nu.gujr", "Qucarat Rəqəmləri" },
            { "type.nu.guru", "Qurmuxi Rəqəmləri" },
            { "type.nu.hans", "Sadələşmiş Çin Rəqəmləri" },
            { "type.nu.hant", "Ənənəvi Çin Rəqəmləri" },
            { "type.nu.hebr", "İvrit Rəqəmləri" },
            { "type.nu.java", "Cava rəqəmləri" },
            { "type.nu.jpan", "Yapon Rəqəmləri" },
            { "type.nu.khmr", "Kxmer Rəqəmləri" },
            { "type.nu.knda", "Kannada Rəqəmləri" },
            { "type.nu.laoo", "Lao Rəqəmləri" },
            { "type.nu.latn", "Qərb Rəqəmləri" },
            { "type.nu.mlym", "Malayalam Rəqəmləri" },
            { "type.nu.mtei", "Mitei Mayek rəqəmləri" },
            { "type.nu.mymr", "Myanma Rəqəmləri" },
            { "type.nu.olck", "Ol Çiki rəqəmləri" },
            { "type.nu.orya", "Oriya Rəqəmləri" },
            { "type.nu.taml", "Ənənəvi Tamil Rəqəmləri" },
            { "type.nu.telu", "Teluqu Rəqəmləri" },
            { "type.nu.thai", "Tay Rəqəmləri" },
            { "type.nu.tibt", "Tibet Rəqəmləri" },
            { "type.nu.vaii", "Vai rəqəmləri" },
            { "type.ca.dangi", "Dangi təqvimi" },
            { "type.co.ducet", "Standart Unicode Sıralama" },
            { "type.lb.loose", "Sərbəst sətirdən sətrə keçirmə üslubu" },
            { "type.nu.roman", "Rum Rəqəmləri" },
            { "type.ca.coptic", "Kopt təqvimi" },
            { "type.ca.hebrew", "Yəhudi Təqvimi" },
            { "type.ca.indian", "Hindi təqvimi" },
            { "type.co.pinyin", "Pinyin təqvimi" },
            { "type.co.search", "Ümumi Məqsədli Axtarış" },
            { "type.lb.normal", "Normal sətirdən sətrə keçirmə üslubu" },
            { "type.lb.strict", "Sərt sətirdən sətrə keçirmə üslubu" },
            { "type.ms.metric", "Metrik Sistem" },
            { "type.ca.chinese", "Çin təqvimi" },
            { "type.ca.islamic", "Hicri təqvimi" },
            { "type.ca.iso8601", "ISO-8601 Təqvimi" },
            { "type.ca.persian", "İran Təqvimi" },
            { "type.cf.account", "Uçot Valyuta Formatı" },
            { "type.nu.arabext", "Genişlənmiş Ərəb-Hind Rəqəmləri" },
            { "type.nu.armnlow", "Kiçik Erməni Rəqəmləri" },
            { "type.nu.greklow", "Kiçik Yunan Rəqəmləri" },
            { "type.nu.hanidec", "Onluq Çin Rəqəmləri" },
            { "type.nu.hansfin", "Sadələşmiş Çin Maliyyə Rəqəmləri" },
            { "type.nu.hantfin", "Ənənəvi Çin Maliyyə Rəqəmləri" },
            { "type.nu.jpanfin", "Yapon Maliyyə Rəqəmləri" },
            { "type.nu.tamldec", "Tamil Rəqəmləri" },
            { "type.ca.buddhist", "Buddist təqvimi" },
            { "type.ca.ethiopic", "Efiop təqvimi" },
            { "type.ca.japanese", "Yapon Təqvimi" },
            { "type.cf.standard", "Standart Valyuta Formatı" },
            { "type.co.standard", "Standart Sıralama" },
            { "type.ms.uksystem", "İmperial Ölçü Sistemi" },
            { "type.ms.ussystem", "ABŞ Ölçü Sistemi" },
            { "type.nu.fullwide", "Tam Geniş Rəqəmlər" },
            { "type.nu.romanlow", "Kiçik Rum Rəqəmləri" },
            { "type.ca.gregorian", "Qriqori təqvimi" },
            { "type.ca.islamic-tbla", "Hicri təqvim (tabulyar, astromonik dövr)" },
            { "type.ca.islamic-civil", "Hicri təqvimi (tabulyar, vətəndaşlıq dövrü)" },
            { "type.ca.islamic-umalqura", "Hicri təqvim (Umm əl-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Efiop amet-alem təqvimi" },
        };
        return data;
    }
}
