/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

// DeviceRequestApplyConfiguration represents a declarative configuration of the DeviceRequest type for use
// with apply.
//
// DeviceRequest is a request for devices required for a claim.
// This is typically a request for a single resource like a device, but can
// also ask for several identical devices. With FirstAvailable it is also
// possible to provide a prioritized list of requests.
type DeviceRequestApplyConfiguration struct {
	// Name can be used to reference this request in a pod.spec.containers[].resources.claims
	// entry and in a constraint of the claim.
	//
	// References using the name in the DeviceRequest will uniquely
	// identify a request when the Exactly field is set. When the
	// FirstAvailable field is set, a reference to the name of the
	// DeviceRequest will match whatever subrequest is chosen by the
	// scheduler.
	//
	// Must be a DNS label.
	Name *string `json:"name,omitempty"`
	// Exactly specifies the details for a single request that must
	// be met exactly for the request to be satisfied.
	//
	// One of Exactly or FirstAvailable must be set.
	Exactly *ExactDeviceRequestApplyConfiguration `json:"exactly,omitempty"`
	// FirstAvailable contains subrequests, of which exactly one will be
	// selected by the scheduler. It tries to
	// satisfy them in the order in which they are listed here. So if
	// there are two entries in the list, the scheduler will only check
	// the second one if it determines that the first one can not be used.
	//
	// DRA does not yet implement scoring, so the scheduler will
	// select the first set of devices that satisfies all the
	// requests in the claim. And if the requirements can
	// be satisfied on more than one node, other scheduling features
	// will determine which node is chosen. This means that the set of
	// devices allocated to a claim might not be the optimal set
	// available to the cluster. Scoring will be implemented later.
	FirstAvailable []DeviceSubRequestApplyConfiguration `json:"firstAvailable,omitempty"`
}

// DeviceRequestApplyConfiguration constructs a declarative configuration of the DeviceRequest type for use with
// apply.
func DeviceRequest() *DeviceRequestApplyConfiguration {
	return &DeviceRequestApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *DeviceRequestApplyConfiguration) WithName(value string) *DeviceRequestApplyConfiguration {
	b.Name = &value
	return b
}

// WithExactly sets the Exactly field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Exactly field is set to the value of the last call.
func (b *DeviceRequestApplyConfiguration) WithExactly(value *ExactDeviceRequestApplyConfiguration) *DeviceRequestApplyConfiguration {
	b.Exactly = value
	return b
}

// WithFirstAvailable adds the given value to the FirstAvailable field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the FirstAvailable field.
func (b *DeviceRequestApplyConfiguration) WithFirstAvailable(values ...*DeviceSubRequestApplyConfiguration) *DeviceRequestApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithFirstAvailable")
		}
		b.FirstAvailable = append(b.FirstAvailable, *values[i])
	}
	return b
}
