from io import BytesIO

from pytest import importorskip

from translate.convert import po2sub
from translate.storage import po

from . import test_convert

importorskip("aeidon", exc_type=ImportError)


class TestPO2Sub:
    @staticmethod
    def merge2sub(subsource, posource):
        """Helper that merges po translations to subtitle source without requiring files."""
        inputfile = BytesIO(posource.encode())
        inputpo = po.pofile(inputfile)
        templatefile = BytesIO(subsource.encode())
        convertor = po2sub.po2sub(templatefile, inputpo)
        outputsub = convertor.convert_store()
        print(outputsub)
        return outputsub.decode("utf-8")

    def test_subrip(self) -> None:
        """Test SubRip or .srt files."""
        posource = """#: 00:00:20.000-->00:00:24.400
msgid "Altocumulus clouds occur between six thousand"
msgstr "Blah blah blah blah"

#: 00:00:24.600-->00:00:27.800
msgid "and twenty thousand feet above ground level."
msgstr "Koei koei koei koei"
"""
        subtemplate = """1
00:00:20,000 --> 00:00:24,400
Altocumulus clouds occur between six thousand

2
00:00:24,600 --> 00:00:27,800
and twenty thousand feet above ground level.
"""
        subexpected = """1
00:00:20,000 --> 00:00:24,400
Blah blah blah blah

2
00:00:24,600 --> 00:00:27,800
Koei koei koei koei

"""
        subfile = self.merge2sub(subtemplate, posource)
        print(subexpected)
        assert subfile == subexpected


class TestPO2SubCommand(test_convert.TestConvertCommand, TestPO2Sub):
    """Tests running actual po2sub commands on files."""

    convertmodule = po2sub
    defaultoptions = {"progress": "none"}

    expected_options = [
        "-t TEMPLATE, --template=TEMPLATE",
        "--threshold=PERCENT",
        "--fuzzy",
        "--nofuzzy",
    ]
