//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A base class that represents a conversation between participants, such as in an email or messaging app.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiconversationcontext?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIConversationContext;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIConversationContext {}
);

impl UIConversationContext {
    extern_methods!(
        /// A string that uniquely identifies a conversation.
        /// This identifier is persistent for the life of the conversation.
        #[unsafe(method(threadIdentifier))]
        #[unsafe(method_family = none)]
        pub fn threadIdentifier(&self) -> Retained<NSString>;

        /// Setter for [`threadIdentifier`][Self::threadIdentifier].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setThreadIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn setThreadIdentifier(&self, thread_identifier: &NSString);

        #[cfg(feature = "UIConversationEntry")]
        /// Array of messages in the conversation
        #[unsafe(method(entries))]
        #[unsafe(method_family = none)]
        pub fn entries(&self) -> Retained<NSArray<UIConversationEntry>>;

        #[cfg(feature = "UIConversationEntry")]
        /// Setter for [`entries`][Self::entries].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setEntries:))]
        #[unsafe(method_family = none)]
        pub fn setEntries(&self, entries: &NSArray<UIConversationEntry>);

        /// A set of strings that identifies the active person in the conversation on the current device.
        #[unsafe(method(selfIdentifiers))]
        #[unsafe(method_family = none)]
        pub fn selfIdentifiers(&self) -> Retained<NSSet<NSString>>;

        /// Setter for [`selfIdentifiers`][Self::selfIdentifiers].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelfIdentifiers:))]
        #[unsafe(method_family = none)]
        pub fn setSelfIdentifiers(&self, self_identifiers: &NSSet<NSString>);

        /// A dictionary that relates participant identifiers to participant names.
        #[unsafe(method(responsePrimaryRecipientIdentifiers))]
        #[unsafe(method_family = none)]
        pub fn responsePrimaryRecipientIdentifiers(&self) -> Retained<NSSet<NSString>>;

        /// Setter for [`responsePrimaryRecipientIdentifiers`][Self::responsePrimaryRecipientIdentifiers].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setResponsePrimaryRecipientIdentifiers:))]
        #[unsafe(method_family = none)]
        pub fn setResponsePrimaryRecipientIdentifiers(
            &self,
            response_primary_recipient_identifiers: &NSSet<NSString>,
        );

        /// Map of participant identifiers to participant names
        #[unsafe(method(participantNameByIdentifier))]
        #[unsafe(method_family = none)]
        pub fn participantNameByIdentifier(
            &self,
        ) -> Retained<NSDictionary<NSString, NSPersonNameComponents>>;

        /// Setter for [`participantNameByIdentifier`][Self::participantNameByIdentifier].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setParticipantNameByIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn setParticipantNameByIdentifier(
            &self,
            participant_name_by_identifier: &NSDictionary<NSString, NSPersonNameComponents>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl UIConversationContext {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for UIConversationContext {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
