//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// The key of the target object that is exported
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcifiltergeneratorexportedkey?language=objc)
    pub static kCIFilterGeneratorExportedKey: &'static NSString;
}

extern "C" {
    /// Target object for the exported key
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcifiltergeneratorexportedkeytargetobject?language=objc)
    pub static kCIFilterGeneratorExportedKeyTargetObject: &'static NSString;
}

extern "C" {
    /// Name of the key under which it is exported.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcifiltergeneratorexportedkeyname?language=objc)
    pub static kCIFilterGeneratorExportedKeyName: &'static NSString;
}

extern_class!(
    /// The goal is to CIFilters to be connected and form a single CIFilter for ease of reusability.
    ///
    /// The CIFilterGenerator allows developers to create complex effects built out of one or more CIFilter and reuse them without changing code. The resulting CIFilterGenerator can be written into a file for which we introduce a new file type (extension). A CIFilterGenerator can be created from the API or more conveniently through an editor view that we provide.
    /// CIFilterGenerator files can be put into the Image Units folders on the system and they will be loaded when the user invokes one of the loadPlugIns methods. They will be registered by their filename or if present by an attribute in its description.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifiltergenerator?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIFilterGenerator;
);

#[cfg(feature = "CIFilterConstructor")]
extern_conformance!(
    unsafe impl CIFilterConstructor for CIFilterGenerator {}
);

extern_conformance!(
    unsafe impl NSCoding for CIFilterGenerator {}
);

extern_conformance!(
    unsafe impl NSCopying for CIFilterGenerator {}
);

unsafe impl CopyingHelper for CIFilterGenerator {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIFilterGenerator {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIFilterGenerator {}
);

impl CIFilterGenerator {
    extern_methods!(
        /// This creates an empty CIFilterGenerator in which you connect filters and images.
        #[unsafe(method(filterGenerator))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterGenerator() -> Retained<CIFilterGenerator>;

        /// Create a CIFilterGenerator with the contents of the file.
        ///
        /// Returns: CIFilterGenerator object. If the file could not be read it returns nil.
        #[unsafe(method(filterGeneratorWithContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterGeneratorWithContentsOfURL(
            a_url: &NSURL,
        ) -> Option<Retained<CIFilterGenerator>>;

        /// Initializes a CIFilterGenerator with the contents of the file.
        ///
        ///
        /// Returns: CIFilterGenerator object. If the file could not be read it returns nil.
        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            a_url: &NSURL,
        ) -> Option<Retained<Self>>;

        /// Connect two objects into the filter chain.
        ///
        /// This method connects two object in the filter chain. For instance you can connect the outputImage key of a CISepiaTone filter object to the inputImage key of another CIFilter.
        ///
        /// Parameter `sourceObject`: A CIFilter, CIImage, NSString, or NSURL describing the path to the image
        ///
        /// Parameter `sourceKey`: For KVC access to the source object. Can be nil which means that the source object will be used directly.
        ///
        /// Parameter `targetObject`: The object that you link the source object to.
        ///
        /// Parameter `targetKey`: The key that you assign the source object to.
        ///
        /// # Safety
        ///
        /// - `source_object` should be of the correct type.
        /// - `target_object` should be of the correct type.
        #[unsafe(method(connectObject:withKey:toObject:withKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn connectObject_withKey_toObject_withKey(
            &self,
            source_object: &AnyObject,
            source_key: Option<&NSString>,
            target_object: &AnyObject,
            target_key: &NSString,
        );

        /// Removes the connection between two objects in the filter chain.
        ///
        /// Use this method to disconnect two objects that you connected using the connectObject:withKey:toObject:withKey: method.
        ///
        /// Parameter `sourceObject`: A CIFilter or CIImage or an NSString or an NSURL describing the path to the image
        ///
        /// Parameter `sourceKey`: For KVC access to the source object. Can be nil which means that the source object will be used directly.
        ///
        /// Parameter `targetObject`: The object that you linked the source object to.
        ///
        /// Parameter `targetKey`: The key that you assigned the source object to.
        ///
        /// # Safety
        ///
        /// - `source_object` should be of the correct type.
        /// - `target_object` should be of the correct type.
        #[unsafe(method(disconnectObject:withKey:toObject:withKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn disconnectObject_withKey_toObject_withKey(
            &self,
            source_object: &AnyObject,
            source_key: &NSString,
            target_object: &AnyObject,
            target_key: &NSString,
        );

        /// This methods allows you to export an input or output key of an object in the filter chain to be available through the inputKeys or outputKeys API when converted into a CIFilter
        ///
        /// When you create a CIFilter from the CIFilterGenerator, you might want the client of the filter being able to set some of the paramters of the filter chain. To do so these parameters have to be exported as keys much like the inputKeys and outputKeys of all CIFilters.
        ///
        /// Parameter `key`: The key path that is to be exported from the target object (eg. inputImage)
        ///
        /// Parameter `targetObject`: The object of which the key is to be exported (eg the filter).
        ///
        /// Parameter `exportedKeyName`: The name under which you want the new key to be available. This parameter can be nil in which case the original key name will be used. This name has to be unique. If a key being exported is an inputKey of the filter it will be exported as an input key and the other way around for output keys.
        ///
        /// # Safety
        ///
        /// `target_object` should be of the correct type.
        #[unsafe(method(exportKey:fromObject:withName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn exportKey_fromObject_withName(
            &self,
            key: &NSString,
            target_object: &AnyObject,
            exported_key_name: Option<&NSString>,
        );

        /// Removes a key that was exported before using exportKey:fromObject:withName:
        ///
        /// Use this method when you want to remove a prior exported key. It will not show up under inputKeys or outputKeys anymore.
        ///
        /// Parameter `exportedKeyName`: Name of the key that was exported.
        #[unsafe(method(removeExportedKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeExportedKey(&self, exported_key_name: &NSString);

        /// An array of the exported keys.
        ///
        /// Use this method to get an NSArray of all the keys that you have exported using exportKey:fromObject:withName: or that were exported before written to a file from which you read the filter chain.
        ///
        /// Returns: An array of dictionaries that describe the exported key and target object. See CIExportedKey, CIExportedKeyTargetObject and CIExportedKeyName for keys used in the dictionary.
        #[unsafe(method(exportedKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn exportedKeys(&self) -> Retained<NSDictionary>;

        /// Set a new dictionary of attributes for an exported key.
        ///
        /// By default, the exported key inherits the attributes from its original key and target object. Use this method to for instance change the default value or lower the maximum allowed value.
        ///
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[unsafe(method(setAttributes:forExportedKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributes_forExportedKey(
            &self,
            attributes: &NSDictionary,
            key: &NSString,
        );

        /// Retrieve or Set the class attributes that will be used to register the filter using the registerFilterName method.
        /// Make sure you set the class attributes before using the registerFilterName method.
        /// See CIFilter for a description of the classAttributes that are needed to register a filter.
        #[unsafe(method(classAttributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn classAttributes(&self) -> Retained<NSDictionary>;

        /// Setter for [`classAttributes`][Self::classAttributes].
        ///
        /// # Safety
        ///
        /// `class_attributes` generic should be of the correct type.
        #[unsafe(method(setClassAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClassAttributes(&self, class_attributes: &NSDictionary);

        #[cfg(feature = "CIFilter")]
        /// Create a CIFilter object based on this filter chain.
        ///
        /// This method creates a CIFilter from the filter chain where the topology of the chain is immutable, meaning that changes to the filter chain will not be reflected in the filter. The filter will have the input and output keys that were exported as described above.
        #[unsafe(method(filter))]
        #[unsafe(method_family = none)]
        pub unsafe fn filter(&self) -> Retained<CIFilter>;

        /// Register the resulting filter of the chain in the CIFilter repository.
        ///
        /// This method allows you to register the filter chain as a named filter in the filter repository. You can then create a CIFilter object from it using the filterWithName: method. Make sure you set the class attributes first - see CIFilter for a description of the classAttributes that are needed to register a filter.
        /// When registering Core Image automatically adds the kCIFilterGeneratorCategory to the filters categories. The kCIFilterGeneratorCategory is purely for identification purpose and will not be exposed in the filter browser as a seperate category.
        ///
        ///
        /// Parameter `name`: The name under which the filter will be registered. This name has to be unique.
        #[unsafe(method(registerFilterName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerFilterName(&self, name: &NSString);

        /// Write the CIFilterGenerator into a file
        ///
        /// Returns: Returns true when the chain with written our succesfully
        #[unsafe(method(writeToURL:atomically:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToURL_atomically(&self, a_url: &NSURL, flag: bool) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIFilterGenerator {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
