macro(configure_stats_frontend _NAME_TARGET)
    # Could use if() with VERSION_GREATER_EQUAL but that requires 3.7 or later.
    if((${CMAKE_MAJOR_VERSION} GREATER 3) OR ((${CMAKE_MAJOR_VERSION} EQUAL 3) AND (${CMAKE_MINOR_VERSION} GREATER 13)))
        find_package(SQLite3)
    else()
        find_library(SQLite3_LIBRARY sqlite3)
        if(SQLite3_LIBRARY)
            include(CheckLibraryExists)
            check_library_exists(${SQLite3_LIBRARY} sqlite3_exec "" SQLite3_HAS_)
            if(SQLite3_HAS_)
                find_path(SQLite3_INCLUDE_DIR sqlite3.h)
                if(SQLite3_INCLUDE_DIR)
                    set(SQLite3_FOUND YES)
                    set(SQLite3_LIBRARIES ${SQLite3_LIBRARY})
                    set(SQLite3_INCLUDE_DIRS ${SQLite3_INCLUDE_DIR})
                else()
                    message(STATUS "Did not find sqlite3.h")
                endif()
            else()
                message(STATUS "${SQLite3_LIBRARY} does not have sqlite3_exec()")
            endif()
        else()
            message(STATUS "Did not find the sqlite3 library")
        endif()
    endif()

    if(SQLite3_FOUND)
        target_link_libraries(${_NAME_TARGET} PRIVATE ${SQLite3_LIBRARIES})
        target_include_directories(${_NAME_TARGET} PRIVATE ${SQLite3_INCLUDE_DIRS})
        message(STATUS "Support for statistics front end - Ready")
    else()
        message(FATAL_ERROR "Support for statistics front end - Failed")
    endif()
endmacro()
