// <copyright file="ProxyConfiguration.cs" company="Selenium Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// </copyright>

using System.Text.Json.Serialization;

namespace OpenQA.Selenium.BiDi.Session;

[JsonPolymorphic(TypeDiscriminatorPropertyName = "proxyType")]
[JsonDerivedType(typeof(AutoDetectProxyConfiguration), "autodetect")]
[JsonDerivedType(typeof(DirectProxyConfiguration), "direct")]
[JsonDerivedType(typeof(ManualProxyConfiguration), "manual")]
[JsonDerivedType(typeof(PacProxyConfiguration), "pac")]
[JsonDerivedType(typeof(SystemProxyConfiguration), "system")]
public abstract record ProxyConfiguration;

public sealed record AutoDetectProxyConfiguration : ProxyConfiguration;

public sealed record DirectProxyConfiguration : ProxyConfiguration;

public sealed record ManualProxyConfiguration : ProxyConfiguration, ISocksProxyConfiguration
{
    public string? HttpProxy { get; init; }

    public string? SslProxy { get; init; }

    public string? SocksProxy { get; init; }

    public int? SocksVersion { get; init; }

    public IEnumerable<string>? NoProxy { get; init; }
}

public sealed record PacProxyConfiguration(string ProxyAutoConfigUrl) : ProxyConfiguration;

public sealed record SystemProxyConfiguration : ProxyConfiguration;

public interface ISocksProxyConfiguration
{
    public string? SocksProxy { get; init; }

    public int? SocksVersion { get; init; } // 0..255
}
