// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// NewLogServiceListStreamingDestinationsForResourceParams creates a new LogServiceListStreamingDestinationsForResourceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLogServiceListStreamingDestinationsForResourceParams() *LogServiceListStreamingDestinationsForResourceParams {
	return &LogServiceListStreamingDestinationsForResourceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLogServiceListStreamingDestinationsForResourceParamsWithTimeout creates a new LogServiceListStreamingDestinationsForResourceParams object
// with the ability to set a timeout on a request.
func NewLogServiceListStreamingDestinationsForResourceParamsWithTimeout(timeout time.Duration) *LogServiceListStreamingDestinationsForResourceParams {
	return &LogServiceListStreamingDestinationsForResourceParams{
		timeout: timeout,
	}
}

// NewLogServiceListStreamingDestinationsForResourceParamsWithContext creates a new LogServiceListStreamingDestinationsForResourceParams object
// with the ability to set a context for a request.
func NewLogServiceListStreamingDestinationsForResourceParamsWithContext(ctx context.Context) *LogServiceListStreamingDestinationsForResourceParams {
	return &LogServiceListStreamingDestinationsForResourceParams{
		Context: ctx,
	}
}

// NewLogServiceListStreamingDestinationsForResourceParamsWithHTTPClient creates a new LogServiceListStreamingDestinationsForResourceParams object
// with the ability to set a custom HTTPClient for a request.
func NewLogServiceListStreamingDestinationsForResourceParamsWithHTTPClient(client *http.Client) *LogServiceListStreamingDestinationsForResourceParams {
	return &LogServiceListStreamingDestinationsForResourceParams{
		HTTPClient: client,
	}
}

/*
LogServiceListStreamingDestinationsForResourceParams contains all the parameters to send to the API endpoint

	for the log service list streaming destinations for resource operation.

	Typically these are written to a http.Request.
*/
type LogServiceListStreamingDestinationsForResourceParams struct {

	// Body.
	Body *models.LogService20210330ListStreamingDestinationsForResourceRequest

	/* ResourceID.

	   id is the identifier for this resource.
	*/
	ResourceID string

	/* ResourceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	ResourceLocationOrganizationID string

	/* ResourceLocationProjectID.

	   project_id is the projects id.
	*/
	ResourceLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the log service list streaming destinations for resource params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LogServiceListStreamingDestinationsForResourceParams) WithDefaults() *LogServiceListStreamingDestinationsForResourceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the log service list streaming destinations for resource params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LogServiceListStreamingDestinationsForResourceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) WithTimeout(timeout time.Duration) *LogServiceListStreamingDestinationsForResourceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) WithContext(ctx context.Context) *LogServiceListStreamingDestinationsForResourceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) WithHTTPClient(client *http.Client) *LogServiceListStreamingDestinationsForResourceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) WithBody(body *models.LogService20210330ListStreamingDestinationsForResourceRequest) *LogServiceListStreamingDestinationsForResourceParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) SetBody(body *models.LogService20210330ListStreamingDestinationsForResourceRequest) {
	o.Body = body
}

// WithResourceID adds the resourceID to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) WithResourceID(resourceID string) *LogServiceListStreamingDestinationsForResourceParams {
	o.SetResourceID(resourceID)
	return o
}

// SetResourceID adds the resourceId to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) SetResourceID(resourceID string) {
	o.ResourceID = resourceID
}

// WithResourceLocationOrganizationID adds the resourceLocationOrganizationID to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) WithResourceLocationOrganizationID(resourceLocationOrganizationID string) *LogServiceListStreamingDestinationsForResourceParams {
	o.SetResourceLocationOrganizationID(resourceLocationOrganizationID)
	return o
}

// SetResourceLocationOrganizationID adds the resourceLocationOrganizationId to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) SetResourceLocationOrganizationID(resourceLocationOrganizationID string) {
	o.ResourceLocationOrganizationID = resourceLocationOrganizationID
}

// WithResourceLocationProjectID adds the resourceLocationProjectID to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) WithResourceLocationProjectID(resourceLocationProjectID string) *LogServiceListStreamingDestinationsForResourceParams {
	o.SetResourceLocationProjectID(resourceLocationProjectID)
	return o
}

// SetResourceLocationProjectID adds the resourceLocationProjectId to the log service list streaming destinations for resource params
func (o *LogServiceListStreamingDestinationsForResourceParams) SetResourceLocationProjectID(resourceLocationProjectID string) {
	o.ResourceLocationProjectID = resourceLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *LogServiceListStreamingDestinationsForResourceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param resource.id
	if err := r.SetPathParam("resource.id", o.ResourceID); err != nil {
		return err
	}

	// path param resource.location.organization_id
	if err := r.SetPathParam("resource.location.organization_id", o.ResourceLocationOrganizationID); err != nil {
		return err
	}

	// path param resource.location.project_id
	if err := r.SetPathParam("resource.location.project_id", o.ResourceLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
