// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceGetTFCConfigReader is a Reader for the WaypointServiceGetTFCConfig structure.
type WaypointServiceGetTFCConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceGetTFCConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceGetTFCConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceGetTFCConfigDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceGetTFCConfigOK creates a WaypointServiceGetTFCConfigOK with default headers values
func NewWaypointServiceGetTFCConfigOK() *WaypointServiceGetTFCConfigOK {
	return &WaypointServiceGetTFCConfigOK{}
}

/*
WaypointServiceGetTFCConfigOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceGetTFCConfigOK struct {
	Payload *models.HashicorpCloudWaypointGetTFCConfigResponse
}

// IsSuccess returns true when this waypoint service get t f c config o k response has a 2xx status code
func (o *WaypointServiceGetTFCConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service get t f c config o k response has a 3xx status code
func (o *WaypointServiceGetTFCConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service get t f c config o k response has a 4xx status code
func (o *WaypointServiceGetTFCConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service get t f c config o k response has a 5xx status code
func (o *WaypointServiceGetTFCConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service get t f c config o k response a status code equal to that given
func (o *WaypointServiceGetTFCConfigOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service get t f c config o k response
func (o *WaypointServiceGetTFCConfigOK) Code() int {
	return 200
}

func (o *WaypointServiceGetTFCConfigOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig][%d] waypointServiceGetTFCConfigOK %s", 200, payload)
}

func (o *WaypointServiceGetTFCConfigOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig][%d] waypointServiceGetTFCConfigOK %s", 200, payload)
}

func (o *WaypointServiceGetTFCConfigOK) GetPayload() *models.HashicorpCloudWaypointGetTFCConfigResponse {
	return o.Payload
}

func (o *WaypointServiceGetTFCConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointGetTFCConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceGetTFCConfigDefault creates a WaypointServiceGetTFCConfigDefault with default headers values
func NewWaypointServiceGetTFCConfigDefault(code int) *WaypointServiceGetTFCConfigDefault {
	return &WaypointServiceGetTFCConfigDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceGetTFCConfigDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceGetTFCConfigDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service get t f c config default response has a 2xx status code
func (o *WaypointServiceGetTFCConfigDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service get t f c config default response has a 3xx status code
func (o *WaypointServiceGetTFCConfigDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service get t f c config default response has a 4xx status code
func (o *WaypointServiceGetTFCConfigDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service get t f c config default response has a 5xx status code
func (o *WaypointServiceGetTFCConfigDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service get t f c config default response a status code equal to that given
func (o *WaypointServiceGetTFCConfigDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service get t f c config default response
func (o *WaypointServiceGetTFCConfigDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceGetTFCConfigDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig][%d] WaypointService_GetTFCConfig default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetTFCConfigDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig][%d] WaypointService_GetTFCConfig default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetTFCConfigDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceGetTFCConfigDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
