// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetAwsDynamicSecretReader is a Reader for the GetAwsDynamicSecret structure.
type GetAwsDynamicSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAwsDynamicSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAwsDynamicSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetAwsDynamicSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAwsDynamicSecretOK creates a GetAwsDynamicSecretOK with default headers values
func NewGetAwsDynamicSecretOK() *GetAwsDynamicSecretOK {
	return &GetAwsDynamicSecretOK{}
}

/*
GetAwsDynamicSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetAwsDynamicSecretOK struct {
	Payload *models.Secrets20231128GetAwsDynamicSecretResponse
}

// IsSuccess returns true when this get aws dynamic secret o k response has a 2xx status code
func (o *GetAwsDynamicSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get aws dynamic secret o k response has a 3xx status code
func (o *GetAwsDynamicSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aws dynamic secret o k response has a 4xx status code
func (o *GetAwsDynamicSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get aws dynamic secret o k response has a 5xx status code
func (o *GetAwsDynamicSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get aws dynamic secret o k response a status code equal to that given
func (o *GetAwsDynamicSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get aws dynamic secret o k response
func (o *GetAwsDynamicSecretOK) Code() int {
	return 200
}

func (o *GetAwsDynamicSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] getAwsDynamicSecretOK %s", 200, payload)
}

func (o *GetAwsDynamicSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] getAwsDynamicSecretOK %s", 200, payload)
}

func (o *GetAwsDynamicSecretOK) GetPayload() *models.Secrets20231128GetAwsDynamicSecretResponse {
	return o.Payload
}

func (o *GetAwsDynamicSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetAwsDynamicSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAwsDynamicSecretDefault creates a GetAwsDynamicSecretDefault with default headers values
func NewGetAwsDynamicSecretDefault(code int) *GetAwsDynamicSecretDefault {
	return &GetAwsDynamicSecretDefault{
		_statusCode: code,
	}
}

/*
GetAwsDynamicSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetAwsDynamicSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get aws dynamic secret default response has a 2xx status code
func (o *GetAwsDynamicSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get aws dynamic secret default response has a 3xx status code
func (o *GetAwsDynamicSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get aws dynamic secret default response has a 4xx status code
func (o *GetAwsDynamicSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get aws dynamic secret default response has a 5xx status code
func (o *GetAwsDynamicSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get aws dynamic secret default response a status code equal to that given
func (o *GetAwsDynamicSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get aws dynamic secret default response
func (o *GetAwsDynamicSecretDefault) Code() int {
	return o._statusCode
}

func (o *GetAwsDynamicSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] GetAwsDynamicSecret default %s", o._statusCode, payload)
}

func (o *GetAwsDynamicSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] GetAwsDynamicSecret default %s", o._statusCode, payload)
}

func (o *GetAwsDynamicSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetAwsDynamicSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
