// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// ReadArchitectureReader is a Reader for the ReadArchitecture structure.
type ReadArchitectureReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ReadArchitectureReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewReadArchitectureOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewReadArchitectureDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewReadArchitectureOK creates a ReadArchitectureOK with default headers values
func NewReadArchitectureOK() *ReadArchitectureOK {
	return &ReadArchitectureOK{}
}

/*
ReadArchitectureOK describes a response with status code 200, with default header values.

A successful response.
*/
type ReadArchitectureOK struct {
	Payload *models.HashicorpCloudVagrant20220930ReadArchitectureResponse
}

// IsSuccess returns true when this read architecture o k response has a 2xx status code
func (o *ReadArchitectureOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this read architecture o k response has a 3xx status code
func (o *ReadArchitectureOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read architecture o k response has a 4xx status code
func (o *ReadArchitectureOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this read architecture o k response has a 5xx status code
func (o *ReadArchitectureOK) IsServerError() bool {
	return false
}

// IsCode returns true when this read architecture o k response a status code equal to that given
func (o *ReadArchitectureOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the read architecture o k response
func (o *ReadArchitectureOK) Code() int {
	return 200
}

func (o *ReadArchitectureOK) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] readArchitectureOK  %+v", 200, o.Payload)
}

func (o *ReadArchitectureOK) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] readArchitectureOK  %+v", 200, o.Payload)
}

func (o *ReadArchitectureOK) GetPayload() *models.HashicorpCloudVagrant20220930ReadArchitectureResponse {
	return o.Payload
}

func (o *ReadArchitectureOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930ReadArchitectureResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadArchitectureDefault creates a ReadArchitectureDefault with default headers values
func NewReadArchitectureDefault(code int) *ReadArchitectureDefault {
	return &ReadArchitectureDefault{
		_statusCode: code,
	}
}

/*
ReadArchitectureDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ReadArchitectureDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this read architecture default response has a 2xx status code
func (o *ReadArchitectureDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this read architecture default response has a 3xx status code
func (o *ReadArchitectureDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this read architecture default response has a 4xx status code
func (o *ReadArchitectureDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this read architecture default response has a 5xx status code
func (o *ReadArchitectureDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this read architecture default response a status code equal to that given
func (o *ReadArchitectureDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the read architecture default response
func (o *ReadArchitectureDefault) Code() int {
	return o._statusCode
}

func (o *ReadArchitectureDefault) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] ReadArchitecture default  %+v", o._statusCode, o.Payload)
}

func (o *ReadArchitectureDefault) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] ReadArchitecture default  %+v", o._statusCode, o.Payload)
}

func (o *ReadArchitectureDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ReadArchitectureDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
