// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceCreateChannelReader is a Reader for the PackerServiceCreateChannel structure.
type PackerServiceCreateChannelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceCreateChannelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceCreateChannelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceCreateChannelDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceCreateChannelOK creates a PackerServiceCreateChannelOK with default headers values
func NewPackerServiceCreateChannelOK() *PackerServiceCreateChannelOK {
	return &PackerServiceCreateChannelOK{}
}

/*
PackerServiceCreateChannelOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceCreateChannelOK struct {
	Payload *models.HashicorpCloudPacker20230101CreateChannelResponse
}

// IsSuccess returns true when this packer service create channel o k response has a 2xx status code
func (o *PackerServiceCreateChannelOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service create channel o k response has a 3xx status code
func (o *PackerServiceCreateChannelOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service create channel o k response has a 4xx status code
func (o *PackerServiceCreateChannelOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service create channel o k response has a 5xx status code
func (o *PackerServiceCreateChannelOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service create channel o k response a status code equal to that given
func (o *PackerServiceCreateChannelOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service create channel o k response
func (o *PackerServiceCreateChannelOK) Code() int {
	return 200
}

func (o *PackerServiceCreateChannelOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] packerServiceCreateChannelOK %s", 200, payload)
}

func (o *PackerServiceCreateChannelOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] packerServiceCreateChannelOK %s", 200, payload)
}

func (o *PackerServiceCreateChannelOK) GetPayload() *models.HashicorpCloudPacker20230101CreateChannelResponse {
	return o.Payload
}

func (o *PackerServiceCreateChannelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101CreateChannelResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceCreateChannelDefault creates a PackerServiceCreateChannelDefault with default headers values
func NewPackerServiceCreateChannelDefault(code int) *PackerServiceCreateChannelDefault {
	return &PackerServiceCreateChannelDefault{
		_statusCode: code,
	}
}

/*
PackerServiceCreateChannelDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceCreateChannelDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service create channel default response has a 2xx status code
func (o *PackerServiceCreateChannelDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service create channel default response has a 3xx status code
func (o *PackerServiceCreateChannelDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service create channel default response has a 4xx status code
func (o *PackerServiceCreateChannelDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service create channel default response has a 5xx status code
func (o *PackerServiceCreateChannelDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service create channel default response a status code equal to that given
func (o *PackerServiceCreateChannelDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service create channel default response
func (o *PackerServiceCreateChannelDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceCreateChannelDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] PackerService_CreateChannel default %s", o._statusCode, payload)
}

func (o *PackerServiceCreateChannelDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels][%d] PackerService_CreateChannel default %s", o._statusCode, payload)
}

func (o *PackerServiceCreateChannelDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceCreateChannelDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
