// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// NewLogServiceUpdateStreamingDestinationParams creates a new LogServiceUpdateStreamingDestinationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLogServiceUpdateStreamingDestinationParams() *LogServiceUpdateStreamingDestinationParams {
	return &LogServiceUpdateStreamingDestinationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLogServiceUpdateStreamingDestinationParamsWithTimeout creates a new LogServiceUpdateStreamingDestinationParams object
// with the ability to set a timeout on a request.
func NewLogServiceUpdateStreamingDestinationParamsWithTimeout(timeout time.Duration) *LogServiceUpdateStreamingDestinationParams {
	return &LogServiceUpdateStreamingDestinationParams{
		timeout: timeout,
	}
}

// NewLogServiceUpdateStreamingDestinationParamsWithContext creates a new LogServiceUpdateStreamingDestinationParams object
// with the ability to set a context for a request.
func NewLogServiceUpdateStreamingDestinationParamsWithContext(ctx context.Context) *LogServiceUpdateStreamingDestinationParams {
	return &LogServiceUpdateStreamingDestinationParams{
		Context: ctx,
	}
}

// NewLogServiceUpdateStreamingDestinationParamsWithHTTPClient creates a new LogServiceUpdateStreamingDestinationParams object
// with the ability to set a custom HTTPClient for a request.
func NewLogServiceUpdateStreamingDestinationParamsWithHTTPClient(client *http.Client) *LogServiceUpdateStreamingDestinationParams {
	return &LogServiceUpdateStreamingDestinationParams{
		HTTPClient: client,
	}
}

/*
LogServiceUpdateStreamingDestinationParams contains all the parameters to send to the API endpoint

	for the log service update streaming destination operation.

	Typically these are written to a http.Request.
*/
type LogServiceUpdateStreamingDestinationParams struct {

	// Body.
	Body *models.LogService20210330UpdateStreamingDestinationRequest

	/* DestinationResourceID.

	   id is the identifier for this resource.
	*/
	DestinationResourceID string

	/* DestinationResourceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	DestinationResourceLocationOrganizationID string

	/* DestinationResourceLocationProjectID.

	   project_id is the projects id.
	*/
	DestinationResourceLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the log service update streaming destination params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LogServiceUpdateStreamingDestinationParams) WithDefaults() *LogServiceUpdateStreamingDestinationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the log service update streaming destination params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LogServiceUpdateStreamingDestinationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) WithTimeout(timeout time.Duration) *LogServiceUpdateStreamingDestinationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) WithContext(ctx context.Context) *LogServiceUpdateStreamingDestinationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) WithHTTPClient(client *http.Client) *LogServiceUpdateStreamingDestinationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) WithBody(body *models.LogService20210330UpdateStreamingDestinationRequest) *LogServiceUpdateStreamingDestinationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) SetBody(body *models.LogService20210330UpdateStreamingDestinationRequest) {
	o.Body = body
}

// WithDestinationResourceID adds the destinationResourceID to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) WithDestinationResourceID(destinationResourceID string) *LogServiceUpdateStreamingDestinationParams {
	o.SetDestinationResourceID(destinationResourceID)
	return o
}

// SetDestinationResourceID adds the destinationResourceId to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) SetDestinationResourceID(destinationResourceID string) {
	o.DestinationResourceID = destinationResourceID
}

// WithDestinationResourceLocationOrganizationID adds the destinationResourceLocationOrganizationID to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) WithDestinationResourceLocationOrganizationID(destinationResourceLocationOrganizationID string) *LogServiceUpdateStreamingDestinationParams {
	o.SetDestinationResourceLocationOrganizationID(destinationResourceLocationOrganizationID)
	return o
}

// SetDestinationResourceLocationOrganizationID adds the destinationResourceLocationOrganizationId to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) SetDestinationResourceLocationOrganizationID(destinationResourceLocationOrganizationID string) {
	o.DestinationResourceLocationOrganizationID = destinationResourceLocationOrganizationID
}

// WithDestinationResourceLocationProjectID adds the destinationResourceLocationProjectID to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) WithDestinationResourceLocationProjectID(destinationResourceLocationProjectID string) *LogServiceUpdateStreamingDestinationParams {
	o.SetDestinationResourceLocationProjectID(destinationResourceLocationProjectID)
	return o
}

// SetDestinationResourceLocationProjectID adds the destinationResourceLocationProjectId to the log service update streaming destination params
func (o *LogServiceUpdateStreamingDestinationParams) SetDestinationResourceLocationProjectID(destinationResourceLocationProjectID string) {
	o.DestinationResourceLocationProjectID = destinationResourceLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *LogServiceUpdateStreamingDestinationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param destination.resource.id
	if err := r.SetPathParam("destination.resource.id", o.DestinationResourceID); err != nil {
		return err
	}

	// path param destination.resource.location.organization_id
	if err := r.SetPathParam("destination.resource.location.organization_id", o.DestinationResourceLocationOrganizationID); err != nil {
		return err
	}

	// path param destination.resource.location.project_id
	if err := r.SetPathParam("destination.resource.location.project_id", o.DestinationResourceLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
