// Code generated by go-swagger; DO NOT EDIT.

package auth_config_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// AuthConfigServiceEditAuthConnectionReader is a Reader for the AuthConfigServiceEditAuthConnection structure.
type AuthConfigServiceEditAuthConnectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuthConfigServiceEditAuthConnectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuthConfigServiceEditAuthConnectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuthConfigServiceEditAuthConnectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuthConfigServiceEditAuthConnectionOK creates a AuthConfigServiceEditAuthConnectionOK with default headers values
func NewAuthConfigServiceEditAuthConnectionOK() *AuthConfigServiceEditAuthConnectionOK {
	return &AuthConfigServiceEditAuthConnectionOK{}
}

/*
AuthConfigServiceEditAuthConnectionOK describes a response with status code 200, with default header values.

A successful response.
*/
type AuthConfigServiceEditAuthConnectionOK struct {
	Payload interface{}
}

// IsSuccess returns true when this auth config service edit auth connection o k response has a 2xx status code
func (o *AuthConfigServiceEditAuthConnectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this auth config service edit auth connection o k response has a 3xx status code
func (o *AuthConfigServiceEditAuthConnectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this auth config service edit auth connection o k response has a 4xx status code
func (o *AuthConfigServiceEditAuthConnectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this auth config service edit auth connection o k response has a 5xx status code
func (o *AuthConfigServiceEditAuthConnectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this auth config service edit auth connection o k response a status code equal to that given
func (o *AuthConfigServiceEditAuthConnectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the auth config service edit auth connection o k response
func (o *AuthConfigServiceEditAuthConnectionOK) Code() int {
	return 200
}

func (o *AuthConfigServiceEditAuthConnectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] authConfigServiceEditAuthConnectionOK %s", 200, payload)
}

func (o *AuthConfigServiceEditAuthConnectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] authConfigServiceEditAuthConnectionOK %s", 200, payload)
}

func (o *AuthConfigServiceEditAuthConnectionOK) GetPayload() interface{} {
	return o.Payload
}

func (o *AuthConfigServiceEditAuthConnectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuthConfigServiceEditAuthConnectionDefault creates a AuthConfigServiceEditAuthConnectionDefault with default headers values
func NewAuthConfigServiceEditAuthConnectionDefault(code int) *AuthConfigServiceEditAuthConnectionDefault {
	return &AuthConfigServiceEditAuthConnectionDefault{
		_statusCode: code,
	}
}

/*
AuthConfigServiceEditAuthConnectionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type AuthConfigServiceEditAuthConnectionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this auth config service edit auth connection default response has a 2xx status code
func (o *AuthConfigServiceEditAuthConnectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this auth config service edit auth connection default response has a 3xx status code
func (o *AuthConfigServiceEditAuthConnectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this auth config service edit auth connection default response has a 4xx status code
func (o *AuthConfigServiceEditAuthConnectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this auth config service edit auth connection default response has a 5xx status code
func (o *AuthConfigServiceEditAuthConnectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this auth config service edit auth connection default response a status code equal to that given
func (o *AuthConfigServiceEditAuthConnectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the auth config service edit auth connection default response
func (o *AuthConfigServiceEditAuthConnectionDefault) Code() int {
	return o._statusCode
}

func (o *AuthConfigServiceEditAuthConnectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] AuthConfigService_EditAuthConnection default %s", o._statusCode, payload)
}

func (o *AuthConfigServiceEditAuthConnectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] AuthConfigService_EditAuthConnection default %s", o._statusCode, payload)
}

func (o *AuthConfigServiceEditAuthConnectionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *AuthConfigServiceEditAuthConnectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AuthConfigServiceEditAuthConnectionBody auth config service edit auth connection body
swagger:model AuthConfigServiceEditAuthConnectionBody
*/
type AuthConfigServiceEditAuthConnectionBody struct {

	// client_id is the ID of the client for the connection.
	ClientID string `json:"client_id,omitempty"`

	// client_secret is the secret for the client above.
	ClientSecret string `json:"client_secret,omitempty"`

	// default_role is the RBAC role that users signing in to the
	// SSO org will get as the default.
	DefaultRole string `json:"default_role,omitempty"`

	// email_domain associated with the connection.
	EmailDomain string `json:"email_domain,omitempty"`

	// issuer is the URL of the identity provider.
	Issuer string `json:"issuer,omitempty"`

	// update mask
	UpdateMask string `json:"update_mask,omitempty"`
}

// Validate validates this auth config service edit auth connection body
func (o *AuthConfigServiceEditAuthConnectionBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this auth config service edit auth connection body based on context it is used
func (o *AuthConfigServiceEditAuthConnectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *AuthConfigServiceEditAuthConnectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AuthConfigServiceEditAuthConnectionBody) UnmarshalBinary(b []byte) error {
	var res AuthConfigServiceEditAuthConnectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
