// Code generated by go-swagger; DO NOT EDIT.

package billing_account_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// BillingAccountServiceUpdateReader is a Reader for the BillingAccountServiceUpdate structure.
type BillingAccountServiceUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BillingAccountServiceUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBillingAccountServiceUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBillingAccountServiceUpdateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBillingAccountServiceUpdateOK creates a BillingAccountServiceUpdateOK with default headers values
func NewBillingAccountServiceUpdateOK() *BillingAccountServiceUpdateOK {
	return &BillingAccountServiceUpdateOK{}
}

/*
BillingAccountServiceUpdateOK describes a response with status code 200, with default header values.

A successful response.
*/
type BillingAccountServiceUpdateOK struct {
	Payload *models.Billing20201105UpdateBillingAccountResponse
}

// IsSuccess returns true when this billing account service update o k response has a 2xx status code
func (o *BillingAccountServiceUpdateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this billing account service update o k response has a 3xx status code
func (o *BillingAccountServiceUpdateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this billing account service update o k response has a 4xx status code
func (o *BillingAccountServiceUpdateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this billing account service update o k response has a 5xx status code
func (o *BillingAccountServiceUpdateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this billing account service update o k response a status code equal to that given
func (o *BillingAccountServiceUpdateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the billing account service update o k response
func (o *BillingAccountServiceUpdateOK) Code() int {
	return 200
}

func (o *BillingAccountServiceUpdateOK) Error() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/accounts/{id}][%d] billingAccountServiceUpdateOK  %+v", 200, o.Payload)
}

func (o *BillingAccountServiceUpdateOK) String() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/accounts/{id}][%d] billingAccountServiceUpdateOK  %+v", 200, o.Payload)
}

func (o *BillingAccountServiceUpdateOK) GetPayload() *models.Billing20201105UpdateBillingAccountResponse {
	return o.Payload
}

func (o *BillingAccountServiceUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Billing20201105UpdateBillingAccountResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBillingAccountServiceUpdateDefault creates a BillingAccountServiceUpdateDefault with default headers values
func NewBillingAccountServiceUpdateDefault(code int) *BillingAccountServiceUpdateDefault {
	return &BillingAccountServiceUpdateDefault{
		_statusCode: code,
	}
}

/*
BillingAccountServiceUpdateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BillingAccountServiceUpdateDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this billing account service update default response has a 2xx status code
func (o *BillingAccountServiceUpdateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this billing account service update default response has a 3xx status code
func (o *BillingAccountServiceUpdateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this billing account service update default response has a 4xx status code
func (o *BillingAccountServiceUpdateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this billing account service update default response has a 5xx status code
func (o *BillingAccountServiceUpdateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this billing account service update default response a status code equal to that given
func (o *BillingAccountServiceUpdateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the billing account service update default response
func (o *BillingAccountServiceUpdateDefault) Code() int {
	return o._statusCode
}

func (o *BillingAccountServiceUpdateDefault) Error() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/accounts/{id}][%d] BillingAccountService_Update default  %+v", o._statusCode, o.Payload)
}

func (o *BillingAccountServiceUpdateDefault) String() string {
	return fmt.Sprintf("[PUT /billing/2020-11-05/organizations/{organization_id}/accounts/{id}][%d] BillingAccountService_Update default  %+v", o._statusCode, o.Payload)
}

func (o *BillingAccountServiceUpdateDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *BillingAccountServiceUpdateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
