/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// ScaleIOPersistentVolumeSourceApplyConfiguration represents a declarative configuration of the ScaleIOPersistentVolumeSource type for use
// with apply.
//
// ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume
type ScaleIOPersistentVolumeSourceApplyConfiguration struct {
	// gateway is the host address of the ScaleIO API Gateway.
	Gateway *string `json:"gateway,omitempty"`
	// system is the name of the storage system as configured in ScaleIO.
	System *string `json:"system,omitempty"`
	// secretRef references to the secret for ScaleIO user and other
	// sensitive information. If this is not provided, Login operation will fail.
	SecretRef *SecretReferenceApplyConfiguration `json:"secretRef,omitempty"`
	// sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
	SSLEnabled *bool `json:"sslEnabled,omitempty"`
	// protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
	ProtectionDomain *string `json:"protectionDomain,omitempty"`
	// storagePool is the ScaleIO Storage Pool associated with the protection domain.
	StoragePool *string `json:"storagePool,omitempty"`
	// storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
	// Default is ThinProvisioned.
	StorageMode *string `json:"storageMode,omitempty"`
	// volumeName is the name of a volume already created in the ScaleIO system
	// that is associated with this volume source.
	VolumeName *string `json:"volumeName,omitempty"`
	// fsType is the filesystem type to mount.
	// Must be a filesystem type supported by the host operating system.
	// Ex. "ext4", "xfs", "ntfs".
	// Default is "xfs"
	FSType *string `json:"fsType,omitempty"`
	// readOnly defaults to false (read/write). ReadOnly here will force
	// the ReadOnly setting in VolumeMounts.
	ReadOnly *bool `json:"readOnly,omitempty"`
}

// ScaleIOPersistentVolumeSourceApplyConfiguration constructs a declarative configuration of the ScaleIOPersistentVolumeSource type for use with
// apply.
func ScaleIOPersistentVolumeSource() *ScaleIOPersistentVolumeSourceApplyConfiguration {
	return &ScaleIOPersistentVolumeSourceApplyConfiguration{}
}

// WithGateway sets the Gateway field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Gateway field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithGateway(value string) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.Gateway = &value
	return b
}

// WithSystem sets the System field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the System field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithSystem(value string) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.System = &value
	return b
}

// WithSecretRef sets the SecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretRef field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithSecretRef(value *SecretReferenceApplyConfiguration) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.SecretRef = value
	return b
}

// WithSSLEnabled sets the SSLEnabled field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SSLEnabled field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithSSLEnabled(value bool) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.SSLEnabled = &value
	return b
}

// WithProtectionDomain sets the ProtectionDomain field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProtectionDomain field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithProtectionDomain(value string) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.ProtectionDomain = &value
	return b
}

// WithStoragePool sets the StoragePool field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StoragePool field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithStoragePool(value string) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.StoragePool = &value
	return b
}

// WithStorageMode sets the StorageMode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StorageMode field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithStorageMode(value string) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.StorageMode = &value
	return b
}

// WithVolumeName sets the VolumeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the VolumeName field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithVolumeName(value string) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.VolumeName = &value
	return b
}

// WithFSType sets the FSType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FSType field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithFSType(value string) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.FSType = &value
	return b
}

// WithReadOnly sets the ReadOnly field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReadOnly field is set to the value of the last call.
func (b *ScaleIOPersistentVolumeSourceApplyConfiguration) WithReadOnly(value bool) *ScaleIOPersistentVolumeSourceApplyConfiguration {
	b.ReadOnly = &value
	return b
}
