/*
    SPDX-FileCopyrightText: 2008 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "replacepiecetablechangeabstractpiecetablechangeiftest.hpp"

// test object
#include <piecetable/replacepiecetablechange.hpp>
// lib
#include <piecetable/piecetable.hpp>
// Qt
#include <QTest>

namespace KPieceTable {

static constexpr Address Start = 32;
static constexpr Address End = 78;
static constexpr Size Width = End - Start + 1;
static constexpr Size InsertLength = 80;
static constexpr Address InsertStorageOffset = 67;

static constexpr Address ChangeStorageOffset = 23;

std::unique_ptr<AbstractPieceTableChange> ReplacePieceTableChangeAbstractPieceTableChangeIfTest::createPieceTableChange()
{
    const Piece replacedPiece(AddressRange::fromWidth(Start + ChangeStorageOffset, Width), Piece::ChangeStorage);

    auto pieceTableChange =
        std::make_unique<ReplacePieceTableChange>(AddressRange(Start, End), InsertLength, InsertStorageOffset,
                                                  PieceList(replacedPiece));

    return pieceTableChange;
}
void ReplacePieceTableChangeAbstractPieceTableChangeIfTest::changePieceTable(PieceTable* pieceTable)
{
    pieceTable->replace(AddressRange(Start, End), InsertLength, InsertStorageOffset);
}

void ReplacePieceTableChangeAbstractPieceTableChangeIfTest::deletePieceTableChange(
    std::unique_ptr<AbstractPieceTableChange>&& pieceTableChange)
{
    Q_UNUSED(pieceTableChange)
}

}

QTEST_GUILESS_MAIN(KPieceTable::ReplacePieceTableChangeAbstractPieceTableChangeIfTest)

#include "moc_replacepiecetablechangeabstractpiecetablechangeiftest.cpp"
