/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.TemplateEngine;
import org.apache.commons.jexl3.internal.TemplateScript;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.ASTArguments;
import org.apache.commons.jexl3.parser.ASTFunctionNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.JexlNode;

public class TemplateInterpreter
extends Interpreter {
    private final TemplateEngine.TemplateExpression[] exprs;
    private final Writer writer;

    TemplateInterpreter(Engine jexl, JexlContext jcontext, Scope.Frame jframe, TemplateEngine.TemplateExpression[] expressions, Writer out) {
        super(jexl, jcontext, jframe);
        this.exprs = expressions;
        this.writer = out;
    }

    public void include(TemplateScript script, Object ... args) {
        script.evaluate(this.context, this.writer, args);
    }

    public void print(int e) {
        if (e < 0 || e >= this.exprs.length) {
            return;
        }
        TemplateEngine.TemplateExpression expr = this.exprs[e];
        if (expr.isDeferred()) {
            expr = expr.prepare(this.frame, this.context);
        }
        if (expr instanceof TemplateEngine.CompositeExpression) {
            this.printComposite((TemplateEngine.CompositeExpression)expr);
        } else {
            this.doPrint(expr.getInfo(), expr.evaluate(this));
        }
    }

    private void printComposite(TemplateEngine.CompositeExpression composite) {
        TemplateEngine.TemplateExpression[] cexprs = composite.exprs;
        int size = cexprs.length;
        for (int e = 0; e < size; ++e) {
            Object value = cexprs[e].evaluate(this);
            this.doPrint(cexprs[e].getInfo(), value);
        }
    }

    private void doPrint(JexlInfo info, Object arg) {
        try {
            if (this.writer != null) {
                if (arg instanceof CharSequence) {
                    this.writer.write(arg.toString());
                } else if (arg != null) {
                    Object[] value = new Object[]{arg};
                    JexlUberspect uber = this.jexl.getUberspect();
                    JexlMethod method = uber.getMethod(this.writer, "print", value);
                    if (method != null) {
                        method.invoke(this.writer, value);
                    } else {
                        this.writer.write(arg.toString());
                    }
                }
            }
        }
        catch (IOException xio) {
            throw TemplateEngine.createException(info, "call print", null, xio);
        }
        catch (Exception xany) {
            throw TemplateEngine.createException(info, "invoke print", null, xany);
        }
    }

    @Override
    protected Object resolveNamespace(String prefix, JexlNode node) {
        return "jexl".equals(prefix) ? this : super.resolveNamespace(prefix, node);
    }

    @Override
    protected Object visit(ASTFunctionNode node, Object data) {
        String prefix;
        int argc = node.jjtGetNumChildren();
        if (argc > 2 && "jexl".equals(prefix = ((ASTIdentifier)node.jjtGetChild(0)).getName())) {
            Object argv;
            ASTIdentifier functionNode = (ASTIdentifier)node.jjtGetChild(1);
            ASTArguments argNode = (ASTArguments)node.jjtGetChild(2);
            String fname = functionNode.getName();
            if ("print".equals(fname)) {
                Object[] argv2 = this.visit(argNode, null);
                this.print((Integer)argv2[0]);
                return null;
            }
            if ("include".equals(fname) && (argv = this.visit(argNode, null)) != null && ((Object[])argv).length > 0 && argv[0] instanceof TemplateScript) {
                TemplateScript script = (TemplateScript)argv[0];
                argv = ((Object[])argv).length > 1 ? Arrays.copyOfRange(argv, 1, ((Object[])argv).length) : null;
                this.include(script, argv);
                return null;
            }
            throw new JxltEngine.Exception(node.jexlInfo(), "no callable template function " + fname, null);
        }
        return super.visit(node, data);
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        String name = node.getName();
        if ("$jexl".equals(name)) {
            return this.writer;
        }
        return super.visit(node, data);
    }
}

