// { dg-do compile { target c++26 } }
// { dg-additional-options "-freflection" }
// Test reflection type traits [meta.reflection.traits], type properties.

#include <meta>
using namespace std::meta;

class ClassType { };
class DerivedType : public ClassType { };
enum EnumType { e0 };
struct ThrowDefaultClass { ThrowDefaultClass () noexcept (false); };
struct ThrowCopyConsClass { ThrowCopyConsClass (const ThrowCopyConsClass &) noexcept (false); };
struct ThrowMoveConsClass { ThrowMoveConsClass (ThrowMoveConsClass &&) noexcept (false); };
struct NoexceptDefaultClass { NoexceptDefaultClass () noexcept (true); };
struct ExceptDefaultClass { ExceptDefaultClass () noexcept (false); };
struct NoexceptCopyConsClass { NoexceptCopyConsClass (const NoexceptCopyConsClass &) noexcept (true); };
struct ExceptCopyConsClass { ExceptCopyConsClass (const ExceptCopyConsClass &) noexcept (false); };
struct NoexceptMoveConsClass { NoexceptMoveConsClass (NoexceptMoveConsClass &&) noexcept (true); NoexceptMoveConsClass &operator= (NoexceptMoveConsClass &&) = default; };
struct ExceptMoveConsClass { ExceptMoveConsClass (ExceptMoveConsClass &&) noexcept (false); };
struct NoexceptCopyAssignClass { NoexceptCopyAssignClass &operator= (const NoexceptCopyAssignClass &) noexcept (true); };
struct ExceptCopyAssignClass { ExceptCopyAssignClass &operator= (const ExceptCopyAssignClass &) noexcept (false); };
struct NoexceptMoveAssignClass { NoexceptMoveAssignClass (NoexceptMoveAssignClass &&) = default; NoexceptMoveAssignClass &operator= (NoexceptMoveAssignClass &&) noexcept (true); };
struct ExceptMoveAssignClass { ExceptMoveAssignClass &operator= (ExceptMoveAssignClass &&) noexcept (false); };
struct DeletedCopyAssignClass { DeletedCopyAssignClass & operator= (const DeletedCopyAssignClass &) = delete; };
struct DeletedMoveAssignClass { DeletedMoveAssignClass &operator= (DeletedMoveAssignClass &&) = delete; };
struct NType { int i; int j; virtual ~NType (); };
struct TType { int i; private: int j; };
struct SLType { int i; int j; ~SLType (); };
struct PODType { int i; int j; };

namespace N1
{
  struct Empty {};
  struct B { int i; B () {} };
  struct D : B {};
  enum E { ee1 };
  enum E2 { ee2 };
  enum class SE { e1 };
  enum class SE2 { e2 };
  enum OpE : int;
  enum class OpSE : bool;
  union U { int i; Empty b; };
  struct Abstract { virtual ~Abstract () = 0; };
  struct AbstractDelDtor { ~AbstractDelDtor () = delete; virtual void foo () = 0; };
  struct Ukn;
  template <class To>
  struct ImplicitTo { operator To (); };
  template <class To>
  struct DelImplicitTo { operator To () = delete; };
  template <class To>
  struct ExplicitTo { explicit operator To (); };
  struct Ellipsis { Ellipsis (...) {} };
  struct DelEllipsis { DelEllipsis (...) = delete; };
  struct Any { template <class T> Any (T &&) {} };
  struct nAny { template <class... T> nAny (T &&...) {} };
  struct DelnAny { template <class... T> DelnAny (T &&...) = delete; };
  template <class... Args>
  struct FromArgs { FromArgs (Args...); };
  struct DelDef { DelDef () = delete; };
  struct DelCopy { DelCopy (const DelCopy &) = delete; };
  struct DelDtor {
    DelDtor () = default;
    DelDtor (const DelDtor &) = default;
    DelDtor (DelDtor &&) = default;
    DelDtor (int);
    DelDtor (int, B, U);
    ~DelDtor () = delete;
  };
  struct Nontrivial {
    Nontrivial ();
    Nontrivial (const Nontrivial &);
    Nontrivial &operator= (const Nontrivial &);
    ~Nontrivial ();
  };
  union NontrivialUnion { int i; Nontrivial n; };
  struct UnusualCopy { UnusualCopy (UnusualCopy &); };
}

namespace N2
{
  struct E {};
  struct NTD1 { ~NTD1 () = default; };
  struct NTD2 { ~NTD2 (); };
  struct NTD3 { ~NTD3 () noexcept (true); };
  struct TD1 { ~TD1 () noexcept (false); };
  struct TD2 { ~TD2 () noexcept (false); };
  struct Aggr { int i; bool b; E e; };
  struct Aggr2 { int i; bool b; TD1 r; };
  struct Del { ~Del () = delete; };
  struct Del2 { ~Del2 () noexcept = delete; };
  struct Del3 { ~Del3 () noexcept (false) = delete; };
  struct Der : Aggr {};
  struct Der2 : Aggr2 {};
  union U1 { int i; double d; void *p; TD1 *pt; };
  union Ut { int i; double d; void *p; TD1 pt; };
  enum class En { a, b, c, d };
  enum En2 { En2a, En2b, En2c, En2d };
  enum OpE : int;
  enum class OpSE : bool;
  struct Abstract1 { virtual ~Abstract1 () = 0; };
  struct AbstractDelDtor { ~AbstractDelDtor () = delete; virtual void foo () = 0; };
  struct Abstract2 { virtual ~Abstract2 () noexcept (false) = 0; };
  struct Abstract3 { ~Abstract3 () noexcept (false); virtual void foo () noexcept = 0; };
  struct Nontrivial {
    Nontrivial ();
    Nontrivial (const Nontrivial &);
    Nontrivial &operator= (const Nontrivial &);
    ~Nontrivial ();
  };
  union NontrivialUnion { int i; Nontrivial n; };
  struct UnusualCopy { UnusualCopy (UnusualCopy &); };
  struct Ellipsis { Ellipsis (...) {} };
  struct DelEllipsis { DelEllipsis (...) = delete; };
  struct DelDef { DelDef () = delete; };
  struct DelCopy { DelCopy (const DelCopy &) = delete; };
}

namespace N3
{
  struct Empty {};
  struct B { int i; B (){} };
  struct D : B {};
  enum E { ee1 };
  enum E2 { ee2 };
  enum class SE { e1 };
  enum class SE2 { e2 };
  enum OpE : int;
  enum class OpSE : bool;
  union U { int i; Empty b; };
  union UAssignAll { bool b; char c; template <class T> void operator= (T &&); };
  union UDelAssignAll { bool b; char c; template <class T> void operator= (T &&) = delete; };
  struct Abstract { virtual ~Abstract () = 0; };
  struct AbstractDelDtor { ~AbstractDelDtor () = delete; virtual void foo () = 0; };
  struct Ukn;
  template <class To>
  struct ImplicitTo { operator To (); };
  template <class To>
  struct ExplicitTo { explicit operator To (); };
  template <class To>
  struct DelImplicitTo { operator To () = delete; };
  template<class To> struct DelExplicitTo { explicit operator To () = delete; };
  struct Ellipsis { Ellipsis (...) {} };
  struct DelEllipsis { DelEllipsis (...) = delete; };
  struct Any { template <class T> Any (T &&) {} };
  struct nAny { template <class... T> nAny (T &&...) {} };
  struct DelnAny { template <class... T> DelnAny (T &&...) = delete; };
  template<class... Args>
  struct FromArgs { FromArgs (Args...); };
  template<class... Args>
  struct DelFromArgs { DelFromArgs (Args...) = delete; };
  struct DelDef { DelDef () = delete; };
  struct DelCopy { DelCopy (const DelCopy &) = delete; };
  struct DelDtor {
    DelDtor () = default;
    DelDtor (const DelDtor &) = default;
    DelDtor (DelDtor &&) = default;
    DelDtor (int);
    DelDtor (int, B, U);
    ~DelDtor () = delete;
  };
  struct Nontrivial {
    Nontrivial ();
    Nontrivial (const Nontrivial &);
    Nontrivial &operator= (const Nontrivial &);
    ~Nontrivial ();
  };
  union NontrivialUnion { int i; Nontrivial n; };
  struct UnusualCopy { UnusualCopy (UnusualCopy &); };
  struct AnyAssign { template <class T> void operator= (T &&); };
  struct DelAnyAssign { template <class T> void operator= (T &&) = delete; };
  struct DelCopyAssign {
    DelCopyAssign &operator= (const DelCopyAssign &) = delete;
    DelCopyAssign &operator= (DelCopyAssign &&) = default;
  };
  struct MO { MO (MO &&) = default; MO &operator= (MO &&) = default; };
}

struct CopyConsOnlyType {
  CopyConsOnlyType (int) { }
  CopyConsOnlyType (CopyConsOnlyType &&) = delete;
  CopyConsOnlyType (const CopyConsOnlyType &) = default;
  CopyConsOnlyType &operator= (const CopyConsOnlyType &) = delete;
  CopyConsOnlyType &operator= (CopyConsOnlyType &&) = delete;
};

struct MoveConsOnlyType {
  MoveConsOnlyType (int) { }
  MoveConsOnlyType (const MoveConsOnlyType &) = delete;
  MoveConsOnlyType (MoveConsOnlyType &&) = default;
  MoveConsOnlyType &operator= (const MoveConsOnlyType &) = delete;
  MoveConsOnlyType &operator= (MoveConsOnlyType &&) = delete;
};

struct HasTemplateCtor { HasTemplateCtor () = default; template <class T> HasTemplateCtor (); };
struct HasTemplateCCtor {
  HasTemplateCCtor (const HasTemplateCCtor &) = default;
  template <class T>
  HasTemplateCCtor (T &&);
};
struct MoveOnly { MoveOnly (MoveOnly &&) = default; };
struct MoveOnly2 { MoveOnly2 (MoveOnly2 &&) = delete; };
struct HasTemplateCAssign
{
  HasTemplateCAssign &operator= (const HasTemplateCAssign &) = default;
  template <class T>
  HasTemplateCAssign &operator= (T &&);
};
struct MoveOnly3 { MoveOnly3 &operator= (MoveOnly3 &&) = default; };
struct MoveOnly4 { MoveOnly4 &operator= (MoveOnly4 &&) = delete; };

static_assert (is_default_constructible_type (^^int));
static_assert (is_default_constructible_type (^^int const));
static_assert (is_default_constructible_type (^^int const volatile));
static_assert (is_default_constructible_type (^^int *));
static_assert (is_default_constructible_type (^^void *));
static_assert (is_default_constructible_type (^^void *const));
static_assert (is_default_constructible_type (^^int N1::B::*));
static_assert (is_default_constructible_type (^^void (*) ()));
static_assert (is_default_constructible_type (^^std::nullptr_t));
static_assert (is_default_constructible_type (^^std::nullptr_t const));
static_assert (is_default_constructible_type (^^N1::Empty));
static_assert (is_default_constructible_type (^^N1::Empty const));
static_assert (is_default_constructible_type (^^N1::FromArgs <>));
static_assert (is_default_constructible_type (^^N1::FromArgs <> const));
static_assert (is_default_constructible_type (^^N1::nAny));
static_assert (is_default_constructible_type (^^N1::nAny const));
static_assert (is_default_constructible_type (^^N1::Ellipsis));
static_assert (is_default_constructible_type (^^N1::Ellipsis const));
static_assert (is_default_constructible_type (^^N1::U));
static_assert (is_default_constructible_type (^^N1::U const));
static_assert (is_default_constructible_type (^^N1::E));
static_assert (is_default_constructible_type (^^N1::E const));
static_assert (is_default_constructible_type (^^N1::SE));
static_assert (is_default_constructible_type (^^N1::SE const));
static_assert (is_default_constructible_type (^^N1::OpE));
static_assert (is_default_constructible_type (^^N1::OpE const));
static_assert (is_default_constructible_type (^^N1::OpSE));
static_assert (is_default_constructible_type (^^N1::OpSE const));
static_assert (is_default_constructible_type (^^int [1]));
static_assert (is_default_constructible_type (^^const int [1]));
static_assert (is_default_constructible_type (^^int [1][2]));
static_assert (is_default_constructible_type (^^const int [1][2]));
static_assert (is_default_constructible_type (^^N1::FromArgs <> [1]));
static_assert (is_default_constructible_type (^^const N1::FromArgs <> [1]));
static_assert (is_default_constructible_type (^^N1::U [1]));
static_assert (is_default_constructible_type (^^const N1::U [1]));
static_assert (is_default_constructible_type (^^N1::Empty [1]));
static_assert (is_default_constructible_type (^^const N1::Empty [1]));
static_assert (is_default_constructible_type (^^N1::Ellipsis [1]));
static_assert (is_default_constructible_type (^^const N1::Ellipsis [1]));
static_assert (is_default_constructible_type (^^std::nullptr_t [1]));
static_assert (is_default_constructible_type (^^const std::nullptr_t [1]));
static_assert (is_default_constructible_type (^^N1::nAny [1]));
static_assert (is_default_constructible_type (^^const N1::nAny [1]));
static_assert (is_default_constructible_type (^^N1::E [1]));
static_assert (is_default_constructible_type (^^const N1::E [1]));
static_assert (is_default_constructible_type (^^N1::SE [1]));
static_assert (is_default_constructible_type (^^const N1::SE [1]));
static_assert (is_default_constructible_type (^^N1::OpE [1]));
static_assert (is_default_constructible_type (^^const N1::OpE [1]));
static_assert (is_default_constructible_type (^^N1::OpSE [1]));
static_assert (is_default_constructible_type (^^const N1::OpSE [1]));
static_assert (is_default_constructible_type (^^int * [1]));
static_assert (is_default_constructible_type (^^int * const [1]));
static_assert (is_default_constructible_type (^^int N1::B::* [1]));
static_assert (is_default_constructible_type (^^int N1::B::* const [1]));
static_assert (is_default_constructible_type (^^std::initializer_list <int>));
static_assert (is_default_constructible_type (^^const std::initializer_list <int>));
static_assert (is_default_constructible_type (^^std::initializer_list <int> [1]));
static_assert (is_default_constructible_type (^^const std::initializer_list <int> [1]));
static_assert (is_default_constructible_type (^^NoexceptDefaultClass));
static_assert (is_default_constructible_type (^^ThrowDefaultClass));
static_assert (is_default_constructible_type (^^ExceptDefaultClass));
static_assert (!is_default_constructible_type (^^void));
static_assert (!is_default_constructible_type (^^const void));
static_assert (!is_default_constructible_type (^^N1::Abstract));
static_assert (!is_default_constructible_type (^^const N1::Abstract));
static_assert (!is_default_constructible_type (^^N1::Any));
static_assert (!is_default_constructible_type (^^const N1::Any));
static_assert (!is_default_constructible_type (^^N1::FromArgs <int>));
static_assert (!is_default_constructible_type (^^const N1::FromArgs <int>));
static_assert (!is_default_constructible_type (^^int &));
static_assert (!is_default_constructible_type (^^int &&));
static_assert (!is_default_constructible_type (^^void ()));
static_assert (!is_default_constructible_type (^^void () const volatile));
static_assert (!is_default_constructible_type (^^void (&) ()));
static_assert (!is_default_constructible_type (^^int (&) [1]));
static_assert (!is_default_constructible_type (^^int (&) []));
static_assert (!is_default_constructible_type (^^int []));
static_assert (!is_default_constructible_type (^^const int []));
static_assert (!is_default_constructible_type (^^int [][1][2]));
static_assert (!is_default_constructible_type (^^const int [][1][2]));
static_assert (!is_default_constructible_type (^^N1::Any [1]));
static_assert (!is_default_constructible_type (^^const N1::Any [1]));
static_assert (!is_default_constructible_type (^^N1::FromArgs <int> [1]));
static_assert (!is_default_constructible_type (^^const N1::FromArgs <int> [1]));
static_assert (!is_default_constructible_type (^^N1::FromArgs <std::initializer_list <int>>));
static_assert (!is_default_constructible_type (^^const N1::FromArgs <std::initializer_list <int>>));
static_assert (!is_default_constructible_type (^^const N1::FromArgs <const std::initializer_list <int>>));
static_assert (!is_default_constructible_type (^^N1::DelDef));
static_assert (!is_default_constructible_type (^^const N1::DelDef));
static_assert (!is_default_constructible_type (^^N1::DelCopy));
static_assert (!is_default_constructible_type (^^const N1::DelCopy));
static_assert (!is_default_constructible_type (^^N1::DelDtor));
static_assert (!is_default_constructible_type (^^const N1::DelDtor));
static_assert (!is_default_constructible_type (^^int []));
static_assert (!is_default_constructible_type (^^N1::Empty []));
static_assert (!is_default_constructible_type (^^N1::B []));
static_assert (!is_default_constructible_type (^^N1::D []));
static_assert (!is_default_constructible_type (^^N1::U []));
static_assert (!is_default_constructible_type (^^N1::Ukn []));
static_assert (!is_default_constructible_type (^^N1::Ellipsis []));
static_assert (!is_default_constructible_type (^^N1::Any []));
static_assert (!is_default_constructible_type (^^N1::nAny []));

static_assert (is_copy_constructible_type (^^int));
static_assert (is_copy_constructible_type (^^float));
static_assert (is_copy_constructible_type (^^EnumType));
static_assert (is_copy_constructible_type (^^int *));
static_assert (is_copy_constructible_type (^^int (*) (int)));
static_assert (is_copy_constructible_type (^^int (ClassType::*)));
static_assert (is_copy_constructible_type (^^int (ClassType::*) (int)));
static_assert (is_copy_constructible_type (^^NoexceptCopyConsClass));
static_assert (is_copy_constructible_type (^^const NoexceptCopyConsClass));
static_assert (is_copy_constructible_type (^^ThrowCopyConsClass));
static_assert (is_copy_constructible_type (^^ExceptCopyConsClass));
static_assert (!is_copy_constructible_type (^^void));
static_assert (!is_copy_constructible_type (^^int [2]));
static_assert (!is_copy_constructible_type (^^int []));
static_assert (!is_copy_constructible_type (^^float [][3]));
static_assert (!is_copy_constructible_type (^^EnumType [2][3][4]));
static_assert (!is_copy_constructible_type (^^int * [3]));
static_assert (!is_copy_constructible_type (^^int (* [][2]) (int)));
static_assert (!is_copy_constructible_type (^^int (ClassType::* [2][3])));
static_assert (!is_copy_constructible_type (^^int (ClassType::* [][2][3]) (int)));
static_assert (!is_copy_constructible_type (^^ClassType (unsigned) const &));
static_assert (!is_copy_constructible_type (^^bool (ClassType) const));
static_assert (!is_copy_constructible_type (^^bool (...) &&));
static_assert (!is_copy_constructible_type (^^EnumType (int, ...)));
static_assert (!is_copy_constructible_type (^^volatile NoexceptCopyConsClass));

static_assert (is_move_constructible_type (^^int));
static_assert (is_move_constructible_type (^^float));
static_assert (is_move_constructible_type (^^EnumType));
static_assert (is_move_constructible_type (^^int *));
static_assert (is_move_constructible_type (^^int (*) (int)));
static_assert (is_move_constructible_type (^^int (ClassType::*)));
static_assert (is_move_constructible_type (^^int (ClassType::*) (int)));
static_assert (is_move_constructible_type (^^NoexceptMoveConsClass));
static_assert (is_move_constructible_type (^^ThrowMoveConsClass));
static_assert (is_move_constructible_type (^^ExceptMoveConsClass));
static_assert (!is_move_constructible_type (^^void));
static_assert (!is_move_constructible_type (^^int [2]));
static_assert (!is_move_constructible_type (^^int []));
static_assert (!is_move_constructible_type (^^float [][3]));
static_assert (!is_move_constructible_type (^^EnumType [2][3][4]));
static_assert (!is_move_constructible_type (^^int * [3]));
static_assert (!is_move_constructible_type (^^int (* [][2]) (int)));
static_assert (!is_move_constructible_type (^^int (ClassType::* [2][3])));
static_assert (!is_move_constructible_type (^^int (ClassType::* [][2][3]) (int)));
static_assert (!is_move_constructible_type (^^ClassType (unsigned) const &));
static_assert (!is_move_constructible_type (^^bool (ClassType) const));
static_assert (!is_move_constructible_type (^^bool (...) &&));
static_assert (!is_move_constructible_type (^^EnumType (int, ...)));
static_assert (!is_move_constructible_type (^^const NoexceptMoveConsClass));
static_assert (!is_move_constructible_type (^^volatile NoexceptMoveConsClass));

static_assert (is_assignable_type (^^int &, ^^int));
static_assert (is_assignable_type (^^int &, ^^const int));
static_assert (is_assignable_type (^^int &, ^^int &));
static_assert (is_assignable_type (^^int &, ^^const int &));
static_assert (!is_assignable_type (^^int, ^^int));
static_assert (!is_assignable_type (^^int, ^^const int));
static_assert (!is_assignable_type (^^int, ^^int &));
static_assert (!is_assignable_type (^^int, ^^const int &));
static_assert (!is_assignable_type (^^const int, ^^int));
static_assert (!is_assignable_type (^^const int, ^^const int));
static_assert (!is_assignable_type (^^const int, ^^int &));
static_assert (!is_assignable_type (^^const int, ^^const int &));
static_assert (!is_assignable_type (^^const int &, ^^int));
static_assert (!is_assignable_type (^^const int &, ^^const int));
static_assert (!is_assignable_type (^^const int &, ^^int &));
static_assert (!is_assignable_type (^^const int &, ^^const int &));
static_assert (is_assignable_type (^^N3::Empty &, ^^N3::Empty));
static_assert (is_assignable_type (^^N3::Empty &, ^^const N3::Empty));
static_assert (is_assignable_type (^^N3::Empty &, ^^N3::Empty &));
static_assert (is_assignable_type (^^N3::Empty &, ^^const N3::Empty &));
static_assert (is_assignable_type (^^N3::Empty, ^^N3::Empty));
static_assert (is_assignable_type (^^N3::Empty, ^^const N3::Empty));
static_assert (is_assignable_type (^^N3::Empty, ^^N3::Empty &));
static_assert (is_assignable_type (^^N3::Empty, ^^const N3::Empty &));
static_assert (is_assignable_type (^^N3::B &, ^^N3::B));
static_assert (is_assignable_type (^^N3::B &, ^^const N3::B));
static_assert (is_assignable_type (^^N3::B &, ^^N3::B &));
static_assert (is_assignable_type (^^N3::B &, ^^const N3::B &));
static_assert (is_assignable_type (^^N3::B, ^^N3::B));
static_assert (is_assignable_type (^^N3::B, ^^const N3::B));
static_assert (is_assignable_type (^^N3::B, ^^N3::B &));
static_assert (is_assignable_type (^^N3::B, ^^const N3::B &));
static_assert (is_assignable_type (^^bool &, ^^bool));
static_assert (is_assignable_type (^^bool &, ^^const bool));
static_assert (is_assignable_type (^^bool &, ^^bool &));
static_assert (is_assignable_type (^^bool &, ^^const bool &));
static_assert (!is_assignable_type (^^bool, ^^bool));
static_assert (!is_assignable_type (^^bool, ^^const bool));
static_assert (!is_assignable_type (^^bool, ^^bool &));
static_assert (!is_assignable_type (^^bool, ^^const bool &));
static_assert (is_assignable_type (^^std::nullptr_t &, ^^std::nullptr_t));
static_assert (is_assignable_type (^^std::nullptr_t &, ^^const std::nullptr_t));
static_assert (is_assignable_type (^^std::nullptr_t &, ^^std::nullptr_t &));
static_assert (is_assignable_type (^^std::nullptr_t &, ^^const std::nullptr_t &));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^std::nullptr_t));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^const std::nullptr_t));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^std::nullptr_t &));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^const std::nullptr_t &));
static_assert (is_assignable_type (^^N3::E &, ^^N3::E));
static_assert (is_assignable_type (^^N3::E &, ^^const N3::E));
static_assert (is_assignable_type (^^N3::E &, ^^N3::E &));
static_assert (is_assignable_type (^^N3::E &, ^^const N3::E &));
static_assert (is_assignable_type (^^int &, ^^N3::E));
static_assert (is_assignable_type (^^int &, ^^const N3::E));
static_assert (is_assignable_type (^^int &, ^^N3::E &));
static_assert (is_assignable_type (^^int &, ^^const N3::E &));
static_assert (!is_assignable_type (^^N3::E &, ^^int));
static_assert (!is_assignable_type (^^N3::E &, ^^const int));
static_assert (!is_assignable_type (^^N3::E &, ^^int &));
static_assert (!is_assignable_type (^^N3::E &, ^^const int &));
static_assert (!is_assignable_type (^^N3::E &, ^^N3::E2));
static_assert (!is_assignable_type (^^N3::E &, ^^const N3::E2));
static_assert (!is_assignable_type (^^N3::E &, ^^N3::E2 &));
static_assert (!is_assignable_type (^^N3::E &, ^^const N3::E2 &));
static_assert (!is_assignable_type (^^N3::E, ^^N3::E));
static_assert (!is_assignable_type (^^N3::E, ^^const N3::E));
static_assert (!is_assignable_type (^^N3::E, ^^N3::E &));
static_assert (!is_assignable_type (^^N3::E, ^^const N3::E &));
static_assert (is_assignable_type (^^N3::SE &, ^^N3::SE));
static_assert (is_assignable_type (^^N3::SE &, ^^const N3::SE));
static_assert (is_assignable_type (^^N3::SE &, ^^N3::SE &));
static_assert (is_assignable_type (^^N3::SE &, ^^const N3::SE &));
static_assert (!is_assignable_type (^^int &, ^^N3::SE));
static_assert (!is_assignable_type (^^int &, ^^const N3::SE));
static_assert (!is_assignable_type (^^int &, ^^N3::SE &));
static_assert (!is_assignable_type (^^int &, ^^const N3::SE &));
static_assert (!is_assignable_type (^^N3::SE &, ^^int));
static_assert (!is_assignable_type (^^N3::SE &, ^^const int));
static_assert (!is_assignable_type (^^N3::SE &, ^^int &));
static_assert (!is_assignable_type (^^N3::SE &, ^^const int &));
static_assert (!is_assignable_type (^^N3::SE, ^^N3::SE));
static_assert (!is_assignable_type (^^N3::SE, ^^const N3::SE));
static_assert (!is_assignable_type (^^N3::SE, ^^N3::SE &));
static_assert (!is_assignable_type (^^N3::SE, ^^const N3::SE &));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^int));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^std::nullptr_t));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::E));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::SE));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::Empty));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::U));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^int &));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^std::nullptr_t &));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::E &));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::SE &));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::Empty &));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::U &));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::AnyAssign));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^std::initializer_list <int>));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^int [1]));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^std::nullptr_t [1]));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::E [1]));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::SE [1]));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^int (&) [1]));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^std::nullptr_t (&) [1]));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::E (&) [1]));
static_assert (is_assignable_type (^^N3::AnyAssign &, ^^N3::SE (&) [1]));
static_assert (is_assignable_type (^^int &, ^^N3::E));
static_assert (!is_assignable_type (^^int &, ^^N3::SE));
static_assert (is_assignable_type (^^bool &, ^^N3::E));
static_assert (!is_assignable_type (^^bool &, ^^N3::SE));
static_assert (is_assignable_type (^^bool &, ^^void *));
static_assert (is_assignable_type (^^bool &, ^^int N3::B::*));
static_assert (is_assignable_type (^^bool &, ^^void *));
static_assert (!is_assignable_type (^^bool &, ^^std::nullptr_t));
static_assert (is_assignable_type (^^std::nullptr_t &, ^^std::nullptr_t));
static_assert (is_assignable_type (^^void *&, ^^std::nullptr_t));
static_assert (is_assignable_type (^^int *&, ^^std::nullptr_t));
static_assert (is_assignable_type (^^int N3::B::*&, ^^std::nullptr_t));
static_assert (!is_assignable_type (^^std::nullptr_t &, ^^bool));
static_assert (!is_assignable_type (^^void *&, ^^bool));
static_assert (!is_assignable_type (^^N3::E &, ^^bool));
static_assert (!is_assignable_type (^^N3::SE &, ^^bool));
static_assert (is_assignable_type (^^std::initializer_list <int> &, ^^std::initializer_list <int>));
static_assert (is_assignable_type (^^std::initializer_list <int> &, ^^std::initializer_list <int> &&));
static_assert (is_assignable_type (^^std::initializer_list <int> &, ^^const std::initializer_list <int> &&));
static_assert (is_assignable_type (^^std::initializer_list <int> &, ^^std::initializer_list <int> &));
static_assert (is_assignable_type (^^std::initializer_list <int> &, ^^const std::initializer_list <int> &));
static_assert (!is_assignable_type (^^const std::initializer_list <int> &, ^^std::initializer_list <int>));
static_assert (!is_assignable_type (^^const N3::AnyAssign &, ^^int));
static_assert (!is_assignable_type (^^N3::AnyAssign &, ^^void));
static_assert (!is_assignable_type (^^void, ^^int));
static_assert (!is_assignable_type (^^const void, ^^int));
static_assert (!is_assignable_type (^^int, ^^void));
static_assert (!is_assignable_type (^^int, ^^const void));
static_assert (!is_assignable_type (^^const int, ^^void));
static_assert (!is_assignable_type (^^const int, ^^const void));
static_assert (!is_assignable_type (^^int &, ^^void));
static_assert (!is_assignable_type (^^int &, ^^const void));
static_assert (!is_assignable_type (^^const int &, ^^void));
static_assert (!is_assignable_type (^^const int &, ^^const void));
static_assert (!is_assignable_type (^^void, ^^void));
static_assert (!is_assignable_type (^^const void, ^^void));
static_assert (!is_assignable_type (^^const void, ^^const void));
static_assert (!is_assignable_type (^^int [1], ^^int [1]));
static_assert (!is_assignable_type (^^int (&) [1], ^^int [1]));
static_assert (!is_assignable_type (^^int (&) [1], ^^int (&) [1]));
static_assert (!is_assignable_type (^^int [2], ^^int [1]));
static_assert (!is_assignable_type (^^int (&) [2], ^^int [1]));
static_assert (!is_assignable_type (^^int (&) [2], ^^int (&) [1]));
static_assert (!is_assignable_type (^^int [1], ^^void));
static_assert (!is_assignable_type (^^int (&) [1], ^^void));
static_assert (!is_assignable_type (^^void, ^^int [1]));
static_assert (!is_assignable_type (^^void, ^^int (&) [1]));
static_assert (!is_assignable_type (^^int [], ^^int []));
static_assert (!is_assignable_type (^^int (&) [], ^^int []));
static_assert (!is_assignable_type (^^int (&) [], ^^int (&) []));
static_assert (!is_assignable_type (^^int [1], ^^int []));
static_assert (!is_assignable_type (^^int (&) [1], ^^int []));
static_assert (!is_assignable_type (^^int (&) [1], ^^int (&) []));
static_assert (!is_assignable_type (^^int [], ^^int [1]));
static_assert (!is_assignable_type (^^int (&) [], ^^int [1]));
static_assert (!is_assignable_type (^^int (&) [], ^^int (&) [1]));
static_assert (!is_assignable_type (^^int [], ^^void));
static_assert (!is_assignable_type (^^int (&) [], ^^void));
static_assert (!is_assignable_type (^^void, ^^int []));
static_assert (!is_assignable_type (^^void, ^^int (&) []));
static_assert (is_assignable_type (^^N3::DelCopyAssign &, ^^N3::DelCopyAssign));
static_assert (!is_assignable_type (^^N3::DelCopyAssign &, ^^const N3::DelCopyAssign));
static_assert (!is_assignable_type (^^N3::DelCopyAssign &, ^^N3::DelCopyAssign &));
static_assert (!is_assignable_type (^^N3::DelCopyAssign &, ^^const N3::DelCopyAssign &));
static_assert (!is_assignable_type (^^N3::DelCopyAssign &, ^^void));
static_assert (!is_assignable_type (^^N3::DelCopyAssign &, ^^void ()));
static_assert (!is_assignable_type (^^N3::DelCopyAssign &, ^^void (&) ()));
static_assert (!is_assignable_type (^^N3::DelCopyAssign &, ^^int));
static_assert (is_assignable_type (^^N3::DelAnyAssign &, ^^N3::DelAnyAssign &&));
static_assert (is_assignable_type (^^N3::DelAnyAssign &, ^^const N3::DelAnyAssign &));
static_assert (is_assignable_type (^^N3::DelAnyAssign, ^^N3::DelAnyAssign &&));
static_assert (is_assignable_type (^^N3::DelAnyAssign, ^^const N3::DelAnyAssign &));
static_assert (!is_assignable_type (^^const N3::DelAnyAssign &, ^^N3::DelAnyAssign &&));
static_assert (!is_assignable_type (^^const N3::DelAnyAssign &, ^^const N3::DelAnyAssign &));
static_assert (!is_assignable_type (^^const N3::DelAnyAssign, ^^N3::DelAnyAssign &&));
static_assert (!is_assignable_type (^^const N3::DelAnyAssign, ^^const N3::DelAnyAssign &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^const int &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^void));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^void ()));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^void () const));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^void (&) ()));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^void (&&) ()));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^std::nullptr_t));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^std::nullptr_t &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^std::initializer_list <int>));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^std::initializer_list <int> &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^bool));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^bool &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::E));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::E &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::SE));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::SE &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::Empty));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::Empty &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::B));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::B &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::U));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::U &));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^void *));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int *));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::B *));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^N3::D *));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int N3::B::*));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int N3::D::*));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int []));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int [1]));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int (&) []));
static_assert (!is_assignable_type (^^N3::DelAnyAssign &, ^^int (&) [1]));
static_assert (!is_assignable_type (^^void (), ^^void));
static_assert (!is_assignable_type (^^void, ^^void ()));
static_assert (!is_assignable_type (^^void (), ^^void ()));
static_assert (!is_assignable_type (^^void (&) (), ^^void));
static_assert (!is_assignable_type (^^void, ^^void (&) ()));
static_assert (!is_assignable_type (^^void (&) (), ^^void (&) ()));
static_assert (!is_assignable_type (^^void (&) (), ^^void ()));
static_assert (!is_assignable_type (^^void (), ^^void (&) ()));
static_assert (is_assignable_type (^^int &, ^^N3::ImplicitTo <int>));
static_assert (!is_assignable_type (^^int &, ^^N3::ExplicitTo <int>));
static_assert (!is_assignable_type (^^int, ^^N3::ImplicitTo <int>));
static_assert (!is_assignable_type (^^int, ^^N3::ExplicitTo <int>));
static_assert (!is_assignable_type (^^const int, ^^N3::ImplicitTo <int>));
static_assert (!is_assignable_type (^^const int, ^^N3::ExplicitTo <int>));
static_assert (!is_assignable_type (^^const int &, ^^N3::ImplicitTo <int>));
static_assert (!is_assignable_type (^^const int &, ^^N3::ExplicitTo <int>));
static_assert (is_assignable_type (^^N3::DelImplicitTo <int> &, ^^N3::DelImplicitTo <int>));
static_assert (is_assignable_type (^^N3::DelImplicitTo <int>, ^^N3::DelImplicitTo <int>));
static_assert (!is_assignable_type (^^int &, ^^N3::DelImplicitTo <int>));
static_assert (!is_assignable_type (^^int, ^^N3::DelImplicitTo <int>));
static_assert (!is_assignable_type (^^const int &, ^^N3::DelImplicitTo <int>));
static_assert (!is_assignable_type (^^const int, ^^N3::DelImplicitTo <int>));
static_assert (!is_assignable_type (^^int &, ^^N3::DelExplicitTo <int>));
static_assert (!is_assignable_type (^^int, ^^N3::DelExplicitTo <int>));
static_assert (!is_assignable_type (^^const int &, ^^N3::DelExplicitTo <int>));
static_assert (!is_assignable_type (^^const int, ^^N3::DelExplicitTo <int>));
static_assert (is_assignable_type (^^N3::B &, ^^N3::B));
static_assert (is_assignable_type (^^N3::B &, ^^N3::D));
static_assert (is_assignable_type (^^N3::B &, ^^N3::B &));
static_assert (is_assignable_type (^^N3::B &, ^^N3::D &));
static_assert (!is_assignable_type (^^const N3::B &, ^^N3::B &));
static_assert (!is_assignable_type (^^const N3::B &, ^^N3::D &));
static_assert (!is_assignable_type (^^N3::D &, ^^N3::B));
static_assert (!is_assignable_type (^^N3::D &, ^^N3::B &));
static_assert (is_assignable_type (^^N3::B *&, ^^N3::B *));
static_assert (is_assignable_type (^^N3::B *&, ^^N3::D *));
static_assert (is_assignable_type (^^const N3::B *&, ^^N3::D *));
static_assert (is_assignable_type (^^const N3::B *&, ^^const N3::D *));
static_assert (is_assignable_type (^^N3::B *&, ^^N3::B *&));
static_assert (is_assignable_type (^^N3::B *&, ^^N3::D *&));
static_assert (is_assignable_type (^^const N3::B *&, ^^N3::B *&));
static_assert (is_assignable_type (^^const N3::B *&, ^^N3::D *&));
static_assert (!is_assignable_type (^^N3::B * const &, ^^N3::B *&));
static_assert (!is_assignable_type (^^N3::B * const &, ^^N3::D *&));
static_assert (!is_assignable_type (^^N3::D *&, ^^N3::B *));
static_assert (!is_assignable_type (^^N3::D *&, ^^N3::B *&));
static_assert (is_assignable_type (^^N3::MO &, ^^N3::MO));
static_assert (is_assignable_type (^^N3::MO &, ^^N3::MO &&));
static_assert (is_assignable_type (^^N3::MO, ^^N3::MO));
static_assert (is_assignable_type (^^N3::MO, ^^N3::MO &&));
static_assert (!is_assignable_type (^^const N3::MO &, ^^N3::MO));
static_assert (!is_assignable_type (^^const N3::MO &, ^^N3::MO &&));
static_assert (!is_assignable_type (^^N3::MO &, ^^const N3::MO &&));
static_assert (!is_assignable_type (^^N3::MO &, ^^N3::MO &));
static_assert (!is_assignable_type (^^N3::MO &, ^^const N3::MO &));
static_assert (!is_assignable_type (^^const N3::MO, ^^N3::MO));
static_assert (!is_assignable_type (^^const N3::MO, ^^N3::MO &&));
static_assert (!is_assignable_type (^^N3::MO, ^^const N3::MO &&));
static_assert (!is_assignable_type (^^N3::MO, ^^N3::MO &));
static_assert (!is_assignable_type (^^N3::MO, ^^const N3::MO &));
static_assert (!is_assignable_type (^^N3::NontrivialUnion &, ^^N3::NontrivialUnion));
static_assert (!is_assignable_type (^^N3::NontrivialUnion &, ^^N3::NontrivialUnion &&));
static_assert (!is_assignable_type (^^N3::NontrivialUnion &, ^^N3::NontrivialUnion &));
static_assert (!is_assignable_type (^^N3::NontrivialUnion &, ^^const N3::NontrivialUnion &));
static_assert (!is_assignable_type (^^N3::NontrivialUnion &, ^^const N3::NontrivialUnion &&));
static_assert (is_assignable_type (^^N3::Abstract &, ^^N3::Abstract));
static_assert (is_assignable_type (^^N3::Abstract &, ^^N3::Abstract &&));
static_assert (is_assignable_type (^^N3::Abstract &, ^^N3::Abstract &));
static_assert (is_assignable_type (^^N3::Abstract &, ^^const N3::Abstract &));
static_assert (is_assignable_type (^^N3::Abstract &, ^^const N3::Abstract &&));
static_assert (is_assignable_type (^^N3::Abstract &&, ^^N3::Abstract));
static_assert (is_assignable_type (^^N3::Abstract &&, ^^N3::Abstract &&));
static_assert (is_assignable_type (^^N3::Abstract &&, ^^N3::Abstract &));
static_assert (is_assignable_type (^^N3::Abstract &&, ^^const N3::Abstract &));
static_assert (is_assignable_type (^^N3::Abstract &&, ^^const N3::Abstract &&));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &, ^^N3::AbstractDelDtor));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &, ^^N3::AbstractDelDtor &&));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &, ^^N3::AbstractDelDtor &));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &, ^^const N3::AbstractDelDtor &));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &, ^^const N3::AbstractDelDtor &&));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &&, ^^N3::AbstractDelDtor));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &&, ^^N3::AbstractDelDtor &&));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &&, ^^N3::AbstractDelDtor &));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &&, ^^const N3::AbstractDelDtor &));
static_assert (is_assignable_type (^^N3::AbstractDelDtor &&, ^^const N3::AbstractDelDtor &&));
static_assert (is_assignable_type (^^N3::DelDef &, ^^N3::DelDef));
static_assert (is_assignable_type (^^N3::DelDef &, ^^N3::DelDef &&));
static_assert (is_assignable_type (^^N3::DelDef &, ^^N3::DelDef &));
static_assert (is_assignable_type (^^N3::DelDef &, ^^const N3::DelDef &));
static_assert (is_assignable_type (^^N3::DelDef &, ^^const N3::DelDef &&));
static_assert (is_assignable_type (^^N3::DelDef &&, ^^N3::DelDef));
static_assert (is_assignable_type (^^N3::DelDef &&, ^^N3::DelDef &&));
static_assert (is_assignable_type (^^N3::DelDef &&, ^^N3::DelDef &));
static_assert (is_assignable_type (^^N3::DelDef &&, ^^const N3::DelDef &));
static_assert (is_assignable_type (^^N3::DelDef &&, ^^const N3::DelDef &&));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::Ellipsis));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::Ellipsis));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::Ellipsis &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::Ellipsis &));
static_assert (is_assignable_type (^^N3::Ellipsis, ^^N3::Ellipsis));
static_assert (is_assignable_type (^^N3::Ellipsis, ^^const N3::Ellipsis));
static_assert (is_assignable_type (^^N3::Ellipsis, ^^N3::Ellipsis &));
static_assert (is_assignable_type (^^N3::Ellipsis, ^^const N3::Ellipsis &));
static_assert (!is_assignable_type (^^N3::Ellipsis &, ^^void));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^int));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const int));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^int &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const int &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::Empty));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::Empty));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::Empty &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::Empty &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::E));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::E));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::E &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::E &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::SE));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::SE));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^N3::SE &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const N3::SE &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^bool));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const bool));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^bool &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const bool &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^std::nullptr_t));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const std::nullptr_t));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^std::nullptr_t &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const std::nullptr_t &));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^void *));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const void *));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^void *&));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^const void *&));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^void ()));
static_assert (is_assignable_type (^^N3::Ellipsis &, ^^void (&) ()));
static_assert (is_assignable_type (^^N3::DelEllipsis &, ^^N3::DelEllipsis));
static_assert (is_assignable_type (^^N3::DelEllipsis &, ^^const N3::DelEllipsis));
static_assert (is_assignable_type (^^N3::DelEllipsis &, ^^N3::DelEllipsis &));
static_assert (is_assignable_type (^^N3::DelEllipsis &, ^^const N3::DelEllipsis &));
static_assert (is_assignable_type (^^N3::DelEllipsis, ^^N3::DelEllipsis));
static_assert (is_assignable_type (^^N3::DelEllipsis, ^^const N3::DelEllipsis));
static_assert (is_assignable_type (^^N3::DelEllipsis, ^^N3::DelEllipsis &));
static_assert (is_assignable_type (^^N3::DelEllipsis, ^^const N3::DelEllipsis &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^void));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^int));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const int));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^int &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const int &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^N3::Empty));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const N3::Empty));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^N3::Empty &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const N3::Empty &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^N3::E));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const N3::E));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^N3::E &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const N3::E &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^N3::SE));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const N3::SE));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^N3::SE &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const N3::SE &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^bool));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const bool));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^bool &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const bool &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^std::nullptr_t));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const std::nullptr_t));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^std::nullptr_t &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const std::nullptr_t &));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^void *));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const void *));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^void *&));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^const void *&));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^void ()));
static_assert (!is_assignable_type (^^N3::DelEllipsis &, ^^void (&) ()));
static_assert (is_assignable_type (^^N3::FromArgs <int> &, ^^int));
static_assert (is_assignable_type (^^N3::FromArgs <int> &, ^^const int));
static_assert (!is_assignable_type (^^N3::FromArgs <int> &, ^^N3::ImplicitTo <int>));
static_assert (!is_assignable_type (^^N3::FromArgs <int> &, ^^N3::ImplicitTo <const int>));
static_assert (!is_assignable_type (^^N3::FromArgs <int> &, ^^N3::ExplicitTo <int>));
static_assert (!is_assignable_type (^^N3::FromArgs <int> &, ^^N3::ExplicitTo <const int>));
static_assert (!is_assignable_type (^^N3::DelFromArgs <int> &, ^^int));
static_assert (!is_assignable_type (^^N3::DelFromArgs <int> &, ^^const int));
static_assert (is_assignable_type (^^void (*&) (), ^^N3::ImplicitTo <void (*) ()>));
static_assert (!is_assignable_type (^^void (*&) (), ^^N3::ExplicitTo <void (*) ()>));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::UAssignAll));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^const N3::UAssignAll));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::UAssignAll &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^const N3::UAssignAll &));
static_assert (is_assignable_type (^^N3::UAssignAll, ^^N3::UAssignAll));
static_assert (is_assignable_type (^^N3::UAssignAll, ^^const N3::UAssignAll));
static_assert (is_assignable_type (^^N3::UAssignAll, ^^N3::UAssignAll &));
static_assert (is_assignable_type (^^N3::UAssignAll, ^^const N3::UAssignAll &));
static_assert (!is_assignable_type (^^N3::UAssignAll &, ^^void));
static_assert (!is_assignable_type (^^const N3::UAssignAll &, ^^void));
static_assert (!is_assignable_type (^^const N3::UAssignAll &, ^^N3::UAssignAll));
static_assert (!is_assignable_type (^^const N3::UAssignAll &, ^^const N3::UAssignAll));
static_assert (!is_assignable_type (^^const N3::UAssignAll &, ^^N3::UAssignAll &));
static_assert (!is_assignable_type (^^const N3::UAssignAll &, ^^const N3::UAssignAll &));
static_assert (!is_assignable_type (^^N3::UAssignAll &, ^^void () const));
static_assert (!is_assignable_type (^^N3::UAssignAll &, ^^void () &));
static_assert (!is_assignable_type (^^N3::UAssignAll &, ^^void () const volatile &&));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::E));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::E &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::SE));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::SE &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^double));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^double &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::Empty));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::Empty &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::B));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::B &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::U));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^N3::U &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^std::nullptr_t));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^std::nullptr_t &));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^void ()));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^void (&) ()));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^void (*) ()));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^void (*&) ()));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int *));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int *&));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^void *));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^void *&));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^const int *));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^const int *&));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^const void *));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^const void *&));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int [1]));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int (&) [1]));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int []));
static_assert (is_assignable_type (^^N3::UAssignAll &, ^^int (&) []));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::E));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::E &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::SE));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::SE &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^double));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^double &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::Empty));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::Empty &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::B));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::B &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::U));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^N3::U &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^std::nullptr_t));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^std::nullptr_t &));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^void ()));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^void (&) ()));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^void () const));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^void (*) ()));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^void (*&) ()));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int *));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int *&));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^void *));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^void *&));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^const int *));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^const int *&));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^const void *));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^const void *&));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int [1]));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int (&) [1]));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int []));
static_assert (!is_assignable_type (^^N3::UDelAssignAll &, ^^int (&) []));
static_assert (!is_assignable_type (^^void (&) (), ^^std::nullptr_t));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^void (&) ()));
static_assert (!is_assignable_type (^^void (&) (), ^^int []));
static_assert (!is_assignable_type (^^int [], ^^void (&) ()));
static_assert (!is_assignable_type (^^int [], ^^std::nullptr_t));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^int []));
static_assert (!is_assignable_type (^^int [1], ^^std::nullptr_t));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^int [1]));
static_assert (!is_assignable_type (^^void, ^^std::nullptr_t));
static_assert (!is_assignable_type (^^std::nullptr_t, ^^void));
static_assert (!is_assignable_type (^^const N3::D &, ^^N3::B &));
static_assert (!is_assignable_type (^^const N3::B &, ^^N3::B &));
static_assert (is_assignable_type (^^N3::B &, ^^const N3::D &));
static_assert (is_assignable_type (^^N3::B &, ^^const N3::B &));
static_assert (is_assignable_type (^^int &, ^^const int &));
static_assert (is_assignable_type (^^int &, ^^const double &));

static_assert (is_copy_assignable_type (^^int));
static_assert (is_copy_assignable_type (^^float));
static_assert (is_copy_assignable_type (^^EnumType));
static_assert (is_copy_assignable_type (^^int *));
static_assert (is_copy_assignable_type (^^int (*) (int)));
static_assert (is_copy_assignable_type (^^int (ClassType::*)));
static_assert (is_copy_assignable_type (^^int (ClassType::*) (int)));
static_assert (is_copy_assignable_type (^^NoexceptCopyAssignClass));
static_assert (is_copy_assignable_type (^^ExceptCopyAssignClass));
static_assert (!is_copy_assignable_type (^^void));
static_assert (!is_copy_assignable_type (^^int [2]));
static_assert (!is_copy_assignable_type (^^float [][3]));
static_assert (!is_copy_assignable_type (^^EnumType [2][3][4]));
static_assert (!is_copy_assignable_type (^^int * [3]));
static_assert (!is_copy_assignable_type (^^int (* [][2]) (int)));
static_assert (!is_copy_assignable_type (^^int (ClassType::* [2][3])));
static_assert (!is_copy_assignable_type (^^int (ClassType::* [][2][3]) (int)));
static_assert (!is_copy_assignable_type (^^ClassType (unsigned) const &));
static_assert (!is_copy_assignable_type (^^bool (ClassType) const));
static_assert (!is_copy_assignable_type (^^bool (...) &&));
static_assert (!is_copy_assignable_type (^^EnumType (int, ...)));
static_assert (!is_copy_assignable_type (^^NoexceptMoveAssignClass));
static_assert (!is_copy_assignable_type (^^ExceptMoveAssignClass));
static_assert (!is_copy_assignable_type (^^DeletedCopyAssignClass));
static_assert (!is_copy_assignable_type (^^DeletedMoveAssignClass));

static_assert (is_move_assignable_type (^^int));
static_assert (is_move_assignable_type (^^float));
static_assert (is_move_assignable_type (^^EnumType));
static_assert (is_move_assignable_type (^^int *));
static_assert (is_move_assignable_type (^^int (*) (int)));
static_assert (is_move_assignable_type (^^int (ClassType::*)));
static_assert (is_move_assignable_type (^^int (ClassType::*) (int)));
static_assert (is_move_assignable_type (^^NoexceptMoveAssignClass));
static_assert (is_move_assignable_type (^^ExceptMoveAssignClass));
static_assert (is_move_assignable_type (^^NoexceptCopyAssignClass));
static_assert (is_move_assignable_type (^^ExceptCopyAssignClass));
static_assert (!is_move_assignable_type (^^void));
static_assert (!is_move_assignable_type (^^int [2]));
static_assert (!is_move_assignable_type (^^float [][3]));
static_assert (!is_move_assignable_type (^^EnumType [2][3][4]));
static_assert (!is_move_assignable_type (^^int * [3]));
static_assert (!is_move_assignable_type (^^int (* [][2]) (int)));
static_assert (!is_move_assignable_type (^^int (ClassType::* [2][3])));
static_assert (!is_move_assignable_type (^^int (ClassType::* [][2][3]) (int)));
static_assert (!is_move_assignable_type (^^ClassType (unsigned) const &));
static_assert (!is_move_assignable_type (^^bool (ClassType) const));
static_assert (!is_move_assignable_type (^^bool (...) &&));
static_assert (!is_move_assignable_type (^^EnumType (int, ...)));
static_assert (!is_move_assignable_type (^^DeletedCopyAssignClass));
static_assert (!is_move_assignable_type (^^DeletedMoveAssignClass));

static_assert (is_destructible_type (^^int));
static_assert (is_destructible_type (^^const int));
static_assert (is_destructible_type (^^bool));
static_assert (is_destructible_type (^^const bool));
static_assert (is_destructible_type (^^int *));
static_assert (is_destructible_type (^^void *));
static_assert (is_destructible_type (^^int N2::Der::*));
static_assert (is_destructible_type (^^const int N2::Der::*));
static_assert (is_destructible_type (^^void (N2::Der::*) () const));
static_assert (is_destructible_type (^^void (*) ()));
static_assert (is_destructible_type (^^N2::En));
static_assert (is_destructible_type (^^const N2::En));
static_assert (is_destructible_type (^^N2::En2));
static_assert (is_destructible_type (^^const N2::En2));
static_assert (is_destructible_type (^^N2::OpE));
static_assert (is_destructible_type (^^const N2::OpE));
static_assert (is_destructible_type (^^N2::OpSE));
static_assert (is_destructible_type (^^const N2::OpSE));
static_assert (is_destructible_type (^^std::nullptr_t));
static_assert (is_destructible_type (^^const std::nullptr_t));
static_assert (is_destructible_type (^^N2::Der));
static_assert (is_destructible_type (^^const N2::Der));
static_assert (is_destructible_type (^^N2::Aggr));
static_assert (is_destructible_type (^^const N2::Aggr));
static_assert (is_destructible_type (^^N2::E));
static_assert (is_destructible_type (^^const N2::E));
static_assert (is_destructible_type (^^N2::U1));
static_assert (is_destructible_type (^^const N2::U1));
static_assert (is_destructible_type (^^N2::Abstract1));
static_assert (is_destructible_type (^^const N2::Abstract1));
static_assert (is_destructible_type (^^int [1]));
static_assert (is_destructible_type (^^const int [1]));
static_assert (is_destructible_type (^^int [1][2]));
static_assert (is_destructible_type (^^const int [1][2]));
static_assert (is_destructible_type (^^int &));
static_assert (is_destructible_type (^^int &&));
static_assert (is_destructible_type (^^int (&) [1]));
static_assert (is_destructible_type (^^const int (&) [1]));
static_assert (is_destructible_type (^^void (&) ()));
static_assert (is_destructible_type (^^N2::Ellipsis));
static_assert (is_destructible_type (^^const N2::Ellipsis));
static_assert (is_destructible_type (^^N2::Abstract2));
static_assert (is_destructible_type (^^const N2::Abstract2));
static_assert (is_destructible_type (^^N2::Aggr2));
static_assert (is_destructible_type (^^const N2::Aggr2));
static_assert (is_destructible_type (^^N2::DelDef));
static_assert (is_destructible_type (^^const N2::DelDef));
static_assert (is_destructible_type (^^N2::DelCopy));
static_assert (is_destructible_type (^^const N2::DelCopy));
static_assert (is_destructible_type (^^N2::DelEllipsis));
static_assert (is_destructible_type (^^const N2::DelEllipsis));
static_assert (is_destructible_type (^^std::initializer_list <int>));
static_assert (is_destructible_type (^^const std::initializer_list <int>));
static_assert (is_destructible_type (^^std::initializer_list <N2::Del>));
static_assert (!is_destructible_type (^^void));
static_assert (!is_destructible_type (^^const void));
static_assert (!is_destructible_type (^^void ()));
static_assert (!is_destructible_type (^^void () const));
static_assert (!is_destructible_type (^^int []));
static_assert (!is_destructible_type (^^const int []));
static_assert (!is_destructible_type (^^N2::Del));
static_assert (!is_destructible_type (^^const N2::Del));
static_assert (!is_destructible_type (^^N2::AbstractDelDtor));
static_assert (!is_destructible_type (^^const N2::AbstractDelDtor));
static_assert (!is_destructible_type (^^int [][1]));
static_assert (!is_destructible_type (^^const int [][1]));
static_assert (!is_destructible_type (^^N2::Del [1]));
static_assert (!is_destructible_type (^^const N2::Del [1]));
static_assert (!is_destructible_type (^^N2::Del []));
static_assert (!is_destructible_type (^^const N2::Del []));
static_assert (!is_destructible_type (^^N2::NontrivialUnion));
static_assert (is_destructible_type (^^N2::UnusualCopy));

static_assert (is_trivially_default_constructible_type (^^int));
static_assert (is_trivially_default_constructible_type (^^TType));
static_assert (is_trivially_default_constructible_type (^^PODType));
static_assert (!is_trivially_default_constructible_type (^^NType));
static_assert (!is_trivially_default_constructible_type (^^SLType));
static_assert (!is_trivially_default_constructible_type (^^N1::DelDef));
static_assert (!is_trivially_default_constructible_type (^^N1::Abstract));
static_assert (!is_trivially_default_constructible_type (^^N1::Ellipsis));
static_assert (!is_trivially_default_constructible_type (^^N1::DelEllipsis));
static_assert (!is_trivially_default_constructible_type (^^N1::Any));
static_assert (!is_trivially_default_constructible_type (^^N1::DelCopy));
static_assert (!is_trivially_default_constructible_type (^^N1::DelDtor));
static_assert (!is_trivially_default_constructible_type (^^N1::Nontrivial));
static_assert (is_trivially_default_constructible_type (^^HasTemplateCtor));

static_assert (!is_trivially_default_constructible_type (^^int []));
struct A { };
static_assert (!is_trivially_default_constructible_type (^^A []));
struct B { B () { } };
static_assert (!is_trivially_default_constructible_type (^^B []));

static_assert (is_trivially_copy_constructible_type (^^int));
static_assert (is_trivially_copy_constructible_type (^^TType));
static_assert (is_trivially_copy_constructible_type (^^PODType));
static_assert (!is_trivially_copy_constructible_type (^^NType));
static_assert (!is_trivially_copy_constructible_type (^^SLType));
static_assert (is_trivially_copy_constructible_type (^^N1::DelDef));
static_assert (!is_trivially_copy_constructible_type (^^N1::Abstract));
static_assert (is_trivially_copy_constructible_type (^^N1::Ellipsis));
static_assert (is_trivially_copy_constructible_type (^^N1::DelEllipsis));
static_assert (is_trivially_copy_constructible_type (^^N1::Any));
static_assert (!is_trivially_copy_constructible_type (^^N1::DelCopy));
static_assert (!is_trivially_copy_constructible_type (^^N1::DelDtor));
static_assert (!is_trivially_copy_constructible_type (^^N1::Nontrivial));
static_assert (!is_trivially_copy_constructible_type (^^N1::UnusualCopy));
static_assert (is_trivially_copy_constructible_type (^^CopyConsOnlyType));
static_assert (!is_trivially_copy_constructible_type (^^MoveConsOnlyType));
static_assert (is_trivially_copy_constructible_type (^^HasTemplateCCtor));
static_assert (!is_trivially_copy_constructible_type (^^MoveOnly));
static_assert (!is_trivially_copy_constructible_type (^^MoveOnly2));
static_assert (!is_trivially_copy_constructible_type (^^void));

static_assert (is_trivially_move_constructible_type (^^int));
static_assert (is_trivially_move_constructible_type (^^TType));
static_assert (is_trivially_move_constructible_type (^^PODType));
static_assert (!is_trivially_move_constructible_type (^^NType));
static_assert (!is_trivially_move_constructible_type (^^SLType));
static_assert (is_trivially_move_constructible_type (^^N1::DelDef));
static_assert (!is_trivially_move_constructible_type (^^N1::Abstract));
static_assert (is_trivially_move_constructible_type (^^N1::Ellipsis));
static_assert (is_trivially_move_constructible_type (^^N1::DelEllipsis));
static_assert (is_trivially_move_constructible_type (^^N1::Any));
static_assert (!is_trivially_move_constructible_type (^^N1::DelCopy));
static_assert (!is_trivially_move_constructible_type (^^N1::DelDtor));
static_assert (!is_trivially_move_constructible_type (^^N1::Nontrivial));
static_assert (!is_trivially_move_constructible_type (^^N1::UnusualCopy));
static_assert (!is_trivially_move_constructible_type (^^CopyConsOnlyType));
static_assert (is_trivially_move_constructible_type (^^MoveConsOnlyType));
static_assert (!is_trivially_move_constructible_type (^^HasTemplateCCtor));
static_assert (is_trivially_move_constructible_type (^^MoveOnly));
static_assert (!is_trivially_move_constructible_type (^^MoveOnly2));
static_assert (!is_trivially_move_constructible_type (^^void));

static_assert (!is_trivially_assignable_type (^^int, ^^int));
static_assert (is_trivially_assignable_type (^^int &, ^^int));
static_assert (is_trivially_assignable_type (^^int &, ^^int &));
static_assert (is_trivially_assignable_type (^^int &, ^^int &&));
static_assert (is_trivially_assignable_type (^^int &, ^^const int &));
static_assert (!is_trivially_assignable_type (^^int &, ^^int *));
static_assert (!is_trivially_assignable_type (^^int &, ^^void *));
static_assert (!is_trivially_assignable_type (^^const int, ^^int));
static_assert (!is_trivially_assignable_type (^^const int &, ^^int));
static_assert (!is_trivially_assignable_type (^^const int &, ^^const int &));
static_assert (is_trivially_assignable_type (^^const int *&, ^^int *));
static_assert (!is_trivially_assignable_type (^^int *&, ^^const int *&));
static_assert (!is_trivially_assignable_type (^^int *&, ^^const int &));
static_assert (!is_trivially_assignable_type (^^const int *&, ^^void *));
static_assert (is_trivially_assignable_type (^^const void *&, ^^void *));
static_assert (is_trivially_assignable_type (^^const void *&, ^^int *));
static_assert (is_trivially_assignable_type (^^TType, ^^TType));
static_assert (is_trivially_assignable_type (^^TType &, ^^TType));
static_assert (is_trivially_assignable_type (^^TType &, ^^TType &));
static_assert (is_trivially_assignable_type (^^TType &, ^^TType &&));
static_assert (is_trivially_assignable_type (^^TType &, ^^const TType &));
static_assert (is_trivially_assignable_type (^^PODType, ^^PODType));
static_assert (!is_trivially_assignable_type (^^NType &, ^^NType &));
static_assert (is_trivially_assignable_type (^^SLType, ^^SLType));
static_assert (is_trivially_assignable_type (^^N3::Empty, ^^N3::Empty));
static_assert (!is_trivially_assignable_type (^^N3::Abstract, ^^N3::Abstract));
static_assert (is_trivially_assignable_type (^^N3::Ellipsis, ^^N3::Ellipsis));
static_assert (is_trivially_assignable_type (^^N3::DelEllipsis, ^^N3::DelEllipsis));
static_assert (is_trivially_assignable_type (^^N3::Any, ^^N3::Any));
static_assert (is_trivially_assignable_type (^^N3::DelDef, ^^N3::DelDef));
static_assert (is_trivially_assignable_type (^^N3::DelCopy, ^^N3::DelCopy));
static_assert (!is_trivially_assignable_type (^^N3::Nontrivial, ^^N3::Nontrivial));
static_assert (is_trivially_assignable_type (^^N3::AnyAssign, ^^N3::AnyAssign));
static_assert (is_trivially_assignable_type (^^N3::DelAnyAssign, ^^N3::DelAnyAssign));
static_assert (is_trivially_assignable_type (^^N3::DelCopyAssign, ^^N3::DelCopyAssign));
static_assert (is_trivially_assignable_type (^^N3::MO, ^^N3::MO));
static_assert (is_trivially_assignable_type (^^N3::MO, ^^N3::MO &&));
static_assert (!is_trivially_assignable_type (^^N3::MO, ^^N3::MO &));
static_assert (!is_trivially_assignable_type (^^N3::MO, ^^const N3::MO &));
static_assert (!is_trivially_assignable_type (^^CopyConsOnlyType, ^^CopyConsOnlyType));
static_assert (!is_trivially_assignable_type (^^CopyConsOnlyType, ^^const CopyConsOnlyType &));
static_assert (!is_trivially_assignable_type (^^MoveConsOnlyType, ^^MoveConsOnlyType));
static_assert (!is_trivially_assignable_type (^^MoveConsOnlyType, ^^MoveConsOnlyType &&));
static_assert (!is_trivially_assignable_type (^^HasTemplateCAssign, ^^HasTemplateCAssign));
static_assert (is_trivially_assignable_type (^^HasTemplateCAssign, ^^const HasTemplateCAssign &));
static_assert (is_trivially_assignable_type (^^ClassType, ^^DerivedType));
static_assert (is_trivially_assignable_type (^^ClassType, ^^DerivedType &));
static_assert (is_trivially_assignable_type (^^ClassType, ^^DerivedType &&));
static_assert (is_trivially_assignable_type (^^ClassType, ^^const DerivedType &));
static_assert (is_trivially_assignable_type (^^MoveOnly3, ^^MoveOnly3));
static_assert (is_trivially_assignable_type (^^MoveOnly3, ^^MoveOnly3 &&));
static_assert (!is_trivially_assignable_type (^^MoveOnly3, ^^MoveOnly3 &));
static_assert (!is_trivially_assignable_type (^^MoveOnly3, ^^const MoveOnly3 &));
static_assert (!is_trivially_assignable_type (^^MoveOnly4, ^^MoveOnly4));

static_assert (is_trivially_copy_assignable_type (^^int));
static_assert (is_trivially_copy_assignable_type (^^TType));
static_assert (is_trivially_copy_assignable_type (^^PODType));
static_assert (!is_trivially_copy_assignable_type (^^NType));
static_assert (is_trivially_copy_assignable_type (^^SLType));
static_assert (is_trivially_copy_assignable_type (^^N3::Empty));
static_assert (!is_trivially_copy_assignable_type (^^N3::Abstract));
static_assert (is_trivially_copy_assignable_type (^^N3::Ellipsis));
static_assert (is_trivially_copy_assignable_type (^^N3::DelEllipsis));
static_assert (is_trivially_copy_assignable_type (^^N3::Any));
static_assert (is_trivially_copy_assignable_type (^^N3::DelDef));
static_assert (is_trivially_copy_assignable_type (^^N3::DelCopy));
static_assert (!is_trivially_copy_assignable_type (^^N3::Nontrivial));
static_assert (is_trivially_copy_assignable_type (^^N3::AnyAssign));
static_assert (is_trivially_copy_assignable_type (^^N3::DelAnyAssign));
static_assert (!is_trivially_copy_assignable_type (^^N3::DelCopyAssign));
static_assert (!is_trivially_copy_assignable_type (^^N3::MO));
static_assert (!is_trivially_copy_assignable_type (^^CopyConsOnlyType));
static_assert (!is_trivially_copy_assignable_type (^^MoveConsOnlyType));
static_assert (is_trivially_copy_assignable_type (^^HasTemplateCAssign));
static_assert (!is_trivially_copy_assignable_type (^^MoveOnly3));
static_assert (!is_trivially_copy_assignable_type (^^MoveOnly4));
static_assert (!is_trivially_copy_assignable_type (^^void));

static_assert (is_trivially_move_assignable_type (^^int));
static_assert (is_trivially_move_assignable_type (^^TType));
static_assert (is_trivially_move_assignable_type (^^PODType));
static_assert (!is_trivially_move_assignable_type (^^NType));
static_assert (is_trivially_move_assignable_type (^^SLType));
static_assert (is_trivially_move_assignable_type (^^N3::Empty));
static_assert (!is_trivially_move_assignable_type (^^N3::Abstract));
static_assert (is_trivially_move_assignable_type (^^N3::Ellipsis));
static_assert (is_trivially_move_assignable_type (^^N3::DelEllipsis));
static_assert (is_trivially_move_assignable_type (^^N3::Any));
static_assert (is_trivially_move_assignable_type (^^N3::DelDef));
static_assert (is_trivially_move_assignable_type (^^N3::DelCopy));
static_assert (!is_trivially_move_assignable_type (^^N3::Nontrivial));
static_assert (is_trivially_move_assignable_type (^^N3::AnyAssign));
static_assert (is_trivially_move_assignable_type (^^N3::DelAnyAssign));
static_assert (is_trivially_move_assignable_type (^^N3::DelCopyAssign));
static_assert (is_trivially_move_assignable_type (^^N3::MO));
static_assert (!is_trivially_move_assignable_type (^^CopyConsOnlyType));
static_assert (!is_trivially_move_assignable_type (^^MoveConsOnlyType));
static_assert (!is_trivially_move_assignable_type (^^HasTemplateCAssign));
static_assert (is_trivially_move_assignable_type (^^MoveOnly3));
static_assert (!is_trivially_move_assignable_type (^^MoveOnly4));
static_assert (!is_trivially_move_assignable_type (^^void));

static_assert (is_trivially_destructible_type (^^int));
static_assert (is_trivially_destructible_type (^^TType));
static_assert (is_trivially_destructible_type (^^PODType));
static_assert (!is_trivially_destructible_type (^^NType));
static_assert (!is_trivially_destructible_type (^^SLType));

static_assert (is_nothrow_default_constructible_type (^^int));
static_assert (is_nothrow_default_constructible_type (^^float));
static_assert (is_nothrow_default_constructible_type (^^EnumType));
static_assert (is_nothrow_default_constructible_type (^^int *));
static_assert (is_nothrow_default_constructible_type (^^int (*) (int)));
static_assert (is_nothrow_default_constructible_type (^^int (ClassType:: *)));
static_assert (is_nothrow_default_constructible_type (^^int (ClassType:: *) (int)));
static_assert (is_nothrow_default_constructible_type (^^int [2]));
static_assert (is_nothrow_default_constructible_type (^^EnumType [2][3][4]));
static_assert (is_nothrow_default_constructible_type (^^int * [3]));
static_assert (is_nothrow_default_constructible_type (^^int (ClassType::* [2][3])));
static_assert (is_nothrow_default_constructible_type (^^ClassType));
static_assert (is_nothrow_default_constructible_type (^^NoexceptDefaultClass));
static_assert (!is_nothrow_default_constructible_type (^^void));
static_assert (!is_nothrow_default_constructible_type (^^int []));
static_assert (!is_nothrow_default_constructible_type (^^float [][3]));
static_assert (!is_nothrow_default_constructible_type (^^int (* [][2]) (int)));
static_assert (!is_nothrow_default_constructible_type (^^int (ClassType:: * [][2][3]) (int)));
static_assert (!is_nothrow_default_constructible_type (^^ThrowDefaultClass));
static_assert (!is_nothrow_default_constructible_type (^^ExceptDefaultClass));

static_assert (is_nothrow_copy_constructible_type (^^int));
static_assert (is_nothrow_copy_constructible_type (^^float));
static_assert (is_nothrow_copy_constructible_type (^^EnumType));
static_assert (is_nothrow_copy_constructible_type (^^int *));
static_assert (is_nothrow_copy_constructible_type (^^int (*) (int)));
static_assert (is_nothrow_copy_constructible_type (^^int (ClassType:: *)));
static_assert (is_nothrow_copy_constructible_type (^^int (ClassType:: *) (int)));
static_assert (is_nothrow_copy_constructible_type (^^NoexceptCopyConsClass));
static_assert (is_nothrow_copy_constructible_type (^^const NoexceptCopyConsClass));
static_assert (!is_nothrow_copy_constructible_type (^^void));
static_assert (!is_nothrow_copy_constructible_type (^^int [2]));
static_assert (!is_nothrow_copy_constructible_type (^^int []));
static_assert (!is_nothrow_copy_constructible_type (^^float [][3]));
static_assert (!is_nothrow_copy_constructible_type (^^EnumType [2][3][4]));
static_assert (!is_nothrow_copy_constructible_type (^^int * [3]));
static_assert (!is_nothrow_copy_constructible_type (^^int (* [][2]) (int)));
static_assert (!is_nothrow_copy_constructible_type (^^int (ClassType:: * [2][3])));
static_assert (!is_nothrow_copy_constructible_type (^^int (ClassType:: * [][2][3]) (int)));
static_assert (!is_nothrow_copy_constructible_type (^^ClassType (unsigned) const &));
static_assert (!is_nothrow_copy_constructible_type (^^bool (ClassType) const));
static_assert (!is_nothrow_copy_constructible_type (^^bool (...) &&));
static_assert (!is_nothrow_copy_constructible_type (^^EnumType (int, ...)));
static_assert (!is_nothrow_copy_constructible_type (^^volatile NoexceptCopyConsClass));
static_assert (!is_nothrow_copy_constructible_type (^^ThrowCopyConsClass));
static_assert (!is_nothrow_copy_constructible_type (^^ExceptCopyConsClass));

static_assert (is_nothrow_move_constructible_type (^^int));
static_assert (is_nothrow_move_constructible_type (^^float));
static_assert (is_nothrow_move_constructible_type (^^EnumType));
static_assert (is_nothrow_move_constructible_type (^^int *));
static_assert (is_nothrow_move_constructible_type (^^int (*) (int)));
static_assert (is_nothrow_move_constructible_type (^^int (ClassType:: *)));
static_assert (is_nothrow_move_constructible_type (^^int (ClassType:: *) (int)));
static_assert (is_nothrow_move_constructible_type (^^NoexceptMoveConsClass));
static_assert (!is_nothrow_move_constructible_type (^^void));
static_assert (!is_nothrow_move_constructible_type (^^int [2]));
static_assert (!is_nothrow_move_constructible_type (^^int []));
static_assert (!is_nothrow_move_constructible_type (^^float [][3]));
static_assert (!is_nothrow_move_constructible_type (^^EnumType [2][3][4]));
static_assert (!is_nothrow_move_constructible_type (^^int * [3]));
static_assert (!is_nothrow_move_constructible_type (^^int (* [][2]) (int)));
static_assert (!is_nothrow_move_constructible_type (^^int (ClassType:: * [2][3])));
static_assert (!is_nothrow_move_constructible_type (^^int (ClassType:: * [][2][3]) (int)));
static_assert (!is_nothrow_move_constructible_type (^^ClassType (unsigned) const &));
static_assert (!is_nothrow_move_constructible_type (^^bool (ClassType) const));
static_assert (!is_nothrow_move_constructible_type (^^bool (...) &&));
static_assert (!is_nothrow_move_constructible_type (^^EnumType (int, ...)));
static_assert (!is_nothrow_move_constructible_type (^^const NoexceptMoveConsClass));
static_assert (!is_nothrow_move_constructible_type (^^volatile NoexceptMoveConsClass));
static_assert (!is_nothrow_move_constructible_type (^^ThrowMoveConsClass));
static_assert (!is_nothrow_move_constructible_type (^^ExceptMoveConsClass));

static_assert (is_nothrow_assignable_type (^^int &, ^^int));
static_assert (is_nothrow_assignable_type (^^int &, ^^const int));
static_assert (is_nothrow_assignable_type (^^NoexceptCopyAssignClass &, ^^const NoexceptCopyAssignClass &));
static_assert (is_nothrow_assignable_type (^^NoexceptMoveAssignClass &, ^^NoexceptMoveAssignClass &&));
static_assert (is_nothrow_assignable_type (^^NoexceptCopyAssignClass &, ^^NoexceptCopyAssignClass &&));
static_assert (!is_nothrow_assignable_type (^^int, ^^int));
static_assert (!is_nothrow_assignable_type (^^int, ^^const int));
static_assert (!is_nothrow_assignable_type (^^ExceptCopyAssignClass &, ^^const ExceptCopyAssignClass &));
static_assert (!is_nothrow_assignable_type (^^ExceptMoveAssignClass &, ^^ExceptMoveAssignClass &&));
static_assert (!is_nothrow_assignable_type (^^NoexceptMoveAssignClass &, ^^const NoexceptMoveAssignClass &));

static_assert (is_nothrow_copy_assignable_type (^^int));
static_assert (is_nothrow_copy_assignable_type (^^float));
static_assert (is_nothrow_copy_assignable_type (^^EnumType));
static_assert (is_nothrow_copy_assignable_type (^^int *));
static_assert (is_nothrow_copy_assignable_type (^^int (*) (int)));
static_assert (is_nothrow_copy_assignable_type (^^int (ClassType:: *)));
static_assert (is_nothrow_copy_assignable_type (^^int (ClassType:: *) (int)));
static_assert (is_nothrow_copy_assignable_type (^^NoexceptCopyAssignClass));
static_assert (!is_nothrow_copy_assignable_type (^^void));
static_assert (!is_nothrow_copy_assignable_type (^^int [2]));
static_assert (!is_nothrow_copy_assignable_type (^^float [][3]));
static_assert (!is_nothrow_copy_assignable_type (^^EnumType [2][3][4]));
static_assert (!is_nothrow_copy_assignable_type (^^int * [3]));
static_assert (!is_nothrow_copy_assignable_type (^^int (* [][2]) (int)));
static_assert (!is_nothrow_copy_assignable_type (^^int (ClassType:: * [2][3])));
static_assert (!is_nothrow_copy_assignable_type (^^int (ClassType:: * [][2][3]) (int)));
static_assert (!is_nothrow_copy_assignable_type (^^ClassType (unsigned) const &));
static_assert (!is_nothrow_copy_assignable_type (^^bool (ClassType) const));
static_assert (!is_nothrow_copy_assignable_type (^^bool (...) &&));
static_assert (!is_nothrow_copy_assignable_type (^^EnumType (int, ...)));
static_assert (!is_nothrow_copy_assignable_type (^^ExceptCopyAssignClass));
static_assert (!is_nothrow_copy_assignable_type (^^NoexceptMoveAssignClass));
static_assert (!is_nothrow_copy_assignable_type (^^ExceptMoveAssignClass));
static_assert (!is_nothrow_copy_assignable_type (^^DeletedCopyAssignClass));
static_assert (!is_nothrow_copy_assignable_type (^^DeletedMoveAssignClass));

static_assert (is_nothrow_move_assignable_type (^^int));
static_assert (is_nothrow_move_assignable_type (^^float));
static_assert (is_nothrow_move_assignable_type (^^EnumType));
static_assert (is_nothrow_move_assignable_type (^^int *));
static_assert (is_nothrow_move_assignable_type (^^int (*) (int)));
static_assert (is_nothrow_move_assignable_type (^^int (ClassType:: *)));
static_assert (is_nothrow_move_assignable_type (^^int (ClassType:: *) (int)));
static_assert (is_nothrow_move_assignable_type (^^NoexceptMoveAssignClass));
static_assert (is_nothrow_move_assignable_type (^^NoexceptCopyAssignClass));
static_assert (!is_nothrow_move_assignable_type (^^void));
static_assert (!is_nothrow_move_assignable_type (^^int [2]));
static_assert (!is_nothrow_move_assignable_type (^^float [][3]));
static_assert (!is_nothrow_move_assignable_type (^^EnumType [2][3][4]));
static_assert (!is_nothrow_move_assignable_type (^^int * [3]));
static_assert (!is_nothrow_move_assignable_type (^^int (* [][2]) (int)));
static_assert (!is_nothrow_move_assignable_type (^^int (ClassType:: * [2][3])));
static_assert (!is_nothrow_move_assignable_type (^^int (ClassType:: * [][2][3]) (int)));
static_assert (!is_nothrow_move_assignable_type (^^ClassType (unsigned) const &));
static_assert (!is_nothrow_move_assignable_type (^^bool (ClassType) const));
static_assert (!is_nothrow_move_assignable_type (^^bool (...) &&));
static_assert (!is_nothrow_move_assignable_type (^^EnumType (int, ...)));
static_assert (!is_nothrow_move_assignable_type (^^ExceptMoveAssignClass));
static_assert (!is_nothrow_move_assignable_type (^^ExceptCopyAssignClass));
static_assert (!is_nothrow_move_assignable_type (^^DeletedMoveAssignClass));
static_assert (!is_nothrow_move_assignable_type (^^DeletedCopyAssignClass));

static_assert (is_nothrow_destructible_type (^^int));
static_assert (is_nothrow_destructible_type (^^const int));
static_assert (is_nothrow_destructible_type (^^const volatile int));
static_assert (is_nothrow_destructible_type (^^int [12]));
static_assert (is_nothrow_destructible_type (^^const int [12]));
static_assert (is_nothrow_destructible_type (^^const volatile int [12]));
static_assert (is_nothrow_destructible_type (^^decltype (nullptr)));
static_assert (is_nothrow_destructible_type (^^std::initializer_list<int>));
static_assert (is_nothrow_destructible_type (^^std::initializer_list<decltype (nullptr)>));
static_assert (is_nothrow_destructible_type (^^std::initializer_list<N2::TD1>));
static_assert (is_nothrow_destructible_type (^^std::initializer_list<N2::TD2>));
static_assert (is_nothrow_destructible_type (^^N2::E));
static_assert (is_nothrow_destructible_type (^^const N2::E));
static_assert (is_nothrow_destructible_type (^^const volatile N2::E));
static_assert (is_nothrow_destructible_type (^^N2::NTD1));
static_assert (is_nothrow_destructible_type (^^N2::NTD2));
static_assert (is_nothrow_destructible_type (^^N2::NTD3));
static_assert (is_nothrow_destructible_type (^^N2::Aggr));
static_assert (is_nothrow_destructible_type (^^N2::U1));
static_assert (is_nothrow_destructible_type (^^void (*) ()));
static_assert (is_nothrow_destructible_type (^^void *));
static_assert (is_nothrow_destructible_type (^^int &));
static_assert (is_nothrow_destructible_type (^^N2::TD1 &));
static_assert (is_nothrow_destructible_type (^^N2::TD2 &));
static_assert (is_nothrow_destructible_type (^^N2::TD1 *));
static_assert (is_nothrow_destructible_type (^^N2::TD2 *));
static_assert (is_nothrow_destructible_type (^^void (&) ()));
static_assert (is_nothrow_destructible_type (^^void (&&) ()));
static_assert (is_nothrow_destructible_type (^^N2::En));
static_assert (is_nothrow_destructible_type (^^N2::En *));
static_assert (is_nothrow_destructible_type (^^N2::En &));
static_assert (is_nothrow_destructible_type (^^N2::En2));
static_assert (is_nothrow_destructible_type (^^N2::En2 *));
static_assert (is_nothrow_destructible_type (^^N2::En2 &));
static_assert (is_nothrow_destructible_type (^^N2::TD1 (&) (N2::Aggr2, N2::TD2)));
static_assert (is_nothrow_destructible_type (^^N2::TD1 (*) (N2::Aggr2, N2::TD2)));
static_assert (is_nothrow_destructible_type (^^N2::Abstract1));
static_assert (is_nothrow_destructible_type (^^N2::Der));
static_assert (is_nothrow_destructible_type (^^N2::Del &));
static_assert (is_nothrow_destructible_type (^^N2::Del2 &));
static_assert (is_nothrow_destructible_type (^^N2::Del3 &));
static_assert (is_nothrow_destructible_type (^^N2::Del (&) [1]));
static_assert (is_nothrow_destructible_type (^^N2::Del2 (&) [2]));
static_assert (is_nothrow_destructible_type (^^N2::Del3 (&) [3]));
static_assert (is_nothrow_destructible_type (^^N2::Del &&));
static_assert (is_nothrow_destructible_type (^^N2::Del2 &&));
static_assert (is_nothrow_destructible_type (^^N2::Del3 &));
static_assert (is_nothrow_destructible_type (^^N2::Del (&&) [1]));
static_assert (is_nothrow_destructible_type (^^N2::Del2 (&&) [2]));
static_assert (is_nothrow_destructible_type (^^N2::Del3 (&&) [3]));
static_assert (is_nothrow_destructible_type (^^N2::Ut &));
static_assert (is_nothrow_destructible_type (^^N2::Ut &&));
static_assert (is_nothrow_destructible_type (^^N2::Ut *));
static_assert (is_nothrow_destructible_type (^^N2::Abstract2 &));
static_assert (is_nothrow_destructible_type (^^N2::Abstract3 &));
static_assert (is_nothrow_destructible_type (^^N2::Abstract2 *));
static_assert (is_nothrow_destructible_type (^^N2::Abstract3 *));
static_assert (!is_nothrow_destructible_type (^^void));
static_assert (!is_nothrow_destructible_type (^^const void));
static_assert (!is_nothrow_destructible_type (^^void ()));
static_assert (!is_nothrow_destructible_type (^^void () const));
static_assert (!is_nothrow_destructible_type (^^N2::TD1 (N2::Aggr2, N2::TD2)));
static_assert (!is_nothrow_destructible_type (^^int []));
static_assert (!is_nothrow_destructible_type (^^const int []));
static_assert (!is_nothrow_destructible_type (^^const volatile int []));
static_assert (!is_nothrow_destructible_type (^^int [][123]));
static_assert (!is_nothrow_destructible_type (^^N2::TD1));
static_assert (!is_nothrow_destructible_type (^^N2::TD2));
static_assert (!is_nothrow_destructible_type (^^N2::Aggr2));
static_assert (!is_nothrow_destructible_type (^^N2::Aggr2 [1]));
static_assert (!is_nothrow_destructible_type (^^N2::TD1 [1][2]));
static_assert (!is_nothrow_destructible_type (^^N2::Ut));
static_assert (!is_nothrow_destructible_type (^^N2::Ut [3]));
static_assert (!is_nothrow_destructible_type (^^N2::AbstractDelDtor));
static_assert (!is_nothrow_destructible_type (^^N2::Abstract2));
static_assert (!is_nothrow_destructible_type (^^N2::Abstract3));
static_assert (!is_nothrow_destructible_type (^^N2::Der2));
static_assert (!is_nothrow_destructible_type (^^N2::Del));
static_assert (!is_nothrow_destructible_type (^^N2::Del2));
static_assert (!is_nothrow_destructible_type (^^N2::Del3));
static_assert (!is_nothrow_destructible_type (^^N2::Del [1]));
static_assert (!is_nothrow_destructible_type (^^N2::Del2 [2]));
static_assert (!is_nothrow_destructible_type (^^N2::Del3 [3]));
