// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    // Reads a RemoteSettings pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerRemoteSettings() {
        const pointerId = 1; // remote_settings:RemoteSettings
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a RemoteSettings pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerRemoteSettings(value) {
        const pointerId = 1; // remote_settings:RemoteSettings
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            let message = result.internalErrorMessage;
            if (message) {
                throw new UniFFIInternalError(message);
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterU64 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isSafeInteger(value)) {
            throw new UniFFITypeError(`${value} exceeds the safe integer bounds`);
        }
        if (value < 0) {
            throw new UniFFITypeError(`${value} exceeds the U64 bounds`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint64(value)
    }
    static read(dataStream) {
        return dataStream.readUint64()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterBool extends FfiConverter {
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value == 1;
    }
    static lower(value) {
        if (value) {
            return 1;
        } else {
            return 0;
        }
    }
    static write(dataStream, value) {
        dataStream.writeUint8(this.lower(value))
    }
    static read(dataStream) {
        return this.lift(dataStream.readUint8())
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

export class RemoteSettings {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * A constructor for RemoteSettings.
     * 
     * @returns { RemoteSettings }
     */
    static init(remoteSettingsConfig) {
        const liftResult = (result) => FfiConverterTypeRemoteSettings.lift(result);
        const liftError = (data) => FfiConverterTypeRemoteSettingsError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterTypeRemoteSettingsConfig.checkType(remoteSettingsConfig)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("remoteSettingsConfig");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                8, // remote_settings:uniffi_remote_settings_fn_constructor_remotesettings_new
                FfiConverterTypeRemoteSettingsConfig.lower(remoteSettingsConfig),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);}

    downloadAttachmentToPath(attachmentId,path) {
        const liftResult = (result) => undefined;
        const liftError = (data) => FfiConverterTypeRemoteSettingsError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterString.checkType(attachmentId)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("attachmentId");
                }
                throw e;
            }
            try {
                FfiConverterString.checkType(path)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("path");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                9, // remote_settings:uniffi_remote_settings_fn_method_remotesettings_download_attachment_to_path
                FfiConverterTypeRemoteSettings.lower(this),
                FfiConverterString.lower(attachmentId),
                FfiConverterString.lower(path),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    getRecords() {
        const liftResult = (result) => FfiConverterTypeRemoteSettingsResponse.lift(result);
        const liftError = (data) => FfiConverterTypeRemoteSettingsError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                10, // remote_settings:uniffi_remote_settings_fn_method_remotesettings_get_records
                FfiConverterTypeRemoteSettings.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    getRecordsSince(timestamp) {
        const liftResult = (result) => FfiConverterTypeRemoteSettingsResponse.lift(result);
        const liftError = (data) => FfiConverterTypeRemoteSettingsError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterU64.checkType(timestamp)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("timestamp");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                11, // remote_settings:uniffi_remote_settings_fn_method_remotesettings_get_records_since
                FfiConverterTypeRemoteSettings.lower(this),
                FfiConverterU64.lower(timestamp),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRemoteSettings extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new RemoteSettings(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'RemoteSettings' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerRemoteSettings());
    }

    static write(dataStream, value) {
        dataStream.writePointerRemoteSettings(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

export class Attachment {
    constructor({ filename, mimetype, location, hash, size } = {}) {
        try {
            FfiConverterString.checkType(filename)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("filename");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(mimetype)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("mimetype");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(location)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("location");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(hash)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("hash");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(size)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("size");
            }
            throw e;
        }
        this.filename = filename;
        this.mimetype = mimetype;
        this.location = location;
        this.hash = hash;
        this.size = size;
    }
    equals(other) {
        return (
            this.filename == other.filename &&
            this.mimetype == other.mimetype &&
            this.location == other.location &&
            this.hash == other.hash &&
            this.size == other.size
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeAttachment extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new Attachment({
            filename: FfiConverterString.read(dataStream),
            mimetype: FfiConverterString.read(dataStream),
            location: FfiConverterString.read(dataStream),
            hash: FfiConverterString.read(dataStream),
            size: FfiConverterU64.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.filename);
        FfiConverterString.write(dataStream, value.mimetype);
        FfiConverterString.write(dataStream, value.location);
        FfiConverterString.write(dataStream, value.hash);
        FfiConverterU64.write(dataStream, value.size);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.filename);
        totalSize += FfiConverterString.computeSize(value.mimetype);
        totalSize += FfiConverterString.computeSize(value.location);
        totalSize += FfiConverterString.computeSize(value.hash);
        totalSize += FfiConverterU64.computeSize(value.size);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof Attachment)) {
            throw new UniFFITypeError(`Expected 'Attachment', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.filename);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".filename");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.mimetype);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".mimetype");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.location);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".location");
            }
            throw e;
        }
        try {
            FfiConverterString.checkType(value.hash);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".hash");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.size);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".size");
            }
            throw e;
        }
    }
}

export class RemoteSettingsConfig {
    constructor({ collectionName, bucketName = null, serverUrl = null, server = null } = {}) {
        try {
            FfiConverterString.checkType(collectionName)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("collectionName");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(bucketName)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("bucketName");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(serverUrl)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("serverUrl");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeRemoteSettingsServer.checkType(server)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("server");
            }
            throw e;
        }
        this.collectionName = collectionName;
        this.bucketName = bucketName;
        this.serverUrl = serverUrl;
        this.server = server;
    }
    equals(other) {
        return (
            this.collectionName == other.collectionName &&
            this.bucketName == other.bucketName &&
            this.serverUrl == other.serverUrl &&
            this.server == other.server
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRemoteSettingsConfig extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new RemoteSettingsConfig({
            collectionName: FfiConverterString.read(dataStream),
            bucketName: FfiConverterOptionalstring.read(dataStream),
            serverUrl: FfiConverterOptionalstring.read(dataStream),
            server: FfiConverterOptionalTypeRemoteSettingsServer.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.collectionName);
        FfiConverterOptionalstring.write(dataStream, value.bucketName);
        FfiConverterOptionalstring.write(dataStream, value.serverUrl);
        FfiConverterOptionalTypeRemoteSettingsServer.write(dataStream, value.server);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.collectionName);
        totalSize += FfiConverterOptionalstring.computeSize(value.bucketName);
        totalSize += FfiConverterOptionalstring.computeSize(value.serverUrl);
        totalSize += FfiConverterOptionalTypeRemoteSettingsServer.computeSize(value.server);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof RemoteSettingsConfig)) {
            throw new UniFFITypeError(`Expected 'RemoteSettingsConfig', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.collectionName);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".collectionName");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(value.bucketName);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".bucketName");
            }
            throw e;
        }
        try {
            FfiConverterOptionalstring.checkType(value.serverUrl);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".serverUrl");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeRemoteSettingsServer.checkType(value.server);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".server");
            }
            throw e;
        }
    }
}

export class RemoteSettingsRecord {
    constructor({ id, lastModified, deleted, attachment, fields } = {}) {
        try {
            FfiConverterString.checkType(id)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("id");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(lastModified)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("lastModified");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(deleted)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("deleted");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeAttachment.checkType(attachment)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("attachment");
            }
            throw e;
        }
        try {
            FfiConverterTypeRsJsonObject.checkType(fields)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("fields");
            }
            throw e;
        }
        this.id = id;
        this.lastModified = lastModified;
        this.deleted = deleted;
        this.attachment = attachment;
        this.fields = fields;
    }
    equals(other) {
        return (
            this.id == other.id &&
            this.lastModified == other.lastModified &&
            this.deleted == other.deleted &&
            this.attachment == other.attachment &&
            this.fields == other.fields
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRemoteSettingsRecord extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new RemoteSettingsRecord({
            id: FfiConverterString.read(dataStream),
            lastModified: FfiConverterU64.read(dataStream),
            deleted: FfiConverterBool.read(dataStream),
            attachment: FfiConverterOptionalTypeAttachment.read(dataStream),
            fields: FfiConverterTypeRsJsonObject.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.id);
        FfiConverterU64.write(dataStream, value.lastModified);
        FfiConverterBool.write(dataStream, value.deleted);
        FfiConverterOptionalTypeAttachment.write(dataStream, value.attachment);
        FfiConverterTypeRsJsonObject.write(dataStream, value.fields);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.id);
        totalSize += FfiConverterU64.computeSize(value.lastModified);
        totalSize += FfiConverterBool.computeSize(value.deleted);
        totalSize += FfiConverterOptionalTypeAttachment.computeSize(value.attachment);
        totalSize += FfiConverterTypeRsJsonObject.computeSize(value.fields);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof RemoteSettingsRecord)) {
            throw new UniFFITypeError(`Expected 'RemoteSettingsRecord', found '${typeof value}'`);
        }
        try {
            FfiConverterString.checkType(value.id);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".id");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.lastModified);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".lastModified");
            }
            throw e;
        }
        try {
            FfiConverterBool.checkType(value.deleted);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".deleted");
            }
            throw e;
        }
        try {
            FfiConverterOptionalTypeAttachment.checkType(value.attachment);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".attachment");
            }
            throw e;
        }
        try {
            FfiConverterTypeRsJsonObject.checkType(value.fields);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".fields");
            }
            throw e;
        }
    }
}

export class RemoteSettingsResponse {
    constructor({ records, lastModified } = {}) {
        try {
            FfiConverterSequenceTypeRemoteSettingsRecord.checkType(records)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("records");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(lastModified)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("lastModified");
            }
            throw e;
        }
        this.records = records;
        this.lastModified = lastModified;
    }
    equals(other) {
        return (
            this.records == other.records &&
            this.lastModified == other.lastModified
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRemoteSettingsResponse extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new RemoteSettingsResponse({
            records: FfiConverterSequenceTypeRemoteSettingsRecord.read(dataStream),
            lastModified: FfiConverterU64.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterSequenceTypeRemoteSettingsRecord.write(dataStream, value.records);
        FfiConverterU64.write(dataStream, value.lastModified);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterSequenceTypeRemoteSettingsRecord.computeSize(value.records);
        totalSize += FfiConverterU64.computeSize(value.lastModified);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof RemoteSettingsResponse)) {
            throw new UniFFITypeError(`Expected 'RemoteSettingsResponse', found '${typeof value}'`);
        }
        try {
            FfiConverterSequenceTypeRemoteSettingsRecord.checkType(value.records);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".records");
            }
            throw e;
        }
        try {
            FfiConverterU64.checkType(value.lastModified);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".lastModified");
            }
            throw e;
        }
    }
}




export class RemoteSettingsError extends Error {}


export class JsonError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `JsonError: ${super.toString()}`
    }
}

export class FileError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `FileError: ${super.toString()}`
    }
}

export class RequestError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `RequestError: ${super.toString()}`
    }
}

export class UrlParsingError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `UrlParsingError: ${super.toString()}`
    }
}

export class BackoffError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `BackoffError: ${super.toString()}`
    }
}

export class ResponseError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `ResponseError: ${super.toString()}`
    }
}

export class AttachmentsUnsupportedError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `AttachmentsUnsupportedError: ${super.toString()}`
    }
}

export class ConfigError extends RemoteSettingsError {

    constructor(message, ...params) {
        super(...params);
        this.message = message;
    }
    toString() {
        return `ConfigError: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRemoteSettingsError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new JsonError(FfiConverterString.read(dataStream));
            case 2:
                return new FileError(FfiConverterString.read(dataStream));
            case 3:
                return new RequestError(FfiConverterString.read(dataStream));
            case 4:
                return new UrlParsingError(FfiConverterString.read(dataStream));
            case 5:
                return new BackoffError(FfiConverterString.read(dataStream));
            case 6:
                return new ResponseError(FfiConverterString.read(dataStream));
            case 7:
                return new AttachmentsUnsupportedError(FfiConverterString.read(dataStream));
            case 8:
                return new ConfigError(FfiConverterString.read(dataStream));
            default:
                throw new UniFFITypeError("Unknown RemoteSettingsError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof JsonError) {
            return totalSize;
        }
        if (value instanceof FileError) {
            return totalSize;
        }
        if (value instanceof RequestError) {
            return totalSize;
        }
        if (value instanceof UrlParsingError) {
            return totalSize;
        }
        if (value instanceof BackoffError) {
            return totalSize;
        }
        if (value instanceof ResponseError) {
            return totalSize;
        }
        if (value instanceof AttachmentsUnsupportedError) {
            return totalSize;
        }
        if (value instanceof ConfigError) {
            return totalSize;
        }
        throw new UniFFITypeError("Unknown RemoteSettingsError variant");
    }
    static write(dataStream, value) {
        if (value instanceof JsonError) {
            dataStream.writeInt32(1);
            return;
        }
        if (value instanceof FileError) {
            dataStream.writeInt32(2);
            return;
        }
        if (value instanceof RequestError) {
            dataStream.writeInt32(3);
            return;
        }
        if (value instanceof UrlParsingError) {
            dataStream.writeInt32(4);
            return;
        }
        if (value instanceof BackoffError) {
            dataStream.writeInt32(5);
            return;
        }
        if (value instanceof ResponseError) {
            dataStream.writeInt32(6);
            return;
        }
        if (value instanceof AttachmentsUnsupportedError) {
            dataStream.writeInt32(7);
            return;
        }
        if (value instanceof ConfigError) {
            dataStream.writeInt32(8);
            return;
        }
        throw new UniFFITypeError("Unknown RemoteSettingsError variant");
    }

    static errorClass = RemoteSettingsError;
}


export class RemoteSettingsServer {}
RemoteSettingsServer.Prod = class extends RemoteSettingsServer{
    constructor(
        ) {
            super();
        }
}
RemoteSettingsServer.Stage = class extends RemoteSettingsServer{
    constructor(
        ) {
            super();
        }
}
RemoteSettingsServer.Dev = class extends RemoteSettingsServer{
    constructor(
        ) {
            super();
        }
}
RemoteSettingsServer.Custom = class extends RemoteSettingsServer{
    constructor(
        url
        ) {
            super();
            this.url = url;
        }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRemoteSettingsServer extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new RemoteSettingsServer.Prod(
                    );
            case 2:
                return new RemoteSettingsServer.Stage(
                    );
            case 3:
                return new RemoteSettingsServer.Dev(
                    );
            case 4:
                return new RemoteSettingsServer.Custom(
                    FfiConverterString.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown RemoteSettingsServer variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof RemoteSettingsServer.Prod) {
            dataStream.writeInt32(1);
            return;
        }
        if (value instanceof RemoteSettingsServer.Stage) {
            dataStream.writeInt32(2);
            return;
        }
        if (value instanceof RemoteSettingsServer.Dev) {
            dataStream.writeInt32(3);
            return;
        }
        if (value instanceof RemoteSettingsServer.Custom) {
            dataStream.writeInt32(4);
            FfiConverterString.write(dataStream, value.url);
            return;
        }
        throw new UniFFITypeError("Unknown RemoteSettingsServer variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof RemoteSettingsServer.Prod) {
            return totalSize;
        }
        if (value instanceof RemoteSettingsServer.Stage) {
            return totalSize;
        }
        if (value instanceof RemoteSettingsServer.Dev) {
            return totalSize;
        }
        if (value instanceof RemoteSettingsServer.Custom) {
            totalSize += FfiConverterString.computeSize(value.url);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown RemoteSettingsServer variant");
    }

    static checkType(value) {
      if (!(value instanceof RemoteSettingsServer)) {
        throw new UniFFITypeError(`${value} is not a subclass instance of RemoteSettingsServer`);
      }
    }
}


// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalstring extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeAttachment extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeAttachment.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeAttachment.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeAttachment.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeAttachment.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterOptionalTypeRemoteSettingsServer extends FfiConverterArrayBuffer {
    static checkType(value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeRemoteSettingsServer.checkType(value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeRemoteSettingsServer.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeRemoteSettingsServer.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeRemoteSettingsServer.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequenceTypeRemoteSettingsRecord extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeRemoteSettingsRecord.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeRemoteSettingsRecord.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeRemoteSettingsRecord.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterTypeRemoteSettingsRecord.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRsJsonObject extends FfiConverter {
    static lift(buf) {
        return FfiConverterString.lift(buf);    
    }
    
    static lower(buf) {
        return FfiConverterString.lower(buf);
    }
    
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    } 
    
    static read(buf) {
        return FfiConverterString.read(buf);
    }
    
    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }
}
// TODO: We should also allow JS to customize the type eventually.




