// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import { UniFFITypeError } from "resource://gre/modules/UniFFI.sys.mjs";



// Objects intended to be used in the unit tests
export var UnitTestObjs = {};

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }

    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    // Reads a RelevancyStore pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerRelevancyStore() {
        const pointerId = 0; // relevancy:RelevancyStore
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a RelevancyStore pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerRelevancyStore(value) {
        const pointerId = 0; // relevancy:RelevancyStore
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            let message = result.internalErrorMessage;
            if (message) {
                throw new UniFFIInternalError(message);
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }

    toString() {
        return `UniFFIError: ${this.message}`
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    // throw `UniFFITypeError` if a value to be converted has an invalid type
    static checkType(value) {
        if (value === undefined ) {
            throw new UniFFITypeError(`undefined`);
        }
        if (value === null ) {
            throw new UniFFITypeError(`null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");
UnitTestObjs.uniffiObjectPtr = uniffiObjectPtr;

// Export the FFIConverter object to make external types work.
export class FfiConverterU32 extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (!Number.isInteger(value)) {
            throw new UniFFITypeError(`${value} is not an integer`);
        }
        if (value < 0 || value > 4294967295) {
            throw new UniFFITypeError(`${value} exceeds the U32 bounds`);
        }
    }
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint32(value)
    }
    static read(dataStream) {
        return dataStream.readUint32()
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterString extends FfiConverter {
    static checkType(value) {
        super.checkType(value);
        if (typeof value !== "string") {
            throw new UniFFITypeError(`${value} is not a string`);
        }
    }

    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

export class RelevancyStore {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * A constructor for RelevancyStore.
     * 
     * @returns { RelevancyStore }
     */
    static init(dbpath) {
        const liftResult = (result) => FfiConverterTypeRelevancyStore.lift(result);
        const liftError = null;
        const functionCall = () => {
            try {
                FfiConverterString.checkType(dbpath)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("dbpath");
                }
                throw e;
            }
            return UniFFIScaffolding.callSync(
                1, // relevancy:uniffi_relevancy_fn_constructor_relevancystore_new
                FfiConverterString.lower(dbpath),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);}

    calculateMetrics() {
        const liftResult = (result) => FfiConverterTypeInterestMetrics.lift(result);
        const liftError = (data) => FfiConverterTypeRelevancyApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                2, // relevancy:uniffi_relevancy_fn_method_relevancystore_calculate_metrics
                FfiConverterTypeRelevancyStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    close() {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                3, // relevancy:uniffi_relevancy_fn_method_relevancystore_close
                FfiConverterTypeRelevancyStore.lower(this),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    ingest(topUrls) {
        const liftResult = (result) => FfiConverterTypeInterestVector.lift(result);
        const liftError = (data) => FfiConverterTypeRelevancyApiError.lift(data);
        const functionCall = () => {
            try {
                FfiConverterSequencestring.checkType(topUrls)
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart("topUrls");
                }
                throw e;
            }
            return UniFFIScaffolding.callAsync(
                4, // relevancy:uniffi_relevancy_fn_method_relevancystore_ingest
                FfiConverterTypeRelevancyStore.lower(this),
                FfiConverterSequencestring.lower(topUrls),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

    interrupt() {
        const liftResult = (result) => undefined;
        const liftError = null;
        const functionCall = () => {
            return UniFFIScaffolding.callSync(
                5, // relevancy:uniffi_relevancy_fn_method_relevancystore_interrupt
                FfiConverterTypeRelevancyStore.lower(this),
            )
        }
        return handleRustResult(functionCall(), liftResult, liftError);
    }

    userInterestVector() {
        const liftResult = (result) => FfiConverterTypeInterestVector.lift(result);
        const liftError = (data) => FfiConverterTypeRelevancyApiError.lift(data);
        const functionCall = () => {
            return UniFFIScaffolding.callAsync(
                6, // relevancy:uniffi_relevancy_fn_method_relevancystore_user_interest_vector
                FfiConverterTypeRelevancyStore.lower(this),
            )
        }
        try {
            return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
        }  catch (error) {
            return Promise.reject(error)
        }
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRelevancyStore extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new RelevancyStore(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'RelevancyStore' instance");
        }
        return ptr;
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerRelevancyStore());
    }

    static write(dataStream, value) {
        dataStream.writePointerRelevancyStore(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

export class InterestMetrics {
    constructor({ topSingleInterestSimilarity, top2interestSimilarity, top3interestSimilarity } = {}) {
        try {
            FfiConverterU32.checkType(topSingleInterestSimilarity)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("topSingleInterestSimilarity");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(top2interestSimilarity)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("top2interestSimilarity");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(top3interestSimilarity)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("top3interestSimilarity");
            }
            throw e;
        }
        this.topSingleInterestSimilarity = topSingleInterestSimilarity;
        this.top2interestSimilarity = top2interestSimilarity;
        this.top3interestSimilarity = top3interestSimilarity;
    }
    equals(other) {
        return (
            this.topSingleInterestSimilarity == other.topSingleInterestSimilarity &&
            this.top2interestSimilarity == other.top2interestSimilarity &&
            this.top3interestSimilarity == other.top3interestSimilarity
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeInterestMetrics extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new InterestMetrics({
            topSingleInterestSimilarity: FfiConverterU32.read(dataStream),
            top2interestSimilarity: FfiConverterU32.read(dataStream),
            top3interestSimilarity: FfiConverterU32.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterU32.write(dataStream, value.topSingleInterestSimilarity);
        FfiConverterU32.write(dataStream, value.top2interestSimilarity);
        FfiConverterU32.write(dataStream, value.top3interestSimilarity);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterU32.computeSize(value.topSingleInterestSimilarity);
        totalSize += FfiConverterU32.computeSize(value.top2interestSimilarity);
        totalSize += FfiConverterU32.computeSize(value.top3interestSimilarity);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof InterestMetrics)) {
            throw new UniFFITypeError(`Expected 'InterestMetrics', found '${typeof value}'`);
        }
        try {
            FfiConverterU32.checkType(value.topSingleInterestSimilarity);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".topSingleInterestSimilarity");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.top2interestSimilarity);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".top2interestSimilarity");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.top3interestSimilarity);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".top3interestSimilarity");
            }
            throw e;
        }
    }
}

export class InterestVector {
    constructor({ animals, arts, autos, business, career, education, fashion, finance, food, government, hobbies, home, news, realEstate, society, sports, tech, travel, inconclusive } = {}) {
        try {
            FfiConverterU32.checkType(animals)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("animals");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(arts)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("arts");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(autos)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("autos");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(business)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("business");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(career)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("career");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(education)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("education");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(fashion)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("fashion");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(finance)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("finance");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(food)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("food");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(government)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("government");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(hobbies)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("hobbies");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(home)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("home");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(news)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("news");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(realEstate)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("realEstate");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(society)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("society");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(sports)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("sports");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(tech)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("tech");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(travel)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("travel");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(inconclusive)
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart("inconclusive");
            }
            throw e;
        }
        this.animals = animals;
        this.arts = arts;
        this.autos = autos;
        this.business = business;
        this.career = career;
        this.education = education;
        this.fashion = fashion;
        this.finance = finance;
        this.food = food;
        this.government = government;
        this.hobbies = hobbies;
        this.home = home;
        this.news = news;
        this.realEstate = realEstate;
        this.society = society;
        this.sports = sports;
        this.tech = tech;
        this.travel = travel;
        this.inconclusive = inconclusive;
    }
    equals(other) {
        return (
            this.animals == other.animals &&
            this.arts == other.arts &&
            this.autos == other.autos &&
            this.business == other.business &&
            this.career == other.career &&
            this.education == other.education &&
            this.fashion == other.fashion &&
            this.finance == other.finance &&
            this.food == other.food &&
            this.government == other.government &&
            this.hobbies == other.hobbies &&
            this.home == other.home &&
            this.news == other.news &&
            this.realEstate == other.realEstate &&
            this.society == other.society &&
            this.sports == other.sports &&
            this.tech == other.tech &&
            this.travel == other.travel &&
            this.inconclusive == other.inconclusive
        )
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeInterestVector extends FfiConverterArrayBuffer {
    static read(dataStream) {
        return new InterestVector({
            animals: FfiConverterU32.read(dataStream),
            arts: FfiConverterU32.read(dataStream),
            autos: FfiConverterU32.read(dataStream),
            business: FfiConverterU32.read(dataStream),
            career: FfiConverterU32.read(dataStream),
            education: FfiConverterU32.read(dataStream),
            fashion: FfiConverterU32.read(dataStream),
            finance: FfiConverterU32.read(dataStream),
            food: FfiConverterU32.read(dataStream),
            government: FfiConverterU32.read(dataStream),
            hobbies: FfiConverterU32.read(dataStream),
            home: FfiConverterU32.read(dataStream),
            news: FfiConverterU32.read(dataStream),
            realEstate: FfiConverterU32.read(dataStream),
            society: FfiConverterU32.read(dataStream),
            sports: FfiConverterU32.read(dataStream),
            tech: FfiConverterU32.read(dataStream),
            travel: FfiConverterU32.read(dataStream),
            inconclusive: FfiConverterU32.read(dataStream),
        });
    }
    static write(dataStream, value) {
        FfiConverterU32.write(dataStream, value.animals);
        FfiConverterU32.write(dataStream, value.arts);
        FfiConverterU32.write(dataStream, value.autos);
        FfiConverterU32.write(dataStream, value.business);
        FfiConverterU32.write(dataStream, value.career);
        FfiConverterU32.write(dataStream, value.education);
        FfiConverterU32.write(dataStream, value.fashion);
        FfiConverterU32.write(dataStream, value.finance);
        FfiConverterU32.write(dataStream, value.food);
        FfiConverterU32.write(dataStream, value.government);
        FfiConverterU32.write(dataStream, value.hobbies);
        FfiConverterU32.write(dataStream, value.home);
        FfiConverterU32.write(dataStream, value.news);
        FfiConverterU32.write(dataStream, value.realEstate);
        FfiConverterU32.write(dataStream, value.society);
        FfiConverterU32.write(dataStream, value.sports);
        FfiConverterU32.write(dataStream, value.tech);
        FfiConverterU32.write(dataStream, value.travel);
        FfiConverterU32.write(dataStream, value.inconclusive);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterU32.computeSize(value.animals);
        totalSize += FfiConverterU32.computeSize(value.arts);
        totalSize += FfiConverterU32.computeSize(value.autos);
        totalSize += FfiConverterU32.computeSize(value.business);
        totalSize += FfiConverterU32.computeSize(value.career);
        totalSize += FfiConverterU32.computeSize(value.education);
        totalSize += FfiConverterU32.computeSize(value.fashion);
        totalSize += FfiConverterU32.computeSize(value.finance);
        totalSize += FfiConverterU32.computeSize(value.food);
        totalSize += FfiConverterU32.computeSize(value.government);
        totalSize += FfiConverterU32.computeSize(value.hobbies);
        totalSize += FfiConverterU32.computeSize(value.home);
        totalSize += FfiConverterU32.computeSize(value.news);
        totalSize += FfiConverterU32.computeSize(value.realEstate);
        totalSize += FfiConverterU32.computeSize(value.society);
        totalSize += FfiConverterU32.computeSize(value.sports);
        totalSize += FfiConverterU32.computeSize(value.tech);
        totalSize += FfiConverterU32.computeSize(value.travel);
        totalSize += FfiConverterU32.computeSize(value.inconclusive);
        return totalSize
    }

    static checkType(value) {
        super.checkType(value);
        if (!(value instanceof InterestVector)) {
            throw new UniFFITypeError(`Expected 'InterestVector', found '${typeof value}'`);
        }
        try {
            FfiConverterU32.checkType(value.animals);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".animals");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.arts);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".arts");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.autos);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".autos");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.business);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".business");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.career);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".career");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.education);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".education");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.fashion);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".fashion");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.finance);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".finance");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.food);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".food");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.government);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".government");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.hobbies);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".hobbies");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.home);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".home");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.news);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".news");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.realEstate);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".realEstate");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.society);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".society");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.sports);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".sports");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.tech);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".tech");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.travel);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".travel");
            }
            throw e;
        }
        try {
            FfiConverterU32.checkType(value.inconclusive);
        } catch (e) {
            if (e instanceof UniFFITypeError) {
                e.addItemDescriptionPart(".inconclusive");
            }
            throw e;
        }
    }
}


export const Interest = {
    ANIMALS: 1,
    ARTS: 2,
    AUTOS: 3,
    BUSINESS: 4,
    CAREER: 5,
    EDUCATION: 6,
    FASHION: 7,
    FINANCE: 8,
    FOOD: 9,
    GOVERNMENT: 10,
    HOBBIES: 11,
    HOME: 12,
    NEWS: 13,
    REAL_ESTATE: 14,
    SOCIETY: 15,
    SPORTS: 16,
    TECH: 17,
    TRAVEL: 18,
    INCONCLUSIVE: 19,
};

Object.freeze(Interest);
// Export the FFIConverter object to make external types work.
export class FfiConverterTypeInterest extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return Interest.ANIMALS
            case 2:
                return Interest.ARTS
            case 3:
                return Interest.AUTOS
            case 4:
                return Interest.BUSINESS
            case 5:
                return Interest.CAREER
            case 6:
                return Interest.EDUCATION
            case 7:
                return Interest.FASHION
            case 8:
                return Interest.FINANCE
            case 9:
                return Interest.FOOD
            case 10:
                return Interest.GOVERNMENT
            case 11:
                return Interest.HOBBIES
            case 12:
                return Interest.HOME
            case 13:
                return Interest.NEWS
            case 14:
                return Interest.REAL_ESTATE
            case 15:
                return Interest.SOCIETY
            case 16:
                return Interest.SPORTS
            case 17:
                return Interest.TECH
            case 18:
                return Interest.TRAVEL
            case 19:
                return Interest.INCONCLUSIVE
            default:
                throw new UniFFITypeError("Unknown Interest variant");
        }
    }

    static write(dataStream, value) {
        if (value === Interest.ANIMALS) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === Interest.ARTS) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === Interest.AUTOS) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === Interest.BUSINESS) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === Interest.CAREER) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === Interest.EDUCATION) {
            dataStream.writeInt32(6);
            return;
        }
        if (value === Interest.FASHION) {
            dataStream.writeInt32(7);
            return;
        }
        if (value === Interest.FINANCE) {
            dataStream.writeInt32(8);
            return;
        }
        if (value === Interest.FOOD) {
            dataStream.writeInt32(9);
            return;
        }
        if (value === Interest.GOVERNMENT) {
            dataStream.writeInt32(10);
            return;
        }
        if (value === Interest.HOBBIES) {
            dataStream.writeInt32(11);
            return;
        }
        if (value === Interest.HOME) {
            dataStream.writeInt32(12);
            return;
        }
        if (value === Interest.NEWS) {
            dataStream.writeInt32(13);
            return;
        }
        if (value === Interest.REAL_ESTATE) {
            dataStream.writeInt32(14);
            return;
        }
        if (value === Interest.SOCIETY) {
            dataStream.writeInt32(15);
            return;
        }
        if (value === Interest.SPORTS) {
            dataStream.writeInt32(16);
            return;
        }
        if (value === Interest.TECH) {
            dataStream.writeInt32(17);
            return;
        }
        if (value === Interest.TRAVEL) {
            dataStream.writeInt32(18);
            return;
        }
        if (value === Interest.INCONCLUSIVE) {
            dataStream.writeInt32(19);
            return;
        }
        throw new UniFFITypeError("Unknown Interest variant");
    }

    static computeSize(value) {
        return 4;
    }

    static checkType(value) {
      if (!Number.isInteger(value) || value < 1 || value > 19) {
          throw new UniFFITypeError(`${value} is not a valid value for Interest`);
      }
    }
}





export class RelevancyApiError extends Error {}


export class Unexpected extends RelevancyApiError {

    constructor(
        reason,
        ...params
    ) {
        super(...params);
        this.reason = reason;
    }
    toString() {
        return `Unexpected: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeRelevancyApiError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new Unexpected(
                    FfiConverterString.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown RelevancyApiError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof Unexpected) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown RelevancyApiError variant");
    }
    static write(dataStream, value) {
        if (value instanceof Unexpected) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        throw new UniFFITypeError("Unknown RelevancyApiError variant");
    }

    static errorClass = RelevancyApiError;
}

// Export the FFIConverter object to make external types work.
export class FfiConverterSequencestring extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterString.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterString.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterString.computeSize(innerValue);
        }
        return size;
    }

    static checkType(value) {
        if (!Array.isArray(value)) {
            throw new UniFFITypeError(`${value} is not an array`);
        }
        value.forEach((innerValue, idx) => {
            try {
                FfiConverterString.checkType(innerValue);
            } catch (e) {
                if (e instanceof UniFFITypeError) {
                    e.addItemDescriptionPart(`[${idx}]`);
                }
                throw e;
            }
        })
    }
}




