/* Copyright 2016 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

// See docs in ../ops/array_ops.cc

#if (defined(GOOGLE_CUDA) && GOOGLE_CUDA) || \
    (defined(TENSORFLOW_USE_ROCM) && TENSORFLOW_USE_ROCM)

#define EIGEN_USE_GPU

#include "tensorflow/core/framework/register_types.h"
#include "tensorflow/core/framework/types.h"
#include "tensorflow/core/kernels/one_hot_op.h"

namespace tensorflow {

typedef Eigen::GpuDevice GPUDevice;

#define DEFINE_GPU_SPEC_INDEX(T, TI)             \
  template class generator::OneGenerator<T, TI>; \
  template struct functor::OneHot<GPUDevice, T, TI>;

#define DEFINE_GPU_SPEC(T)         \
  DEFINE_GPU_SPEC_INDEX(T, uint8); \
  DEFINE_GPU_SPEC_INDEX(T, int32); \
  DEFINE_GPU_SPEC_INDEX(T, int64)

TF_CALL_int32(DEFINE_GPU_SPEC);
TF_CALL_int64(DEFINE_GPU_SPEC);
TF_CALL_GPU_ALL_TYPES(DEFINE_GPU_SPEC);

#undef DEFINE_GPU_SPEC_INDEX
#undef DEFINE_GPU_SPEC

}  // end namespace tensorflow

#endif  // GOOGLE_CUDA || TENSORFLOW_USE_ROCM
