////////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2022 OVITO GmbH, Germany
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify it either under the
//  terms of the GNU General Public License version 3 as published by the Free Software
//  Foundation (the "GPL") or, at your option, under the terms of the MIT License.
//  If you do not alter this notice, a recipient may use your version of this
//  file under either the GPL or the MIT License.
//
//  You should have received a copy of the GPL along with this program in a
//  file LICENSE.GPL.txt.  You should have received a copy of the MIT License along
//  with this program in a file LICENSE.MIT.txt
//
//  This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
//  either express or implied. See the GPL or the MIT License for the specific language
//  governing rights and limitations.
//
////////////////////////////////////////////////////////////////////////////////////////

#pragma once


#include <ovito/core/dataset/animation/AnimationSettings.h>
#include <ovito/core/app/undo/UndoableOperation.h>
#include <ovito/gui/desktop/widgets/general/SpinnerWidget.h>

namespace Ovito {

/**
 * This dialog box lets the user manage the animation settings.
 */
class OVITO_GUI_EXPORT AnimationSettingsDialog : public QDialog, private UndoableTransaction
{
    Q_OBJECT

public:

    /// Constructor.
    AnimationSettingsDialog(MainWindow& mainWindow, QWidget* parentWindow = nullptr);

private Q_SLOTS:

    /// Event handler for the Ok button.
    void onOk();

    /// Is called when the user has selected a new value for the frames per seconds.
    void onFramesPerSecondChanged(int index);

    /// Is called when the user has selected a new value for the playback speed.
    void onPlaybackSpeedChanged(int index);

    /// Is called when the user changes the start/end values of the animation interval.
    void onAnimationIntervalChanged();

private:

    /// Updates the values shown in the dialog.
    void updateUI();

    /// The animation settings being edited.
    OORef<AnimationSettings> _animSettings;

    MainWindow& _mainWindow;
    QComboBox* fpsBox;
    SpinnerWidget* animStartSpinner;
    SpinnerWidget* animEndSpinner;
    SpinnerWidget* everyNthFrameSpinner;
    QComboBox* playbackSpeedBox;
    QCheckBox* loopPlaybackBox;
    QGroupBox* animIntervalBox;

    bool framesPerSecondModified = false;
    bool playbackSpeedModified = false;
    bool loopPlaybackModified = false;
};

}   // End of namespace
