/**
 * Looking Glass
 * Copyright © 2017-2024 The Looking Glass Authors
 * https://looking-glass.io
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef _H_LG_COMMON_CPUINFO_
#define _H_LG_COMMON_CPUINFO_

#include <stddef.h>
#include <stdbool.h>

bool cpuInfo_get(char * model, size_t modelSize, int * procs, int * cores,
  int * sockets);

void cpuInfo_log(void);

typedef struct
{
  bool sse, sse2, sse3, ssse3;
  bool fma;
  bool sse4_1, sse4_2;
  bool popcnt;
  bool aes;
  bool xsave, osxsave;
  bool avx, avx2;
  bool bmi1, bmi2;
}
CPUInfoFeatures;

const CPUInfoFeatures * cpuInfo_getFeatures(void);

#endif
