; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefix=X86

define i8 @scmp.8.8(i8 %x, i8 %y) nounwind {
; X64-LABEL: scmp.8.8:
; X64:       # %bb.0:
; X64-NEXT:    cmpb %sil, %dil
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %al
; X64-NEXT:    subb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp.8.8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %al
; X86-NEXT:    subb %cl, %al
; X86-NEXT:    retl
  %1 = call i8 @llvm.scmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @scmp.8.16(i16 %x, i16 %y) nounwind {
; X64-LABEL: scmp.8.16:
; X64:       # %bb.0:
; X64-NEXT:    cmpw %si, %di
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %al
; X64-NEXT:    subb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp.8.16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpw {{[0-9]+}}(%esp), %ax
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %al
; X86-NEXT:    subb %cl, %al
; X86-NEXT:    retl
  %1 = call i8 @llvm.scmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @scmp.8.32(i32 %x, i32 %y) nounwind {
; X64-LABEL: scmp.8.32:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %al
; X64-NEXT:    subb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp.8.32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %al
; X86-NEXT:    subb %cl, %al
; X86-NEXT:    retl
  %1 = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @scmp.8.64(i64 %x, i64 %y) nounwind {
; X64-LABEL: scmp.8.64:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %al
; X64-NEXT:    subb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp.8.64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %eax, %edx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %ecx, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edx, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    setl %al
; X86-NEXT:    subb %bl, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %1 = call i8 @llvm.scmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @scmp.8.128(i128 %x, i128 %y) nounwind {
; X64-LABEL: scmp.8.128:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rdx, %rdi
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    setl %r8b
; X64-NEXT:    cmpq %rdi, %rdx
; X64-NEXT:    sbbq %rsi, %rcx
; X64-NEXT:    setl %al
; X64-NEXT:    subb %r8b, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp.8.128:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    sbbl %edx, %ebp
; X86-NEXT:    movl %ecx, %ebp
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    sbbl %ebp, %ecx
; X86-NEXT:    setl %cl
; X86-NEXT:    cmpl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %ebx, %edx
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sbbl %esi, %ebp
; X86-NEXT:    setl %al
; X86-NEXT:    subb %cl, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = call i8 @llvm.scmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @scmp.32.32(i32 %x, i32 %y) nounwind {
; X64-LABEL: scmp.32.32:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    retq
;
; X86-LABEL: scmp.32.32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movsbl %cl, %eax
; X86-NEXT:    retl
  %1 = call i32 @llvm.scmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @scmp.32.64(i64 %x, i64 %y) nounwind {
; X64-LABEL: scmp.32.64:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    retq
;
; X86-LABEL: scmp.32.64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %eax, %edx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %ecx, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edx, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    setl %al
; X86-NEXT:    subb %bl, %al
; X86-NEXT:    movsbl %al, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %1 = call i32 @llvm.scmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @scmp.64.64(i64 %x, i64 %y) nounwind {
; X64-LABEL: scmp.64.64:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbq %cl, %rax
; X64-NEXT:    retq
;
; X86-LABEL: scmp.64.64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %eax, %edx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %ecx, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edx, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    setl %al
; X86-NEXT:    subb %bl, %al
; X86-NEXT:    movsbl %al, %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %1 = call i64 @llvm.scmp(i64 %x, i64 %y)
  ret i64 %1
}

define i4 @scmp_narrow_result(i32 %x, i32 %y) nounwind {
; X64-LABEL: scmp_narrow_result:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %al
; X64-NEXT:    subb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp_narrow_result:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %al
; X86-NEXT:    subb %cl, %al
; X86-NEXT:    retl
  %1 = call i4 @llvm.scmp(i32 %x, i32 %y)
  ret i4 %1
}

define i8 @scmp_narrow_op(i62 %x, i62 %y) nounwind {
; X64-LABEL: scmp_narrow_op:
; X64:       # %bb.0:
; X64-NEXT:    shlq $2, %rsi
; X64-NEXT:    sarq $2, %rsi
; X64-NEXT:    shlq $2, %rdi
; X64-NEXT:    sarq $2, %rdi
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %al
; X64-NEXT:    subb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp_narrow_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $2, %eax
; X86-NEXT:    sarl $2, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    shll $2, %esi
; X86-NEXT:    sarl $2, %esi
; X86-NEXT:    cmpl %ecx, %edx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %eax, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edx, %ecx
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    setl %al
; X86-NEXT:    subb %bl, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %1 = call i8 @llvm.scmp(i62 %x, i62 %y)
  ret i8 %1
}

define i141 @scmp_wide_result(i32 %x, i32 %y) nounwind {
; X64-LABEL: scmp_wide_result:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbq %cl, %rax
; X64-NEXT:    movq %rax, %rdx
; X64-NEXT:    sarq $63, %rdx
; X64-NEXT:    movl %edx, %ecx
; X64-NEXT:    andl $8191, %ecx # imm = 0x1FFF
; X64-NEXT:    retq
;
; X86-LABEL: scmp_wide_result:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %cl, %dl
; X86-NEXT:    movsbl %dl, %ecx
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    sarl $31, %ecx
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    andl $8191, %ecx # imm = 0x1FFF
; X86-NEXT:    movw %cx, 16(%eax)
; X86-NEXT:    retl $4
  %1 = call i141 @llvm.scmp(i32 %x, i32 %y)
  ret i141 %1
}

define i8 @scmp_wide_op(i109 %x, i109 %y) nounwind {
; X64-LABEL: scmp_wide_op:
; X64:       # %bb.0:
; X64-NEXT:    shlq $19, %rcx
; X64-NEXT:    sarq $19, %rcx
; X64-NEXT:    shlq $19, %rsi
; X64-NEXT:    sarq $19, %rsi
; X64-NEXT:    cmpq %rdx, %rdi
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    setl %r8b
; X64-NEXT:    cmpq %rdi, %rdx
; X64-NEXT:    sbbq %rsi, %rcx
; X64-NEXT:    setl %al
; X64-NEXT:    subb %r8b, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp_wide_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $19, %eax
; X86-NEXT:    sarl $19, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shll $19, %ecx
; X86-NEXT:    sarl $19, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    cmpl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %edx, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %esi
; X86-NEXT:    sbbl %ebp, %esi
; X86-NEXT:    movl %ecx, %esi
; X86-NEXT:    sbbl %eax, %esi
; X86-NEXT:    setl %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    sbbl %edi, %ebp
; X86-NEXT:    sbbl %ecx, %eax
; X86-NEXT:    setl %al
; X86-NEXT:    subb %bl, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = call i8 @llvm.scmp(i109 %x, i109 %y)
  ret i8 %1
}

define i41 @scmp_uncommon_types(i7 %x, i7 %y) nounwind {
; X64-LABEL: scmp_uncommon_types:
; X64:       # %bb.0:
; X64-NEXT:    addb %sil, %sil
; X64-NEXT:    sarb %sil
; X64-NEXT:    addb %dil, %dil
; X64-NEXT:    sarb %dil
; X64-NEXT:    cmpb %sil, %dil
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbq %cl, %rax
; X64-NEXT:    retq
;
; X86-LABEL: scmp_uncommon_types:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    addb %cl, %cl
; X86-NEXT:    sarb %cl
; X86-NEXT:    cmpb %al, %cl
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movsbl %cl, %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    retl
  %1 = call i41 @llvm.scmp(i7 %x, i7 %y)
  ret i41 %1
}

define <4 x i32> @scmp_normal_vectors(<4 x i32> %x, <4 x i32> %y) nounwind {
; X64-LABEL: scmp_normal_vectors:
; X64:       # %bb.0:
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,3,3,3]
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm3, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; X64-NEXT:    movdqa %xmm2, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: scmp_normal_vectors:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    setl %dl
; X86-NEXT:    setg %dh
; X86-NEXT:    subb %dl, %dh
; X86-NEXT:    movsbl %dh, %edx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    setg %bh
; X86-NEXT:    subb %bl, %bh
; X86-NEXT:    movsbl %bh, %edi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    setl %bl
; X86-NEXT:    setg %bh
; X86-NEXT:    subb %bl, %bh
; X86-NEXT:    movsbl %bh, %esi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %ch
; X86-NEXT:    subb %cl, %ch
; X86-NEXT:    movsbl %ch, %ecx
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %esi, 8(%eax)
; X86-NEXT:    movl %edi, 4(%eax)
; X86-NEXT:    movl %edx, (%eax)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
  %1 = call <4 x i32> @llvm.scmp(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %1
}

define <4 x i8> @scmp_narrow_vec_result(<4 x i32> %x, <4 x i32> %y) nounwind {
; X64-LABEL: scmp_narrow_vec_result:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; X64-NEXT:    movd %xmm2, %edx
; X64-NEXT:    cmpl %ecx, %edx
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %dl
; X64-NEXT:    subb %cl, %dl
; X64-NEXT:    movzbl %dl, %ecx
; X64-NEXT:    shll $8, %ecx
; X64-NEXT:    orl %eax, %ecx
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; X64-NEXT:    movd %xmm2, %edx
; X64-NEXT:    cmpl %eax, %edx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %dl
; X64-NEXT:    subb %al, %dl
; X64-NEXT:    movzbl %dl, %eax
; X64-NEXT:    shll $16, %eax
; X64-NEXT:    orl %ecx, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X64-NEXT:    movd %xmm0, %edx
; X64-NEXT:    cmpl %ecx, %edx
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %dl
; X64-NEXT:    subb %cl, %dl
; X64-NEXT:    movzbl %dl, %ecx
; X64-NEXT:    shll $24, %ecx
; X64-NEXT:    orl %eax, %ecx
; X64-NEXT:    movd %ecx, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: scmp_narrow_vec_result:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    setl %ch
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %ch, %cl
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    setl %ch
; X86-NEXT:    setg %bl
; X86-NEXT:    subb %ch, %bl
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    setl %ch
; X86-NEXT:    setg %bh
; X86-NEXT:    subb %ch, %bh
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    setl %dl
; X86-NEXT:    setg %ch
; X86-NEXT:    subb %dl, %ch
; X86-NEXT:    movb %ch, 3(%eax)
; X86-NEXT:    movb %bh, 2(%eax)
; X86-NEXT:    movb %bl, 1(%eax)
; X86-NEXT:    movb %cl, (%eax)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
  %1 = call <4 x i8> @llvm.scmp(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i8> %1
}

define <4 x i32> @scmp_narrow_vec_op(<4 x i8> %x, <4 x i8> %y) nounwind {
; X64-LABEL: scmp_narrow_vec_op:
; X64:       # %bb.0:
; X64-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3]
; X64-NEXT:    psrad $24, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; X64-NEXT:    psrad $24, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[3,3,3,3]
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm3, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,1,1]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; X64-NEXT:    retq
;
; X86-LABEL: scmp_narrow_vec_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %dl
; X86-NEXT:    setl %dl
; X86-NEXT:    setg %dh
; X86-NEXT:    subb %dl, %dh
; X86-NEXT:    movsbl %dh, %edx
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %bl
; X86-NEXT:    setl %bl
; X86-NEXT:    setg %bh
; X86-NEXT:    subb %bl, %bh
; X86-NEXT:    movsbl %bh, %esi
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    setl %ch
; X86-NEXT:    setg %bl
; X86-NEXT:    subb %ch, %bl
; X86-NEXT:    movsbl %bl, %edi
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %ch
; X86-NEXT:    subb %cl, %ch
; X86-NEXT:    movsbl %ch, %ecx
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %edi, 8(%eax)
; X86-NEXT:    movl %esi, 4(%eax)
; X86-NEXT:    movl %edx, (%eax)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
  %1 = call <4 x i32> @llvm.scmp(<4 x i8> %x, <4 x i8> %y)
  ret <4 x i32> %1
}

define <16 x i32> @scmp_wide_vec_result(<16 x i8> %x, <16 x i8> %y) nounwind {
; X64-LABEL: scmp_wide_vec_result:
; X64:       # %bb.0:
; X64-NEXT:    movdqa %xmm1, %xmm3
; X64-NEXT:    movdqa %xmm0, %xmm2
; X64-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; X64-NEXT:    psrad $24, %xmm5
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[3,3,3,3]
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; X64-NEXT:    psrad $24, %xmm6
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[3,3,3,3]
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[2,3,2,3]
; X64-NEXT:    movd %xmm7, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; X64-NEXT:    movd %xmm7, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm7
; X64-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    movd %xmm6, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,1,1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,1,1]
; X64-NEXT:    movd %xmm5, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm5
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; X64-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; X64-NEXT:    psrad $24, %xmm5
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[3,3,3,3]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4,4,5,5,6,6,7,7]
; X64-NEXT:    psrad $24, %xmm4
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[3,3,3,3]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; X64-NEXT:    movd %xmm6, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[2,3,2,3]
; X64-NEXT:    movd %xmm6, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm6
; X64-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    movd %xmm4, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,1,1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,1,1]
; X64-NEXT:    movd %xmm4, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm4
; X64-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; X64-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; X64-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1],xmm5[2],xmm3[2],xmm5[3],xmm3[3]
; X64-NEXT:    psrad $24, %xmm5
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[3,3,3,3]
; X64-NEXT:    movd %xmm4, %eax
; X64-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm2[8],xmm4[9],xmm2[9],xmm4[10],xmm2[10],xmm4[11],xmm2[11],xmm4[12],xmm2[12],xmm4[13],xmm2[13],xmm4[14],xmm2[14],xmm4[15],xmm2[15]
; X64-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; X64-NEXT:    psrad $24, %xmm6
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[3,3,3,3]
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[2,3,2,3]
; X64-NEXT:    movd %xmm7, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; X64-NEXT:    movd %xmm7, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm7
; X64-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm2[0],xmm7[1],xmm2[1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    movd %xmm6, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,1,1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,1,1]
; X64-NEXT:    movd %xmm5, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm5
; X64-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm7[0]
; X64-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; X64-NEXT:    psrad $24, %xmm5
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[3,3,3,3]
; X64-NEXT:    movd %xmm3, %eax
; X64-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4,4,5,5,6,6,7,7]
; X64-NEXT:    psrad $24, %xmm4
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[3,3,3,3]
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; X64-NEXT:    movd %xmm6, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[2,3,2,3]
; X64-NEXT:    movd %xmm6, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm6
; X64-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    movd %xmm4, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,1,1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,1,1]
; X64-NEXT:    movd %xmm4, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm4
; X64-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm6[0]
; X64-NEXT:    retq
;
; X86-LABEL: scmp_wide_vec_result:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    movb {{[0-9]+}}(%esp), %dh
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %bh
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %bh
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %bl
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %dh
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %dl
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %bh
; X86-NEXT:    subb %al, %bh
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %bl
; X86-NEXT:    subb %al, %bl
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dh
; X86-NEXT:    subb %al, %dh
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %ebp
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %edi
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %ah
; X86-NEXT:    subb %al, %ah
; X86-NEXT:    movsbl %ah, %esi
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %ecx, 60(%eax)
; X86-NEXT:    movl %esi, 56(%eax)
; X86-NEXT:    movl %edi, 52(%eax)
; X86-NEXT:    movl %ebp, 48(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 44(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 40(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movsbl %dh, %edx
; X86-NEXT:    movl %edx, 36(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 1-byte Folded Reload
; X86-NEXT:    movsbl %bl, %esi
; X86-NEXT:    movl %esi, 32(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; X86-NEXT:    movsbl %bh, %edi
; X86-NEXT:    movl %edi, 28(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 1-byte Folded Reload
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 1-byte Folded Reload
; X86-NEXT:    movl %ebx, 24(%eax)
; X86-NEXT:    movl %edi, 20(%eax)
; X86-NEXT:    movl %esi, 16(%eax)
; X86-NEXT:    movl %edx, 12(%eax)
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    addl $16, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
  %1 = call <16 x i32> @llvm.scmp(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i32> %1
}

define <16 x i8> @scmp_wide_vec_op(<16 x i64> %x, <16 x i64> %y) nounwind {
; X64-LABEL: scmp_wide_vec_op:
; X64:       # %bb.0:
; X64-NEXT:    movq %xmm7, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm8
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[2,3,2,3]
; X64-NEXT:    movq %xmm7, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm7
; X64-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3],xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; X64-NEXT:    movq %xmm6, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm7
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,3,2,3]
; X64-NEXT:    movq %xmm6, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm6
; X64-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3],xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm8[0],xmm7[1],xmm8[1],xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; X64-NEXT:    movq %xmm5, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm6
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,3,2,3]
; X64-NEXT:    movq %xmm5, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm5
; X64-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3],xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; X64-NEXT:    movq %xmm4, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm5
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,3,2,3]
; X64-NEXT:    movq %xmm4, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm4
; X64-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3],xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; X64-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1]
; X64-NEXT:    movq %xmm3, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm4
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,2,3]
; X64-NEXT:    movq %xmm3, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; X64-NEXT:    movq %xmm2, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; X64-NEXT:    movq %xmm2, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; X64-NEXT:    movq %xmm1, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; X64-NEXT:    movq %xmm1, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; X64-NEXT:    movq %xmm0, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X64-NEXT:    movq %xmm0, %rax
; X64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    setl %al
; X64-NEXT:    setg %cl
; X64-NEXT:    subb %al, %cl
; X64-NEXT:    movzbl %cl, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X64-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; X64-NEXT:    movdqa %xmm1, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: scmp_wide_vec_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    cmpl %edx, %edi
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    sbbl %esi, %ebp
; X86-NEXT:    setl %al
; X86-NEXT:    cmpl %edi, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    sbbl %ebx, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    setl %ah
; X86-NEXT:    subb %al, %ah
; X86-NEXT:    movb %ah, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl %ecx, %ebp
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    setl %al
; X86-NEXT:    cmpl %ebp, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    sbbl %ebx, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    setl %ah
; X86-NEXT:    subb %al, %ah
; X86-NEXT:    movb %ah, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl %edi, %ecx
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    setl %al
; X86-NEXT:    cmpl %ecx, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    sbbl %edx, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    setl %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movb %dl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    cmpl %ebp, %edi
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    sbbl %ecx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edi, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    setl %cl
; X86-NEXT:    subb %bl, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl %edx, %edi
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    sbbl %eax, %ecx
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edi, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    setl %bh
; X86-NEXT:    subb %bl, %bh
; X86-NEXT:    movb %bh, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl %edx, %eax
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %ecx, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %eax, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    setl %bh
; X86-NEXT:    subb %bl, %bh
; X86-NEXT:    movb %bh, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %edx, %ecx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %eax, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %ecx, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    setl %bh
; X86-NEXT:    subb %bl, %bh
; X86-NEXT:    movb %bh, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl %ecx, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %eax, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edx, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setl %dl
; X86-NEXT:    subb %bl, %dl
; X86-NEXT:    movb %dl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    cmpl %ecx, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %eax, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edx, %ecx
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    setl %dl
; X86-NEXT:    subb %bl, %dl
; X86-NEXT:    movb %dl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl %eax, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %ecx, %eax
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    setl %al
; X86-NEXT:    subb %bl, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl %ebp, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    setl %al
; X86-NEXT:    cmpl %ecx, %ebp
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    setl %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl %ebp, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    setl %al
; X86-NEXT:    cmpl %ecx, %ebp
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    setl %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movb %cl, (%esp) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl %eax, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %ebp
; X86-NEXT:    sbbl %esi, %ebp
; X86-NEXT:    setl %dl
; X86-NEXT:    cmpl %ecx, %eax
; X86-NEXT:    sbbl %edi, %esi
; X86-NEXT:    setl %ch
; X86-NEXT:    subb %dl, %ch
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %edx, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    sbbl %edi, %ebp
; X86-NEXT:    setl %cl
; X86-NEXT:    cmpl %esi, %edx
; X86-NEXT:    sbbl %eax, %edi
; X86-NEXT:    setl %dl
; X86-NEXT:    subb %cl, %dl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %ebx, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    sbbl %edi, %ebp
; X86-NEXT:    setl %dh
; X86-NEXT:    cmpl %esi, %ebx
; X86-NEXT:    sbbl %eax, %edi
; X86-NEXT:    setl %cl
; X86-NEXT:    subb %dh, %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %eax, %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    sbbl %edi, %ebp
; X86-NEXT:    setl %dh
; X86-NEXT:    cmpl %esi, %eax
; X86-NEXT:    sbbl %ebx, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    subb %dh, %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb %bl, 15(%eax)
; X86-NEXT:    movb %cl, 14(%eax)
; X86-NEXT:    movb %dl, 13(%eax)
; X86-NEXT:    movb %ch, 12(%eax)
; X86-NEXT:    movzbl (%esp), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 11(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 10(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 9(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 8(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 7(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 6(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 5(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 4(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 3(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 2(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 1(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, (%eax)
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
  %1 = call <16 x i8> @llvm.scmp(<16 x i64> %x, <16 x i64> %y)
  ret <16 x i8> %1
}

define <7 x i117> @scmp_uncommon_vectors(<7 x i7> %x, <7 x i7> %y) nounwind {
; X64-LABEL: scmp_uncommon_vectors:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rbp
; X64-NEXT:    pushq %r15
; X64-NEXT:    pushq %r14
; X64-NEXT:    pushq %r13
; X64-NEXT:    pushq %r12
; X64-NEXT:    pushq %rbx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %edi
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %r10d
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %r11d
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %ebx
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %ebp
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %r14d
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %r15d
; X64-NEXT:    addb %r15b, %r15b
; X64-NEXT:    sarb %r15b
; X64-NEXT:    addb %sil, %sil
; X64-NEXT:    sarb %sil
; X64-NEXT:    cmpb %r15b, %sil
; X64-NEXT:    setl %sil
; X64-NEXT:    setg %r15b
; X64-NEXT:    subb %sil, %r15b
; X64-NEXT:    movsbq %r15b, %rsi
; X64-NEXT:    movq %rsi, (%rax)
; X64-NEXT:    movq %rsi, %xmm0
; X64-NEXT:    sarq $63, %rsi
; X64-NEXT:    addb %r14b, %r14b
; X64-NEXT:    sarb %r14b
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %r15d
; X64-NEXT:    addb %r15b, %r15b
; X64-NEXT:    sarb %r15b
; X64-NEXT:    cmpb %r14b, %r15b
; X64-NEXT:    setl %r14b
; X64-NEXT:    setg %r15b
; X64-NEXT:    subb %r14b, %r15b
; X64-NEXT:    movsbq %r15b, %r14
; X64-NEXT:    movq %r14, %r15
; X64-NEXT:    sarq $63, %r15
; X64-NEXT:    addb %bpl, %bpl
; X64-NEXT:    sarb %bpl
; X64-NEXT:    addb %dl, %dl
; X64-NEXT:    sarb %dl
; X64-NEXT:    cmpb %bpl, %dl
; X64-NEXT:    setl %dl
; X64-NEXT:    setg %bpl
; X64-NEXT:    subb %dl, %bpl
; X64-NEXT:    movsbq %bpl, %rdx
; X64-NEXT:    movq %rdx, %r12
; X64-NEXT:    sarq $63, %r12
; X64-NEXT:    addb %bl, %bl
; X64-NEXT:    sarb %bl
; X64-NEXT:    addb %cl, %cl
; X64-NEXT:    sarb %cl
; X64-NEXT:    cmpb %bl, %cl
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %bl
; X64-NEXT:    subb %cl, %bl
; X64-NEXT:    movsbq %bl, %rbx
; X64-NEXT:    movq %rbx, %rcx
; X64-NEXT:    sarq $63, %rcx
; X64-NEXT:    addb %r11b, %r11b
; X64-NEXT:    sarb %r11b
; X64-NEXT:    addb %r8b, %r8b
; X64-NEXT:    sarb %r8b
; X64-NEXT:    cmpb %r11b, %r8b
; X64-NEXT:    setl %r8b
; X64-NEXT:    setg %r11b
; X64-NEXT:    subb %r8b, %r11b
; X64-NEXT:    movsbq %r11b, %r8
; X64-NEXT:    movq %r8, %r11
; X64-NEXT:    sarq $63, %r11
; X64-NEXT:    addb %r10b, %r10b
; X64-NEXT:    sarb %r10b
; X64-NEXT:    addb %r9b, %r9b
; X64-NEXT:    sarb %r9b
; X64-NEXT:    cmpb %r10b, %r9b
; X64-NEXT:    setl %r9b
; X64-NEXT:    setg %r10b
; X64-NEXT:    subb %r9b, %r10b
; X64-NEXT:    movsbq %r10b, %r9
; X64-NEXT:    movq %r9, %r10
; X64-NEXT:    sarq $63, %r10
; X64-NEXT:    addb %dil, %dil
; X64-NEXT:    sarb %dil
; X64-NEXT:    movzbl {{[0-9]+}}(%rsp), %ebp
; X64-NEXT:    addb %bpl, %bpl
; X64-NEXT:    sarb %bpl
; X64-NEXT:    cmpb %dil, %bpl
; X64-NEXT:    setl %dil
; X64-NEXT:    setg %bpl
; X64-NEXT:    subb %dil, %bpl
; X64-NEXT:    movsbq %bpl, %r13
; X64-NEXT:    movq %r13, %rbp
; X64-NEXT:    sarq $63, %rbp
; X64-NEXT:    movq %rbp, %rdi
; X64-NEXT:    shldq $62, %r13, %rdi
; X64-NEXT:    movq %rdi, 88(%rax)
; X64-NEXT:    shrq $2, %rbp
; X64-NEXT:    movl %ebp, 96(%rax)
; X64-NEXT:    movq %r10, %rdi
; X64-NEXT:    shldq $20, %r9, %rdi
; X64-NEXT:    movq %rdi, 64(%rax)
; X64-NEXT:    movq %r11, %rdi
; X64-NEXT:    shldq $31, %r8, %rdi
; X64-NEXT:    movq %rdi, 48(%rax)
; X64-NEXT:    movq %rcx, %rdi
; X64-NEXT:    shldq $42, %rbx, %rdi
; X64-NEXT:    movq %rdi, 32(%rax)
; X64-NEXT:    movabsq $9007199254738944, %rdi # imm = 0x1FFFFFFFFFF800
; X64-NEXT:    andq %r12, %rdi
; X64-NEXT:    shldq $53, %rdx, %r12
; X64-NEXT:    movq %r12, 16(%rax)
; X64-NEXT:    movabsq $9007199254740991, %r12 # imm = 0x1FFFFFFFFFFFFF
; X64-NEXT:    andq %r12, %r15
; X64-NEXT:    shldq $9, %r14, %r15
; X64-NEXT:    shlq $62, %r13
; X64-NEXT:    orq %r15, %r13
; X64-NEXT:    movq %r13, 80(%rax)
; X64-NEXT:    movabsq $2251799813685247, %r15 # imm = 0x7FFFFFFFFFFFF
; X64-NEXT:    andq %rbp, %r15
; X64-NEXT:    movq %r15, %r13
; X64-NEXT:    shrq $48, %r13
; X64-NEXT:    movb %r13b, 102(%rax)
; X64-NEXT:    shrq $32, %r15
; X64-NEXT:    movw %r15w, 100(%rax)
; X64-NEXT:    shlq $42, %rbx
; X64-NEXT:    shrq $11, %rdi
; X64-NEXT:    orq %rbx, %rdi
; X64-NEXT:    movq %rdi, 24(%rax)
; X64-NEXT:    shlq $9, %r14
; X64-NEXT:    shrq $44, %r10
; X64-NEXT:    andl $511, %r10d # imm = 0x1FF
; X64-NEXT:    orq %r14, %r10
; X64-NEXT:    movq %r10, 72(%rax)
; X64-NEXT:    shlq $20, %r9
; X64-NEXT:    shrq $33, %r11
; X64-NEXT:    andl $1048575, %r11d # imm = 0xFFFFF
; X64-NEXT:    orq %r9, %r11
; X64-NEXT:    movq %r11, 56(%rax)
; X64-NEXT:    shlq $31, %r8
; X64-NEXT:    shrq $22, %rcx
; X64-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; X64-NEXT:    orq %r8, %rcx
; X64-NEXT:    movq %rcx, 40(%rax)
; X64-NEXT:    movq %rsi, %xmm1
; X64-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; X64-NEXT:    movq %xmm0, %rcx
; X64-NEXT:    andq %r12, %rcx
; X64-NEXT:    shlq $53, %rdx
; X64-NEXT:    orq %rcx, %rdx
; X64-NEXT:    movq %rdx, 8(%rax)
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    popq %rbp
; X64-NEXT:    retq
;
; X86-LABEL: scmp_uncommon_vectors:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    addb %dl, %dl
; X86-NEXT:    sarb %dl
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    addb %ah, %ah
; X86-NEXT:    sarb %ah
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    addb %cl, %cl
; X86-NEXT:    sarb %cl
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    addb %ch, %ch
; X86-NEXT:    sarb %ch
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    addb %bl, %bl
; X86-NEXT:    sarb %bl
; X86-NEXT:    movb {{[0-9]+}}(%esp), %bh
; X86-NEXT:    addb %bh, %bh
; X86-NEXT:    sarb %bh
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    addb %al, %al
; X86-NEXT:    sarb %al
; X86-NEXT:    movb {{[0-9]+}}(%esp), %dh
; X86-NEXT:    addb %dh, %dh
; X86-NEXT:    sarb %dh
; X86-NEXT:    cmpb %al, %dh
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dh
; X86-NEXT:    subb %al, %dh
; X86-NEXT:    movsbl %dh, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sarl $31, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    andl $2097151, %esi # imm = 0x1FFFFF
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    cmpb %bl, %bh
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dh
; X86-NEXT:    subb %al, %dh
; X86-NEXT:    movsbl %dh, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sarl $31, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    andl $2097151, %esi # imm = 0x1FFFFF
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    cmpb %cl, %ch
; X86-NEXT:    setl %al
; X86-NEXT:    setg %cl
; X86-NEXT:    subb %al, %cl
; X86-NEXT:    movsbl %cl, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ecx, (%ebp)
; X86-NEXT:    sarl $31, %ecx
; X86-NEXT:    movl %ecx, %esi
; X86-NEXT:    andl $2097151, %esi # imm = 0x1FFFFF
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    cmpb %dl, %ah
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %edi
; X86-NEXT:    movl %edi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sarl $31, %edi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    cmpb {{[-0-9]+}}(%e{{[sb]}}p), %al # 1-byte Folded Reload
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sarl $31, %esi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    cmpb {{[-0-9]+}}(%e{{[sb]}}p), %al # 1-byte Folded Reload
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sarl $31, %eax
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 1-byte Folded Reload
; X86-NEXT:    cmpb {{[-0-9]+}}(%e{{[sb]}}p), %dl # 1-byte Folded Reload
; X86-NEXT:    setl %dl
; X86-NEXT:    setg %dh
; X86-NEXT:    subb %dl, %dh
; X86-NEXT:    movsbl %dh, %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    movl %edx, 96(%ebp)
; X86-NEXT:    movl %edx, 92(%ebp)
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    movl %ebx, 80(%ebp)
; X86-NEXT:    movl %eax, 68(%ebp)
; X86-NEXT:    movl %eax, 64(%ebp)
; X86-NEXT:    movl %esi, 52(%ebp)
; X86-NEXT:    movl %esi, 48(%ebp)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    movl %ebx, 36(%ebp)
; X86-NEXT:    movl %edi, 24(%ebp)
; X86-NEXT:    movl %edi, 20(%ebp)
; X86-NEXT:    movl %ecx, 8(%ebp)
; X86-NEXT:    movl %ecx, 4(%ebp)
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    shldl $30, %edx, %ecx
; X86-NEXT:    movl %ecx, 88(%ebp)
; X86-NEXT:    movl %ebp, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shldl $9, %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    shldl $9, %ebp, %ecx
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    movl %ecx, 76(%ebx)
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    shldl $20, %ebx, %ecx
; X86-NEXT:    movl %ecx, 60(%ebp)
; X86-NEXT:    movl %esi, %ecx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    shldl $31, %ebx, %ecx
; X86-NEXT:    movl %ecx, 44(%ebp)
; X86-NEXT:    movl %ebp, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shldl $10, %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    shldl $10, %ebp, %ecx
; X86-NEXT:    movl %ecx, 32(%ebx)
; X86-NEXT:    movl %edi, %ecx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    shldl $21, %ebp, %ecx
; X86-NEXT:    movl %ecx, 16(%ebx)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    movl %edx, %ecx
; X86-NEXT:    shrl $2, %ecx
; X86-NEXT:    movw %cx, 100(%ebx)
; X86-NEXT:    shll $21, %ebp
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Folded Reload
; X86-NEXT:    movl %ebp, 12(%ebx)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shll $30, %ecx
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Folded Reload
; X86-NEXT:    movl %ecx, 84(%ebx)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shll $9, %ecx
; X86-NEXT:    shrl $12, %eax
; X86-NEXT:    andl $511, %eax # imm = 0x1FF
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, 72(%ebx)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shll $20, %eax
; X86-NEXT:    shrl %esi
; X86-NEXT:    andl $1048575, %esi # imm = 0xFFFFF
; X86-NEXT:    orl %eax, %esi
; X86-NEXT:    movl %esi, 56(%ebx)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shll $31, %eax
; X86-NEXT:    addl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Folded Reload
; X86-NEXT:    movl %eax, 40(%ebx)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shll $10, %eax
; X86-NEXT:    shrl $11, %edi
; X86-NEXT:    andl $1023, %edi # imm = 0x3FF
; X86-NEXT:    orl %eax, %edi
; X86-NEXT:    movl %edi, 28(%ebx)
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    shrl $18, %eax
; X86-NEXT:    andl $7, %eax
; X86-NEXT:    movb %al, 102(%ebx)
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
  %1 = call <7 x i117> @llvm.scmp(<7 x i7> %x, <7 x i7> %y)
  ret <7 x i117> %1
}

define <1 x i3> @scmp_scalarize(<1 x i33> %x, <1 x i33> %y) nounwind {
; X64-LABEL: scmp_scalarize:
; X64:       # %bb.0:
; X64-NEXT:    shlq $31, %rsi
; X64-NEXT:    sarq $31, %rsi
; X64-NEXT:    shlq $31, %rdi
; X64-NEXT:    sarq $31, %rdi
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %al
; X64-NEXT:    subb %cl, %al
; X64-NEXT:    retq
;
; X86-LABEL: scmp_scalarize:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    andl $1, %esi
; X86-NEXT:    negl %esi
; X86-NEXT:    cmpl %ecx, %edx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %eax, %edi
; X86-NEXT:    setl %bl
; X86-NEXT:    cmpl %edx, %ecx
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    setl %al
; X86-NEXT:    subb %bl, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %1 = call <1 x i3> @llvm.scmp(<1 x i33> %x, <1 x i33> %y)
  ret <1 x i3> %1
}

define <2 x i8> @scmp_bool_operands(<2 x i1> %x, <2 x i1> %y) nounwind {
; X64-LABEL: scmp_bool_operands:
; X64:       # %bb.0:
; X64-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; X64-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    andb $1, %al
; X64-NEXT:    negb %al
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %edx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %esi
; X64-NEXT:    andb $1, %dl
; X64-NEXT:    negb %dl
; X64-NEXT:    cmpb %al, %dl
; X64-NEXT:    setl %al
; X64-NEXT:    setg %dl
; X64-NEXT:    subb %al, %dl
; X64-NEXT:    movzbl %dl, %eax
; X64-NEXT:    andb $1, %cl
; X64-NEXT:    negb %cl
; X64-NEXT:    andb $1, %sil
; X64-NEXT:    negb %sil
; X64-NEXT:    cmpb %cl, %sil
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %dl
; X64-NEXT:    subb %cl, %dl
; X64-NEXT:    movzbl %dl, %ecx
; X64-NEXT:    shll $8, %ecx
; X64-NEXT:    orl %eax, %ecx
; X64-NEXT:    movd %ecx, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: scmp_bool_operands:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    andb $1, %cl
; X86-NEXT:    negb %cl
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    andb $1, %dl
; X86-NEXT:    negb %dl
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andb $1, %al
; X86-NEXT:    negb %al
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    andb $1, %ah
; X86-NEXT:    negb %ah
; X86-NEXT:    cmpb %al, %ah
; X86-NEXT:    setl %ah
; X86-NEXT:    setg %al
; X86-NEXT:    subb %ah, %al
; X86-NEXT:    cmpb %cl, %dl
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %cl, %dl
; X86-NEXT:    retl
  %1 = call <2 x i8> @llvm.scmp(<2 x i1> %x, <2 x i1> %y)
  ret <2 x i8> %1
}

define <2 x i16> @scmp_ret_wider_than_operands(<2 x i8> %x, <2 x i8> %y) nounwind {
; X64-LABEL: scmp_ret_wider_than_operands:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    movl %eax, %ecx
; X64-NEXT:    shrl $8, %ecx
; X64-NEXT:    movd %xmm0, %edx
; X64-NEXT:    movl %edx, %esi
; X64-NEXT:    shrl $8, %esi
; X64-NEXT:    cmpb %cl, %sil
; X64-NEXT:    setl %cl
; X64-NEXT:    setg %sil
; X64-NEXT:    subb %cl, %sil
; X64-NEXT:    movsbl %sil, %ecx
; X64-NEXT:    cmpb %al, %dl
; X64-NEXT:    setl %al
; X64-NEXT:    setg %dl
; X64-NEXT:    subb %al, %dl
; X64-NEXT:    movsbl %dl, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    pinsrw $1, %ecx, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: scmp_ret_wider_than_operands:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    setl %al
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %al, %dl
; X86-NEXT:    movsbl %dl, %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    setl %cl
; X86-NEXT:    setg %dl
; X86-NEXT:    subb %cl, %dl
; X86-NEXT:    movsbl %dl, %edx
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    # kill: def $dx killed $dx killed $edx
; X86-NEXT:    retl
  %1 = call <2 x i16> @llvm.scmp(<2 x i8> %x, <2 x i8> %y)
  ret <2 x i16> %1
}

