; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed -e "s/SETROUND/ldmxcsr/g" %s | llc -mtriple=x86_64-pc-linux - | FileCheck %s --check-prefix=X64
; RUN: sed -e "s/SETROUND/fldcw/g" %s | llc -mtriple=i686-pc-linux - | FileCheck %s --check-prefix=X86

define double @foo(double %0) #0 {
; X64-LABEL: foo:
; X64:       # %bb.0:
; X64-NEXT:    subq $24, %rsp
; X64-NEXT:    movsd %xmm0, (%rsp) # 8-byte Spill
; X64-NEXT:    movl $1024, %edi # imm = 0x400
; X64-NEXT:    callq fesetround@PLT
; X64-NEXT:    movsd {{.*#+}} xmm1 = [1.0E+0,0.0E+0]
; X64-NEXT:    divsd (%rsp), %xmm1 # 8-byte Folded Reload
; X64-NEXT:    movsd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movl $1024, %edi # imm = 0x400
; X64-NEXT:    callq fesetround@PLT
; X64-NEXT:    movsd {{.*#+}} xmm0 = [1.0E+0,0.0E+0]
; X64-NEXT:    divsd (%rsp), %xmm0 # 8-byte Folded Reload
; X64-NEXT:    movsd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movl $1024, %edi # imm = 0x400
; X64-NEXT:    callq fesetround@PLT
; X64-NEXT:    movsd {{.*#+}} xmm2 = [1.0E+0,0.0E+0]
; X64-NEXT:    divsd (%rsp), %xmm2 # 8-byte Folded Reload
; X64-NEXT:    movsd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 8-byte Reload
; X64-NEXT:    # xmm0 = mem[0],zero
; X64-NEXT:    movsd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 8-byte Reload
; X64-NEXT:    # xmm1 = mem[0],zero
; X64-NEXT:    callq fma@PLT
; X64-NEXT:    addq $24, %rsp
; X64-NEXT:    retq
;
; X86-LABEL: foo:
; X86:       # %bb.0:
; X86-NEXT:    subl $60, %esp
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fstpl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Spill
; X86-NEXT:    wait
; X86-NEXT:    movl $1024, (%esp) # imm = 0x400
; X86-NEXT:    calll fesetround@PLT
; X86-NEXT:    fld1
; X86-NEXT:    fstl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Spill
; X86-NEXT:    fldl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Reload
; X86-NEXT:    fdivrp %st, %st(1)
; X86-NEXT:    fstpl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Spill
; X86-NEXT:    wait
; X86-NEXT:    movl $1024, (%esp) # imm = 0x400
; X86-NEXT:    calll fesetround@PLT
; X86-NEXT:    fldl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Reload
; X86-NEXT:    fldl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Reload
; X86-NEXT:    fdivp %st, %st(1)
; X86-NEXT:    fstpl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Spill
; X86-NEXT:    wait
; X86-NEXT:    movl $1024, (%esp) # imm = 0x400
; X86-NEXT:    calll fesetround@PLT
; X86-NEXT:    fldl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Reload
; X86-NEXT:    fldl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Reload
; X86-NEXT:    fdivp %st, %st(1)
; X86-NEXT:    fstpl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Reload
; X86-NEXT:    fstpl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[-0-9]+}}(%e{{[sb]}}p) # 8-byte Folded Reload
; X86-NEXT:    fstpl (%esp)
; X86-NEXT:    wait
; X86-NEXT:    calll fma
; X86-NEXT:    addl $60, %esp
; X86-NEXT:    retl
    %2 = call i32 @fesetround(i32 noundef 1024)
    %3 = call double @llvm.experimental.constrained.fdiv.f64(double 1.000000e+00, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    %4 = call i32 @fesetround(i32 noundef 1024)
    %5 = call double @llvm.experimental.constrained.fdiv.f64(double 1.000000e+00, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    %6 = call i32 @fesetround(i32 noundef 1024)
    %7 = call double @llvm.experimental.constrained.fdiv.f64(double 1.000000e+00, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    %8 = call double @llvm.experimental.constrained.fma.f64(double %3, double %5, double %7, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    ret double %8
}

define double @bar(double %0) #0 {
; X64-LABEL: bar:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    #APP
; X64-NEXT:    ldmxcsr 0
; X64-NEXT:    #NO_APP
; X64-NEXT:    wait
; X64-NEXT:    movsd {{.*#+}} xmm2 = [1.0E+0,0.0E+0]
; X64-NEXT:    movapd %xmm2, %xmm3
; X64-NEXT:    divsd %xmm0, %xmm3
; X64-NEXT:    #APP
; X64-NEXT:    ldmxcsr 0
; X64-NEXT:    #NO_APP
; X64-NEXT:    wait
; X64-NEXT:    movapd %xmm2, %xmm1
; X64-NEXT:    divsd %xmm0, %xmm1
; X64-NEXT:    #APP
; X64-NEXT:    ldmxcsr 0
; X64-NEXT:    #NO_APP
; X64-NEXT:    wait
; X64-NEXT:    divsd %xmm0, %xmm2
; X64-NEXT:    movapd %xmm3, %xmm0
; X64-NEXT:    callq fma@PLT
; X64-NEXT:    popq %rax
; X64-NEXT:    retq
;
; X86-LABEL: bar:
; X86:       # %bb.0:
; X86-NEXT:    subl $28, %esp
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    #APP
; X86-NEXT:    fldcw 0
; X86-NEXT:    #NO_APP
; X86-NEXT:    fld1
; X86-NEXT:    fld %st(0)
; X86-NEXT:    fdiv %st(2), %st
; X86-NEXT:    #APP
; X86-NEXT:    fldcw 0
; X86-NEXT:    #NO_APP
; X86-NEXT:    fld %st(1)
; X86-NEXT:    fdiv %st(3), %st
; X86-NEXT:    #APP
; X86-NEXT:    fldcw 0
; X86-NEXT:    #NO_APP
; X86-NEXT:    fxch %st(2)
; X86-NEXT:    fdivp %st, %st(3)
; X86-NEXT:    fxch %st(2)
; X86-NEXT:    fstpl {{[0-9]+}}(%esp)
; X86-NEXT:    fstpl {{[0-9]+}}(%esp)
; X86-NEXT:    fstpl (%esp)
; X86-NEXT:    wait
; X86-NEXT:    calll fma
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
    call void asm sideeffect "SETROUND $0", "*m,~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i32) null)
    %2 = call double @llvm.experimental.constrained.fdiv.f64(double 1.000000e+00, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    call void asm sideeffect "SETROUND $0", "*m,~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i32) null)
    %3 = call double @llvm.experimental.constrained.fdiv.f64(double 1.000000e+00, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    call void asm sideeffect "SETROUND $0", "*m,~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i32) null)
    %4 = call double @llvm.experimental.constrained.fdiv.f64(double 1.000000e+00, double %0, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    %5 = call double @llvm.experimental.constrained.fma.f64(double %2, double %3, double %4, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
    ret double %5
}

declare i32 @fesetround(i32) #0
declare double @llvm.experimental.constrained.fdiv.f64(double, double, metadata, metadata) #0
declare double @llvm.experimental.constrained.fma.f64(double, double, double, metadata, metadata) #0

attributes #0 = { nounwind strictfp }
