'use strict'

const path    = require('path')
const resolve = require('rollup-plugin-node-resolve')
const common  = require('rollup-plugin-commonjs')

let fileDest  = 'lessc'
const plugins = [
  resolve({
    customResolveOptions: {
      moduleDirectory: ['/usr/share/nodejs']
    }
  }),
  common(),
]
module.exports = {
  input: 'lib/lessc.js',
  output: {
    file: path.resolve(__dirname, `../bin/${fileDest}`),
    format: 'cjs',
    banner: '#!/usr/bin/env node\n// AUTO-GENERATED BY ROLLUP\n',
  },
  plugins
}
